// bowlingView.cpp : implementation of the CBowlingView class
//

#include "stdafx.h"
#include "bowling.h"
#include "math.h"
#include "bowlingDoc.h"
#include "bowlingView.h"
#include "mmsystem.h"
#include <io.h>
#include <fcntl.h>

//#include "mciwave.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBowlingView
void CALLBACK Timer(UINT, UINT, DWORD dwUser, DWORD, DWORD) 
{	                                   // mmtimer (wm_timer blocks messaging)
  CBowlingView* d;                     // pointer to CDOSingleDoc

  d = (CBowlingView*) dwUser;          // dwUser is the 'this' pointer from main
  d->DrawTarget();
}
IMPLEMENT_DYNCREATE(CBowlingView, CFormView)

BEGIN_MESSAGE_MAP(CBowlingView, CFormView)
	//{{AFX_MSG_MAP(CBowlingView)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_NEWGAME, OnNewgame)
	ON_WM_TIMER()
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBowlingView construction/destruction

CBowlingView::CBowlingView()
	: CFormView(CBowlingView::IDD)
{
	//{{AFX_DATA_INIT(CBowlingView)
	//}}AFX_DATA_INIT
	// TODO: add construction code here
	OnStatus = 1;				//set to ready status
	pBowlBMP = NULL;			//pointer of bitmap corresponding to bowling memory DC 
	pBallBMP = NULL;			//pointer of Ball BMP
	pBallMBMP = NULL;			//pointer of Ball mask BMP
	pShoesBMP = NULL;			//pointer of Shoes BMP
	pShoesMBMP = NULL;			//pointer of Shoes mask BMP
	
	BallImageX = 120;			//ball image width, height
	BallImageY = 121;		
	PinImageX = 66;				//pin image width, height
	PinImageY = 213;

	ShoesImageX = 20;			//shoes image width, height
	ShoesImageY = 26;

	BackImageX = 256;			//background image width, height
	BackImageY = 348;


	TimerCount = 0;				//timer count down
	TimerCountTarget = 0;		//timer count for target
	TimerCountCeremony = 5;		//timer count for ceremony
	PinRadius = 17*1.0;				//set pin radius
	BallRadius = 26.8*1.0;			//set bowling ball diameter
	PinIntervalX = 76*1.0;			//set x-distance between two adjacent pins
	PinIntervalY = 48*1.0;			//set y-distance between two adjacent pins
	BottomPinY = -400*1.0;			//set Y location of first 4 pins
	targetY = 60;				//set target mark Y position (from bottom)
	GutterLine = -10;			//set gutterline X postion (from left)
	RefreshRound = FALSE;		//bool variable for refresh round message
	EndGame = FALSE;			//bool variable for end game message
	BaseFrames = 20;			//base frame number of bowl rolling animation	
	bOnRollSound = FALSE;		//rolling sound
	bGutterSound = FALSE;		//gutter sound
	bCollisionSound = FALSE;	//collision sound	
	bGutter = FALSE;			//not gutter
	ViewAngle = 0.01;			//View angle of bowliing stadium
	
	NumberOfLines = 0;			//number of games played
	SpareNo = 0;				//Spare number per 1 game
	NonSpareNo = 0;				//Spare failure number per 1 game
	StrikeNo = 0;				//Strike number per 1 game
	CurveNo = 0;				//Curve points per 1 game
	
	AvgScore = 0;				//Average score	
	AvgStrike = 0;				//Average strike rate
	AvgSpare = 0;				//Average Spare rate
	AvgCurve = 0;				//Average curve points
	BestScore = 0;				//Best score
	WorstScore = 0;				//Worst score
	Accuracy = 20;				//accuracy determined by experience (curve, strike, spare)
	Deviation = 20;				//Deviation determined by accuracy and chance	
	LaneStatus = 0;				//lane status 0, 1, 2, 3, 4, 5  etc..
								//0: deviate to center side
								//1: deviate to gutter side								
								//2: deviate to left side
								//3: deviate to right side
	LaneStatusDegree = 0;		//lane status degree (from 0 to 10)

	Recent5Score = 0;			//Recent 5 game average score
	Recent5Strike = 0;			//Recent 5 game strike rate	
	Recent5Spare = 0;			//Recent 5 game Spare rate
	Recent5Curve = 0;			//Recent 5 game curve points
	Recent5Best = 0;			//Recent 5 game Best score
	Recent5Worst = 0;			//Recent 5 game Worst score

	RoundStatus = 0;			//0: non, 1:strike, 2: spare, 3: double, 4: turkey, 5: gutter

	for (int L=0; L<10; L++)	//Set all pins upright
	{
		PinUp[L] = TRUE;
	}
	scorefile = NULL;			//score file object to record score

	m_pDib = NULL;
	pBitmapInfo = NULL;
	tDib = NULL;

	GetCurrentDirectory(255,filepath);       //get current directory path and name
}

CBowlingView::~CBowlingView()
{	
	if (tDib)
		delete tDib;
	else
	{
		if (m_pDib)
			delete m_pDib;
		if (pBitmapInfo)
			delete pBitmapInfo;
	}

	if (scorefile != NULL)
	{
		fclose(scorefile);
	}
	BowlDC.SelectObject(pBowlBMP);
	BowlDC.DeleteDC();
	
	BallDC.SelectObject(pBallBMP);
	BallDC.DeleteDC();
	BallMDC.SelectObject(pBallMBMP);
	BallMDC.DeleteDC();
	
	PinDC.SelectObject(pPinBMP);
	PinDC.DeleteDC();
	PinMDC.SelectObject(pPinMBMP);
	PinMDC.DeleteDC();
	
	ShoesDC.SelectObject(pShoesBMP);
	ShoesDC.DeleteDC();
	ShoesMDC.SelectObject(pShoesMBMP);
	ShoesMDC.DeleteDC();
	
	memDC.SelectObject(pBackBMP);
	memDC.DeleteDC();
	
	BowlBMP.DeleteObject();	
	BallBMP.DeleteObject();
	BallMBMP.DeleteObject();
	PinBMP.DeleteObject();
	PinMBMP.DeleteObject();
	ShoesBMP.DeleteObject();
	ShoesMBMP.DeleteObject();
	BackBMP.DeleteObject();	

}

void CBowlingView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBowlingView)
	DDX_Control(pDX, IDC_SLIDER6, m_slider6);
	DDX_Control(pDX, IDC_SLIDER5, m_slider5);
	DDX_Control(pDX, IDC_SLIDER4, m_slider4);
	DDX_Control(pDX, IDC_SLIDER3, m_slider3);
	DDX_Control(pDX, IDC_SLIDER2, m_slider2);
	DDX_Control(pDX, IDC_SLIDER1, m_slider1);
	//}}AFX_DATA_MAP
}

BOOL CBowlingView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}







/////////////////////////////////////////////////////////////////////////////
// CBowlingView printing

BOOL CBowlingView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CBowlingView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CBowlingView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CBowlingView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CBowlingView diagnostics

#ifdef _DEBUG
void CBowlingView::AssertValid() const
{
	CFormView::AssertValid();
}

void CBowlingView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CBowlingDoc* CBowlingView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBowlingDoc)));
	return (CBowlingDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBowlingView message handlers


void CBowlingView::OnInitialUpdate()
{

	CFormView::OnInitialUpdate();	
	CWnd* pEdit = (CWnd*)GetDlgItem(IDC_BOARD);
	pEdit->GetWindowRect(rect);
	ScreenToClient(rect);
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();	
	AssignPointerToControls();
	m_slider1.SetRange(0, 100);		//slider for target position
	m_slider2.SetRange(0, 100);		//slider for curving degree	
	m_slider3.SetRange(0, 100);		//slider for throwing power
	m_slider4.SetRange(0, 100);		//slider for standing point
	m_slider5.SetRange(0, 100);		//slider for difficulty level	
	m_slider6.SetRange(0, 100);		//slider for view mode
	
	m_slider1.SetPos(50);
	m_slider2.SetPos(50);
	m_slider3.SetPos(50);
	m_slider4.SetPos(50);
	m_slider5.SetPos(20);
	m_slider6.SetPos(0);			//set slider control to top
	
	PreviousView = m_slider6.GetPos();		//set previous view height to slider control
	PrepareMemoryDC();	//prepare memory DC for bowling place
	SetPinLocation();	//Set Location of Pins	
	InvalidateCtrl();	//draw background and pin image, gutter line, target marks		
	ObtainScoreRecord();	//display score record	
	DisplayScoreRecords();	
	InitializeVariables();	//initialize various variables
	SetTimer(2, 20, NULL);	//start target animation
	
	//if(hTimer)	timeKillEvent(hTimer);
	//hTimer=::timeSetEvent(100,10,Timer,(unsigned long)this, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);	
	
}

void CBowlingView::OnStart() 
{	
	if (!EndGame)
	{ 
		if (scorefile != NULL)
		{
			fclose(scorefile);
		}		
		scorefile = fopen("Score.dat", "a+t");
		
		bGutter = FALSE;		//not gutter state		
		PlaySound("roll.wav",NULL,SND_ASYNC);								//play rolling sound
		
		srand( (unsigned)time( NULL ) );
		//SeekAbility();												//seek and introduce ability to the game		
		CurveNo = CurveNo + 0.02*fabs(50.0-m_slider2.GetPos());		//Curve points		
		
		TimerCount = 0;										//initialize timer count doun						
		TimerCountTarget = rand() % 1000;
		
		Frames = BaseFrames *float(rect.Height()-BottomPinY)/rect.Height();		//increase frame number in case bottom pin location is negative
		KillTimer(2);										//kill timer for target	
		SetTimer(1, 0.5*m_slider3.GetPos()+10.0, NULL);		//set bowl speed
		
	}		
}

void CBowlingView::OnNewgame()		//initialize new game
{		
	InitializeVariables();				//initialize various variables	
	InvalidateCtrl();					//initialize bowling interface
	CWnd* pEdit;						//initialize score board
	CString str;
	str.Format("");
	pEdit=GetDlgItem(IDC_EDIT1A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT1B);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT2A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT2B);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT3A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT3B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT4A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT4B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT5A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT5B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT6A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT6B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT7A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT7B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT8A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT8B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT9A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT9B);
	pEdit->SetWindowText(str);
	pEdit=GetDlgItem(IDC_EDIT10A);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT10B);
	pEdit->SetWindowText(str);			
	pEdit=GetDlgItem(IDC_EDIT10C);
	pEdit->SetWindowText(str);			

}

void CBowlingView::PrepareMemoryDC()
{	
	CDC* pDC = GetDC();
	if (BowlDC.GetSafeHdc() == NULL)
	{
		BowlDC.CreateCompatibleDC(pDC);		
		BowlBMP.CreateCompatibleBitmap(pDC, rect.right-rect.left, rect.bottom-rect.top);		
		pBowlBMP = BowlDC.SelectObject(&BowlBMP);
		
		CRect BallRect;
		BallRect.left = 0;
		BallRect.right = BallImageX;
		BallRect.top = 0;
		BallRect.bottom = BallImageY;		
		BallDC.CreateCompatibleDC(pDC);
		BallMDC.CreateCompatibleDC(pDC);
		BallBMP.CreateCompatibleBitmap(pDC, BallRect.Width(), BallRect.Height());
		BallMBMP.CreateCompatibleBitmap(pDC, BallRect.Width(), BallRect.Height());
		BallBMP.DeleteObject();
		BallBMP.LoadBitmap(IDB_BALLBMP);
		BallMBMP.DeleteObject();
		BallMBMP.LoadBitmap(IDB_BALLMASKBMP);
		pBallBMP = BallDC.SelectObject(&BallBMP);
		pBallMBMP = BallMDC.SelectObject(&BallMBMP);

		CRect BackRect;
		BackRect.left = 0;
		BackRect.right = BackImageX;
		BackRect.top = 0;
		BackRect.bottom = BackImageY;		
		memDC.CreateCompatibleDC(pDC);		
		BackBMP.CreateCompatibleBitmap(pDC, BackRect.Width(), BackRect.Height());		
		BackBMP.DeleteObject();
		BackBMP.LoadBitmap(IDB_BACKBMP);		
		pBackBMP = memDC.SelectObject(&BackBMP);

		CRect ShoesRect;
		ShoesRect.left = 0;
		ShoesRect.right = ShoesImageX;
		ShoesRect.top = 0;
		ShoesRect.bottom = ShoesImageY;		
		ShoesDC.CreateCompatibleDC(pDC);		
		ShoesMDC.CreateCompatibleDC(pDC);		
		ShoesBMP.CreateCompatibleBitmap(pDC, ShoesRect.Width(), ShoesRect.Height());		
		ShoesMBMP.CreateCompatibleBitmap(pDC, ShoesRect.Width(), ShoesRect.Height());		
		ShoesBMP.DeleteObject();
		ShoesMBMP.DeleteObject();
		ShoesBMP.LoadBitmap(IDB_SHOESBMP);		
		ShoesMBMP.LoadBitmap(IDB_SHOESMASKBMP);		
		pShoesBMP = ShoesDC.SelectObject(&ShoesBMP);
		pShoesMBMP = ShoesMDC.SelectObject(&ShoesMBMP);

		CRect PinRect;
		PinRect.left = 0;
		PinRect.right = PinImageX;
		PinRect.top = 0;
		PinRect.bottom = PinImageY;		
		PinDC.CreateCompatibleDC(pDC);
		PinMDC.CreateCompatibleDC(pDC);
		PinBMP.CreateCompatibleBitmap(pDC, PinRect.Width(), PinRect.Height());
		PinMBMP.CreateCompatibleBitmap(pDC, PinRect.Width(), PinRect.Height());
		PinBMP.DeleteObject();
		PinBMP.LoadBitmap(IDB_PINBMP);
		PinMBMP.DeleteObject();
		PinMBMP.LoadBitmap(IDB_PINMASKBMP);
		pPinBMP = PinDC.SelectObject(&PinBMP);
		pPinMBMP = PinMDC.SelectObject(&PinMBMP);		
	}
	ReleaseDC(pDC);
}

void CBowlingView::DrawBowlRolling()		//Draw bowling ball animation and seek fell down pins
{
	//--- (1) make screen DC ------//
	CDC* pDC = GetDC();
	
	//--- (2) Prepare pointers attached to temporary DC ----//
	CDC tempDC;
	CBitmap tempBMP;
	CBitmap* pBMP;
	tempDC.CreateCompatibleDC(pDC);
	tempBMP.CreateCompatibleBitmap(pDC, rect.right - rect.left, rect.bottom - rect.top);
	pBMP = tempDC.SelectObject(&tempBMP);
	
	//--- (3) paste BowlDC to temporary DC ---//		
	tempDC.BitBlt(0,0,rect.Width(),rect.Height(),&BowlDC,0,0,SRCCOPY);	
		
	//--- (4) seek position of bowling ball (frame by frame) --//
	float Width = rect.Width();
	float Height = rect.Height();	
	float posX, finalX;	
	float Power = m_slider3.GetPos()/100.0;		//Power of throwing		
	standingX = m_slider4.GetPos()/100.0*Width;		//Standing point rect.Height()-BottomPinY
	float Curve;
	float CurveFactor = 0.02*fabs(standingX-targetX)/rect.Width();
	switch (LaneStatus)
	{
	case 0:
		if (targetX > standingX)
			Curve = -1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		else
			Curve = 1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		break;
	case 1:
		if (targetX > standingX)
			Curve = -1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		else
			Curve = 1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		break;
	case 2:
		Curve = 1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		break;
	case 3:
		Curve = 1.0*CurveFactor*LaneStatusDegree + (50-m_slider2.GetPos())/100.0;	//Degree of Curve to right or left	
		break;
	}
	
	finalX = float(TimerCount)/float(Frames)*(Height)*(targetX-standingX)/targetY + standingX;	//in case streight ball
	posX = finalX-3.0*Curve*Width*pow(float(TimerCount)/float(Frames),-4.0/100.0*m_slider3.GetPos()+6.0);		//in case hook ball

	//--- (5) seek fell down pins by collision with bowling ball (frame by frame)--//
	if ((posX<GutterLine || posX>Width-GutterLine) && bGutterSound == FALSE)	//play gutter sound
	{
		PlaySound("gutter.wav",NULL,SND_ASYNC);
		bGutterSound = TRUE;
	}
	if (posX<GutterLine || ((bGutter == TRUE) && (posX < Width/2.0)))			//gutterball
	{
		bGutter = TRUE;
		posX = GutterLine - BallRadius;
	}
	if (posX>Width-GutterLine || ((bGutter == TRUE) && (posX > Width/2.0)))
	{
		bGutter = TRUE;
		posX = Width - GutterLine + BallRadius;	
	}
	float posY = (float(Frames-TimerCount))/float(Frames) * (Height-BottomPinY)+BottomPinY;				//Y position of Bowling Ball	
	
	float ratio;	//to determine collision result	
	BOOL  DownAlready;	//to determine whether the pin is already down;	
	float Sep[10];		//to determine direction of collision
	Sep[0] = 1.5;
	Sep[1] = 0.0;
	Sep[2] = -1.5;
	Sep[3] = -10.0;
	Sep[4] = 10.0;

	for (int L=0; L<10; L++)
	{
		if (pow(pow(PinXY[L].x - posX, 2) + pow(PinXY[L].y - posY, 2), 0.5) < (BallRadius + PinRadius+fabs(Curve)*5.0+Power*2.0))
		{			
			if (PinUp[L]==FALSE)		//identify whether the pin is previously fell down
			{
				DownAlready=TRUE;
			}
			else
			{
				DownAlready=FALSE;
				PinUp[L] = FALSE;		//Set the pin is fell down
			}

			if (bCollisionSound == FALSE && DownAlready == FALSE)		//play collision sound
			{
				PlaySound("collision.wav",NULL,SND_ASYNC);
				bCollisionSound = TRUE;
			}
	
			

			if (PinXY[L].y == posY)		//ratio of X distance between ball and pin to Y distance between ball and pin
			{
				ratio = 100;
			}
			else
			{
				ratio= (PinXY[L].x-posX)/(PinXY[L].y - posY);
			}

			if (DownAlready == FALSE)
			{				
				if (L==4 && (posY > PinXY[L].y))
				{
					if (ratio <= Sep[0] && ratio > Sep[1])
					{
						PinUp[0] = FALSE;
					}
					else if (ratio <=Sep[1] && ratio > Sep[2])
					{
						PinUp[1] = FALSE;
					}
					else if (ratio <=Sep[2] && ratio > Sep[3])
					{	
						PinUp[1] = FALSE;
						PinUp[2] = FALSE;
						
					}			
					else if (ratio <=Sep[3])
					{
						float pinposx, pinposy;
						PinUp[2] = FALSE;
						PinUp[3] = FALSE;					
					}
					else
					{
					}
				}

				if (L==5 && (posY > PinXY[L].y))
				{
					if (ratio <= Sep[4] && ratio > Sep[0])
					{
						PinUp[0] = FALSE;
						PinUp[1] = FALSE;						
					}
					else if (ratio <=Sep[0] && ratio > Sep[1])
					{
						PinUp[1] = FALSE;						
					}
					else if (ratio <=Sep[1] && ratio > Sep[2])
					{
						PinUp[2] = FALSE;						
					}
					else if (ratio <=Sep[2] && ratio > Sep[3])
					{
						PinUp[2] = FALSE;						
						PinUp[3] = FALSE;
					}
					else
					{
					}

				}

				if (L==6 && (posY > PinXY[L].y))
				{
					if (ratio > Sep[4])
					{
						PinUp[0] = FALSE;
						PinUp[1] = FALSE;
					}
					else if (ratio <=Sep[4] && ratio > Sep[0])
					{
						PinUp[1] = FALSE;
						PinUp[2] = FALSE;
					}
					else if (ratio <=Sep[0] && ratio > Sep[1])
					{						
						PinUp[2] = FALSE;
					}			
					else if (ratio <=Sep[1] && ratio > Sep[2])
					{
						PinUp[3] = FALSE;
					}
					else
					{
					}
				}

				if (L==7 && (posY > PinXY[L].y))
				{
					if (ratio>Sep[0])
					{					
					}
					else if (ratio <= Sep[0] && ratio > Sep[1])
					{
						PinUp[4] = FALSE;
						PinUp[0] = FALSE;
					}
					else if (ratio <=Sep[1] && ratio > Sep[2])
					{
						PinUp[5] = FALSE;
						PinUp[2] = FALSE;						
						if (rand() % 10 < 9 || abs(Curve)>0.5 || Power > 0.5)
							PinUp[3] = FALSE;
					}
					else if (ratio <=Sep[2] && ratio > Sep[3])
					{
						//PinUp[1] = FALSE;
						PinUp[5] = FALSE;						
						PinUp[6] = FALSE;
						
						if (rand() % 10 < 9 || abs(Curve)>0.5 || Power > 0.5)
						{
							PinUp[2] = FALSE;
							PinUp[3] = FALSE;
						}
					}			
					else
					{						
					}					
				}

				if (L==8 && (posY > PinXY[L].y))
				{
					if (ratio>Sep[4])
					{					
					}
					else if (ratio <= Sep[4] && ratio > Sep[0])
					{
						PinUp[5] = FALSE;
						PinUp[4] = FALSE;
						
						if (rand() % 10 < 9 || abs(Curve)>0.5 || Power > 0.5)
						{							
							PinUp[0] = FALSE;						
							PinUp[1] = FALSE;
						}
						
					}
					else if (ratio <=Sep[0] && ratio > Sep[1])
					{
						PinUp[5] = FALSE;
						PinUp[1] = FALSE;
						
						if (rand() % 10 < 9 || abs(Curve)>0.5 || Power > 0.5)
						{							
							PinUp[0] = FALSE;													
						}

					}
					else if (ratio <=Sep[1] && ratio > Sep[2])
					{						
						PinUp[6] = FALSE;
						PinUp[3] = FALSE;											
					}			
					else
					{						
					}					

				}

				if (L==9 && (posY > PinXY[L].y))
				{
					if (ratio <= Sep[4] && ratio > Sep[1])
					{	
						if (posX < PinXY[9].x -  2*(BallRadius+PinRadius)/3.0 || posX > PinXY[9].x +  2*(BallRadius+PinRadius)/3.0)
						{
							PinUp[7] = FALSE;
							PinUp[4] = FALSE;													
							PinUp[0] = FALSE;
						}
						else
						{
							if (rand() % 10 < 3)							
								PinUp[7] = FALSE;
							if ((rand()*rand()) % 10 < 3)
								PinUp[4] = FALSE;
							if ((rand()*rand()*rand()) % 10 < 3)
								PinUp[0] = FALSE;
							if (PinUp[7] == TRUE && PinUp[4] == FALSE)		//exclude the case only center pin remain unfell down
								PinUp[7] = FALSE;
						}
					}
					else if (ratio <= Sep[1] && ratio > Sep[3])
					{					
						if (posX < PinXY[9].x -  2*(BallRadius+PinRadius)/3.0 || posX > PinXY[9].x +  2*(BallRadius+PinRadius)/3.0)
						{
							PinUp[8] = FALSE;
							PinUp[6] = FALSE;													
							PinUp[3] = FALSE;
						}
						else
						{
							if (rand() % 10 < 3)
								PinUp[8] = FALSE;
							if ((rand()*rand()) % 10 < 3)
								PinUp[6] = FALSE;
							if ((rand()*rand()*rand()) % 10 < 3)
								PinUp[3] = FALSE;
							if (PinUp[8] == TRUE && PinUp[6] == FALSE)		//exclude the case only center pin remain unfell down
								PinUp[8] = FALSE;
						}
					}
					else
					{						
					}					
				}				
			}			
		}
	}
	
	//-- (6) draw bowling ball animation (frame by frame)--//	
	float X[5], Y[5];
	float rX[5], rY[5];

	X[0] = posX-BallRadius;	//left lower
	X[1] = posX+BallRadius;	//right lower
	X[2] = posX-BallRadius;	//left upper
	X[3] = posX+BallRadius;	//right upper			

	Y[0] = posY-BallRadius;
	Y[1] = posY-BallRadius;
	Y[2] = posY+BallRadius;
	Y[3] = posY+BallRadius;
			
	for (int m=0; m<4; m++)
	{
		CPoint InputPoint, OutputPoint;
		InputPoint.x = X[m];
		InputPoint.y = Y[m];

		OutputPoint = GetRealPoint(InputPoint);
		rY[m] = OutputPoint.y;
		rX[m] = OutputPoint.x;
	}		
			
	tempDC.StretchBlt(rX[2], rY[2]-(rX[1]-rX[0]), rX[1]-rX[0], rX[1]-rX[0], &BallMDC, 0, 0, BallImageX, BallImageY, SRCAND);
	tempDC.StretchBlt(rX[2], rY[2]-(rX[1]-rX[0]), rX[1]-rX[0], rX[1]-rX[0], &BallDC, 0, 0, BallImageX, BallImageY, SRCPAINT);						

	//--- (7) paste 10 pin image to temporary DC ---//
	DrawPins(&tempDC);			

	//--- (8) Paste temporary DC to screen DC ----//
	pDC->BitBlt(rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top, &tempDC, 0, 0, SRCCOPY);

	//--- (9) Release pointers attached to temporary DC ----//
	tempDC.SelectObject(pBMP);
	tempBMP.DeleteObject();	
	tempDC.DeleteDC();

	//--- (10) release screen DC ------//
	ReleaseDC(pDC);	
}

void CBowlingView::OnDraw(CDC* pDC) 
{	
	DisplayScoreRecords();
}

void CBowlingView::InvalidateCtrl()		//draw background rectangle and pin image, gutter line, target marks
{
	//--- (1) Prepare pen and brush object ----//
	CBrush BowlBrush;
	CBrush* pBrush;
	CPen  BrushPen, GutterPen;
	CPen* pPen;
	
	//--- (2) Prepare pointers attached to temporary DC ----//
	CDC			boardDC;
	CBitmap		boardBMP;	
	CBitmap*	pboardBMP;
	
	boardDC.CreateCompatibleDC(&BowlDC);
	boardBMP.CreateCompatibleBitmap(&BowlDC, 71, 26);	//load board bitmap object	
	boardBMP.DeleteObject();
	boardBMP.LoadBitmap(IDB_BEFORE);	
	pboardBMP = boardDC.SelectObject(&boardBMP);
	
	//------ (3) Draw background rectangle and image--------//
	float ViewPoint = rect.Height()*ViewAngle*(100-m_slider6.GetPos()+25);
	float ShiftUpper = -0.5*rect.Width()*atan(rect.Height()/ViewPoint)/atan(0.5*rect.Width()/ViewPoint);	
	BrushPen.CreatePen(PS_SOLID, 2, RGB(128,0,92));		
	pPen = BowlDC.SelectObject(&BrushPen);
	
	BowlDC.Rectangle(0, 0, rect.Width(), rect.Height());
	BowlDC.SelectObject(pPen);
	BrushPen.DeleteObject();			
	BowlDC.StretchBlt(0, 0 , rect.Width(), rect.Height(), &memDC, 0, 0, BackImageX, BackImageY, SRCCOPY);		
	BowlDC.BitBlt(90, 10,  71, 26, &boardDC, 0, 0, SRCCOPY);
		
	//--- (4) Release pointers attached to temporary DC ----//
	boardDC.SelectObject(pboardBMP);
	boardBMP.DeleteObject();	
	boardDC.DeleteDC();		

}

void CBowlingView::OnTimer(UINT nIDEvent) 
{
  if (nIDEvent == 1)
  {	
	if (TimerCount <= Frames)
	{		
		DrawBowlRolling();			//draw ball animation and seek fell down pins			
		TimerCount++;				//increase timer count
	}
	else
	{	
		CalculateScore();			//calculate scores		
		bGutterSound = FALSE;		//turn off gutter sound
		bCollisionSound = FALSE;	//turn off collision sound
		KillTimer(1);				//kill ball animation timer
		if (RefreshRound)			//prepare next round
		{
			for (int K=0; K<10; K++)
			{
				PinUp[K] = TRUE;				
				if (Round != 10)
				{
					Point[Round][0] = 0;
				}
			}
			DrawBowlRolling();
			RefreshRound = FALSE;
		}
		if (EndGame)		//save current score data to score file
		{
			fprintf(scorefile, "%3d, %.0f, %.0f, %.0f, %.2f\n", Points, StrikeNo, SpareNo, NonSpareNo, CurveNo);
			ObtainScoreRecord();	
			DisplayScoreRecords();
			KillTimer(2);
			ShowCeremony();
			SetTimer(3, 1000, NULL);		//set ceremony timer			
		}
		else
		{	
			float NewStanding;
			NewStanding = m_slider4.GetPos() + (5 - rand() % 10)*5.0;		//slider for standing point
			m_slider4.SetPos(NewStanding);
			SetTimer(2, 20, NULL);		//set target animation timer
		}
	}
  }
  else if (nIDEvent == 2)
  {	  
	  TimerCountTarget++;		//timer count for target
	  if (PreviousView != m_slider6.GetPos())
	  {
		  InvalidateCtrl();
		  PreviousView = m_slider6.GetPos();
	  }	  
	  DrawTarget();					//draw target animation 	  	  	  
  }
  else
  {
	  TimerCountCeremony--;
	  if (TimerCountCeremony < 1)
	  {
		  KillTimer(3);
		  OnNewgame();
		  SetTimer(2, 20, NULL);
	  }		
  }
  CFormView::OnTimer(nIDEvent);
}

void CBowlingView::GetSliderValue()
{	

}

void CBowlingView::CalculateScore()		//calculate current score every throw
{
	Points=0;							//initialize current score points
	int	K;
	CString str;
	CWnd* pEdit;
	
	if (Round != 10)
	{
		CalculateScoreOfRound(Round);
	}
	else
	{
		if (Count==0)
		{
			for (K=0; K<10; K++)
			{
				if (PinUp[K] == FALSE)
					Point[Round][0]++;
			}
			str.Format("%d",Point[Round][0]);
			pEdit=GetDlgItem(IDC_EDIT10A);
			pEdit->SetWindowText(str);
			if (Point[Round][0]==10)
			{
				if (Point[Round-2][0]==10 && Point[Round-1][0]==10)
				{
					RoundStatus = 4;
				}
				else if (Point[Round-1][0] == 10)
				{
					RoundStatus = 3;
				}
				else
				{
					RoundStatus = 1;
				}
				
				StrikeNo = StrikeNo + 1;
				RefreshRound = TRUE;			
			}
			else
			{
				if (bGutter && Point[Round][0] == 0)
				{
					RoundStatus = 5;
				}
				else
				{
					RoundStatus = 0;
				}
			}
			Count++;			
		}
		else if (Count==1)
		{
			if (Point[Round][0] != 10)
			{
				for (K=0; K<10; K++)
				{
					if (PinUp[K] == FALSE)
						Point[Round][1]++;
				}
				Point[Round][1]=Point[Round][1]-Point[Round][0];								
				if (Point[Round][0]+Point[Round][1] <10)
				{
					EndGame = TRUE;
				}
				else
				{
					RefreshRound = TRUE;			
				}
			}
			else
			{
				for (K=0; K<10; K++)
				{
					if (PinUp[K] == FALSE)
						Point[Round][1]++;
				}

				if (Point[Round][1]==10)
				{			
					RefreshRound = TRUE;			
				}
			}
			str.Format("%d",Point[Round][1]);
			pEdit=GetDlgItem(IDC_EDIT10B);
			
			if (Point[Round][0]+Point[Round][1] == 20)		//calculate spare success or failure counts
			{
				if (Point[Round-1][0] == 10)
				{					
					RoundStatus = 4;
				}
				else
				{
					RoundStatus = 3;
				}
					StrikeNo = StrikeNo + 1;
			}
			else if (Point[Round][0]+Point[Round][1] == 10)
			{
				RoundStatus = 2;
				SpareNo = SpareNo + 1;
			}
			else if (Point[Round][0]+Point[Round][1] < 10)
			{
				if (bGutter && Point[Round][1] == 0)
				{
					RoundStatus = 5;
				}
				else
				{
					RoundStatus = 0;
				}
				NonSpareNo = NonSpareNo + 1;
			}
			else
			{
				if (bGutter && Point[Round][1] == 0)
				{
					RoundStatus = 5;
				}
				else
				{
					RoundStatus = 0;
				}				
			}

			pEdit->SetWindowText(str);			
			
			Count++;
		}
		else
		{
			if (Point[Round][0]+Point[Round][1] <10)
			{
				EndGame = TRUE;
			}
			else if (Point[Round][1] != 10)
			{
				for (K=0; K<10; K++)
				{
					if (PinUp[K] == FALSE)
						Point[Round][2]++;
				}
				if (Point[Round][0] == 10)
					Point[Round][2]=Point[Round][2]-Point[Round][1];								
			
				str.Format("%d",Point[Round][2]);
				pEdit=GetDlgItem(IDC_EDIT10C);
				pEdit->SetWindowText(str);			

				if (Point[Round][1]+Point[Round][2] == 10)		//calculate spare success or failure counts
				{					
					RoundStatus = 2;
					SpareNo = SpareNo + 1;
				}
				else
				{
					if (Point[Round][2] == 10)
					{
						if (Point[Round][0] == 10 && Point[Round][1] == 10)
						{
							RoundStatus = 4;
						}
						else if (Point[Round][1] == 10)
						{
							RoundStatus = 3;
						}
						else
						{
							RoundStatus = 1;
						}
						
						StrikeNo = StrikeNo + 1;
					}
					else
					{
						if (Point[Round][0] == 10)
						{
							if (bGutter && Point[Round][2] == 0)
							{
								RoundStatus = 5;
							}
							else
							{
								RoundStatus = 0;
							}
							
							NonSpareNo = NonSpareNo + 1;							
						}
					}
				}
				EndGame = TRUE;
			}
			else
			{
				for (K=0; K<10; K++)
				{
					if (PinUp[K] == FALSE)
						Point[Round][2]++;
				}
				if (Point[Round][2] == 10)
				{
					RoundStatus = 4;
					StrikeNo = StrikeNo + 1;
				}
				else
				{
					if (bGutter && Point[Round][2] == 0)
					{
						RoundStatus = 5;
					}
					else
					{
						RoundStatus = 0;
					}
				}
				str.Format("%d",Point[Round][2]);
				pEdit=GetDlgItem(IDC_EDIT10C);
				pEdit->SetWindowText(str);	
				
				EndGame = TRUE;
			}			
		}		
	}
	
	for (int L=1;L<=Round;L++)
	{
		if (Point[L][0]==10)
		{
			if(Point[L+1][0]==10)
			{
				P[L]=20+Point[L+2][0];
			}
			else
			{
				P[L]=10+Point[L+1][0]+Point[L+1][1];
			}
		}			
		else if (Point[L][0]+Point[L][1]==10)
		{
			P[L]=10+Point[L+1][0];
		}
		else
		{
			P[L]=Point[L][0]+Point[L][1];
		}
	}	
	if (Round==10)
	{
		if (Point[9][0]==10 && Point[10][0]==10)
		{
			P[9] = 20 + Point[10][1];
		}
		P[10]=Point[10][0]+Point[10][1]+Point[10][2];
	}

	for (L=1;L<=Round;L++)
	{
		Points=Points+P[L];
	}	
	DisplayScoreRecords();
}

void CBowlingView::DrawTarget()
{
	//--- (1) make screen DC ------//
	CDC* pDC = GetDC();
	
	//--- (2) Prepare pointers attached to temporary DC ----//
	CDC tempDC, boardDC;
	CBitmap tempBMP, boardBMP;
	CBitmap* pBMP;
	CBitmap* pboardBMP;

	tempDC.CreateCompatibleDC(pDC);
	tempBMP.CreateCompatibleBitmap(pDC, rect.right - rect.left, rect.bottom - rect.top);
	boardDC.CreateCompatibleDC(pDC);
	boardBMP.CreateCompatibleBitmap(pDC, 71, 26);		

	//--- (3) Prepare Pen object ----//
	CPen Target;
	CPen* pTarget;
	Target.CreatePen(PS_SOLID, 3, RGB(0, 0, 128));
	pTarget = tempDC.SelectObject(&Target);			
	float DeviationArc = 0.5*Deviation/(Deviation + 0.5);
	targetX = DeviationArc*sin(float(TimerCountTarget)/4.0)*rect.Width() + m_slider1.GetPos()*0.01*rect.Width();
	targetY = 0.5*DeviationArc*fabs(cos(float(TimerCountTarget)/4.0))*rect.Width() + m_slider5.GetPos();
	
	//--- (4) paste BowlDC to temporary DC ---//	
	pBMP = tempDC.SelectObject(&tempBMP);
	tempDC.BitBlt(0,0,rect.Width(),rect.Height(),&BowlDC,0,0,SRCCOPY);	
	
	boardBMP.DeleteObject();

	switch (RoundStatus)
	{
	case 0:
		boardBMP.LoadBitmap(IDB_BEFORE);
		break;
	case 1:
		boardBMP.LoadBitmap(IDB_STRIKE);
		break;
	case 2:
		boardBMP.LoadBitmap(IDB_SPARE);
		break;
	case 3:
		boardBMP.LoadBitmap(IDB_DOUBLE);
		break;
	case 4:
		boardBMP.LoadBitmap(IDB_TURKEY);
		break;
	case 5:
		boardBMP.LoadBitmap(IDB_GUTTER);
		break;

	}	
	pboardBMP = boardDC.SelectObject(&boardBMP);
	tempDC.BitBlt(90, 10, 71, 26, &boardDC, 0, 0, SRCCOPY);	

	//--- (5) Draw shoes image to temporary DC -----//
	CPoint InputPointShoes, OutputPointShoes;
	InputPointShoes.x = m_slider4.GetPos()/100.0*rect.Width();
	InputPointShoes.y = rect.Height();
	OutputPointShoes = GetRealPoint(InputPointShoes);
	tempDC.BitBlt(OutputPointShoes.x-10, rect.Height()-28, ShoesImageX, ShoesImageY,
			&ShoesMDC, 0, 0, SRCAND);
	tempDC.BitBlt(OutputPointShoes.x-10, rect.Height()-28, ShoesImageX, ShoesImageY,
			&ShoesDC, 0, 0, SRCPAINT);
	
	//--- (6) Draw target image to temporary DC -----//	
	CPoint InputPoint, OutputPoint;
	InputPoint.x = targetX;
	InputPoint.y = rect.Height() - targetY;
	OutputPoint = GetRealPoint(InputPoint);	
	tempDC.MoveTo(OutputPoint.x-5, OutputPoint.y-targetY);
	tempDC.LineTo(OutputPoint.x+5, OutputPoint.y-targetY);
	tempDC.MoveTo(OutputPoint.x, OutputPoint.y-targetY - 5);
	tempDC.LineTo(OutputPoint.x, OutputPoint.y-targetY + 5);	
	

	//--- (7) Draw 10 Pin image to temporary DC --------//		
	DrawPins(&tempDC);	

	//--- (8) Paste temporary DC to screen DC ----//
	pDC->BitBlt(rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top, &tempDC, 0, 0, SRCCOPY);

	//--- (9) Release pointers attached to temporary DC ----//
	tempDC.SelectObject(pTarget);	
	Target.DeleteObject();		

	boardDC.SelectObject(pboardBMP);
	boardBMP.DeleteObject();

	tempDC.SelectObject(pBMP);	
	tempBMP.DeleteObject();	

	boardDC.DeleteDC();
	tempDC.DeleteDC();

	//--- (10) release screen DC ------//
	ReleaseDC(pDC);
}

void CBowlingView::SetPinLocation()
{
	
	for (int L=0; L<4; L++)
	{
		PinXY[L].x = rect.Width()*0.5 - 3.0*PinIntervalX/2.0 + PinIntervalX*L;
		PinXY[L].y = BottomPinY+PinIntervalY+0;
	}

	for (L=4; L<7; L++)
	{
		PinXY[L].x = rect.Width()*0.5 - 2.0*PinIntervalX/2.0 + PinIntervalX*(L-4);
		PinXY[L].y = BottomPinY+PinIntervalY*2+0;
	}
	
	for (L=7; L<9; L++)
	{
		PinXY[L].x = rect.Width()*0.5 - PinIntervalX/2.0 + PinIntervalX*(L-7);
		PinXY[L].y = BottomPinY+PinIntervalY*3+0;
	}
	
		PinXY[9].x = rect.Width()*0.5 - 0 + PinIntervalX*0;
		PinXY[9].y = BottomPinY+PinIntervalY*4+0;		
}

void CBowlingView::ObtainScoreRecord()
{	
	float TotalScore = 0;
	float TotalStrike = 0;
	float TotalSpare = 0;
	float TotalNonSpare = 0;
	float TotalCurve = 0;
	float TotalRecent5Score = 0;
	float TotalRecent5Strike = 0;
	float TotalRecent5Spare = 0;
	float TotalRecent5NonSpare = 0;
	float TotalRecent5Curve = 0;
	
	BestScore = 0;			//Best score
	WorstScore = 300;			//Worst score
	Recent5Best = 0;			//Recent 5 game Best score
	Recent5Worst = 300;			//Recent 5 game Worst score
			
	if (scorefile != NULL)
	{
		fclose(scorefile);
	}
	
	NumberOfLines = 0;
	int LineNo, CharNo, ch;
	char buffer[255];
	CString sTemp;		//temporary string
	
	//--- Cycle until end of file reached: obtain line number---//
	if ((scorefile = fopen("score.dat", "r")) != NULL)
	{
		while(fgets(buffer, 255, scorefile) != NULL)
		{
			NumberOfLines++;
		}	
		fclose(scorefile);
	}

	//--- Obtain score record total ---//
	if ((scorefile = fopen("score.dat", "r")) != NULL)
	{
	if (NumberOfLines > 0)
	{
		for (int LineNo=0; LineNo<NumberOfLines; LineNo++)
		{
			
            //-----stop getting character array when meet ','-----//
			CharNo=0;
            do
            {
				ch=fgetc(scorefile);    //get character array                        
				buffer[CharNo]=(char)ch;                 
				CharNo++;                            
			} while(buffer[CharNo-1] != ',' && feof( scorefile ) == 0);                			
			buffer[CharNo-1] = '\0';
			sTemp.Format("%s",buffer);
			
			TotalScore = TotalScore + atof(sTemp);		//sum total score
			
			if (LineNo >= (NumberOfLines-5))
			{
				TotalRecent5Score = TotalRecent5Score + atof(sTemp);	//sum recent 5 game score
				if (atof(sTemp)<Recent5Worst)						//obtain recent 5 worst score
					Recent5Worst = atof(sTemp);
				if (atof(sTemp)>Recent5Best)						//obtain recent 5 best score
					Recent5Best = atof(sTemp);
			}
			if (atof(sTemp)<WorstScore)
				WorstScore = atof(sTemp);
			if (atof(sTemp)>BestScore)
				BestScore = atof(sTemp);
			
						
            //-----stop getting character array when meet ','-----//
			CharNo=0;
            do
            {
				ch=fgetc(scorefile);    //get character array                        
				buffer[CharNo]=(char)ch;                 
				CharNo++;                            
			} while(buffer[CharNo-1] != ',' && feof( scorefile ) == 0);                			
			buffer[CharNo-1] = '\0';
			sTemp.Format("%s",buffer);
			TotalStrike = TotalStrike + atof(sTemp);
			if (LineNo >= (NumberOfLines-5))
			{
				TotalRecent5Strike = TotalRecent5Strike + atof(sTemp);	//sum recent 5 strikes 			
			}

            //-----stop getting character array when meet ','-----//
			CharNo=0;
            do
            {
				ch=fgetc(scorefile);    //get character array                        
				buffer[CharNo]=(char)ch;                 
				CharNo++;                            
			} while(buffer[CharNo-1] != ',' && feof( scorefile ) == 0);                			
			buffer[CharNo-1] = '\0';
			sTemp.Format("%s",buffer);
			TotalSpare = TotalSpare + atof(sTemp);
			if (LineNo >= (NumberOfLines-5))
			{
				TotalRecent5Spare = TotalRecent5Spare + atof(sTemp);	//sum recent 5 spares 			
			}
			
            //-----stop getting character array when meet ','-----//
			CharNo=0;
            do
            {
				ch=fgetc(scorefile);    //get character array                        
				buffer[CharNo]=(char)ch;                 
				CharNo++;                            
			} while(buffer[CharNo-1] != ',' && feof( scorefile ) == 0);                			
			buffer[CharNo-1] = '\0';
			sTemp.Format("%s",buffer);
			TotalNonSpare = TotalNonSpare + atof(sTemp);
			if (LineNo >= (NumberOfLines-5))
			{
				TotalRecent5NonSpare = TotalRecent5NonSpare + atof(sTemp);	//sum recent 5 spare failure 			
			}
			
			//-----stop getting character array when meet '\n'-----//
			CharNo=0;
            do
            {
				ch=fgetc(scorefile);    //get character array                        
				buffer[CharNo]=(char)ch;                 
				CharNo++;                            
			} while(buffer[CharNo-1] != '\n' && feof( scorefile ) == 0);                			
			buffer[CharNo-1] = '\0';
			sTemp.Format("%s",buffer);
			TotalCurve = TotalCurve + atof(sTemp);
			if (LineNo >= (NumberOfLines-5))
			{
				TotalRecent5Curve = TotalRecent5Curve + atof(sTemp);	//sum recent 5 curve points 			
			}

		}
		AvgScore = TotalScore/NumberOfLines;									//Average score		
		AvgStrike = TotalStrike/(TotalStrike+TotalSpare+TotalNonSpare)*100.0;	//Average strike rate
		AvgSpare = TotalSpare/(TotalSpare+TotalNonSpare)*100.0;					//Average Spare rate
		AvgCurve = TotalCurve/NumberOfLines;									//Average curve points
		
		Recent5Score = TotalRecent5Score/5.0;									//Recent 5 game average
		Recent5Strike = TotalRecent5Strike/(TotalRecent5Strike+TotalRecent5Spare+TotalRecent5NonSpare)*100.0;	//Average strike rate
		Recent5Spare = TotalRecent5Spare/(TotalRecent5Spare+TotalRecent5NonSpare)*100.0;					//Average Spare rate
		Recent5Curve = TotalRecent5Curve/5.0;									//Average curve points
	}
	fclose(scorefile);	
	}
}

void CBowlingView::DrawPins(CDC* SourceDC)
{
	for (int L=0; L<10; L++)
	{
		if (PinUp[L] == TRUE)
		{	
			float X[5], Y[5];
			float rX[5], rY[5];

			X[0] = PinXY[L].x-PinRadius;	//left lower
			X[1] = PinXY[L].x+PinRadius;	//right lower
			X[2] = PinXY[L].x-PinRadius;	//left upper
			X[3] = PinXY[L].x+PinRadius;	//right upper			

			Y[0] = PinXY[L].y-PinRadius*(2*PinImageY/PinImageX-1);
			Y[1] = PinXY[L].y-PinRadius*(2*PinImageY/PinImageX-1);
			Y[2] = PinXY[L].y+PinRadius;
			Y[3] = PinXY[L].y+PinRadius;
			
			for (int m=0; m<4; m++)
			{	
				CPoint InputPoint, OutputPoint;
				InputPoint.x = X[m];
				InputPoint.y = Y[m];

				OutputPoint = GetRealPoint(InputPoint);
				rY[m] = OutputPoint.y;
				rX[m] = OutputPoint.x;
			}
			
			SourceDC->StretchBlt(rX[2], rY[2]-22, 7, 22, &PinMDC, 0, 0, PinImageX, PinImageY, SRCAND);
			SourceDC->StretchBlt(rX[2], rY[2]-22, 7, 22, &PinDC, 0, 0, PinImageX, PinImageY, SRCPAINT);						
		}
	}
		
}

void CBowlingView::DisplayScoreRecords()
{
	CDC* pDC = GetDC();
	pDC->SetBkColor(RGB(192,192,192));
	pDC->SetTextColor(RGB(0,92,0));
	
	pDC->TextOut(620-5, 70, "̵");		
	pDC->TextOut(620-5, 290, "");
	pDC->TextOut(620-5, 195, " ");
	
	pDC->TextOut(600-5, 365-1, "Ŀ ");
	pDC->TextOut(600-5, 390-2, "ǥ");
	pDC->TextOut(600-5, 415-3, " ġ");

	CString str;
	pDC->SetTextColor(RGB(128,0,128));
	str.Format("ھ :  %3d  ",Points);	
	pDC->TextOut(100, 30, str);	
	
	char buffer[5];
	buffer[0] = '%';
	buffer[1] = '\0';
	
	str.Format("ü %d  (ֱ 5 )", NumberOfLines);			
	pDC->TextOut(60, 170-15, str);	
	str.Format("Average :     %3.0f   (%3.0f)   ", AvgScore, Recent5Score);		
	pDC->TextOut(60, 195-15, str);		
	str.Format("Best Score:   %3.0f   (%3.0f)   ", BestScore, Recent5Best);	
	pDC->TextOut(60, 220-15, str);	
	str.Format("Worst Score : %3.0f   (%3.0f)   ", WorstScore, Recent5Worst);	
	pDC->TextOut(60, 245-15, str);	
	str.Format("Strike Percent : %3.1f   (%3.1f)   ", AvgStrike, Recent5Strike);	
	pDC->TextOut(60, 270-15, str);	
	str.Format("Spare Percent :  %3.1f   (%3.1f)   ", AvgSpare, Recent5Spare);	
	pDC->TextOut(60, 295-15, str);	
	str.Format("Curve Average :  %3.1f   (%3.1f)   ", AvgCurve, Recent5Curve);	
	pDC->TextOut(60, 320-15, str);
	ReleaseDC(pDC);
}

void CBowlingView::OnFileNew() 
{
	OnNewgame();	
	
}

void CBowlingView::ShowCeremony()
{
	///--------- Prepare Canvas where Photos are copied ----------///
	CDC* pDC = GetDC();					//prepare canvas		
	

	///--------- Choose Photos -------------------///
	CString str1, str2;
	str1.Format("Your Score is %d. ", Points);	
	HANDLE hfi;
	SetCurrentDirectory(filepath);       //set current directory path and name	
	if (Points < 60)
	{
		str2.Format("How terrible!");		
		hfi=CreateFile(".\\image\\1.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);			
	}
	else if (Points < 80)
	{
		str2.Format("You are baby...");
		hfi=CreateFile(".\\image\\2.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);				
	}
	else if (Points < 100)
	{
		str2.Format("Just beginner...");
		hfi=CreateFile(".\\image\\3.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 120)
	{
		str2.Format("    Good...");
		hfi=CreateFile(".\\image\\4.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 140)
	{
		str2.Format("    Very Good...");
		hfi=CreateFile(".\\image\\5.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 150)
	{
		str2.Format("     Nice! ");
		hfi=CreateFile(".\\image\\6.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 160)
	{
		str2.Format("     Excellent! ");
		hfi=CreateFile(".\\image\\7.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 170)
	{
		str2.Format("     Great! ");
		hfi=CreateFile(".\\image\\8.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 180)
	{
		str2.Format("     Superb! ");
		hfi=CreateFile(".\\image\\9.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 190)
	{
		str2.Format("You are chicken pro bowler!");
		hfi=CreateFile(".\\image\\10.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 200)
	{
		str2.Format("You are already pro bowler!");
		hfi=CreateFile(".\\image\\11.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else if (Points < 210)
	{
		str2.Format("You are regular pro bowler!");
		hfi=CreateFile(".\\image\\12.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}
	else
	{
		str2.Format("You have the PBA championship!");
		hfi=CreateFile(".\\image\\13.yjb", GENERIC_READ, 0, NULL, OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL, NULL);		
	}

	///--------- Load Image File Data Array to DIB char array-----------///
	if (hfi<0)
		return;
	DWORD size, len;
	if(!ReadFile(hfi, (LPSTR)&bmpHeader, sizeof(bmpHeader), &len, NULL))	//read file and get header and size
		return;		

	size = bmpHeader.bfSize - sizeof(bmpHeader);		//get size of image

	if(tDib)											//make tDib char array
		delete tDib;
	tDib = new char[size];
	tDib[0] = 'B';										//recover correct image
		
	if(!ReadFile(hfi, tDib, size, &len, NULL))			//error code
		return;
	if(len != size)
		return;

	CloseHandle(hfi);									//close file
	SetCurrentDirectory(filepath);						//set current directory path and name	


	///---------- Get Bitmap information header -------------///	
	pBitmapInfo = (LPBITMAPINFO)tDib;			//get bitmap information from tDib
	m_pDib = (tDib + *(LPDWORD)tDib);			//load only bitmap graph region from tDib to m_pDib
	pBitmapInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	
	SIZE sSize;
	sSize.cx = pBitmapInfo->bmiHeader.biWidth; 
	sSize.cy = pBitmapInfo->bmiHeader.biHeight; 
	int m_ndumy;
	m_ndumy = (sSize.cx*3)%4;
	((4-m_ndumy)==4)?m_ndumy=0:m_ndumy=4-m_ndumy;	

	pBitmapInfo->bmiHeader.biSizeImage = ((sSize.cx*3)+m_ndumy)*sSize.cy;
	pBitmapInfo->bmiHeader.biXPelsPerMeter = 0;
	pBitmapInfo->bmiHeader.biYPelsPerMeter = 0;
	pBitmapInfo->bmiHeader.biClrUsed = 0;
	pBitmapInfo->bmiHeader.biClrImportant = 0;	
	
	int Width, Height, StartX, StartY;
	if (sSize.cy/sSize.cx > rect.Height()/rect.Width())
	{
		Height = rect.Height();
		Width = sSize.cx*rect.Height()/sSize.cy;
		StartX = 0.5*(rect.Width()-Width);
		StartY = 0;
	}
	else
	{
		Width = rect.Width();
		Height = sSize.cy*rect.Width()/sSize.cx;
		StartX = 0;
		StartY = 0.5*(rect.Height()-Height);
	}

	///---------- Take Picture and Message ---------------------///
	::SetStretchBltMode(pDC->m_hDC, COLORONCOLOR);
	::StretchDIBits(pDC->m_hDC, rect.left+StartX, rect.top+StartY, Width, Height, 
						0, 0, sSize.cx, sSize.cy, m_pDib, pBitmapInfo, DIB_RGB_COLORS, SRCCOPY);
	pDC->SetBkMode(TRANSPARENT);
	pDC->SetTextColor(RGB(255,0,128));
	pDC->TextOut(rect.left+0.3*rect.Width(), 0.05*rect.Height()+rect.top, str1);
	pDC->TextOut(rect.left+0.15*rect.Width(), 0.05*rect.Height()+rect.top+12, str2);
	
	///---------- Delete canvas -----------------////
	ReleaseDC(pDC);						
}

void CBowlingView::AssignPointerToControls()
{
	ScoreText[0].SubclassDlgItem(IDC_EDIT1A,this);	
	ScoreText[1].SubclassDlgItem(IDC_EDIT1B,this);	
	ScoreText[2].SubclassDlgItem(IDC_EDIT2A,this);	
	ScoreText[3].SubclassDlgItem(IDC_EDIT2B,this);	
	ScoreText[4].SubclassDlgItem(IDC_EDIT3A,this);	
	ScoreText[5].SubclassDlgItem(IDC_EDIT3B,this);	
	ScoreText[6].SubclassDlgItem(IDC_EDIT4A,this);	
	ScoreText[7].SubclassDlgItem(IDC_EDIT4B,this);	
	ScoreText[8].SubclassDlgItem(IDC_EDIT5A,this);	
	ScoreText[9].SubclassDlgItem(IDC_EDIT5B,this);	
	ScoreText[10].SubclassDlgItem(IDC_EDIT6A,this);	
	ScoreText[11].SubclassDlgItem(IDC_EDIT6B,this);	
	ScoreText[12].SubclassDlgItem(IDC_EDIT7A,this);	
	ScoreText[13].SubclassDlgItem(IDC_EDIT7B,this);	
	ScoreText[14].SubclassDlgItem(IDC_EDIT8A,this);	
	ScoreText[15].SubclassDlgItem(IDC_EDIT8B,this);	
	ScoreText[16].SubclassDlgItem(IDC_EDIT9A,this);	
	ScoreText[17].SubclassDlgItem(IDC_EDIT9B,this);	
	ScoreText[18].SubclassDlgItem(IDC_EDIT10A,this);	
	ScoreText[19].SubclassDlgItem(IDC_EDIT10B,this);	
	ScoreText[20].SubclassDlgItem(IDC_EDIT10C,this);		
}

void CBowlingView::CalculateScoreOfRound(int RoundNo)
{
	int K;
	CString str;
	if (Count==0)
	{				
		for (K=0; K<10; K++)
		{
			if (PinUp[K] == FALSE)
				Point[RoundNo][0]++;
		}	

		str.Format("%d",Point[RoundNo][0]);		
		ScoreText[2*RoundNo-2].SetWindowText(str);
		if (Point[RoundNo][0]==10)
		{
			if (Round > 2)
			{
				if (Point[Round-2][0] == 10 && Point[Round-1][0] == 10)
				{
					RoundStatus = 4;
				}
				else if (Point[Round-1][0] == 10)
				{
					RoundStatus = 3;
				}
				else
				{
					RoundStatus = 1;
				}
			}
			else if (Round == 2)
			{
				if (Point[1][0] == 10)
				{
					RoundStatus = 3;
				}
				else
				{
					RoundStatus = 1;
				}
			}
			else
			{
				RoundStatus = 1;
			}			
			StrikeNo = StrikeNo + 1;							
			Round++;
			RefreshRound = TRUE;
			Count=0;				
		}
		else
		{	
			if (bGutter && Point[Round][0] == 0)
			{
				RoundStatus = 5;
			}
			else
			{
				RoundStatus = 0;
			}
			Count++;
		}			
	}

	else
	{
		for (K=0; K<10; K++)
		{
			if (PinUp[K] == FALSE)
				Point[RoundNo][1]++;
		}
		Point[RoundNo][1]=Point[RoundNo][1]-Point[RoundNo][0];					
		str.Format("%d",Point[RoundNo][1]);		
		ScoreText[2*RoundNo-1].SetWindowText(str);
		
		if (Point[RoundNo][0]+Point[RoundNo][1] == 10)		//calculate spare success or failure counts
		{				
			RoundStatus = 2;
			SpareNo = SpareNo + 1;
		}
		else
		{				
			if (bGutter && Point[Round][1] == 0)
			{
				RoundStatus = 5;
			}
			else
			{
				RoundStatus = 0;
			}
			NonSpareNo = NonSpareNo + 1;
		}
		Round++;
		Count=0;
		RefreshRound = TRUE;
	}

}

void CBowlingView::InitializeVariables()
{
	EndGame = FALSE;					//new game ready
	for (int K=0; K<10; K++)			//initialize pins position
	{
		PinUp[K] = TRUE;						
	}
	
	Points=0;							//initialize current Score
	Round=1;							//initialize round number
	Count=0;							//initialize count number of a round
	RoundStatus = 0;					//initialize round status (0: non, 1:strike, 2: spare, 3: double, 4: turkey, 5: gutter)
	for (int L=0;L<100;L++)				//initialize score point
	{
		for (int K=0;K<3;K++)
		{
			Point[L][K]=0;
		}
	}

	SpareNo = 0;				//Spare number per 1 game
	NonSpareNo = 0;				//Spare failure number per 1 game
	StrikeNo = 0;				//Strike number per 1 game
	CurveNo = 0;				//Curve number per 1 game
	TimerCountTarget = 0;		//initialize target counter
	TimerCountCeremony = 5;		//initialize ceremony counter

	srand( (unsigned)time( NULL ) );
	int tempStatus = rand() % 12;	//lane status 0, 1, 2, 3, 4, 5  etc..
	if (tempStatus < 8)
		LaneStatus = 1;
	else if (tempStatus == 9)
		LaneStatus = 3;
	else if (tempStatus == 10)
		LaneStatus = 0;
	else
		LaneStatus = 2;
								//0: deviate to center side
								//1: deviate to gutter side								
								//2: deviate to left side
								//3: deviate to right side	
	LaneStatusDegree = 10*pow((rand() % 10)*0.1, 0.5);		//lane status degree (from 0 to 9)
	SeekAbility();						//seek and introduce ability to the game	
}

void CBowlingView::SeekAbility()
{
	if (Count == 0 || Count == 2)
	{
		Accuracy = 100.0*pow(AvgStrike*0.01, 5.0/(5.0+AvgCurve));
	}
	else
	{
		Accuracy = 100.0*pow(AvgSpare*0.01, 5.0/(5.0+AvgCurve));
	}		
	Deviation = 15.0/(15.0+Accuracy);	
}

void CBowlingView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CFormView::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CBowlingView::PreTranslateMessage(MSG* pMsg) 
{
	int newpos;
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_NUMPAD6))
	{
		newpos = m_slider2.GetPos() + 0.01*rect.Width();
		m_slider2.SetPos(newpos);
	}
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_NUMPAD3))
	{
		newpos = m_slider1.GetPos() + 0.01*rect.Width();
		m_slider1.SetPos(newpos);
	}
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_RIGHT))
	{
		newpos = m_slider4.GetPos() + 0.01*rect.Width();
		m_slider4.SetPos(newpos);
	}
	
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_NUMPAD4))
	{
		newpos = m_slider2.GetPos() - 0.01*rect.Width();
		m_slider2.SetPos(newpos);
	}
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_NUMPAD1))
	{
		newpos = m_slider1.GetPos() - 0.01*rect.Width();
		m_slider1.SetPos(newpos);
	}
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_LEFT))
	{
		newpos = m_slider4.GetPos() - 0.01*rect.Width();
		m_slider4.SetPos(newpos);
	}
	if ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_SPACE))
	{
		OnStart();
	}

	
	return CFormView::PreTranslateMessage(pMsg);
}

CPoint CBowlingView::GetRealPoint(CPoint PointXY)
{
	float ViewPoint = rect.Height()*ViewAngle*(100-m_slider6.GetPos()+25);				
	float theta, theta0;
	float LF, LF0;
	float OriginX, OriginY;
	CPoint	RealPoint;
			
	theta=acos((ViewPoint)/(pow(pow(ViewPoint, 2.0) + pow(0.5*rect.Width()-
			float(PointXY.x), 2.0) + pow(rect.Height()-float(PointXY.y), 2.0), 0.5)));	
	LF = ViewPoint*2.0/3.141592653*theta;
	if (rect.Height() == float(PointXY.y))
		RealPoint.y = rect.Height();
	else
		RealPoint.y = rect.Height() - LF*(rect.Height()-float(PointXY.y))/pow(pow(rect.Height()-float(PointXY.y), 2.0) + pow(0.5*rect.Width()-float(PointXY.x), 2.0), 0.5);		

	theta0 = acos((ViewPoint)/(pow(pow(ViewPoint, 2.0) + pow(0.5*rect.Width()-float(PointXY.x), 2.0) + pow(rect.Height()-rect.Height(), 2.0), 0.5)));	
	LF0 = ViewPoint*2.0/3.141592653*theta0;
	OriginY = rect.Height();

	if (0.5*rect.Width() == float(PointXY.x))
		OriginX = 0.5*rect.Width();
	else
		OriginX = 0.5*rect.Width() - LF0*(0.5*rect.Width()-float(PointXY.x))/pow(pow(rect.Height()-OriginY, 2.0) + 
			pow(0.5*rect.Width()-float(PointXY.x), 2.0), 0.5);								
	RealPoint.x = OriginX + (0.5*rect.Width() - OriginX)*(OriginY-float(RealPoint.y))/ViewPoint;	
	return RealPoint;
}
