// bowlingView.h : interface of the CBowlingView class
//
/////////////////////////////////////////////////////////////////////////////
//{{AFX_INCLUDES()
#include "msdgridctrl.h"
//}}AFX_INCLUDES

#if !defined(AFX_BOWLINGVIEW_H__132F1F6D_F1E0_11D3_8610_C56525510533__INCLUDED_)
#define AFX_BOWLINGVIEW_H__132F1F6D_F1E0_11D3_8610_C56525510533__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "mmsystem.h"


class CBowlingView : public CFormView
{
protected: // create from serialization only
	CBowlingView();
	DECLARE_DYNCREATE(CBowlingView)

public:
	//{{AFX_DATA(CBowlingView)
	enum { IDD = IDD_BOWLING_FORM };
	CSliderCtrl	m_slider6;
	CSliderCtrl	m_slider5;
	CSliderCtrl	m_slider4;
	CSliderCtrl	m_slider3;
	CSliderCtrl	m_slider2;
	CSliderCtrl	m_slider1;
	//}}AFX_DATA

// Attributes
public:
	CBowlingDoc* GetDocument();

// Operations
public:
	CWnd	ScoreText[25];	//text control array for score board
	int Points;				//total points
	int Point[100][3];		//point per round
	int Round;				//which round?
	int Count;				//throw count of a round
	int P[100];				
	int OnStatus;		//bool variable for rolling or other state;
						//1:Ready, 2:On rolling, 3:Collision 4:End 5:Start
	CDC BowlDC;	   //prepare memory DC for bowling place
	CDC BallDC;		//prepare memory DC for bowling ball
	CDC BallMDC;		//prepare memory DC for bowling ball	
	CDC PinDC;     //prepare memory DC for pin
	CDC PinMDC;     //prepare memory DC for pin mask
	CDC TargetDC;	//prepare memory DC for target
	CDC memDC;	   //prepare spare memory DC 	
	CDC ShoesDC;	//prepare shoes DC
	CDC ShoesMDC;	//prepare shoes mask DC
	CBitmap	BowlBMP, *pBowlBMP; //bowling place BMP
	CBitmap	BallBMP, *pBallBMP;	//bowling ball BMP
	CBitmap	BallMBMP, *pBallMBMP;	//bowling ball mask BMP
	CBitmap	PinBMP, *pPinBMP;	//pin BMP
	CBitmap	PinMBMP, *pPinMBMP;	//pin mask BMP
	CBitmap BackBMP, *pBackBMP;	//bacground BMP
	CBitmap ShoesBMP, *pShoesBMP;	//shoes image BMP
	CBitmap ShoesMBMP, *pShoesMBMP;	//shoes image BMP

	float	BallImageX, BallImageY;		//ball image width, height
	float	PinImageX, PinImageY;		//pin image width, height
	float	ShoesImageX, ShoesImageY;	//shoes image width, height
	float	BackImageX, BackImageY;		//background image width, height

	CRect rect;
	int TimerCount;
	int TimerCountTarget;		//timer count for target
	int TimerCountCeremony;		//timer count for ceremony
	float BottomPinY;			//first 4 pins location 
	CPoint	PinXY[10];			//pin location array
	CPoint  RPinXY[10];			//real pin location array
	BOOL	PinUp[10];
	BOOL	RefreshRound;		//prepare next round
	float PinRadius;			//set pin radius
	float BallRadius;			//set bowling ball radius
	float PinIntervalX;			//set x distance between two adjacent pins
	float PinIntervalY;			//set y distance between two adjacent pins
	
	int	  NumberOfLines;		//number of games played
	float SpareNo;				//Spare number per 1 game
	float NonSpareNo;			//Spare failure number per 1 game		
	float StrikeNo;				//Strike number per 1 game
	float CurveNo;				//Curve points per 1 game
	
	float AvgScore;				//Average score	
	float AvgStrike;			//Average strike rate	
	float AvgSpare;				//Average Spare rate
	float AvgCurve;				//Average curve points
	float BestScore;			//Best score
	float WorstScore;			//Worst score
	
	float Recent5Score;			//Recent 5 game average score
	float Recent5Strike;		//Recent 5 game strike rate	
	float Recent5Spare;			//Recent 5 game Spare rate
	float Recent5Curve;			//Recent 5 game curve points
	float Recent5Best;			//Recent 5 game Best score
	float Recent5Worst;			//Recent 5 game Worst score

	BOOL		EndGame;
	MMRESULT	hTimer;
	UINT		idTimer;
	float   targetX;	//target point
	float	targetY;	//target point
	float	Accuracy;	//accuracy determined by experience (curve, strike, spare)
	float	Deviation;	//Deviation determined by accuracy and chance
	int		LaneStatus;	//lane status 1, 2, 3, 4, 5  etc..
	int		LaneStatusDegree;
	float	standingX;	//standing point
	int		Frames;		//frame number of bowl rolling animation
	int		BaseFrames;		//base frame number of bowl rolling animation
	float	GutterLine;	//Set gutterline
	BOOL	bOnRollSound;	//rolling sound
	BOOL	bGutterSound;	//gutter sound
	BOOL	bCollisionSound;	//collision sound
	BOOL	bGutter;		//BOOL for gutter
	float	ViewAngle;		//View angle to see the bowling stadium
	float   PreviousView;	//previous view angle
	int		RoundStatus;	//0: non, 1:strike, 2: spare, 3: double, 4: turkey, 5: gutter

	FILE*	scorefile;			//file to record score
	
	BITMAPFILEHEADER	bmpHeader;		//  
	LPBITMAPINFO		pBitmapInfo;	//  
	LPSTR		m_pDib;			//DIB   
	LPSTR		tDib;			//ӽ 

	char	filepath[255];		//root file path

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBowlingView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnDraw(CDC* pDC);
	//}}AFX_VIRTUAL

// Implementation
public:	
	CPoint GetRealPoint(CPoint PointXY);
	void SeekAbility();
	void InitializeVariables();
	void CalculateScoreOfRound(int RoundNo);
	void AssignPointerToControls();
	void ShowCeremony();
	void DisplayScoreRecords();
	void DrawPins(CDC* SourceDC);
	void ObtainScoreRecord();
	void SetPinLocation();
	void DrawTarget();
	void CalculateScore();
	void GetSliderValue();
	void InvalidateCtrl();
	void DrawBowlRolling();
	void PrepareMemoryDC();
	virtual ~CBowlingView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CBowlingView)
	afx_msg void OnStart();
	afx_msg void OnNewgame();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnFileNew();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in bowlingView.cpp
inline CBowlingDoc* CBowlingView::GetDocument()
   { return (CBowlingDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BOWLINGVIEW_H__132F1F6D_F1E0_11D3_8610_C56525510533__INCLUDED_)
