// AniView.cpp : implementation file
//

#include "stdafx.h"
#include "Sprite.h"

#include "SpriteDoc.h"
#include "AniView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ANI_VIEW_MIN_SPACE_X	0
#define ANI_VIEW_MIN_SPACE_Y	0
#define ANI_VIEW_BORDER_SIZE	0
#define ANI_VIEW_MAX_X		   800	
#define ANI_VIEW_MAX_Y		   600	

/////////////////////////////////////////////////////////////////////////////
// CAniView

IMPLEMENT_DYNCREATE(CAniView, CScrollView)

CAniView::CAniView()
{
	m_VirtualBasePoint.x = NULL;		//     ǥ...
	m_VirtualBasePoint.y = NULL;		//     ǥ...
	
	m_MaxAniViewScrolledSize.cx = ANI_VIEW_MAX_X;	//   ּ ũ...
	m_MaxAniViewScrolledSize.cy = ANI_VIEW_MAX_Y;	//   ּ ũ...

	m_CurAniSprNum = 0;
}

CAniView::~CAniView()
{
}


BEGIN_MESSAGE_MAP(CAniView, CScrollView)
	//{{AFX_MSG_MAP(CAniView)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAniView drawing

// ʱȭ  Ÿ̸ ......
void CAniView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();
	

	// Ÿ̸ ...
	if(pMF->m_AniPlayTime<=0)
		pMF->m_AniPlayTime = 300;
	pMF->m_AniPlayTime = (abs)(pMF->m_AniPlayTime);
	SetTimer(0,pMF->m_AniPlayTime,NULL);

	//   ...
	m_MaxAniViewScrolledSize.cx = ANI_VIEW_MAX_X;	//   ּ ũ...
	m_MaxAniViewScrolledSize.cy = ANI_VIEW_MAX_Y;	//   ּ ũ...

	CRect tempRect;
	GetClientRect(&tempRect);

	m_VirtualBasePoint.x = 60;
	m_VirtualBasePoint.y = 60;

	if(m_VirtualBasePoint.x <= 0)
		m_VirtualBasePoint.x = 80;

	if(m_VirtualBasePoint.y <= 0)
		m_VirtualBasePoint.y = 80; 

	sizeTotal = m_MaxAniViewScrolledSize;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

// Ÿ̸ ........
void CAniView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
	// TODO: Add your message handler code here
	KillTimer(0);	
}

/////////////////////////////////////////////////////////////////////////////
// CAniView diagnostics

#ifdef _DEBUG
void CAniView::AssertValid() const
{
	CScrollView::AssertValid();
}

CSpriteDoc* CAniView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSpriteDoc)));
	return (CSpriteDoc*)m_pDocument;
}

void CAniView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAniView message handlers

void CAniView::OnDraw(CDC* pDC)
{
	CSpriteDoc* pDoc = GetDocument();
	CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();
	
	//  ȭ   ǥ ϱ...
	

	CSize	tempMaxViewSize	= m_MaxAniViewScrolledSize;
	
	if( pMF->m_bAniStart )
	{
		DrawAniSprite(pDC);
	}

	else
	{
		DrawSprite(pDC); //  ׸ ׸..
		DrawCrushRt(pDC);
	}

	DrawCenterCrossLine(pDC);

	// ũ  ..
	SetScrollSizes(MM_TEXT, tempMaxViewSize);
}


void CAniView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();

	CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();


	if(pMF->m_bAniStart)
	{
		CSpriteDoc* pDoc = GetDocument();

		if( (pDoc->GetMaxSprNodeNumber()) <=0 )	//	Ʈ  ..
			return;

		int tempSprNum = m_CurAniSprNum;
		
		++tempSprNum;

		if(tempSprNum >= pDoc->m_MaxSprNodeNumber)
			tempSprNum = 0;

		if( tempSprNum > (pMF -> m_AniEndNum ) )
			tempSprNum = (pMF -> m_AniStartNum);
		
		m_CurAniSprNum = tempSprNum;

		Invalidate();
	}

	CScrollView::OnTimer(nIDEvent);
}

void CAniView::ChangeTime()
{
	KillTimer(0);

	CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();

	SetTimer(0,pMF->m_AniPlayTime,NULL);
}

//     ǥ ϱ..
CPoint CAniView::GetVirtualBasePoint()
{
	return m_VirtualBasePoint;
}

CSize CAniView::GetMaxScrolledSize()
{
	return m_MaxAniViewScrolledSize;
}

BOOL CAniView::DrawSprite(CDC *pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	if( (pDoc->GetMaxSprNodeNumber()) <=0 )	//	Ʈ  ..
		return TRUE;
	
	int tempCurSprNum = pDoc->m_CurSprViewSelectedSprNumber;

	CSprData *ptempNode = pDoc->GetSprNode(tempCurSprNum);
	
	if(!ptempNode)	return FALSE;

	if( (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left) > m_MaxAniViewScrolledSize.cx)
		m_MaxAniViewScrolledSize.cx =  (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left)  + 100;

	if(((ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom) ) > m_MaxAniViewScrolledSize.cy)
		m_MaxAniViewScrolledSize.cy = (ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom) + 100;

	// ִ  Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CAniViewMultiNumber;


	// ִ   ϱ.......
	CPoint tempBasePoint = ptempNode->m_BasePoint;
	
	tempBasePoint.x *= tempMultifyNumber;
	tempBasePoint.y *= tempMultifyNumber;
	
	// ׸ ׸  ǥ (0,0)    ...
	CPoint tempSprDrawPoint = GetVirtualBasePoint() - (tempBasePoint); // .......
	
	//  ׸.. // Ȯ ó..
	pDoc->m_Bmp.BmpMultiDraw(pDC,ptempNode->m_SprRect, tempSprDrawPoint, tempMultifyNumber);

	return TRUE;
}



BOOL CAniView::DrawAniSprite(CDC *pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	if( (pDoc->GetMaxSprNodeNumber()) <= 0 )	//	Ʈ  ..
		return TRUE;
	
	int tempCurSprNum = m_CurAniSprNum;

	CSprData *ptempNode = pDoc->GetSprNode(tempCurSprNum);
	
	if(!ptempNode)	return FALSE;

	if( (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left) > m_MaxAniViewScrolledSize.cx)
		m_MaxAniViewScrolledSize.cx =  (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left)  + 100;

	if(((ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom) ) > m_MaxAniViewScrolledSize.cy)
		m_MaxAniViewScrolledSize.cy = (ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom) + 100;

	// ִ  Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CAniViewMultiNumber;


	// ִ   ϱ.......
	CPoint tempBasePoint = ptempNode->m_BasePoint;
	
	tempBasePoint.x *= tempMultifyNumber;
	tempBasePoint.y *= tempMultifyNumber;
	
	// ׸ ׸  ǥ (0,0)    ...
	CPoint tempSprDrawPoint = GetVirtualBasePoint() - (tempBasePoint); // .......
	
	//  ׸.. // Ȯ ó..
	pDoc->m_Bmp.BmpMultiDraw(pDC,ptempNode->m_SprRect, tempSprDrawPoint, tempMultifyNumber);

	return TRUE;
}


BOOL CAniView::DrawCrushRt(CDC *pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	//  .........
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CAniViewMultiNumber;

	if( (pDoc->GetMaxSprNodeNumber()) <=0 )	//	Ʈ  ..
		return TRUE;

	// TODO: add draw code here
	CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
	
	if(ptempNode == NULL)
		return FALSE;

	int tempMaxCrushRtNum = ptempNode->m_MaxCrushRtNum;
	
	CPoint tempBasePt;
	CRect tempRealRt;
	CRect tempVirRt;

	CPoint tempDrawPoint = GetVirtualBasePoint();

	for(int i = 0; i < tempMaxCrushRtNum; i++)
	{
		tempBasePt = ptempNode->m_BasePoint;
		tempRealRt = ptempNode->m_CrushRt[i];
		tempVirRt = tempRealRt;

		tempVirRt.left   = tempDrawPoint.x + (( tempRealRt.left - tempBasePt.x) * tempMultifyNumber);
		tempVirRt.top    = tempDrawPoint.y + (( tempRealRt.top  - tempBasePt.y) * tempMultifyNumber);

		tempVirRt.right  = tempVirRt.left + ( tempRealRt.Width()  * tempMultifyNumber );
		tempVirRt.bottom = tempVirRt.top  + ( tempRealRt.Height() * tempMultifyNumber );
		
		pDoc->m_DrawTool.DrawRectangle(pDC, tempVirRt, 2, RGB(0,0,255));
	}
	return TRUE;
}



BOOL CAniView::DrawCenterCrossLine(CDC *pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	CSize tempMaxViewSize = m_MaxAniViewScrolledSize;	//   ּ ũ...

	CRect tempRect;
	GetClientRect(&tempRect);

	if(tempRect.right > tempMaxViewSize.cx)
		tempMaxViewSize.cx = tempRect.right;
	
	if(tempRect.bottom > tempMaxViewSize.cy)
		tempMaxViewSize.cy = tempRect.bottom;
	
	CPoint tempDrawPoint = GetVirtualBasePoint();

	pDC->MoveTo(tempDrawPoint.x,                  0);
	pDC->LineTo(tempDrawPoint.x, tempMaxViewSize.cy);

	pDC->MoveTo(0,                  tempDrawPoint.y);
	pDC->LineTo(tempMaxViewSize.cx, tempDrawPoint.y);

	return TRUE;
}

//////// ϴ .................
BOOL CAniView::DrawSprOutLine(CDC *pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	if( (pDoc->GetMaxSprNodeNumber()) <=0 )	//	Ʈ  ..
		return TRUE;

	CSprData * ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
	if(!ptempNode) return FALSE;

	CRect targetDrawOutlineRect;
	CPoint tempDrawPoint = m_VirtualBasePoint;

	if(tempDrawPoint.x < 0) return FALSE;
	if(tempDrawPoint.y < 0) return FALSE;

	int tempBorderSize = ANI_VIEW_BORDER_SIZE / 2;

	targetDrawOutlineRect.left   = tempDrawPoint.x - tempBorderSize;
	targetDrawOutlineRect.top    = tempDrawPoint.y - tempBorderSize;
	targetDrawOutlineRect.right  = tempDrawPoint.x + (  (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left)   ) + tempBorderSize;
	targetDrawOutlineRect.bottom = tempDrawPoint.y + ( (ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom) ) + tempBorderSize;
				  
	pDoc -> m_DrawTool.DrawRectangle( pDC,targetDrawOutlineRect, tempBorderSize ,RGB(0,0,255) );

	return TRUE;
}

void CAniView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CPoint tempScrolledPoint = point + (GetScrollPosition());

	m_VirtualBasePoint = tempScrolledPoint;

	Invalidate();

	CScrollView::OnLButtonDown(nFlags, point);
}
