// Bmp.cpp: implementation of the CBmp class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SPRITE.h"
#include "Bmp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBmp::CBmp()
{
	// ʿ   ........
	m_hBmp = NULL;
	m_pBmpInfoHeader = NULL;
	m_pBmpPalette = NULL;
	m_pImageBit = NULL;

	// ʿ ͵ ...
	m_BmpSize = NULL;  // ũ.
	m_BmpWidth = NULL; // .
	m_BmpHeight = NULL; // .
	m_ClrUsed = NULL; // ȷƮ .
	m_DibSize = NULL;  // Ʈ   κ.
	m_PaletteSize = NULL;
	m_BitCount = NULL; // Ʈʿ  ȼ ũ... 
	m_BmpWidthBytes = NULL;
	m_ByteForOnePixel = NULL;		//  ȼ Ʈ ... -  ƮīƮ 8  .
}

CBmp::~CBmp()
{
	if(m_hBmp)
		delete m_hBmp;
	m_hBmp = NULL;
}


/////////////////////////////////////////////////////////////////////////////////////////
////// ʿ ũ⸦ ϴ Լ.........
/////////////////////////////////////////////////////////////////////////////////////////

int CBmp::GetHeight()  // ׸ ....
{
	if(m_hBmp)
		return(m_pBmpInfoHeader -> biHeight);
	
	AfxMessageBox("Bmp  GetHeight ... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetWidth()   // ׸ ũ....
{
	if(m_hBmp)
		return(m_pBmpInfoHeader -> biWidth);
	AfxMessageBox("Bmp  GetWidth ... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetClrUsed() //  ... 
{
	if(m_hBmp)
		return(m_pBmpInfoHeader -> biClrUsed);
	
	AfxMessageBox("Bmp  GetClrUsed ... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetBitCount() //  ȼ  Ʈ ....
{	
	if(m_hBmp)
		return(m_pBmpInfoHeader ->biBitCount);
	
	AfxMessageBox("Bmp  GetHeight ... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetByteForOnePixel() //  ȼ  Ʈ ϱ......
{
	if(m_hBmp)
		return ( (GetBitCount()/ 8));

	AfxMessageBox("Bmp  GetByteForPixel ..... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetDibSize() // ޸𸮸 Ҵ .
{	
	if(m_hBmp)
		return(m_DibSize);

	AfxMessageBox("Bmp  GetDibSize ... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetBmpSize() // ü ũ.
{	
	if(m_hBmp)
		return(m_BmpSize);

	AfxMessageBox("Bmp  GetBmpSize... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetPalSize() // ȷƮ  ũ.
{	
	if(m_hBmp)
		return(m_PaletteSize);

	AfxMessageBox("Bmp  GetPalSize... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetBmpHandle() // Ʈ ڵ ϱ.
{
	if(m_hBmp)
		return ( (int) (m_hBmp) );

	AfxMessageBox("Bmp  GetBmpHandle... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetImageBitStart()
{
	if(m_hBmp)
		return ((int) m_pImageBit); // Ʈ ̹ .

	AfxMessageBox("Bmp  GetImageBitStart... ׸ ڵ .");
	return FALSE;
}

int CBmp::GetWidthBytesPerLine()
{
	int tempByteForPixel = (GetBitCount() / 8); //  ȼ óϴ Ʈ .
	int tempWidthBytes = NULL; // ׷ ׸   Ʈ ũ.. (y)
	int SourceWidthBytes = NULL; // ҽ ׸   Ʈ ũ...(y)

	int tempWidth = GetWidth();
	//
	// width = (width+3)&~3;
	//
	
	if(tempByteForPixel == 1) // 256 Į ....
	{
		tempWidthBytes = (tempWidth+3)&~3; // 4 ȭ Ŵ.
	}

	if(tempByteForPixel == 3) // 24 Ʈ Į .....
	{
		tempWidthBytes = tempWidth * 3; // ʿ  Ʈ ....
		tempWidthBytes = (tempWidthBytes+3)&~3; // 4 ȭ Ŵ.
	}

	return tempWidthBytes;
}

BYTE * CBmp::GetImagePointAddress(int x, int y)
{
	if(! m_hBmp)
		return FALSE;

	CPoint tempPoint(x,y);

	return (GetImagePointAddress(tempPoint));
}

BYTE * CBmp::GetImagePointAddress(CPoint sourcePoint)
{
	if(! m_hBmp)
		return FALSE;

	int tempImageBitStart = (int) m_pImageBit;
	CPoint tempSourcePoint = sourcePoint;

	int tempCurPointAddress = 0;
	int tempSourceY = GetHeight() - tempSourcePoint.y;

	int tempWidthBytesPerLine	= GetWidthBytesPerLine();
	int tempByteForOnePixel	= GetByteForOnePixel();

	tempCurPointAddress = tempImageBitStart
						   + (tempSourceY * tempWidthBytesPerLine)
						   + (tempSourcePoint.x * tempByteForOnePixel);
	
	return (BYTE *) tempCurPointAddress;
}

////////////////////////////////////////////////////////////////////////////////////////////
///////   ȭ...............
////////////////////////////////////////////////////////////////////////////////////////////

CRect CBmp::MinimizeSelectedRect(CRect selectedRect)
{
	if(! m_hBmp)	
		return FALSE;

	CRect tempSelectedRect = selectedRect;

	tempSelectedRect.NormalizeRect();

	if(GetByteForOnePixel() == 1)
		return (Minimize8bitColor(tempSelectedRect));
		
	if(GetByteForOnePixel() == 3)
		return (Minimize24bitColor(tempSelectedRect));

	AfxMessageBox(" ʴ Į......... T_/~~");
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////////////////
///////   ȭ (8 bit BMP FIle)...............
////////////////////////////////////////////////////////////////////////////////////////////

CRect CBmp::Minimize8bitColor(CRect selectedRect)
{
	CRect	tempMinimizedRect(0,0,0,0);

	//  ǥ մϴ ̹Ʈ  ϱ...
	// ⼭ ʹ  ޸ ġ  ...
	// ׸ ؿ ..........

	//   ...
	CRect tempOriginalRect = selectedRect;

	int tempValueX	= m_ByteForOnePixel;		// ޸ 󿡼  1 ޸  ..
	int tempValueY	= m_BmpWidthBytes;		// ޸ 󿡼  1 ޸  ..

	// õ  ⺻ ּ ...  ...
	BYTE * ptempBaseStartAddress = GetImagePointAddress(tempOriginalRect.left, tempOriginalRect.bottom);
	
	if(!ptempBaseStartAddress)	return FALSE;

	//    ϸ鼭 üũ...
	BYTE tempBaseValueColor	= *(ptempBaseStartAddress + 0);	// ù ȼ  ȣ..
	BYTE tempCurValueColor = 0;							//    ȣ..

	//	int fromBLtoBR = 0;		// BL : Bottom Left
	//	int fromTLtoTR = 0;		// BR : Bottom Right
	//	int fromBLtoTL = 0;		// TL : Top Left
	//	int fromBRtoTR = 0;		// TR : Top Right

	//    ¿  ..


	CRect tempCurRect(0,0,0,0);				// ȭ   ...

	int tempCurRectHeight	= 0;			// ׸ ӽ  ..
	int tempCurRectWidth	= 0;			// ׸ ӽ  ..

	BYTE * ptempStartAddress	= NULL;		//   ּ...
	BYTE * ptempCurPointAddress = NULL;
	
	////////////////////////////////////////////////////////////////////
	// Ʒ    üũ... bottom  ϱ..... 
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	tempCurRect = tempOriginalRect;
	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.bottom = 0;
	
	// ּҰ ... ( Ʒ ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.bottom);

	// ؿ  ̸ŭ.. ׸ tempMinimizedrect.bottom    Ż..
	for(int fromBLtoTL = 0; (fromBLtoTL < tempCurRectHeight) && (!tempMinimizedRect.bottom) ; fromBLtoTL ++)
	{
		// Ʒ ʿ Ʒ  ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromBLtoBR = 0 ; (fromBLtoBR < tempCurRectWidth ) && (!tempMinimizedRect.bottom) ; fromBLtoBR ++)
		{
			//  ̵ϸ鼭 ... 8Ʈ   ȼ ũ 1Ʈ..
			// 			 = (BYTE *) ( (int) ptempStartAddress + (fromBLtoBR * tempValueX);	

			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (fromBLtoBR) ) ;	

			//   Ʋ     ŭ ȭ   bottom  ..
			if(tempBaseValueColor != *ptempCurPointAddress)
				tempMinimizedRect.bottom = (tempCurRect.bottom - fromBLtoTL);
		}

		// ޸ ġ 1ĭ ø.. ؿ  ö󰡱ؼ ޸ ּҰ ..
		
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress + tempValueY); 
	 }

	
	
	if(!tempMinimizedRect.bottom)	// ٴ   ϸ
		return	(tempOriginalRect);  //  ǥ ״ ...    ٴ ..
	                                //   ̶...   ..


	////////////////////////////////////////////////////////////////////
	// κ Ʒ   üũ... top  ϱ......
	////////////////////////////////////////////////////////////////////

	//    ٴ   Ŵϱ...    ؾ ,
	//  for Żϰ Ǵϱ  ..............

	// ʱȭ...............

	tempCurRect = tempOriginalRect;
	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.top = 0;
	
	// ּҰ ... (  ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.top);

	//   ̸ŭ.. ׸ tempMinimizedrect.top    Ż..
	for(int fromTLtoBL = 0; (fromTLtoBL < tempCurRectHeight) && (!tempMinimizedRect.top) ; fromTLtoBL ++)
	{
		//  ʿ ϴ  ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromTLtoTR = 0 ; (fromTLtoTR < tempCurRectWidth ) && (!tempMinimizedRect.top) ; fromTLtoTR ++)
		{
			//  ̵ϸ鼭 ... 8Ʈ   ȼ ũ 1Ʈ..
			// 			 = (BYTE *) ( (int) ptempStartAddress + (fromTLtoTR * tempValueX);	

			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (fromTLtoTR) ) ;	

			//   Ʋ     ŭ ȭ   top  ..
			// ׸   ̸ 1ŭ ø..
			if(tempBaseValueColor != *ptempCurPointAddress)
				tempMinimizedRect.top = (tempCurRect.top + fromTLtoBL - 1);
			//   ̻ѵ... μ  .. ǰ...
		}


		//   ĭ .. ޸ 迭   Ʈ ŭ ..
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress - tempValueY); 
	}

	//   µ  ⿡  ٴ   ȵ, Ȥó ؼ ...
	// ̰Ŵ  5ð  ؼ ¥  ..
	//  õ鰡..............^^;

	//   9ð°..  ִ.   -1    Ȱ...

	if(!tempMinimizedRect.top)
		return FALSE;

	////////////////////////////////////////////////////////////////////
	// κ    üũ... left  ϱ......
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	// üũ  ̶ ٿ ϴ .............

	tempCurRect.left = tempOriginalRect.left;
	tempCurRect.right = tempOriginalRect.right;
	
	// Ʊ üũ ŭ̶ ....
	tempCurRect.top		= tempMinimizedRect.top;
	tempCurRect.bottom	= tempMinimizedRect.bottom;

	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.left = 0;
	
	// ּҰ ... ( ϴ ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.bottom);

	// ϴ  ϴ  ̸ŭ.. ׸ tempMinimizedrect.left    Ż..
	for(int fromBLtoBR = 0; (fromBLtoBR < tempCurRectWidth) && (!tempMinimizedRect.left) ; fromBLtoBR ++)
	{
		// ϴ   ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromBLtoTL = 0 ; (fromBLtoTL < tempCurRectHeight ) && (!tempMinimizedRect.left) ; fromBLtoTL ++)
		{
			// Ʒ  ̵ϸ鼭 ... | ̷  üũ..
			//  ּҸ Y  1 ŭ ... => ؿ  ö...
			
			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (tempValueY * fromBLtoTL) );

			//   Ʋ     ŭ ȭ   top  ..
			if(tempBaseValueColor != *ptempCurPointAddress)
				tempMinimizedRect.left = (tempCurRect.left + fromBLtoBR);
		}

		//  ּҸ   ...
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress + tempValueX); 
	}

	if(!tempMinimizedRect.left)
		return FALSE;

	{//   ӽ..
		int a = 0;
		++a;
	}

	////////////////////////////////////////////////////////////////////
	// κ    üũ... right  ϱ......
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	// üũ  ̶ ٿ ϴ .............

	tempCurRect.left = tempOriginalRect.left;
	tempCurRect.right = tempOriginalRect.right;
	
	// Ʊ üũ ŭ̶ ....
	tempCurRect.top		= tempMinimizedRect.top;
	tempCurRect.bottom	= tempMinimizedRect.bottom;

	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.right = 0;
	
	// ּҰ ... ( ϴ ..)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.right, tempCurRect.bottom);

	// ϴ  ϴ  ̸ŭ.. ׸ tempMinimizedrect.right    Ż..
	for(int fromBRtoBL = 0; (fromBRtoBL < tempCurRectWidth) && (!tempMinimizedRect.right) ; fromBRtoBL ++)
	{
		// ϴܿ   ̵ϸ鼭 ... // ޸ 迭 .. ..
		for(int fromBRtoTR = 0 ; (fromBRtoTR < tempCurRectHeight ) && (!tempMinimizedRect.right) ; fromBRtoTR ++)
		{
			// Ʒ  ̵ϸ鼭 ... | ̷  üũ..
			//  ּҸ Y  1 ŭ ... => ؿ  ö...
			
			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (tempValueY * fromBRtoTR) );

			//   Ʋ     ŭ ȭ   right  ..
			if(tempBaseValueColor != *ptempCurPointAddress)
				tempMinimizedRect.right = (tempCurRect.right - fromBRtoBL + 1);

			//  1 ؾ .. Ƹ 鼭 ⶧ ϴ  ...
		}

		//  ּҸ   ...
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress - tempValueX); 
	}

	if(!tempMinimizedRect.right)
		return FALSE;

	///////////////////////////////////////////////////////////

	// 󸶳  ΰ............ 
	// .................................... T_/~~  By Jisung Jung !!

	// ߿     .............
	
	return (tempMinimizedRect);
}

////////////////////////////////////////////////////////////////////////////////////////////
///////   ȭ (24 bit BMP FIle)...............
////////////////////////////////////////////////////////////////////////////////////////////

CRect CBmp::Minimize24bitColor(CRect selectedRect)
{
	CRect	tempMinimizedRect(0,0,0,0);

	//  ǥ մϴ ̹Ʈ  ϱ...
	// ⼭ ʹ  ޸ ġ  ...
	// ׸ ؿ ..........

	//   ...
	CRect tempOriginalRect = selectedRect;

	int tempValueX	= m_ByteForOnePixel;		// ޸ 󿡼  1 ޸  ..
	int tempValueY	= m_BmpWidthBytes;		// ޸ 󿡼  1 ޸  ..

	// õ  ⺻ ּ ...  ...
	BYTE * ptempBaseStartAddress = GetImagePointAddress(tempOriginalRect.left, tempOriginalRect.bottom);
	
	if(!ptempBaseStartAddress)	return FALSE;

	//    ϸ鼭 üũ...
	BYTE tempBaseValueRed	= *(ptempBaseStartAddress + 0);	// ù ȼ  
	BYTE tempBaseValueGreen	= *(ptempBaseStartAddress + 1);	// ù ȼ ׸ 
	BYTE tempBaseValueBlue	= *(ptempBaseStartAddress + 2);	// ù ȼ  

	BYTE tempCurValueRed = 0;
	BYTE tempCurValueGreen = 0;
	BYTE tempCurValueBlue = 0;

	
	//	int fromBLtoBR = 0;		// BL : Bottom Left
	//	int fromTLtoTR = 0;		// BR : Bottom Right
	//	int fromBLtoTL = 0;		// TL : Top Left
	//	int fromBRtoTR = 0;		// TR : Top Right

	//    ¿  ..

	CRect tempCurRect(0,0,0,0);				// ȭ   ...

	int tempCurRectHeight	= 0;			// ׸ ӽ  ..
	int tempCurRectWidth	= 0;			// ׸ ӽ  ..

	BYTE * ptempStartAddress	= NULL;		//   ּ...
	BYTE * ptempCurPointAddress = NULL;
	
	////////////////////////////////////////////////////////////////////
	// Ʒ    üũ... bottom  ϱ..... 
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	tempCurRect = tempOriginalRect;
	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.bottom = 0;
	
	// ּҰ ... ( Ʒ ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.bottom);

	// ؿ  ̸ŭ.. ׸ tempMinimizedrect.bottom    Ż..
	for(int fromBLtoTL = 0; (fromBLtoTL < tempCurRectHeight) && (!tempMinimizedRect.bottom) ; fromBLtoTL ++)
	{
		// Ʒ ʿ Ʒ  ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromBLtoBR = 0 ; (fromBLtoBR < tempCurRectWidth ) && (!tempMinimizedRect.bottom) ; fromBLtoBR ++)
		{
			//  ̵ϸ鼭 ... 24 Ʈ   ȼ ũ 3 Ʈ..

			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (fromBLtoBR * tempValueX) ) ;

			tempCurValueRed		= *(ptempCurPointAddress + 0);	//  ȼ  ...
			tempCurValueGreen	= *(ptempCurPointAddress + 1);	//  ȼ  ...
			tempCurValueBlue	= *(ptempCurPointAddress + 2);	//  ȼ ۷ ...
			
			//   Ʋ     ŭ ȭ   bottom  ..

			if ( ( tempCurValueRed		!= tempBaseValueRed		) |
			     ( tempCurValueGreen	!= tempBaseValueGreen	) |
				 ( tempCurValueBlue		!= tempBaseValueBlue	) )
				
				tempMinimizedRect.bottom = (tempCurRect.bottom - fromBLtoTL);
		}

		// ޸ ġ 1ĭ ø.. ؿ  ö󰡱ؼ ޸ ּҰ ..
	
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress + tempValueY); 
	}
	
	
	if(!tempMinimizedRect.bottom)	// ٴ   ϸ
		return	(tempOriginalRect);  //  ǥ ״ ...    ٴ ..
	                                //   ̶...   ..


	////////////////////////////////////////////////////////////////////
	// κ Ʒ   üũ... top  ϱ......
	////////////////////////////////////////////////////////////////////

	//    ٴ   Ŵϱ...    ؾ ,
	//  for Żϰ Ǵϱ  ..............

	// ʱȭ...............

	tempCurRect = tempOriginalRect;
	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.top = 0;
	
	// ּҰ ... (  ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.top);

	//   ̸ŭ.. ׸ tempMinimizedrect.top    Ż..
	for(int fromTLtoBL = 0; (fromTLtoBL < tempCurRectHeight) && (!tempMinimizedRect.top) ; fromTLtoBL ++)
	{
		//  ʿ ϴ  ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromTLtoTR = 0 ; (fromTLtoTR < tempCurRectWidth ) && (!tempMinimizedRect.top) ; fromTLtoTR ++)
		{
			//  ̵ϸ鼭 ... 24Ʈ   ȼ ũ 3Ʈ..

			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (fromTLtoTR * tempValueX) ) ;	

			tempCurValueRed		= *(ptempCurPointAddress + 0);	//  ȼ  ...
			tempCurValueGreen	= *(ptempCurPointAddress + 1);	//  ȼ  ...
			tempCurValueBlue	= *(ptempCurPointAddress + 2);	//  ȼ ۷ ...
			
			//   Ʋ     ŭ ȭ   bottom  ..

			if ( ( tempCurValueRed		!= tempBaseValueRed		) |
			     ( tempCurValueGreen	!= tempBaseValueGreen	) |
				 ( tempCurValueBlue		!= tempBaseValueBlue	) )
				
			
				tempMinimizedRect.top = (tempCurRect.top + fromTLtoBL - 1);

			//   ̻ѵ... μ  .. ǰ...
		}


		//   ĭ .. ޸ 迭   Ʈ ŭ ..
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress - tempValueY); 
	}

	//   µ  ⿡  ٴ   ȵ, Ȥó ؼ ...
	// ̰Ŵ  5ð  ؼ ¥  ..
	//  õ鰡..............^^;

	//   9ð°..  ִ.   -1    Ȱ...

	if(!tempMinimizedRect.top)
		return FALSE;

	////////////////////////////////////////////////////////////////////
	// κ    üũ... left  ϱ......
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	// üũ  ̶ ٿ ϴ .............

	tempCurRect.left = tempOriginalRect.left;
	tempCurRect.right = tempOriginalRect.right;
	
	// Ʊ üũ ŭ̶ ....
	tempCurRect.top		= tempMinimizedRect.top;
	tempCurRect.bottom	= tempMinimizedRect.bottom;

	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.left = 0;
	
	// ּҰ ... ( ϴ ...)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.left, tempCurRect.bottom);

	// ϴ  ϴ  ̸ŭ.. ׸ tempMinimizedrect.left    Ż..
	for(int fromBLtoBR = 0; (fromBLtoBR < tempCurRectWidth) && (!tempMinimizedRect.left) ; fromBLtoBR ++)
	{
		// ϴ   ̵ϸ鼭 ... // ޸ 迭 ..
		for(int fromBLtoTL = 0 ; (fromBLtoTL < tempCurRectHeight ) && (!tempMinimizedRect.left) ; fromBLtoTL ++)
		{
			// Ʒ  ̵ϸ鼭 ... | ̷  üũ..
			//  ּҸ Y  1 ŭ ... => ؿ  ö...
			
			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (tempValueY * fromBLtoTL) );

			tempCurValueRed		= *(ptempCurPointAddress + 0);	//  ȼ  ...
			tempCurValueGreen	= *(ptempCurPointAddress + 1);	//  ȼ  ...
			tempCurValueBlue	= *(ptempCurPointAddress + 2);	//  ȼ ۷ ...

			//   Ʋ     ŭ ȭ   top  ..
			if ( ( tempCurValueRed		!= tempBaseValueRed		) |
			     ( tempCurValueGreen	!= tempBaseValueGreen	) |
				 ( tempCurValueBlue		!= tempBaseValueBlue	) )
				
				tempMinimizedRect.left = (tempCurRect.left + fromBLtoBR);
		}

		//  ּҸ   ...
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress + tempValueX); 
	}

	if(!tempMinimizedRect.left)
		return FALSE;

	{//   ӽ..
		int a = 0;
		++a;
	}

	////////////////////////////////////////////////////////////////////
	// κ    üũ... right  ϱ......
	////////////////////////////////////////////////////////////////////

	// ʱȭ...............

	// üũ  ̶ ٿ ϴ .............

	tempCurRect.left = tempOriginalRect.left;
	tempCurRect.right = tempOriginalRect.right;
	
	// Ʊ üũ ŭ̶ ....
	tempCurRect.top		= tempMinimizedRect.top;
	tempCurRect.bottom	= tempMinimizedRect.bottom;

	tempCurRectHeight = tempCurRect.Height();
	tempCurRectWidth = tempCurRect.Width();

	tempMinimizedRect.right = 0;
	
	// ּҰ ... ( ϴ ..)
	ptempStartAddress = (BYTE *) GetImagePointAddress(tempCurRect.right, tempCurRect.bottom);

	// ϴ  ϴ  ̸ŭ.. ׸ tempMinimizedrect.right    Ż..
	for(int fromBRtoBL = 0; (fromBRtoBL < tempCurRectWidth) && (!tempMinimizedRect.right) ; fromBRtoBL ++)
	{
		// ϴܿ   ̵ϸ鼭 ... // ޸ 迭 .. ..
		for(int fromBRtoTR = 0 ; (fromBRtoTR < tempCurRectHeight ) && (!tempMinimizedRect.right) ; fromBRtoTR ++)
		{
			// Ʒ  ̵ϸ鼭 ... | ̷  üũ..
			//  ּҸ Y  1 ŭ ... => ؿ  ö...
			
			ptempCurPointAddress = (BYTE *) ( (int) ptempStartAddress + (tempValueY * fromBRtoTR) );

			tempCurValueRed		= *(ptempCurPointAddress + 0);	//  ȼ  ...
			tempCurValueGreen	= *(ptempCurPointAddress + 1);	//  ȼ  ...
			tempCurValueBlue	= *(ptempCurPointAddress + 2);	//  ȼ ۷ ...

			//   Ʋ     ŭ ȭ   right  ..

			if ( ( tempCurValueRed		!= tempBaseValueRed		) |
			     ( tempCurValueGreen	!= tempBaseValueGreen	) |
				 ( tempCurValueBlue		!= tempBaseValueBlue	) )
				
				tempMinimizedRect.right = (tempCurRect.right - fromBRtoBL + 1);

			//  1 ؾ .. Ƹ 鼭 ⶧ ϴ  ...
		}

		//  ּҸ   ...
		ptempStartAddress = (BYTE *) ((int) ptempStartAddress - tempValueX); 
	}

	if(!tempMinimizedRect.right)
		return FALSE;

	///////////////////////////////////////////////////////////
	// 󸶳  ΰ............ 
	// .................................... T_/~~  By Jisung Jung !!
	// ߿     .............

	//  8Ʈ  ϰ.... ణ ؼ 24Ʈ 带 ó.......
	// Ȯ ũ  ߿ϴ.................
	// 8Ʈ  ϴµ 1ð  ҿ..
	//
	// 24Ʈ    ........ ũ...........
	
	return (tempMinimizedRect);
}


////////////////////////////////////////////////////////////////////////////////////////////
//////// Ʈ  .........
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpLoad(const char *fileName)
{
	TRY	//  .......  ޸ Ҵ.  ݱ.
	{
		if(m_hBmp)
		{
			delete m_hBmp;
			m_hBmp = NULL;
		}

		BITMAPFILEHEADER temp_BmpFileHeader;
		
		CFile file(fileName,CFile::modeRead);
		
		//  .........
		if(!file.Read(&temp_BmpFileHeader,sizeof(BITMAPFILEHEADER)) )
		{
			AfxMessageBox("Ʈ   б ....");
			return FALSE;
		}

		// Ʈ  ´ Ȯ....
		if(temp_BmpFileHeader.bfType != 0x4d42)
		{
			AfxMessageBox("Ʈ  ƴ...");
			return FALSE;
		}

		//    ϱ.
		m_BmpSize = (UINT) temp_BmpFileHeader.bfSize;

		// DIB ޸ ũ .
		m_DibSize = (UINT) m_BmpSize - sizeof(BITMAPFILEHEADER);


		// ޸𸮸 Ҵ κ  ( )
		if(!(m_hBmp = new BYTE[m_DibSize]))
		{
			AfxMessageBox("޸ Ҵ ");
			return FALSE;
		}
		
		// ޸𸮿 DIB ..  ڵ .
		file.Read((void*)m_hBmp, m_DibSize);
		file.Close();
	}

	CATCH( CFileException, e )
	{
	   #ifdef _DEBUG
		  afxDump << "File could not be opened " << e->m_cause << "\n";
	   #endif
	}
	END_CATCH

	//   ... 
	m_pBmpInfoHeader = (BITMAPINFOHEADER *) m_hBmp;

	//  Ʈ īƮ ϱ.....
	m_BitCount = m_pBmpInfoHeader -> biBitCount;

	//Ʈ ÷  .
	m_ClrUsed = m_pBmpInfoHeader -> biClrUsed;

	if(m_BitCount == 8)
		m_ClrUsed = 256;

	// ȷƮ  ũ.
	m_PaletteSize = m_ClrUsed * sizeof(RGBQUAD);

	//Ʈ ÷ ̺  
	m_pBmpPalette = (RGBQUAD *)((UINT)(m_pBmpInfoHeader) + (UINT)(m_pBmpInfoHeader->biSize));
	
	// ̹ Ʈ  .
	m_pImageBit = m_hBmp + sizeof(BITMAPINFOHEADER)+ m_PaletteSize;

	m_ByteForOnePixel = m_BitCount / 8;

	//   ũ ϱ.......
	if(m_BitCount == 8) // 256 Į ....
	{
		m_BmpWidthBytes = m_pBmpInfoHeader->biWidth;
		m_BmpWidthBytes  = (m_BmpWidthBytes +3)&~3; // 4 ȭ Ŵ.
	}

	if(m_BitCount == 24) // 24 Ʈ Į .....
	{
		m_BmpWidthBytes = (m_pBmpInfoHeader->biWidth) *3 ; // ʿ  Ʈ ....
		m_BmpWidthBytes  = (m_BmpWidthBytes +3)&~3; // 4 ȭ Ŵ.
	}
	
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////////
///////////  ü ...
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpSaveFile(const char *FileName) 
{
	if(!m_hBmp)
	{
		AfxMessageBox(" ׸ ..  ε϶ī..");
		return FALSE;
	}

	CFile tempSprFile(FileName, CFile::modeCreate | CFile::modeWrite); 
	
	//    ֱ.................
	BITMAPFILEHEADER tempBmpFileHeader;

	tempBmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + GetPalSize();
	tempBmpFileHeader.bfReserved1 = NULL;
	tempBmpFileHeader.bfReserved2 = NULL;
	tempBmpFileHeader.bfSize = GetBmpSize(); //  ũ⸦ ־.
	tempBmpFileHeader.bfType = 0x4d42; // Ʈ ũ ǥ....
	
	//   ...
	tempSprFile.Write(&tempBmpFileHeader, sizeof(BITMAPFILEHEADER)); //  .....

	// ҽ ׸ ...
	tempSprFile.Write(m_hBmp, (GetBmpSize() - sizeof(BITMAPFILEHEADER)) );
	tempSprFile.Close();
	
	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////////////////
/////// ǥõ ŭ   ......... ظϸ ġ ...
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpSaveFile(const char *FileName, CRect SourceRect) //  ŭ ̸ .
{
	if(SourceRect.top == SourceRect.bottom)
	{
		AfxMessageBox("  õ ʾҽϴ.");
		return FALSE;
	}

	int tempHeaderSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	
	if(!m_hBmp) // ׸ ڵ  .......
	{
		AfxMessageBox(" ׸ ϴ.  ׸ εּ.... -_/~~");
		return FALSE;
	}

	if(tempHeaderSize != 54) //   üũ........
	{
		AfxMessageBox("   α׷  ʴ Ʈ Դϴ.");
		return FALSE;
	}

	//   ̺  ...
	
	CFile tempBmpFile(FileName, CFile::modeCreate | CFile::modeWrite); 

	// ʿ ͵..........
	
	BITMAPFILEHEADER tempBmpFileHeader;
	BITMAPINFOHEADER * ptempBmpInfoHeader = NULL;
	RGBQUAD * ptempPal = NULL;
	BYTE * ptempImageBit = NULL;
	BYTE * temphBmp = NULL; // Ʈ Ͽ  ڵ( ۵Ǵ  ּ)

	//  ̺꿡 ʿ .........
	
	BYTE *ptempSourceImageBit = NULL; // ҽ  ̹ Ʈ. ϸ ȵ.
	BYTE *ptempCurImageBit = NULL;	//   ǥ  Ʈ .
	BYTE *ptempCurDesImageBit = NULL; //  ̹ Ʈ.
	int tempRealSourceY = NULL; //  Y ...
	
	// ʿ .....

	int tempBmpSize = NULL; //   
	int tempHeight = (SourceRect.bottom - SourceRect.top);  //   
	int tempWidth = (SourceRect.right - SourceRect.left); //   

	int tempDibSize = NULL; //  .
	int tempPalSize = NULL;
	int tempImageBitSize = NULL; // ̹Ʈ ũ.

	int tempByteForPixel = (GetBitCount() / 8); //  ȼ óϴ Ʈ .
	int tempWidthBytes = NULL; // ׷ ׸   Ʈ ũ.. (y)
	int SourceWidthBytes = NULL; // ҽ ׸   Ʈ ũ...(y)

//
	// width = (width+3)&~3;
	//
	
	if(tempByteForPixel == 1) // 256 Į ....
	{
		tempWidthBytes = (tempWidth+3)&~3; // 4 ȭ Ŵ.
	}

	if(tempByteForPixel == 3) // 24 Ʈ Į .....
	{
		tempWidthBytes = tempWidth * 3; // ʿ  Ʈ ....
		tempWidthBytes = (tempWidthBytes+3)&~3; // 4 ȭ Ŵ.
	}
	
	//  ϱ....

	tempPalSize = GetPalSize();
	
	tempBmpSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER)
		+ tempPalSize + (tempWidthBytes * tempHeight);     
	
	tempDibSize = tempBmpSize - sizeof(BITMAPFILEHEADER);
	
	tempImageBitSize = tempDibSize - sizeof(BITMAPINFOHEADER) - tempPalSize;
	
	//    ֱ.................

	tempBmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + tempPalSize;
	tempBmpFileHeader.bfReserved1 = NULL;
	tempBmpFileHeader.bfReserved2 = NULL;
	tempBmpFileHeader.bfSize = tempBmpSize; //  ũ⸦ ־.
	tempBmpFileHeader.bfType = 0x4d42; // Ʈ ũ ǥ....
	
	tempBmpFile.Write(&tempBmpFileHeader, sizeof(BITMAPFILEHEADER)); //  .....

	//  ּ .

	if(!(temphBmp = new BYTE[tempDibSize]))      // ޸  Ҵ..........
		{
			AfxMessageBox("޸ Ҵ ");
			return FALSE;
		}

	ptempBmpInfoHeader = (BITMAPINFOHEADER *) temphBmp; //  .

	ptempPal = (RGBQUAD *)( (UINT)(ptempBmpInfoHeader) + sizeof(BITMAPINFOHEADER) ); // ȷƮ 
	
	ptempImageBit = temphBmp + sizeof(BITMAPINFOHEADER) + tempPalSize; // ̹ Ʈ  .


	//  ȷƮ  ְ Ͽ ̺긦 .

	//  ޸ ī.
	memcpy(ptempBmpInfoHeader,m_pBmpInfoHeader, sizeof(BITMAPINFOHEADER) ); // ƿ  .

	//  ޸ ī.
	if(tempPalSize)
		memcpy(ptempPal,m_pBmpPalette, tempPalSize); // ƿ  .

	ptempBmpInfoHeader->biHeight = tempHeight;
	ptempBmpInfoHeader->biWidth = tempWidth;
	ptempBmpInfoHeader->biSizeImage = tempImageBitSize;
	
	tempBmpFile.Write(ptempBmpInfoHeader, sizeof(BITMAPINFOHEADER));
	tempBmpFile.Write(ptempPal,tempPalSize);

    // Ʈ ̹ Ʈ ̺ ϱ........
	{
		ptempSourceImageBit = m_pImageBit; // ҽ  ̹ Ʈ. ϸ ȵ.
		ptempCurImageBit = NULL;	//   ǥ  Ʈ .
		ptempCurDesImageBit = ptempImageBit; //  ̹ Ʈ.
		tempRealSourceY = GetHeight() - SourceRect.bottom; //  Y ...

		for(int i = 0; i < tempHeight ; i++)
		{
			ptempCurImageBit = (ptempSourceImageBit) + //  .
							   ( ( tempRealSourceY + i) * m_BmpWidthBytes) + // Y ǥ .
							   ( SourceRect.left * tempByteForPixel); // x ǥ .
			
			ptempCurDesImageBit = (ptempImageBit) + (i * tempWidthBytes);

			//      ŭ.. ޸ ī !!

			memcpy(ptempCurDesImageBit, ptempCurImageBit, tempWidthBytes);

			tempBmpFile.Write(ptempCurDesImageBit, tempWidthBytes);
		}
	}

	tempBmpFile.Close();

	if(temphBmp)
	{
		delete temphBmp;
		temphBmp = NULL;
	}

	return TRUE;
}


















///////////////////////////////////////////////////////////
// ȭ ׸..........
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
// ü ȭ ׷ֱ......
//////////////////////////////////////////////////////////

BOOL CBmp::BmpDraw(CDC *pDC)
{
	CRect tempRect;

	tempRect.top = 0;
	tempRect.left = 0;
	tempRect.right = GetWidth();
	tempRect.bottom = GetHeight();

	tempRect.NormalizeRect();

	if(BmpDraw(pDC,tempRect,tempRect))
		return TRUE;

	return FALSE;
}

//////////////////////////////////////////////////////////
// ҽ   0,0  ׷ֱ....
//////////////////////////////////////////////////////////

BOOL CBmp::BmpDraw(CDC *pDC, CRect tempSourceRect)
{
	CRect tempTargetRect;
	CPoint tempTargetPoint;

	tempSourceRect.NormalizeRect();

	tempTargetPoint.x = 0;
	tempTargetPoint.y = 0;

	tempTargetRect.top = 0;
	tempTargetRect.left = 0;
	tempTargetRect.right = tempSourceRect.Width();
	tempTargetRect.bottom = tempSourceRect.Height();

	if(BmpDraw(pDC,tempSourceRect,tempTargetRect))
		return TRUE;

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////////////////
/////// ҽȭ Ÿ 信 Ʈ ׷ֱ........
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpDraw(CDC *pDC, CRect sourceRect, CPoint targetPoint)
{
	CRect tempTargetRect;

	sourceRect.NormalizeRect();
	tempTargetRect.NormalizeRect();

	tempTargetRect.left = targetPoint.x;
	tempTargetRect.top = targetPoint.y;
	
	tempTargetRect.right = sourceRect.Width() + targetPoint.x;
	tempTargetRect.bottom = sourceRect.Height() + targetPoint.y;


	if(BmpDraw(pDC,sourceRect,tempTargetRect))
		return TRUE;

	return FALSE;
}


//////////////////////////////////////////////////////////////////////
// ׸ ׸ (׸ ҽ  Ÿ  ؼ...........)
//////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpDraw(CDC *pDC, CRect sourceRect, CRect targetRect)
{
	// ǥ  .
	sourceRect.NormalizeRect();
	targetRect.NormalizeRect();
	
	if(sourceRect.right > GetWidth())
	{
		AfxMessageBox("  ߸Ǿϴ. \nõ  ǥ  ׸ ׸ Ѿϴ.");
		return FALSE;
	}

	if(sourceRect.bottom > GetHeight())
	{
		AfxMessageBox("  ߸Ǿϴ. \nõ Ʒ ǥ  ׸ ׸ Ѿϴ.");
		return FALSE;
	}

	int tempSourceX = sourceRect.left;
	
	//  Y ......
	int tempSourceY = GetHeight() - sourceRect.top - sourceRect.Height();

	int tempSourceWidth = sourceRect.Width();
	int tempSourceHeight = sourceRect.Height();

	int tempTargetWidth = targetRect.Width();
	int tempTargetHeight = targetRect.Height();

	///// 24Ʈ Į.........................
	if(m_BitCount == 24)
	{
		StretchDIBits(
					  pDC->m_hDC,
					  
					  targetRect.left,
					  targetRect.top,
					  tempTargetWidth,
					  tempTargetHeight,

					  tempSourceX,
					  tempSourceY,
					  tempSourceWidth,
					  tempSourceHeight,

					  m_pImageBit,
					  (BITMAPINFO*)m_pBmpInfoHeader,
					  DIB_RGB_COLORS,
					  SRCCOPY
					 );
		return TRUE;
	}

	
	////////////////////////// 8Ʈ ׸..............
	
	if(m_BitCount == 8)
	{
		HPALETTE hPalette=NULL, hOldPalette=NULL;

		RGBQUAD *pTempPalette;
		pTempPalette = m_pBmpPalette;
		
		struct
		{
			WORD Version;
			WORD NumberOfEntries;
			PALETTEENTRY aEntries[256];
		} logicalPalette = {0x300,256};

		for(int i =0 ; i < m_ClrUsed ; i++)
		{
			logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;
			logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;
			logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;
			logicalPalette.aEntries[i].peFlags = 0;
		}

		hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);
		hOldPalette = SelectPalette(pDC->m_hDC,hPalette,FALSE);

		RealizePalette(pDC->m_hDC);

		StretchDIBits(
					  pDC->m_hDC,
	
		  
					  targetRect.left,
					  targetRect.top,
					  tempTargetWidth,
					  tempTargetHeight,

					  tempSourceX,
					  tempSourceY,
					  tempSourceWidth,
					  tempSourceHeight,			  

					  m_pImageBit,
					  (BITMAPINFO*)m_pBmpInfoHeader,
					  DIB_RGB_COLORS,
					  SRCCOPY
					 );
		
		SelectPalette(pDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
		return TRUE;
	}


	if(m_BitCount == 1)
	{
		AfxMessageBox(" α׷ 2  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}

	if(m_BitCount == 2)
	{
		AfxMessageBox(" α׷ 4  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}

	if(m_BitCount == 4)
	{
		AfxMessageBox(" α׷ 16  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}
	
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
////////
////////  //   ؼ ׸ ׸.........................
////////
///////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// ü ȭ ׷ֱ..................//   
//////////////////////////////////////////////////////////

BOOL CBmp::BmpMultiDraw(CDC *pDC, UINT multifyNumber)
{
	CRect tempRect;

	tempRect.top = 0;
	tempRect.left = 0;
	tempRect.right = GetWidth();
	tempRect.bottom = GetHeight();

	tempRect.NormalizeRect();

	if(BmpMultiDraw(pDC,tempRect,tempRect, multifyNumber))
		return TRUE;

	return FALSE;
}

//////////////////////////////////////////////////////////
// ҽ   0,0  ׷ֱ....//   
//////////////////////////////////////////////////////////

BOOL CBmp::BmpMultiDraw(CDC *pDC, CRect tempSourceRect, UINT multifyNumber)
{
	CRect tempTargetRect;
	CPoint tempTargetPoint;

	tempSourceRect.NormalizeRect();

	tempTargetPoint.x = 0;
	tempTargetPoint.y = 0;

	tempTargetRect.top = 0;
	tempTargetRect.left = 0;
	tempTargetRect.right = tempSourceRect.Width();
	tempTargetRect.bottom = tempSourceRect.Height();

	if(BmpMultiDraw(pDC,tempSourceRect,tempTargetRect, multifyNumber))
		return TRUE;

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////////////////
/////// ҽȭ Ÿ 信 Ʈ ׷ֱ........//   
////////////////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpMultiDraw(CDC *pDC, CRect sourceRect, CPoint targetPoint, UINT multifyNumber)
{
	CRect tempTargetRect;

	sourceRect.NormalizeRect();
	tempTargetRect.NormalizeRect();

	tempTargetRect.left = targetPoint.x;
	tempTargetRect.top = targetPoint.y;
	
	tempTargetRect.right = sourceRect.Width() + targetPoint.x;
	tempTargetRect.bottom = sourceRect.Height() + targetPoint.y;


	if(BmpMultiDraw(pDC,sourceRect,tempTargetRect, multifyNumber))
		return TRUE;

	return FALSE;
}


///////////////////////////////////////////////////////////////////////////////////
// ׸ ׸ (׸ ҽ  Ÿ  ؼ....//   )
///////////////////////////////////////////////////////////////////////////////////

BOOL CBmp::BmpMultiDraw(CDC *pDC, CRect sourceRect, CRect targetRect, UINT multifyNumber)
{
	// ǥ  .
	sourceRect.NormalizeRect();
	targetRect.NormalizeRect();

	int tempMultifyNumber = multifyNumber;
	
	if(tempMultifyNumber <=0)
	{
		AfxMessageBox("  0 Ǿϴ..\n  1 ʱȭ մϴ.\nԷ  !!");
		tempMultifyNumber = 1;
	}	
	
	int tempBmpWidth	= GetWidth()	* tempMultifyNumber;
	int tempBmpHeight	= GetHeight()	* tempMultifyNumber;
	
	if(sourceRect.right  > tempBmpWidth)
	{
		AfxMessageBox("  ߸Ǿϴ. \nõ  ǥ  ׸ ׸ Ѿϴ.");
		return FALSE;
	}

	if(sourceRect.bottom > tempBmpHeight)
	{
		AfxMessageBox("  ߸Ǿϴ. \nõ Ʒ ǥ  ׸ ׸ Ѿϴ.");
		return FALSE;
	}

	int tempSourceX = sourceRect.left;
	
	//  Y ......
	int tempSourceY = GetHeight() - sourceRect.top - sourceRect.Height();

	int tempSourceWidth = sourceRect.Width();
	int tempSourceHeight = sourceRect.Height();

	//   ........
	int tempTargetWidth = targetRect.Width()   * tempMultifyNumber;
	int tempTargetHeight = targetRect.Height() * tempMultifyNumber;

	///// 24Ʈ Į.........................
	if(m_BitCount == 24)
	{
		StretchDIBits(
					  pDC->m_hDC,
					  
					  targetRect.left,
					  targetRect.top,
					  tempTargetWidth,
					  tempTargetHeight,

					  tempSourceX,
					  tempSourceY,
					  tempSourceWidth,
					  tempSourceHeight,

					  m_pImageBit,
					  (BITMAPINFO*)m_pBmpInfoHeader,
					  DIB_RGB_COLORS,
					  SRCCOPY
					 );
		return TRUE;
	}

	
	////////////////////////// 8Ʈ ׸..............
	
	if(m_BitCount == 8)
	{
		HPALETTE hPalette=NULL, hOldPalette=NULL;

		RGBQUAD *pTempPalette;
		pTempPalette = m_pBmpPalette;
		
		struct
		{
			WORD Version;
			WORD NumberOfEntries;
			PALETTEENTRY aEntries[256];
		} logicalPalette = {0x300,256};

		for(int i =0 ; i < m_ClrUsed ; i++)
		{
			logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;
			logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;
			logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;
			logicalPalette.aEntries[i].peFlags = 0;
		}

		hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);
		hOldPalette = SelectPalette(pDC->m_hDC,hPalette,FALSE);

		RealizePalette(pDC->m_hDC);

		StretchDIBits(
					  pDC->m_hDC,
	
		  
					  targetRect.left,
					  targetRect.top,
					  tempTargetWidth,
					  tempTargetHeight,

					  tempSourceX,
					  tempSourceY,
					  tempSourceWidth,
					  tempSourceHeight,			  

					  m_pImageBit,
					  (BITMAPINFO*)m_pBmpInfoHeader,
					  DIB_RGB_COLORS,
					  SRCCOPY
					 );
		
		SelectPalette(pDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
		return TRUE;
	}


	if(m_BitCount == 1)
	{
		AfxMessageBox(" α׷ 2  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}

	if(m_BitCount == 2)
	{
		AfxMessageBox(" α׷ 4  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}

	if(m_BitCount == 4)
	{
		AfxMessageBox(" α׷ 16  ʽϴ.\n256 ̻ մϴ.");
		return FALSE;
	}
	
	return FALSE;
}

//    .............(ʿ   ...........)

BOOL CBmp::BmpSave()
{
	return TRUE;
}
