//
// DibView.cpp : implementation file
//

#include "stdafx.h"
#include "Sprite.h"

#include "MainFrm.h"
#include "SpriteDoc.h"
#include "SprData.h"

#include "DibView.h"

#include "Bmp.h"
#include "DrawTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define CDIBVIEW_COLOR RGB(150,50,150)


/////////////////////////////////////////////////////////////////////////////
// CDibView

IMPLEMENT_DYNCREATE(CDibView, CScrollView)

CDibView::CDibView()
{
}

CDibView::~CDibView()
{
}


BEGIN_MESSAGE_MAP(CDibView, CScrollView)
	//{{AFX_MSG_MAP(CDibView)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//  ũó  Ʈ   信 Ž....
void CDibView::UpdateInfoViewDataPoint(CPoint CurScrolledPoint)
{
	//   ϱ.........
	//((CMainFrame *)AfxGetMainWnd())->m_pCInfoView->m_CurPoint = m_CurScrollSize;

	//   ϱ......
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CDibViewMultiNumber;

	CString tempStr; 

	CPoint tempCurScrolledPoint = CurScrolledPoint;

	tempCurScrolledPoint.x /= tempMultifyNumber;
	tempCurScrolledPoint.y /= tempMultifyNumber;

	// ⼭  콺 ġ ׸   ̵ϴ ..

	tempStr.Format("X = %4d", tempCurScrolledPoint.x );
	pMF->m_pCInfoView->m_szCurScrolledPointX = tempStr;

	tempStr.Format("Y = %4d", tempCurScrolledPoint.y);
	pMF->m_pCInfoView->m_szCurScrolledPointY = tempStr;

	//  ֱ..........
	pMF->m_pCInfoView->UpdateData(FALSE);	
}

///////////////////////////////////////////////////////
//  忡 ϱ............
BOOL CDibView::	SaveCurSelectedRect(CRect selectedRect)
{
	CSpriteDoc *pDoc = GetDocument();

	CRect tempSelectedRect = selectedRect;
	CRect tempSourceBmpRect;
	{
		tempSourceBmpRect.left	 = NULL;
		tempSourceBmpRect.top	 = NULL;
		tempSourceBmpRect.right  = pDoc->m_Bmp.GetWidth();
		tempSourceBmpRect.bottom = pDoc->m_Bmp.GetHeight();
	}

	tempSelectedRect.NormalizeRect();
	tempSourceBmpRect.NormalizeRect();

	// ׸  ũ üũ
	if(tempSelectedRect.Width() > tempSourceBmpRect.Width())
		return FALSE;

	// ׸  ũ üũ
	if(tempSelectedRect.Height() > tempSourceBmpRect.Height())
		return FALSE;

	// ׸   üũ
	if(tempSelectedRect.left < tempSourceBmpRect.left)
		return FALSE;

	// ׸   üũ
	if(tempSelectedRect.top < tempSourceBmpRect.top)
		return FALSE;


	// ׸   üũ
	if(tempSelectedRect.right > tempSourceBmpRect.right)
		return FALSE;

	// ׸   üũ
	if(tempSelectedRect.bottom > tempSourceBmpRect.bottom)
		return FALSE;

	if(! tempSelectedRect.Width() )
		return FALSE;

	if(! tempSelectedRect.Height() )
		return FALSE;

	CSprData *ptempNode;
	ptempNode = new CSprData;

	ptempNode ->m_SprRect = tempSelectedRect;
	GetDocument()-> m_SprDataList.AddTail(ptempNode);

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	pMF->m_pCSprView->Invalidate();


	ptempNode = NULL;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CDibView drawing

void CDibView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CDibView::OnDraw(CDC* pDC)
{
	CSpriteDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CDibViewMultiNumber;
	
	CRect tempRect;
	GetClientRect(&tempRect);


	// TODO: add draw code for native data here
	if (pDoc->m_Bmp.m_hBmp)
	{
		//  ĥϱ.....
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		int tempMultifyNumber = pMF->m_CDibViewMultiNumber;

		int tempBmpWidth	= pDoc->m_Bmp.GetWidth()  * tempMultifyNumber;
		int tempBmpHeight	= pDoc->m_Bmp.GetHeight() * tempMultifyNumber;

		
		if( (tempBmpHeight < tempRect.Height() ) | ( tempBmpWidth < tempRect.Width() ) )
		{
			tempRect.left = 0;
			tempRect.top = 0;

			if( tempBmpWidth > tempRect.Width())
			{
				tempRect.right = tempBmpWidth;
			}


			if( tempBmpHeight > tempRect.Height())
			{
				tempRect.bottom = tempBmpHeight;
			}

			pDoc->m_DrawTool.DrawRectangle(pDC,tempRect, 1, CDIBVIEW_COLOR, CDIBVIEW_COLOR);
		}

		// ׸ ׸....
		pDoc->m_Bmp.BmpMultiDraw (pDC,tempMultifyNumber);
	}

	else
		pDoc->m_DrawTool.DrawRectangle(pDC,tempRect, 1, CDIBVIEW_COLOR, CDIBVIEW_COLOR);


	SetScrollRange();
}

/////////////////////////////////////////////////////////////////////////////
// CDibView diagnostics

#ifdef _DEBUG
void CDibView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CDibView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDibView message handlers

int CDibView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	m_bStartCross  = FALSE;
	m_bStartBox    = FALSE;
	m_bStart	   = FALSE;
	m_bLBtnDn      = FALSE;

	m_ptBoxStart = m_ptBoxEnd = NULL;
	m_ptCurPoint = m_ptCurPointFix = m_ptOldPoint = NULL;
	m_rRect = NULL;

	return 0;
}

int CDibView::MakeDefault()
{
	// TODO: Add your specialized creation code here
	m_bStartCross  = FALSE;
	m_bStartBox    = FALSE;
	m_bStart	   = FALSE;
	m_bLBtnDn      = FALSE;

	m_ptBoxStart = m_ptBoxEnd = NULL;
	m_ptCurPoint = m_ptCurPointFix = m_ptOldPoint = NULL;
	m_rRect = NULL;

	return 0;
}

void CDibView::SetScrollRange()
{

	CSpriteDoc *pDoc = GetDocument();

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CDibViewMultiNumber;

	
	CSize tempMaxScrolledSize;

	if(pDoc->m_Bmp.m_hBmp)
	{
		tempMaxScrolledSize.cx = pDoc->m_Bmp.GetWidth()		* tempMultifyNumber;
		tempMaxScrolledSize.cy = pDoc->m_Bmp.GetHeight()	* tempMultifyNumber;
	}

	if(tempMaxScrolledSize.cx <= 0)
		tempMaxScrolledSize.cx = 1;

	if(tempMaxScrolledSize.cy <= 0)
		tempMaxScrolledSize.cy = 1;
	
	SetScrollSizes( MM_TEXT, tempMaxScrolledSize);
}

BOOL CDibView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	if(m_bStartCross)
		DrawCross(m_ptOldPoint);
	m_bStartCross = FALSE; 

	return CScrollView::OnEraseBkgnd(pDC);
}

void CDibView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc *pDoc = GetDocument();
	CPoint tempScrolledPoint = point + GetScrollPosition();


	//  信  ǥ ֱ.............
	UpdateInfoViewDataPoint(tempScrolledPoint); 


	if (pDoc->m_Bmp.m_hBmp == NULL) return;

	CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();
	GetClientRect(&m_rRect);	
	m_ptCurPointFix  = GetScrollPosition();
	m_ptCurPoint     = point;

    /////////////////////////////
	//  ׸
	if (m_bLBtnDn == FALSE)
	{//ʹư ȴ 

		if (m_bStartCross)
		{
			DrawCross(m_ptOldPoint);
			m_bStartCross = FALSE;
		}
			m_ptOldPoint = m_ptCurPoint;
			DrawCross(m_ptCurPoint);
			m_bStartCross = TRUE;
									
			SetCapture();

			if(!m_rRect.PtInRect(point))
			{
				DrawCross(m_ptOldPoint);
				ReleaseCapture();
				m_bStartCross  = FALSE;
			}
	}//ʹư ȴ 

	///////////////////////////
	// 簢 ׸
	else
	{//ʹư  
		if(m_bStartCross && m_bStartBox) 
		{
			DrawCross(m_ptOldPoint);
			m_bStartCross = FALSE;
		}

		DrawBox(m_ptBoxStart, m_ptBoxEnd);
		m_ptBoxEnd = point;
		DrawBox(m_ptBoxStart, m_ptBoxEnd);
		m_bStartBox = TRUE;  


	}//ʹư  

	CScrollView::OnMouseMove(nFlags, point);
}

void CDibView::DrawCross(CPoint pt)
{
	CClientDC dc(this);
	CPen MyPen(PS_SOLID, 1, RGB(255, 255, 255));
	CPen *pOldPen;
	pOldPen = dc.SelectObject(&MyPen);

	dc.SetROP2(R2_XORPEN);

    //  ///////////////////////////////		
	dc.MoveTo(            0, pt.y);
	dc.LineTo(m_rRect.right, pt.y);
    // 	///////////////////////////////
	dc.MoveTo(pt.x,              0);
	dc.LineTo(pt.x, m_rRect.bottom);
    ///////////////////////////////////////

	dc.SelectObject(pOldPen);
}


void CDibView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();

	if (pDoc->m_Bmp.m_hBmp != NULL)
	{
		m_bLBtnDn = m_bStartBox = TRUE;
		//pDoc->m_bOnSprDib = TRUE;

		m_ptBoxStart = m_ptBoxEnd = point;
		SetCapture();

		//CMainFrame *pMF = (CMainFrame *)AfxGetMainWnd();
		//pMF->m_pCCutView->OnInitialUpdate();
	}
	CScrollView::OnLButtonDown(nFlags, point);
}


void CDibView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();	

	if (pDoc->m_Bmp.m_hBmp) 
	{//NULL

		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		int tempMultifyNumber = pMF->m_CDibViewMultiNumber;

		int tempBmpWidth	= pDoc->m_Bmp.GetWidth() * tempMultifyNumber;
		int tempBmpHeight	= pDoc->m_Bmp.GetHeight()* tempMultifyNumber;

		if ( (point.x+m_ptCurPointFix.x > tempBmpWidth )
			 || (point.y+m_ptCurPointFix.y > tempBmpHeight ) )
		{//׸ 
			DrawBox(m_ptBoxStart, m_ptBoxEnd);
			m_bLBtnDn = m_bStartBox = FALSE;
			ReleaseCapture();
		}//׸ 

		else
		{//׸ 
			if (m_bStartBox && m_bLBtnDn)
			{//btn

			//////////////////////////////////////
			//  Dib 
			CRect RectOrg(m_ptBoxStart+m_ptCurPointFix,
						m_ptBoxEnd+m_ptCurPointFix);  //ũ :  ( ־)

			if(pDoc->m_Bmp.m_hBmp)
			{	

				CRect tempMinimizedRect;

				RectOrg.left	/= tempMultifyNumber;
				RectOrg.top		/= tempMultifyNumber;
				RectOrg.right	/= tempMultifyNumber;
				RectOrg.bottom	/= tempMultifyNumber;
				
				if(RectOrg.left		>= 0	)
				if(RectOrg.top		>= 0	)
				if(RectOrg.right	>= 0	)
				if(RectOrg.bottom	>= 0	)
				{
					RectOrg.NormalizeRect();
					tempMinimizedRect = pDoc->m_Bmp.MinimizeSelectedRect(RectOrg);
					
					if( tempMinimizedRect.Width()	)
					if( tempMinimizedRect.Height()	)					
						SaveCurSelectedRect(tempMinimizedRect);
				}//  ϱ.. //  ...
			}
		
			DrawBox(m_ptBoxStart, m_ptBoxEnd);
			m_bLBtnDn = m_bStartBox = FALSE;
			ReleaseCapture();
			//////////////////////////////////////

			}//btn
		}//׸ 
	}//NULL

	CScrollView::OnLButtonUp(nFlags, point);
}

void CDibView::DrawBox(CPoint ptStart, CPoint ptEnd)
{
	CClientDC dc(this);

	dc.SelectStockObject(WHITE_PEN);
	dc.SelectStockObject(NULL_BRUSH);
	dc.SetROP2(R2_XORPEN);
	// 簢 ////////////////////////////////////////////////
	dc.Rectangle(ptStart.x, ptStart.y, ptEnd.x, ptEnd.y);
	//////////////////////////////////////////////////////////
}
