// DrawTool.cpp: implementation of the CDrawTool class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Sprite.h"
#include "DrawTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDrawTool::CDrawTool()
{

}

CDrawTool::~CDrawTool()
{

}


BOOL CDrawTool::DrawSelectedArea(CDC * pDC, CPoint startPoint, CPoint endPoint)
{
	CRect tempRect;
	tempRect.left	= startPoint.x;
	tempRect.top	= startPoint.y;
	tempRect.right  = endPoint.x;
	tempRect.bottom = endPoint.y;

	DrawSelectedArea(pDC,tempRect);
	return TRUE;
}

//   ׷ֱ... 
BOOL CDrawTool::DrawSelectedArea(CDC * pDC,CRect curRect)
{

	CRect tempRect = curRect;
	
	pDC->SetROP2(R2_XORPEN);
	pDC->SelectObject(GetStockObject(WHITE_PEN));
	pDC->SelectObject(GetStockObject(NULL_BRUSH));

	pDC->Rectangle(&tempRect);
				
	pDC->SetROP2(R2_COPYPEN);
	
	return TRUE;
}


//   ׷ֱ....
void CDrawTool::DrawCenterCrossLine(CDC * pDC, CPoint targetPoint, CSize maxViewSize)
{
	if(maxViewSize.cx <=0)
		maxViewSize.cx = 1;

	if(maxViewSize.cy <=0)
		maxViewSize.cy = 1;

	CPoint tempStartPoint;
	CPoint tempEndPoint;

	CSize tempMaxViewSize = maxViewSize;

	//   ׸..
	tempStartPoint.x = targetPoint.x;
	tempStartPoint.y = 0;

	tempEndPoint.x = targetPoint.x;
	tempEndPoint.y = tempMaxViewSize.cy;

	pDC->MoveTo(tempStartPoint);
	pDC->LineTo(tempEndPoint);

	// μ ׸...
	tempStartPoint.x = 0;
	tempStartPoint.y = targetPoint.y;

	tempEndPoint.x = tempMaxViewSize.cx;
	tempEndPoint.y = targetPoint.y;

	pDC->MoveTo(tempStartPoint);
	pDC->LineTo(tempEndPoint);
}

void CDrawTool::DrawCenterCrossLine(CDC * pDC, CSize maxViewSize)
{
	CPoint tempTargetPoint;
	tempTargetPoint.x = maxViewSize.cx / 2;
	tempTargetPoint.y = maxViewSize.cy / 2;

	DrawCenterCrossLine(pDC, tempTargetPoint, maxViewSize);
}


void CDrawTool::DrawPixel(CDC * pDC,CPoint scrolledPoint)
{
	pDC->SetPixel(scrolledPoint, RGB(100,100,100) );
}


void CDrawTool::DrawPointCrossX
(CDC *pDC, CPoint scrolledPoint, int halfLength, int penSize, COLORREF penColor)
{
	CPoint tempStartPoint = scrolledPoint;
	CPoint tempEndPoint = scrolledPoint;

	CPen tempPen, *ptempOldPen = NULL;

	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	tempStartPoint.x = scrolledPoint.x - halfLength;
	tempStartPoint.y = scrolledPoint.y - halfLength;
	
	tempEndPoint.x = scrolledPoint.x + halfLength;
	tempEndPoint.y = scrolledPoint.y + halfLength;
	
	// \ ׸...
	pDC->MoveTo(tempStartPoint);
	pDC->LineTo(tempEndPoint);

	tempStartPoint.x = scrolledPoint.x + halfLength;
	tempStartPoint.y = scrolledPoint.y - halfLength;

	tempEndPoint.x = scrolledPoint.x - halfLength;
	tempEndPoint.y = scrolledPoint.y + halfLength;

	pDC->MoveTo(tempStartPoint);
	pDC->LineTo(tempEndPoint);

	pDC->SelectObject(ptempOldPen);
}

void CDrawTool::DrawPointCircle
(CDC *pDC, CPoint scrolledPoint, int halfLength, int penSize, COLORREF penColor, COLORREF brushColor)
{
	CRect tempRect;
	{
		tempRect.left = scrolledPoint.x;
		tempRect.top = scrolledPoint.y;
		tempRect.right = scrolledPoint.x;
		tempRect.bottom = scrolledPoint.y;
	}
	
	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	
	
	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( brushColor );
	ptempOldBrush = (CBrush *) pDC->SelectObject(&tempBrush);

	tempRect.NormalizeRect();

	tempRect.left -= halfLength;
	tempRect.top -= halfLength;
	tempRect.right += halfLength;
	tempRect.bottom += halfLength;

	pDC->Ellipse(&tempRect);	

	pDC->SelectObject(ptempOldPen);
	pDC->SelectObject(ptempOldBrush);
}


// 簢 ׸...
void CDrawTool::DrawRectangle
(CDC *pDC, CRect targetRect, int penSize, COLORREF penColor)
{
	CPen tempPen, *ptempOldPen = NULL;

	CRect tempTargetRect = targetRect;

	tempTargetRect.NormalizeRect();

	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	pDC->SelectObject( GetStockObject (NULL_BRUSH) );

	pDC->Rectangle(&tempTargetRect);	

	pDC->SelectObject(ptempOldPen);
}


// 簢  Բ ׸... 
void CDrawTool::DrawRectangle
(CDC *pDC, CRect targetRect, int penSize, COLORREF penColor, COLORREF brushColor)
{
	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	CRect tempTargetRect = targetRect;
	tempTargetRect.NormalizeRect();
	
	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( brushColor );

	ptempOldBrush = (CBrush *) pDC->SelectObject(&tempBrush);


	pDC->Rectangle(&tempTargetRect);	

	pDC->SelectObject(ptempOldPen);
	pDC->SelectObject(ptempOldBrush);
}


//  ׸...
void CDrawTool::DrawEllipse
(CDC *pDC, CRect targetRect, int penSize, COLORREF penColor)
{
	CPen tempPen, *ptempOldPen = NULL;

	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	pDC->SelectObject( GetStockObject (NULL_BRUSH) );

	targetRect.NormalizeRect();
													  
	pDC->Ellipse(&targetRect);	
	
	pDC->SelectObject(ptempOldPen);
}


//   Բ ׸... 
void CDrawTool::DrawEllipse
(CDC *pDC, CRect targetRect, int penSize, COLORREF penColor, COLORREF brushColor)
{
	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	
	
	tempPen.CreatePen(PS_SOLID, penSize, penColor);
	ptempOldPen = (CPen *) pDC->SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( brushColor );

	ptempOldBrush = (CBrush *) pDC->SelectObject(&tempBrush);

	targetRect.NormalizeRect();

	pDC->Ellipse(&targetRect);	

	pDC->SelectObject(ptempOldPen);
	pDC->SelectObject(ptempOldBrush);
}

void CDrawTool::DrawPointCross
(CDC *pDC, CPoint curPoint, CRect targetRect, int penSize, COLORREF penColor)
{
	
	CPen tempPen(PS_SOLID, penSize, penColor );
	CPen *ptempOldPen;

	CRect tempRect;

	tempRect = targetRect;

	tempRect.NormalizeRect();

	ptempOldPen = pDC->SelectObject(&tempPen);

	pDC->SetROP2(R2_XORPEN);


	CRect rect;

    //  ///////////////////////////////		
	pDC->MoveTo(               0, curPoint.y);
	pDC->LineTo(tempRect.right, curPoint.y);
    // 	///////////////////////////////
	pDC->MoveTo(curPoint.x,              0);
	pDC->LineTo(curPoint.x, tempRect.bottom);
    ///////////////////////////////////////

	pDC->SelectObject(ptempOldPen);
}