// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Sprite.h"

#include "MainFrm.h"

//  ȭ ......
//#include "SpriteDoc.h"
#include "AniView.h"
#include "DibView.h"
#include "SprView.h"
#include "ZoomView.h"
#include "InfoView.h"

#include "DlgTimeSet.h"
#include "AniPlayNumSetDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_ANIMATION_PLAY, OnAnimationPlay)
	ON_UPDATE_COMMAND_UI(ID_ANIMATION_PLAY, OnUpdateAnimationPlay)
	ON_COMMAND_RANGE			(ID_CDIBVIEW_X1 , ID_CDIBVIEW_X4 , OnDibViewMultifySetting)
	ON_UPDATE_COMMAND_UI_RANGE	(ID_CDIBVIEW_X1 , ID_CDIBVIEW_X4 , OnUpdateDibViewMultifySetting)
	ON_COMMAND_RANGE			(ID_CSPRVIEW_X1 , ID_CSPRVIEW_X4 , OnSprViewMultifySetting)
	ON_UPDATE_COMMAND_UI_RANGE	(ID_CSPRVIEW_X1 , ID_CSPRVIEW_X4 , OnUpdateSprViewMultifySetting)
	ON_COMMAND_RANGE			(ID_CZOOMVIEW_X1 , ID_CZOOMVIEW_X4 , OnZoomViewMultifySetting)
	ON_UPDATE_COMMAND_UI_RANGE	(ID_CZOOMVIEW_X1 , ID_CZOOMVIEW_X4 , OnUpdateZoomViewMultifySetting)
	ON_COMMAND_RANGE			(ID_CANIVIEW_X1 , ID_CANIVIEW_X4 , OnAniViewMultifySetting)
	ON_UPDATE_COMMAND_UI_RANGE	(ID_CANIVIEW_X1 , ID_CANIVIEW_X4 , OnUpdateAniViewMultifySetting)
	ON_COMMAND(ID_ANIMATION_TIME_SETTING, OnAnimationTimeSetting)
	ON_COMMAND(ID_ANI_PLAY_BUTTON, OnAniPlayButton)
	ON_COMMAND(ID_ANI_STOP_BUTTON, OnAniStopButton)
	ON_UPDATE_COMMAND_UI(ID_ANI_PLAY_BUTTON, OnUpdateAniPlayButton)
	ON_UPDATE_COMMAND_UI(ID_ANI_STOP_BUTTON, OnUpdateAniStopButton)
	ON_COMMAND(ID_ANI_NUMSET, OnAniNumset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	m_bIsSplitter = FALSE;
	
	m_bAniStart = FALSE;

	m_AniPlayTime = 500;
	m_AniStartNum = 0;
	m_AniEndNum = 0;


	// Ȯ밪 ........
	
	m_CDibViewMultiNumber	= 1;
	m_CSprViewMultiNumber	= 1;
	m_CZoomViewMultiNumber	= 1;
	m_CAniViewMultiNumber	= 1;
	
	//   Ȯ밪 üũ..........

	m_CDibViewMultiNumberCheck	=	ID_CDIBVIEW_X1	; 
	m_CSprViewMultiNumberCheck	=	ID_CSPRVIEW_X1	;
	m_CZoomViewMultiNumberCheck	=	ID_CZOOMVIEW_X1	;
	m_CAniViewMultiNumberCheck	=	ID_CANIVIEW_X1	;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	m_wndSplit01.CreateStatic(this, 1, 2, WS_CHILD|WS_VISIBLE, AFX_IDW_PANE_FIRST) ;
	m_wndSplit02.CreateStatic(&m_wndSplit01, 2, 1,WS_CHILD|WS_VISIBLE, m_wndSplit01.IdFromRowCol(0,1)) ;
	m_wndSplit03.CreateStatic(&m_wndSplit02, 1, 2,WS_CHILD|WS_VISIBLE, m_wndSplit02.IdFromRowCol(0,0)) ;
	m_wndSplit04.CreateStatic(&m_wndSplit03, 2, 1,WS_CHILD|WS_VISIBLE, m_wndSplit03.IdFromRowCol(0,1)) ;

	// ̼  - ¿ ....
	m_wndSplit01.CreateView(0,0, RUNTIME_CLASS(CInfoView), CSize(150, 150), pContext) ;

	// Ʈ  () - Ʒ ... Ʒ ....
	m_wndSplit02.CreateView(1,0, RUNTIME_CLASS(CSprView), CSize(30, 30), pContext) ;

	// DibView (¿ ..) -  ... 
	m_wndSplit03.CreateView(0,0, RUNTIME_CLASS(CDibView), CSize(50, 50), pContext) ;

	// ִϸ̼  (Ϸ ....  )
	m_wndSplit04.CreateView(0,0, RUNTIME_CLASS(CAniView), CSize(50, 50), pContext) ;
	
	// ܺ (Ϸ ...  )
	m_wndSplit04.CreateView(1,0, RUNTIME_CLASS(CZoomView), CSize(50, 50), pContext) ;

	/////////////////////////////
	// View Pointer
	m_pCInfoView	= (CInfoView *)m_wndSplit01.GetPane(0,0);
	m_pCSprView		= (CSprView *) m_wndSplit02.GetPane(1,0);
	m_pCDibView		= (CDibView *) m_wndSplit03.GetPane(0,0);
	m_pCAniView		= (CAniView *) m_wndSplit04.GetPane(0,0);    
	m_pCZoomView	= (CZoomView *)m_wndSplit04.GetPane(1,0);
	
	//SetActiveView(m_pCDibView);

	m_bIsSplitter = TRUE;
	//ResizeSplitter();

	return TRUE;
}

void CMainFrame::ResizeSplitter()
{
	if(!m_bIsSplitter)	{
		//MessageBox("ResizeSplitter Error");
		return;
	}

	CRect rect;
	GetClientRect(&rect);



	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... (Ŭ̾Ʈ  5/10  ⺻ ̷ )
	m_wndSplit02.SetRowInfo(0, (rect.bottom * 6) /10 , 150); 

	m_wndSplit02.SetRowInfo(1, (rect.bottom * 3) /10 , 50); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, (rect.right * 5) / 10, 150); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, (rect.bottom * 33) / 100, 150); 
	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();

}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
	GetClientRect(&m_rClient);
	ResizeSplitter();	
}

void CMainFrame::OnAnimationPlay() 
{
	// TODO: Add your command handler code here
	if(m_bAniStart) m_bAniStart = FALSE;
	else
	{
		m_bAniStart = TRUE;
		m_pCAniView->m_CurAniSprNum = m_AniStartNum;
	}

	m_pCAniView->Invalidate();
}

void CMainFrame::OnUpdateAnimationPlay(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(m_bAniStart)pCmdUI->SetText("Stop (&S)");
	else pCmdUI->SetText("Play (&P)");

	m_pCSprView->Invalidate();
	m_pCAniView->Invalidate();

}

void CMainFrame::OnAnimationTimeSetting() 
{
	// TODO: Add your command handler code here
	CDlgTimeSet dlg;
	if(dlg.DoModal() == IDOK)
	{
		m_AniPlayTime = dlg.m_AniPlayTime;
		m_pCAniView->ChangeTime();
	}
}



/////////////////////////////////////////////////////////////////////////////////////
//// ׸  Ȯ...............

void CMainFrame::OnDibViewMultifySetting(UINT nID)
{
	m_CDibViewMultiNumberCheck = nID;

	if(m_CDibViewMultiNumberCheck == ID_CDIBVIEW_X1)
		m_CDibViewMultiNumber = 1;

	if(m_CDibViewMultiNumberCheck == ID_CDIBVIEW_X2)
		m_CDibViewMultiNumber = 2;

	if(m_CDibViewMultiNumberCheck == ID_CDIBVIEW_X4)
		m_CDibViewMultiNumber = 4;

	m_pCDibView->Invalidate();
}

void CMainFrame::OnUpdateDibViewMultifySetting(CCmdUI * pCmdUI)
{
	pCmdUI -> SetCheck( m_CDibViewMultiNumberCheck == pCmdUI ->m_nID);
}

//// Ʈ  Ȯ...............

void CMainFrame::OnSprViewMultifySetting(UINT nID)
{
	m_CSprViewMultiNumberCheck = nID;

	if(m_CSprViewMultiNumberCheck == ID_CSPRVIEW_X1)
		m_CSprViewMultiNumber = 1;

	if(m_CSprViewMultiNumberCheck == ID_CSPRVIEW_X2)
		m_CSprViewMultiNumber = 2;

	if(m_CSprViewMultiNumberCheck == ID_CSPRVIEW_X4)
		m_CSprViewMultiNumber = 4;
	
	m_pCSprView->Invalidate();
}
void CMainFrame::OnUpdateSprViewMultifySetting(CCmdUI * pCmdUI)
{
	pCmdUI -> SetCheck( m_CSprViewMultiNumberCheck == pCmdUI ->m_nID);
}

////   Ȯ...............

void CMainFrame::OnZoomViewMultifySetting(UINT nID)
{
	m_CZoomViewMultiNumberCheck = nID;

	if(m_CZoomViewMultiNumberCheck == ID_CZOOMVIEW_X1)
		m_CZoomViewMultiNumber = 1;

	if(m_CZoomViewMultiNumberCheck == ID_CZOOMVIEW_X2)
		m_CZoomViewMultiNumber = 2;

	if(m_CZoomViewMultiNumberCheck == ID_CZOOMVIEW_X4)
		m_CZoomViewMultiNumber = 4;
		
	m_pCZoomView->Invalidate();
}

void CMainFrame::OnUpdateZoomViewMultifySetting(CCmdUI * pCmdUI)
{
	pCmdUI -> SetCheck( m_CZoomViewMultiNumberCheck == pCmdUI ->m_nID);
}

//// ִ  Ȯ...............

void CMainFrame::OnAniViewMultifySetting(UINT nID)
{
	m_CAniViewMultiNumberCheck = nID;

	if(m_CAniViewMultiNumberCheck == ID_CANIVIEW_X1)
		m_CAniViewMultiNumber = 1;

	if(m_CAniViewMultiNumberCheck == ID_CANIVIEW_X2)
		m_CAniViewMultiNumber = 2;

	if(m_CAniViewMultiNumberCheck == ID_CANIVIEW_X4)
		m_CAniViewMultiNumber = 4;

	m_pCAniView->Invalidate();
}


void CMainFrame::OnUpdateAniViewMultifySetting(CCmdUI * pCmdUI)
{
	pCmdUI -> SetCheck( m_CAniViewMultiNumberCheck == pCmdUI ->m_nID);
}




//    .........
void CMainFrame::ResizeAllView()
{
	// TODO: Add your control notification handler code here
	if(!m_bIsSplitter)	{
		//MessageBox("ResizeSplitter Error");
		return;
	}

	CRect rect;
	GetClientRect(&rect);
	

	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... (Ŭ̾Ʈ  5/10  ⺻ ̷ )
	m_wndSplit02.SetRowInfo(0, (rect.bottom * 6) /10 , 150); 

	m_wndSplit02.SetRowInfo(1, (rect.bottom * 3) /10 , 50); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, (rect.right * 5) / 10, 150); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, (rect.bottom * 33) / 100, 150); 
	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();

}


void CMainFrame::MaxCDibView()
{
		
	CRect rect;
	GetClientRect(&rect);

	if(!m_bIsSplitter)		
	{
		//MessageBox("ResizeSplitter Error");
		return;
	}


	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... (Ŭ̾Ʈ  5/10  ⺻ ̷ )
	m_wndSplit02.SetRowInfo(0, (rect.bottom * 99)/100 , 1); 

	m_wndSplit02.SetRowInfo(1, 1 , 1); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, (rect.right * 99)/100 ,  1); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, 1, 1); 

	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();
}


void CMainFrame::MaxCSprView()
{
	if(!m_bIsSplitter)		
	{
		//MessageBox("ResizeSplitter Error");
		return;
	}

	CRect rect;
	GetClientRect(&rect);

	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... (Ŭ̾Ʈ  5/10  ⺻ ̷ )
	m_wndSplit02.SetRowInfo(0, 1, 1); 

	m_wndSplit02.SetRowInfo(1, (rect.bottom * 99)/100  , 1); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, (rect.right * 99)/100 , 1); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, 1, 1); 

	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();
}

void CMainFrame::MaxCAniView()
{
	if(!m_bIsSplitter)		
	{
		//MessageBox("ResizeSplitter Error");
		return;
	}

	CRect rect;
	GetClientRect(&rect);

	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... 
	m_wndSplit02.SetRowInfo(0, (rect.right * 99)/100, 1); 

	m_wndSplit02.SetRowInfo(1, 1, 1); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, 1, 1); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, (rect.right * 99)/100, 1); 

	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();

}

void CMainFrame::MaxCZoomView()
{
	CRect rect;
	GetClientRect(&rect);

	if(!m_bIsSplitter)		
	{
		//MessageBox("ResizeSplitter Error");
		return;
	}


	//   ............
	// CInfoView... (80 ⺻ ̷ )
	m_wndSplit01.SetColumnInfo(0, 180, 180); 
	
	// CDibView  .... 
	m_wndSplit02.SetRowInfo(0, (rect.right * 99)/100, 1); 

	m_wndSplit02.SetRowInfo(1, 1, 1); 
	
	// CDibView  .....
	m_wndSplit03.SetColumnInfo(0, 1, 1); 

	// ִϸ̼  ....
	m_wndSplit04.SetRowInfo(0, 1, 1); 

	m_wndSplit01.RecalcLayout();
	m_wndSplit02.RecalcLayout();
	m_wndSplit03.RecalcLayout();
	m_wndSplit04.RecalcLayout();

}

void CMainFrame::CDibViewMultify(int multiNumber)
{
	m_CDibViewMultiNumber = multiNumber;
	
	m_pCDibView->Invalidate();
}

void CMainFrame::CSprViewMultify(int multiNumber)
{
	m_CSprViewMultiNumber = multiNumber;
	m_pCSprView->Invalidate();
}

void CMainFrame::CZoomViewMultify(int multiNumber)
{
	m_CZoomViewMultiNumber = multiNumber;
	m_pCZoomView->Invalidate();
}

void CMainFrame::CAniViewMultify(int multiNumber)
{
	m_CAniViewMultiNumber = multiNumber;
	m_pCAniView->Invalidate();
}

void CMainFrame::OnAniPlayButton() 
{
	// TODO: Add your command handler code here
	m_bAniStart = TRUE;

	m_pCAniView->m_CurAniSprNum = m_AniStartNum;

	m_pCAniView->Invalidate();

}

void CMainFrame::OnAniStopButton() 
{
	// TODO: Add your command handler code here
	m_bAniStart = FALSE;
	m_pCAniView->Invalidate();
}

void CMainFrame::OnUpdateAniPlayButton(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}


void CMainFrame::OnUpdateAniStopButton(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

BOOL CMainFrame::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class

	m_pCAniView->GetDocument()->ReleaseAllData();
	
	return CFrameWnd::DestroyWindow();
}

void CMainFrame::OnAniNumset() 
{
	// TODO: Add your command handler code here
	CAniPlayNumSetDlg dlg;
	if(dlg.DoModal() == IDOK)
	{
		m_AniStartNum	= dlg.m_AniStartNum;
		m_AniEndNum		= dlg.m_AniEndNum;
	}
}
