// SprView.cpp : implementation file
//

#include "stdafx.h"
#include "Sprite.h"

#include "MainFrm.h"
#include "SpriteDoc.h"
#include "SprView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// 10 * 10   ⺻ Ʋ ...... ȭ  10*10    ׵θ ׷...

#define MIN_SPR_DRAW_POINT_X  10 
#define MIN_SPR_DRAW_POINT_Y  25
#define BORDER_SIZE 5

// ⺻ .
#define MIN_SPRVIEW_HEIGHT  20 // ⺻   (top + bottom)
#define MIN_SPRVIEW_WIDTH   20 // ⺻   (left + right)

#define SPR_NUM_MSG_Y 0

/////////////////////////////////////////////////////////////////////////////
// CSprView

IMPLEMENT_DYNCREATE(CSprView, CScrollView)

CSprView::CSprView()
{
	// ũ   ...
	m_MaxScrolledPoint.x = MIN_SPRVIEW_WIDTH;
	m_MaxScrolledPoint.y = MIN_SPRVIEW_HEIGHT;
}

CSprView::~CSprView()
{
}


BEGIN_MESSAGE_MAP(CSprView, CScrollView)
	//{{AFX_MSG_MAP(CSprView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSprView drawing

void CSprView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;

	// TODO: calculate the total size of this view
	sizeTotal.cx = 1;
	sizeTotal.cy = 1;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CSprView::OnDraw(CDC* pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CSprViewMultiNumber;


	CSize tempMaxScrolledSize; // ũ  ũ ũ⸦  .
	{ // ʱȭ...
		tempMaxScrolledSize.cx = 1;
		tempMaxScrolledSize.cy = 1;
	}
	
	CPoint tempDrawSprPoint; // Ʈ ׷ Ʈ.
	{ // ʱȭ......
		tempDrawSprPoint.x = MIN_SPR_DRAW_POINT_X;
		tempDrawSprPoint.y = MIN_SPR_DRAW_POINT_Y;
	}

	CRect tempSprCurScrolledRect; //  Ʈ ׷ ִ ..
	
	CRect tempSourceBmpRect; // ũ Ʈ ȭ  ޱ  ...
	{ // ʱȭ..
		tempSourceBmpRect.top = 0;
		tempSourceBmpRect.left = 0;
		tempSourceBmpRect.right = 1;
		tempSourceBmpRect.bottom = 1;
	}

	CRect tempBorderRect; // ֺ ׵θα  ...

	int tempViewHeight = NULL; //  Ʈ ׸ ̿ ũ.
	int tempViewWidth = NULL;

	CSprData *ptempNode; // ũ Ʈ      .
	{ // ʱȭ......
		ptempNode = NULL;
	}

	CString msg; // Ʈ Ϸùȣ.

	int tempSprNumber = NULL; //  Ʈ ȣ...


	////////////////////////////////////////
	// ȭ鿡 Ʈ 並 ....
	///////////////////////////////////////////
	
	tempDrawSprPoint.y = MIN_SPR_DRAW_POINT_Y;
	tempDrawSprPoint.x = MIN_SPR_DRAW_POINT_X;


	// Ȯ..... Ҹ  ó.....
	int tempSourceBmpHeight= 0;
	int tempSourceBmpWidth = 0;

	if(!pDoc->m_SprDataList.IsEmpty())
	{
		for(POSITION pos = pDoc -> m_SprDataList.GetHeadPosition(); pos != NULL;)
		{
			// ũ Ʈ    Ϳ ...
			ptempNode = (CSprData *) pDoc->m_SprDataList.GetNext(pos);

			// 忡 ִ ׸ ҽ  ӽ Ʈ  ...
			tempSourceBmpRect = ptempNode-> m_SprRect;

			// ׸   ° ǥ...........
			tempSourceBmpHeight =	tempSourceBmpRect.Height()	* tempMultifyNumber;
			tempSourceBmpWidth	=	tempSourceBmpRect.Width()	* tempMultifyNumber;

			// ũ   ũ ִ  ó....
			{
				tempViewHeight = tempSourceBmpHeight + MIN_SPRVIEW_HEIGHT + MIN_SPR_DRAW_POINT_Y;
				if( tempViewHeight > tempMaxScrolledSize.cy ) 
					tempMaxScrolledSize.cy = tempViewHeight;
			}
			

			{	// ũ   ũ ִ  ó....
				tempViewWidth = tempSourceBmpWidth + MIN_SPRVIEW_WIDTH;
				tempMaxScrolledSize.cx += tempViewWidth;  
				tempDrawSprPoint.x = tempMaxScrolledSize.cx - tempViewWidth + MIN_SPR_DRAW_POINT_X;
			}

			{	// ׸ ׷  ڷ ...
				tempSprCurScrolledRect.left		= tempDrawSprPoint.x;
				tempSprCurScrolledRect.top		= tempDrawSprPoint.y; 
				tempSprCurScrolledRect.right	= tempSourceBmpWidth	+ tempDrawSprPoint.x;
				tempSprCurScrolledRect.bottom	= tempSourceBmpHeight	+ tempDrawSprPoint.y;
			
				tempSprCurScrolledRect.NormalizeRect();
			}


			{// Ʈ  ׵θ ׸...
				tempBorderRect = tempSprCurScrolledRect;

				tempBorderRect.left -= BORDER_SIZE;
				tempBorderRect.top -= BORDER_SIZE;
				tempBorderRect.right += BORDER_SIZE;
				tempBorderRect.bottom += BORDER_SIZE;


				//  Ʈ 信 ׸   ϱ.
				ptempNode->m_SprViewCurRect = tempSprCurScrolledRect;

				if(ptempNode->m_Selected) //  Ǿִٸ...
					pDoc->m_DrawTool.DrawRectangle( pDC,tempBorderRect,1,RGB(255,0,0),RGB(255,0,0) );
				else
					pDoc->m_DrawTool.DrawRectangle( pDC,tempBorderRect,1,RGB(0,0,255),RGB(0,0,255) );
			}

			{
				if(pDoc->m_Bmp.m_hBmp) // ׸ ׸...
					DrawNodeBmp(pDC, ptempNode,tempDrawSprPoint);

				// Ʈ ȣ ...
				msg.Format("[ %d ]",tempSprNumber);
				pDC ->TextOut(tempDrawSprPoint.x, SPR_NUM_MSG_Y, msg);
				++ tempSprNumber;
			}

		}
	}

	// ũ   .
	
	if(!tempMaxScrolledSize.cx) tempMaxScrolledSize.cx = 1;
	if(!tempMaxScrolledSize.cy) tempMaxScrolledSize.cy = 1;
		
	SetScrollSizes(MM_TEXT, tempMaxScrolledSize);	
}

/////////////////////////////////////////////////////////////////////////////
// CSprView diagnostics

#ifdef _DEBUG
void CSprView::AssertValid() const
{
	CScrollView::AssertValid();
}

CSpriteDoc* CSprView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSpriteDoc)));
	return (CSpriteDoc*)m_pDocument;
}

void CSprView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSprView message handlers

void CSprView::DrawNodeBmp(CDC *pDC, CSprData *ptempNode,CPoint SprDrawPoint)
{
	CSpriteDoc* pDoc = GetDocument();


	// ȭ  ϱ..............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CSprViewMultiNumber;

	if(pDoc->m_Bmp.m_hBmp)
		pDoc->m_Bmp.BmpMultiDraw(pDC,ptempNode->m_SprRect,SprDrawPoint, tempMultifyNumber);
}

int CSprView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	return 0;
}

int CSprView::CheckPoint(CPoint curPoint,CRect curRect)
{
	CRect tempRect = curRect;
	CPoint tempPoint = curPoint;

	tempRect.NormalizeRect();

	if(tempRect.PtInRect(tempPoint))
		return TRUE;

	else
		return FALSE;
}

void CSprView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CSpriteDoc* pDoc = GetDocument();

	// TODO: Add your message handler code here and/or call default
	CPoint tempPoint = point;
	CPoint tempScrolledPoint = point + (GetScrollPosition());

	// ִ Ʈ  ϱ...
	int tempMaxSprNumber = pDoc->GetMaxSprNodeNumber();

	if(tempMaxSprNumber)
	{
		CSprData *ptempNode; // ũ Ʈ      .
		{ // ʱȭ......
			ptempNode = NULL;
		}

		//  ѷ Ʈ ׸   üũ...
		CRect tempCurNodeSprViewRect;

		for(int i = 0; i<tempMaxSprNumber;i++)
		{	
			ptempNode = pDoc->GetSprNode(i);
			tempCurNodeSprViewRect = ptempNode->m_SprViewCurRect;

			if(CheckPoint(tempScrolledPoint, tempCurNodeSprViewRect))
			{
				ptempNode -> m_Selected = TRUE;
				pDoc->m_CurSprViewSelectedSprNumber = i; //  õ Ʈ ȣ ..

				////////// 信  õ Ʈ  ֱ..
				UpdateInfoViewSprData(ptempNode);
				/////////////////////////////////////////////////////////////
			}

			else
			{
				ptempNode -> m_Selected = FALSE;
				UpdateInfoViewSprDataDefault();
			}
		}
	}

	{ //   ............
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		pMF->m_pCZoomView->Invalidate();
		pMF->m_pCAniView->Invalidate();	

	}

	Invalidate();

	CScrollView::OnLButtonDown(nFlags, point);
}

void CSprView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CSpriteDoc* pDoc = GetDocument();

	// TODO: Add your message handler code here and/or call default
	CPoint tempPoint = point;
	CPoint tempScrolledPoint = point + (GetScrollPosition());

	// ִ Ʈ  ϱ...
	int tempMaxSprNumber = pDoc->GetMaxSprNodeNumber();

	int tempCurSelectedNodeNumber = 0;

	if(tempMaxSprNumber)
	{
		CSprData *ptempNode; // ũ Ʈ      .
		{ // ʱȭ......
			ptempNode = NULL;
		}

		//  ѷ Ʈ ׸   üũ...
		CRect tempCurNodeSprViewRect;

		for(int i = 0; i<tempMaxSprNumber;i++)
		{	
			ptempNode = pDoc->GetSprNode(i);
			
			if(!ptempNode) return;
			
			tempCurNodeSprViewRect = ptempNode->m_SprViewCurRect;

			if(CheckPoint(tempScrolledPoint, tempCurNodeSprViewRect))
			{
				ptempNode -> m_Selected = TRUE;
				tempCurSelectedNodeNumber = i;
			}
			else
				ptempNode -> m_Selected = FALSE;

		}
	
	
	}

	{	//  õ 带 ...
		CSprData *ptempNode =pDoc->GetSprNode(tempCurSelectedNodeNumber);
		if(ptempNode)
			if(ptempNode -> m_Selected)
				pDoc->DeletCurNodes(tempCurSelectedNodeNumber);
	}


	{ //   ............
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		pMF->m_pCZoomView->Invalidate();
		pMF->m_pCAniView->Invalidate();	
	}

	Invalidate();

	CScrollView::OnRButtonDown(nFlags, point);
}


	
void CSprView::UpdateInfoViewSprData(CSprData *pNode)
{
	//((CMainFrame *)AfxGetMainWnd())->m_pCInfoView->m_CurPoint = m_CurScrollSize;
	CSpriteDoc* pDoc = GetDocument();

	CSprData *ptempNode = pNode;
	
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	

	// ʿ ......

	CString tempStr; 
	
	CPoint tempSprBasePoint	= ptempNode->m_BasePoint;

	int tempSprNumber		= pDoc->m_CurSprViewSelectedSprNumber;
	
	CSize tempSprSize;

	{
		tempSprSize.cx =  (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left);
		tempSprSize.cy = (ptempNode->m_SprRect.top - ptempNode->m_SprRect.bottom);
	}

	if(pDoc->m_Bmp.m_hBmp)
	{
	// Ʈ  Ÿ..........

		tempStr.Format("ȣ : %d", tempSprNumber);
		pMF->m_pCInfoView->m_szCurSelectedSprNumber = tempStr;

		tempStr.Format("ũ : %d X %d ( Pixels )", tempSprSize.cx, tempSprSize.cy);
		pMF->m_pCInfoView->m_szCurSelectedSprSize = tempStr;

		tempStr.Format(" : %d, %d", tempSprBasePoint.x, tempSprBasePoint.y);
		pMF->m_pCInfoView->m_szCurSelectedSprBasePoint = tempStr;

		pMF->m_pCInfoView->UpdateData(FALSE);	
	}
}


void CSprView::UpdateInfoViewSprDataDefault()
{
	//((CMainFrame *)AfxGetMainWnd())->m_pCInfoView->m_CurPoint = m_CurScrollSize;
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	CString tempStr = _T(""); 

	pMF->m_pCInfoView->m_szCurSelectedSprNumber = tempStr;

	pMF->m_pCInfoView->m_szCurSelectedSprSize = tempStr;

	pMF->m_pCInfoView->m_szCurSelectedSprBasePoint = tempStr;

	pMF->m_pCInfoView->UpdateData(FALSE);	
}
