// SpriteDoc.cpp : implementation of the CSpriteDoc class
//

#include "stdafx.h"
#include "Sprite.h"
#include "SpriteDoc.h"
#include "SprData.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSpriteDoc

IMPLEMENT_DYNCREATE(CSpriteDoc, CDocument)

BEGIN_MESSAGE_MAP(CSpriteDoc, CDocument)
	//{{AFX_MSG_MAP(CSpriteDoc)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_CLR_CRUSH_RT, OnClrCrushRt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpriteDoc construction/destruction

CSpriteDoc::CSpriteDoc()
{
	// TODO: add one-time construction code here
	m_MaxSprNodeNumber = NULL;
	m_CurAniViewSprNumber = NULL;

	m_CurSprViewSelectedSprNumber = NULL;

	m_BasePoint.x = NULL; // ....
	m_BasePoint.y = NULL;
	m_szCurFileName = _T("");


}

CSpriteDoc::~CSpriteDoc()
{
}

BOOL CSpriteDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CSpriteDoc serialization

void CSpriteDoc::Serialize(CArchive& ar)
{
	if ( ar.IsStoring() )  
	{// ϱ...........
		// TODO: add storing code here

	
	}

	else 
	{// εϱ.............
		// TODO: add loading code here

	
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSpriteDoc diagnostics

#ifdef _DEBUG
void CSpriteDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSpriteDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSpriteDoc commands


int CSpriteDoc:: GetMaxSprNodeNumber()
{
	
	m_MaxSprNodeNumber = m_SprDataList.GetCount();
	
	return (m_MaxSprNodeNumber);
}

void CSpriteDoc::DrawNodeBmp(CDC *pDC, CSprData *ptempNode,CPoint SprDrawPoint)
{
	if(m_Bmp.m_hBmp)
		m_Bmp.BmpDraw(pDC,ptempNode->m_SprRect,SprDrawPoint);
}

void CSpriteDoc::DrawNodeBmp(CDC *pDC, CSprData *ptempNode,CPoint SprDrawPoint, int multifyNumber)
{
	if(m_Bmp.m_hBmp)
		m_Bmp.BmpMultiDraw(pDC,ptempNode->m_SprRect,SprDrawPoint, multifyNumber);
}

CSprData *CSpriteDoc:: GetSprNode(int sprNumber)
{

	if(! m_SprDataList.GetCount() )
		return FALSE;
	
	CSprData *ptempNode = NULL; // ũ Ʈ      .

	if ( sprNumber < 0 )
		return FALSE;
 
	POSITION tempPosition = m_SprDataList.GetHeadPosition();

	if(! GetMaxSprNodeNumber())
		return FALSE;

	if( GetMaxSprNodeNumber() <= sprNumber)
		return FALSE;


	for(int i = 0; i <= sprNumber; i++)
	{
		// ũ Ʈ    Ϳ ...
		ptempNode = (CSprData *) m_SprDataList.GetNext(tempPosition);

		if(!ptempNode)
			return FALSE;
	}
	
	return ptempNode;
}

//	浹üũ  ϱ.......
BOOL CSpriteDoc:: GetCurCrashRtNum(int curSprNumber)
{
	CSprData *ptempNode = GetSprNode(curSprNumber);
	
	if(ptempNode != NULL)
	{
		return (ptempNode -> m_MaxCrushRtNum);
	}

	else 
		return NULL;
}

BOOL CSpriteDoc:: SetCurCrashRtNum(int curSprNumber, int setCrushRtNum)
{
	CSprData *ptempNode = GetSprNode(curSprNumber);
	
	if(ptempNode != NULL)
	{
		if (setCrushRtNum >= MAX_CRUSH_RT_NUM)
			setCrushRtNum = MAX_CRUSH_RT_NUM - 1;
		
		ptempNode->m_MaxCrushRtNum = setCrushRtNum;
		
		return TRUE;
	}

	else 
		return NULL;
}


POSITION CSpriteDoc:: GetSprPosition(int sprNumber)
{
	CSprData *ptempNode; // ũ Ʈ      .
	{
		ptempNode = NULL; 
	}

	if ( sprNumber < 0 )
		return FALSE;
 
	POSITION tempPosition = m_SprDataList.GetHeadPosition();

	if(!tempPosition)
		return FALSE;
	
	POSITION tempCurPosition = tempPosition;

	if (sprNumber <=0 )
		return tempCurPosition;

	if(! GetMaxSprNodeNumber())
		return FALSE;

	if( m_MaxSprNodeNumber <= sprNumber)
		return FALSE;

	for(int i = 0; i <= (sprNumber - 1); i++)
	{
		// ũ Ʈ    Ϳ ...
		ptempNode = (CSprData *) m_SprDataList.GetNext(tempPosition);
		tempCurPosition = tempPosition;

		if(!tempCurPosition)
			return FALSE;

		if(!ptempNode)
			return FALSE;
	}


	if(! tempCurPosition)
		return FALSE;
	
	return tempCurPosition;
}



BOOL CSpriteDoc::DeletCurNodes(int selectedNodeNumber)
{
	int tempSelectedNodeNumber = selectedNodeNumber;
	if( selectedNodeNumber < 0 )
		return FALSE;

	CObject *ptempSprDataList;

	POSITION tempSelectedPosition = GetSprPosition(tempSelectedNodeNumber);

	if(! tempSelectedPosition)
		return FALSE;

	ptempSprDataList = m_SprDataList.GetAt( tempSelectedPosition );
	m_SprDataList.RemoveAt( tempSelectedPosition );

	delete ptempSprDataList;

	return TRUE;
}


//  ũ Ʈ Ÿ ...
BOOL CSpriteDoc::DeleteAllData()
{
	if(m_SprDataList.GetCount())
		m_SprDataList.RemoveAll();
	{
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		pMF->m_pCSprView->Invalidate();
	}

	return TRUE;
}

void CSpriteDoc::OnFileSave() 
{
	//CMainFrame*	pMF=(CMainFrame*)AfxGetMainWnd();
	CFileDialog tempFileDlg(FALSE, "spr", "*.SPR", OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
				    "Ʈ  (*.spr)|*.spr|   (*.*)|*.*|");

	if( tempFileDlg.DoModal() == IDOK ) 
	{//OK
		CString tempFileName = tempFileDlg.GetPathName(); 

		if(! SaveSprFile(tempFileName))
			AfxMessageBox(" ̺ ....");		

		m_szCurFileName = tempFileDlg.GetFileName();
		UpdateInfoViewFileData();
	}
}

BOOL CSpriteDoc::SaveSprFile(CString fileName)
{
	if(!m_Bmp.m_hBmp)
	{
		AfxMessageBox(" ׸ ..  ε϶ī..");
		return FALSE;
	}

	//  ...
	CFile tempSprFile(fileName, CFile::modeCreate | CFile::modeWrite); 
	{	
		///////////////////////////////////////////////////////////////////
		// Ʈ  ...........
		// Ʈ  
		// ׸ + Ʈ  + ̹  +  + ִ Ʈ 浹  + 浹  ̷...
		///////////////////////////////////////////////////////////////////
		
		//    ֱ.................
		BITMAPFILEHEADER tempBmpFileHeader;

		tempBmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + m_Bmp.GetPalSize();
		tempBmpFileHeader.bfReserved1 = NULL;
		tempBmpFileHeader.bfReserved2 = NULL;
		tempBmpFileHeader.bfSize = m_Bmp.GetBmpSize(); //  ũ⸦ ־.
		tempBmpFileHeader.bfType = 0x4d42; // Ʈ ũ ǥ....
		
		//   ...
		tempSprFile.Write(&tempBmpFileHeader, sizeof(BITMAPFILEHEADER)); //  .....

		// ҽ ׸ ...
		tempSprFile.Write(m_Bmp.m_hBmp, (m_Bmp.GetBmpSize() - sizeof(BITMAPFILEHEADER)) );
	}

	{	//  ũ帮Ʈ ϱ...................
		int tempMaxListNumber = m_SprDataList.GetCount();

		if(! tempMaxListNumber)
		{	//  Ʈ   ݰ .... BMP file  Ȱ ..
			AfxMessageBox("  Ǿ....^_/~~~\nBy JiSung Jung !!");
			tempSprFile.Close();
			return TRUE;
		}

		// Ʈ  ....
		tempSprFile.Write(&tempMaxListNumber, sizeof(int) );

		CSprData *ptempNode = NULL;

		POINT tempBasePt;
		RECT  tempImageRt;
		int	  tempCrushRtNum;
		RECT  tempCrushRt;
		CRect tempCheckCrushRt;

		POSITION tempPos = m_SprDataList.GetHeadPosition();
		if(!tempPos)
			return FALSE;

		for(int i = 0; i < tempMaxListNumber; i++)
		{
			// ũ Ʈ    Ϳ ...
			ptempNode = (CSprData *) m_SprDataList.GetNext(tempPos);

			tempBasePt  = ptempNode->m_BasePoint;			//  ..
			tempImageRt = ptempNode->m_SprRect;				//  ..
			tempCrushRtNum = ptempNode->m_MaxCrushRtNum;	// ִ 浹 

			if(!ptempNode)
				return FALSE;

			//////////////////////////////////////////////////////
			// ũ Ʈ Ͽ ...
			tempSprFile.Write(&tempBasePt,	sizeof(POINT) );	//  ..
			tempSprFile.Write(&tempImageRt,	sizeof(RECT) );		// ̹  
			tempSprFile.Write(&tempCrushRtNum,	sizeof(int) );	// ִ 浹 
			
			for(int j = 0; j < tempCrushRtNum ; j++)
			{
				tempCheckCrushRt = ptempNode->m_CrushRt[j];
				tempCheckCrushRt.NormalizeRect();
				tempCrushRt = tempCheckCrushRt;
				tempSprFile.Write(&tempCrushRt,	sizeof(RECT) );
			}
		}
	}

	tempSprFile.Close();

	AfxMessageBox("  Ǿ....^_/~~~\nBy JiSung Jung !!");

	return TRUE;
}

void CSpriteDoc::OnFileOpen() 
{
	// TODO: Add your command handler code here
	static CFileDialog tempFileDlg( TRUE, "BMP", "*.BMP",
									OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
									"Ʈ (*.bmp)|*.BMP|Ʈ (*.spr)|*.SPR| (*.*)|*.*|" );

	if( tempFileDlg.DoModal() == IDOK ) 
	{
		CString tempFileName = tempFileDlg.GetPathName(); 
		
		//  ̸..
		m_szCurFileName = tempFileDlg.GetFileName();

		CString tempFileType;
		tempFileType = tempFileName;

		tempFileType.MakeUpper();

		// Ʈ  εϱ....
		if(tempFileType.Find(".BMP") > -1 )
			LoadBmpFile(tempFileName);

		if(tempFileType.Find(".SPR") > -1)
			LoadSprFile(tempFileName);

		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		pMF->m_pCDibView->MakeDefault();

		UpdateAllViews(NULL);
	}

	if(m_Bmp.m_hBmp)
		UpdateInfoViewFileData();
}

BOOL CSpriteDoc::LoadBmpFile(CString fileName)
{
	DeleteAllData();
	if(m_Bmp.BmpLoad(fileName))
		return TRUE;
	return FALSE;
}

BOOL CSpriteDoc::LoadSprFile(CString fileName)
{
	DeleteAllData();	//   ........

	//  ׸ ε...( ġ  ϰ ذ...)
	if(m_Bmp.BmpLoad(fileName))
	{		//  ׸ ũ ...
		long tempSourceBmpSize = (long) m_Bmp.GetBmpSize();

		// ũ Ʈ ...
		int tempMaxListNumber = NULL;
		
		//   ٽ ....
		CFile tempSprFile(fileName, CFile::modeRead | CFile::shareDenyRead);

		//  ͸  Ʈ  ũ⸸ŭ ̵...
		tempSprFile.Seek(tempSourceBmpSize, CFile::begin);

		// ũ Ʈ  ...
		tempSprFile.Read(&tempMaxListNumber, sizeof(int) );

		{	//  Ÿ   + ̹  + ִ 浹   + 浹 ..
			CSprData	*ptempNode = NULL;
			
			RECT		tempImageRt;
			POINT		tempBasePt;
			int			tempCrushRtNum;
			RECT		tempCrushRt;

			for(int i = 0; i < tempMaxListNumber; i++)
			{
				tempSprFile.Read( &tempBasePt,		sizeof(POINT) );
				tempSprFile.Read( &tempImageRt,		sizeof(RECT)  );
				tempSprFile.Read( &tempCrushRtNum,	sizeof(int)  );
				
				ptempNode = new CSprData;

				ptempNode -> m_BasePoint =	tempBasePt;
				ptempNode -> m_SprRect	 =	tempImageRt;
				ptempNode -> m_MaxCrushRtNum = tempCrushRtNum;

				
				for(int j = 0; j < tempCrushRtNum; j++)
				{
					tempSprFile.Read(& tempCrushRt,		sizeof(RECT)  );
					ptempNode->m_CrushRt[j] = tempCrushRt;
				}
				
				m_SprDataList.AddTail(ptempNode);

				//////////////////////////////////////////////////////
				// ũ Ʈ Ͽ ...
			}
		}

		//  غ............ ...
		DWORD dwCurPosition = tempSprFile.GetPosition();
		if(dwCurPosition == tempSprFile.SeekToEnd() )
		{
			tempSprFile.Close();
			return TRUE;		
		}
	
	}
	return FALSE;
}

void CSpriteDoc::UpdateInfoViewFileData()
{
	//((CMainFrame *)AfxGetMainWnd())->m_pCInfoView->m_CurPoint = m_CurScrollSize;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	
	CString tempStr; 


	int tempBmpWidth	= m_Bmp.GetWidth()	;
	int tempBmpHeight	= m_Bmp.GetHeight()	;
	int tempBmpBitCount = m_Bmp.GetBitCount();
	CString tempFileName = m_szCurFileName;

	if(m_Bmp.m_hBmp)
	{
	// Ʈ  Ÿ..........

		tempStr.Format("%s", tempFileName);
		pMF->m_pCInfoView->m_szCurFileName = tempStr;

		tempStr.Format("%d X %d ( Pixels )", tempBmpWidth, tempBmpHeight);
		pMF->m_pCInfoView->m_szBmpSize = tempStr;

		tempStr.Format("%d ( bit Color )", tempBmpBitCount);
		pMF->m_pCInfoView->m_szBmpBitMode = tempStr;

		pMF->m_pCInfoView->UpdateData(FALSE);	
	}
}


// ʱȭ...............  Ÿ..........
void CSpriteDoc::UpdateInfoViewFileDataDefault()
{
	//((CMainFrame *)AfxGetMainWnd())->m_pCInfoView->m_CurPoint = m_CurScrollSize;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	
	CString tempStr; 


	tempStr.Format("");

	pMF->m_pCInfoView->m_szCurFileName	= tempStr;

	pMF->m_pCInfoView->m_szBmpSize		= tempStr;

	pMF->m_pCInfoView->m_szBmpBitMode	= tempStr;

	pMF->m_pCInfoView->UpdateData(FALSE);	
}


void CSpriteDoc::ReleaseAllData()
{
	//	  ..
	DeleteAllData();
	if(m_Bmp.m_hBmp)
	{
		delete m_Bmp.m_hBmp;
		m_Bmp.m_hBmp = NULL;
	}
}

void CSpriteDoc::OnClrCrushRt() 
{
	// TODO: Add your command handler code here
	ClearCrushRt();
	
}


BOOL CSpriteDoc::ClearCrushRt()
{
	CSprData *ptempNode = GetSprNode(m_CurSprViewSelectedSprNumber);
	
	if(ptempNode == NULL)
		return TRUE;

	if( (ptempNode -> m_Selected) == NULL )
		return TRUE;

	int tempMaxCrushRtNum = ptempNode->m_MaxCrushRtNum;
	
	CRect tempRect(0,0,0,0);

	for(int i = 0; i < tempMaxCrushRtNum; i++)
	{
		ptempNode->m_CrushRt[i] = tempRect;
	}

	ptempNode->m_MaxCrushRtNum = 0;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	pMF->m_pCAniView  ->Invalidate(TRUE);
	pMF->m_pCZoomView ->Invalidate(TRUE);

	return TRUE;
}
