// SpriteDoc.h : interface of the CSpriteDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPRITEDOC_H__A46CDBCA_BA4E_11D4_A1DD_00C026BA5B4D__INCLUDED_)
#define AFX_SPRITEDOC_H__A46CDBCA_BA4E_11D4_A1DD_00C026BA5B4D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Bmp.h"
#include "SprData.h"
#include "DrawTool.h"


class CSpriteDoc : public CDocument
{
protected: // create from serialization only
	CSpriteDoc();
	DECLARE_DYNCREATE(CSpriteDoc)

// Attributes
public:

// Operations
public:
	int GetMaxSprNodeNumber(); // Ʈ  ... (ó   1 . -> (sprNumber + 1  ...)

	CSprData *GetSprNode(int sprNumber);		// ش Ʈ ȣ  ˾Ƴ. 0  ...
	POSITION  GetSprPosition(int sprNumber);	// ش Ʈ ȣ  ˾Ƴ..


	void DrawNodeBmp(CDC *pDC, CSprData *ptempNode,CPoint SprDrawPoint);
	void DrawNodeBmp(CDC *pDC, CSprData *ptempNode,CPoint SprDrawPoint, int multifyNumber);

	void UpdateInfoViewFileData();
	void UpdateInfoViewFileDataDefault();		// ʱȭ...........

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSpriteDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
//	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSpriteDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


public:
	CBmp m_Bmp; //  Ʈ .......

	CDrawTool m_DrawTool; //     ũ...

	CObList m_SprDataList; // Ʈ    ũ Ʈ.......
	
	POSITION m_CurNodePos; //   .

	int m_MaxSprNodeNumber; // Ʈ ִ ...  0

	CRect m_DibViewSelectedRect;	// õ ... ...

	CPoint m_BasePoint;				// ..... 

	CString m_szCurFileName;

	int m_CurAniViewSprNumber;  // ִ 信  ׷ ׸ ȣ..
	
	int m_CurSprViewSelectedSprNumber;//  õ Ʈ ȣ.. Ʈ   信 ϱ  ... 

	BOOL DeletCurNodes(int selectedNodeNumber);

	BOOL GetDataExist();

	BOOL DeleteAllData();
	
	BOOL LoadBmpFile(CString fileName);

	BOOL SaveSprFile(CString fileName);
	
	BOOL LoadSprFile(CString fileName);

	BOOL GetCurCrashRtNum(int curSprNumber);
	
	BOOL SetCurCrashRtNum(int curSprNumber, int setCrushRtNum);
	
	BOOL ClearCrushRt();

	void ReleaseAllData();
	

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CSpriteDoc)
	afx_msg void OnFileSave();
	afx_msg void OnFileOpen();
	afx_msg void OnClrCrushRt();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPRITEDOC_H__A46CDBCA_BA4E_11D4_A1DD_00C026BA5B4D__INCLUDED_)
