// ZoomView.cpp : implementation file
//

#include "stdafx.h"
#include "Sprite.h"

#include "MainFrm.h"

#include "SpriteDoc.h"


#include "ZoomView.h"
#include "DrawTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ZOOM_VIEW_MIN_SPACE_X 30
#define ZOOM_VIEW_MIN_SPACE_Y 50
#define ZOOM_VIEW_BORDER_SIZE 2


/////////////////////////////////////////////////////////////////////////////
// CZoomView

IMPLEMENT_DYNCREATE(CZoomView, CScrollView)

CZoomView::CZoomView()
{
	m_VirtualBasePoint.x = NULL;	//     ǥ...
	m_VirtualBasePoint.y = NULL;
	
	m_MinScrolledViewSize.cx = 1;	//   ּ ũ..
	m_MinScrolledViewSize.cy = 1;
}

CZoomView::~CZoomView()
{
}


BEGIN_MESSAGE_MAP(CZoomView, CScrollView)
	//{{AFX_MSG_MAP(CZoomView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZoomView drawing

void CZoomView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}


/////////////////////////////////////////////////////////////////////////////
// CZoomView diagnostics

#ifdef _DEBUG
void CZoomView::AssertValid() const
{
	CScrollView::AssertValid();
}

CSpriteDoc* CZoomView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSpriteDoc)));
	return (CSpriteDoc*)m_pDocument;
}

void CZoomView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CZoomView message handlers


void CZoomView::OnDraw(CDC* pDC)
{
	CSpriteDoc* pDoc = GetDocument();

	//  .........
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;

	CSize tempMaxSize;
	{
		tempMaxSize.cx = 1;
		tempMaxSize.cy = 1;
	}

	CRect tempMaxRect;	GetClientRect(&tempMaxRect);

	// TODO: add draw code here
	CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);

	if( (ptempNode) && (ptempNode -> m_Selected) )
	{   //    ׸  κ...

		//  ũ  ּ   ϱ..
		m_MinScrolledViewSize = GetMinScrolledViewSize(pDC, ptempNode);

		if(m_MinScrolledViewSize.cx <= 0) m_MinScrolledViewSize.cx = 1;
		if(m_MinScrolledViewSize.cy <= 0) m_MinScrolledViewSize.cy = 1;

		CSize tempMinScrolledViewSize = m_MinScrolledViewSize;
		
		// ũѺ  ּҰ ° ..
		SetScrollSizes(MM_TEXT, tempMinScrolledViewSize);
		
		//  ȭ   ǥ ϱ...
		m_VirtualBasePoint = GetVirtualBasePoint(pDC, ptempNode,tempMinScrolledViewSize);
		
		CPoint tempVirtualBasePoint = m_VirtualBasePoint;
		
		//    ..
		PutZoomViewInfo(pDC, ptempNode); 
		
		// Ʈ ܰ ׸...
		DrawZoomViewSprOutLine(pDC, ptempNode, tempVirtualBasePoint);
		
		// Ʈ ׸..
		DrawZoomViewSprite(pDC, ptempNode, tempVirtualBasePoint); //  ׸ ׸..
		
		//  ׸..
		DrawZoomViewBasePoint(pDC, ptempNode, tempVirtualBasePoint);

		// 浹  ׸..
		DrawCrushRt(pDC, tempVirtualBasePoint);


		// Ʈ   .........
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

		pMF->m_pCSprView->UpdateInfoViewSprData(ptempNode);
	}
}

// Ʈ ׸ ׷ֱ..
BOOL CZoomView::DrawZoomViewSprite(CDC *pDC, CSprData *pNode, CPoint virtualBasePoint)
{
	CSpriteDoc* pDoc = GetDocument();
	if(!pNode)	return FALSE;

	//   Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	
	pDoc -> DrawNodeBmp(pDC,pNode, virtualBasePoint, tempMultifyNumber);
	return TRUE;
}


BOOL CZoomView::DrawCrushRt(CDC *pDC, CPoint virtualBasePoint)
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();

	//  .........
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;


	// TODO: add draw code here
	CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
	
	if(ptempNode == NULL)
		return FALSE;

	int tempMaxCrushRtNum = ptempNode->m_MaxCrushRtNum;
	
	CRect tempRealRt;
	CRect tempVirRt;

	for(int i = 0; i < tempMaxCrushRtNum; i++)
	{
		tempRealRt = ptempNode->m_CrushRt[i];
		tempVirRt = tempRealRt;

		tempVirRt.left   = ( tempVirRt.left * tempMultifyNumber)  + virtualBasePoint.x;
		tempVirRt.top    = ( tempVirRt.top  * tempMultifyNumber)  + virtualBasePoint.y;

		tempVirRt.right  = tempVirRt.left + ( tempRealRt.Width()  * tempMultifyNumber );
		tempVirRt.bottom = tempVirRt.top  + ( tempRealRt.Height() * tempMultifyNumber );
		
		pDoc->m_DrawTool.DrawRectangle(pDC, tempVirRt, 2, RGB(0,0,255));
	}

	return TRUE;
}

	


//     ǥ ϱ..
CPoint CZoomView::GetVirtualBasePoint(CDC *pDC, CSprData *pNode,CSize minViewSize)
{
	CSpriteDoc* pDoc = GetDocument();

	if(!pNode) return FALSE;

	//   Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	int tempSourceBmpHeight = (pNode->m_SprRect.bottom - pNode->m_SprRect.top) * tempMultifyNumber;
	int tempSourceBmpWidth  =  (pNode->m_SprRect.right - pNode->m_SprRect.left)   * tempMultifyNumber;
	/////////////////////////////////////////////////////
	
	CPoint tempVirtualBasePoint;
	{
		tempVirtualBasePoint.x = NULL;
		tempVirtualBasePoint.y = NULL;
	}

	CSize tempMinViewSize = minViewSize;

	tempVirtualBasePoint.x = (tempMinViewSize.cx / 2) ;
	tempVirtualBasePoint.y = (tempMinViewSize.cy / 2) ;

	tempVirtualBasePoint.x -= (tempSourceBmpWidth	/ 2);
	tempVirtualBasePoint.y -= (tempSourceBmpHeight  / 2);

	if(tempVirtualBasePoint.x <= 0)
		return FALSE;
	if(tempVirtualBasePoint.y <=0)
		return FALSE;

	return tempVirtualBasePoint;
}

BOOL CZoomView::DrawZoomViewSprOutLine(CDC *pDC, CSprData *pNode, CPoint virtualBasePoint)
{
	//   Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	/////////////////////////////////////////////////////

	CSpriteDoc* pDoc = GetDocument();
	if(!pNode) return FALSE;
	CSprData * ptempNode = pNode;


	int tempSourceBmpHeight = (pNode->m_SprRect.bottom - pNode->m_SprRect.top) * tempMultifyNumber;
	int tempSourceBmpWidth  =  (pNode->m_SprRect.right - pNode->m_SprRect.left)   * tempMultifyNumber;


	CRect targetDrawOutlineRect;
	CPoint tempDrawPoint = virtualBasePoint;

	if(tempDrawPoint.x < 0) return FALSE;
	if(tempDrawPoint.y < 0) return FALSE;

	int tempBorderSize = ZOOM_VIEW_BORDER_SIZE / 2;

	targetDrawOutlineRect.left   = tempDrawPoint.x - tempBorderSize;
	targetDrawOutlineRect.top    = tempDrawPoint.y - tempBorderSize;
	targetDrawOutlineRect.right  = tempDrawPoint.x + ( tempSourceBmpWidth  ) + tempBorderSize;
	targetDrawOutlineRect.bottom = tempDrawPoint.y + ( tempSourceBmpHeight ) + tempBorderSize;
				  
	pDoc -> m_DrawTool.DrawRectangle( pDC,targetDrawOutlineRect, tempBorderSize ,RGB(0,0,0) );

	return TRUE;
}

CSize CZoomView::GetMinScrolledViewSize(CDC * pDC, CSprData * pNode)
{
	CSpriteDoc	*pDoc		= GetDocument();
	CSprData	*ptempNode	= pNode;

	if(!pNode) return FALSE;

	//   Ȯ밪 ϱ.............
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;

	int tempSourceBmpHeight = ( (ptempNode->m_SprRect.bottom - ptempNode->m_SprRect.top) * tempMultifyNumber );
	int tempSourceBmpWidth  = (  (pNode->m_SprRect.right - pNode->m_SprRect.left)   * tempMultifyNumber );


	//   ũ Ʈ ϱ....
	CRect tempMaxRect; GetClientRect(&tempMaxRect);

	CSize tempMinSize;

	// ܺ ּ  ϱ...
	tempMinSize.cx =  ZOOM_VIEW_MIN_SPACE_X + tempSourceBmpWidth	+ ZOOM_VIEW_MIN_SPACE_X + ZOOM_VIEW_BORDER_SIZE + ZOOM_VIEW_BORDER_SIZE;
	tempMinSize.cy =  ZOOM_VIEW_MIN_SPACE_Y + tempSourceBmpHeight	+ ZOOM_VIEW_MIN_SPACE_Y + ZOOM_VIEW_BORDER_SIZE + ZOOM_VIEW_BORDER_SIZE;

	if( tempMaxRect.Width()		>= tempMinSize.cx )
		tempMinSize.cx = tempMaxRect.Width();

	if( tempMaxRect.Height()	>= tempMinSize.cy )
		tempMinSize.cy = tempMaxRect.Height();

	if(tempMinSize.cx <= 0)
		tempMinSize.cx = 1;

	if(tempMinSize.cy <= 0)
		tempMinSize.cy = 1;

	return tempMinSize;
}
	
BOOL CZoomView::PutZoomViewInfo(CDC *pDC, CSprData *pNode)
{
	CSpriteDoc* pDoc = GetDocument();
	if(!pNode) return FALSE;
	CSprData * ptempNode = pNode;

	int tempSprNumber = pDoc->m_CurSprViewSelectedSprNumber; // Ʈ ȣ..
	int tempSprWidth =  (ptempNode->m_SprRect.right - ptempNode->m_SprRect.left) ;	  // Ʈ ..
	int tempSprHeight = (ptempNode->m_SprRect.bottom - ptempNode->m_SprRect.top);	  // Ʈ ..
	CPoint tempSprBasePoint = ptempNode->m_BasePoint; // .......

	CString tempString;

	tempString.Format("[ %d ]", tempSprNumber); //  ȣ ..
	pDC ->TextOut( 1, 1, tempString);

	tempString.Format("%d X %d", tempSprWidth, tempSprHeight); // ׸ ũ ..
	pDC ->TextOut( 1, 15, tempString);

	tempString.Format("( %d, %d )", tempSprBasePoint.x, tempSprBasePoint.y); //  ..
	pDC ->TextOut( 1, 30, tempString);

	return TRUE;
}

void CZoomView::OnLButtonDown(UINT nFlags, CPoint point) 
{

	//  ........../////////////////////////////
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	///////////////////////////////////////////////////


	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();
	CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
	if(!ptempNode) return;

	// ũ  ǥ...
	CPoint tempScrolledPoint = point + (GetScrollPosition());

	CPoint tempVirtualBasePoint = m_VirtualBasePoint;
	
	// Է  ŭ  忡  Է..
	if(ptempNode->m_Selected)
	{
		ptempNode->m_BasePoint.x = (tempScrolledPoint.x - tempVirtualBasePoint.x) / tempMultifyNumber ;
		ptempNode->m_BasePoint.y = (tempScrolledPoint.y - tempVirtualBasePoint.y) / tempMultifyNumber ;
	}

	{
		Invalidate();	
		pMF->m_pCAniView->Invalidate();
	}
	CScrollView::OnLButtonDown(nFlags, point);
}

BOOL CZoomView::DrawZoomViewBasePoint(CDC *pDC, CSprData *pNode, CPoint virtualBasePoint)
{
	CSpriteDoc* pDoc = GetDocument();

	if(!pNode) return FALSE;

	//  ........../////////////////////////////
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	///////////////////////////////////////////////////

	CSprData * ptempNode = pNode;
	CPoint tempBasePoint = ptempNode->m_BasePoint; //   ǥ..
	CPoint tempRealDrawPoint;

	//  ׸ .........
	tempRealDrawPoint.x = (tempBasePoint.x * tempMultifyNumber) + virtualBasePoint.x ;
	tempRealDrawPoint.y = (tempBasePoint.y * tempMultifyNumber) + virtualBasePoint.y ;

	pDoc->m_DrawTool.DrawPointCircle(pDC, tempRealDrawPoint, 5, 1, RGB(255,0,0), RGB(255,0,0) );
	pDoc->m_DrawTool.DrawPointCrossX(pDC, tempRealDrawPoint, 3, 1, RGB(0,0,255) );

	return FALSE;
}

void CZoomView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CSpriteDoc* pDoc = GetDocument();
	// TODO: Add your message handler code here and/or call default
	//  ........../////////////////////////////
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;
	///////////////////////////////////////////////////

	// ũ  ǥ...
	CPoint tempScrolledPoint = point + (GetScrollPosition());

	CPoint tempVirtualBasePoint = m_VirtualBasePoint;
	
	// Է  ŭ  忡  Է..

	CPoint tempCurVirtualPoint; 

	tempCurVirtualPoint.x = (tempScrolledPoint.x - tempVirtualBasePoint.x) / tempMultifyNumber ;
	tempCurVirtualPoint.y = (tempScrolledPoint.y - tempVirtualBasePoint.y) / tempMultifyNumber ;
	
	pMF->m_pCDibView->UpdateInfoViewDataPoint(tempCurVirtualPoint);


	if(nFlags & MK_RBUTTON)
	{
		// TODO: add draw code here
		CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
		
		if( (ptempNode) && (ptempNode -> m_Selected) )
		{
			int tempMaxCrushRtNum = ptempNode->m_MaxCrushRtNum;

			if(tempMaxCrushRtNum <= 0)
				return;

			int tempCurCrushRtNum = tempMaxCrushRtNum - 1;
		
			CPoint tempScrolledPoint = point + (GetScrollPosition());
			CPoint tempVirtualBasePoint = m_VirtualBasePoint;
			
																
			(ptempNode->m_CrushRt[tempCurCrushRtNum].right  ) = ( (tempScrolledPoint.x - tempVirtualBasePoint.x) / tempMultifyNumber ) ;
			(ptempNode->m_CrushRt[tempCurCrushRtNum].bottom ) = ( (tempScrolledPoint.y - tempVirtualBasePoint.y) / tempMultifyNumber ) ;

			pMF->m_pCAniView->Invalidate(TRUE);
			Invalidate(TRUE);
		}

	}

	CScrollView::OnMouseMove(nFlags, point);
}


//	浹 üũ   ư  ....

void CZoomView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CSpriteDoc* pDoc = GetDocument();

	//  .........
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	int tempMultifyNumber = pMF->m_CZoomViewMultiNumber;


	// TODO: add draw code here
	CSprData *ptempNode = pDoc->GetSprNode(pDoc->m_CurSprViewSelectedSprNumber);
	
	if( (ptempNode) && (ptempNode -> m_Selected) )
	{
		int tempMaxCrushRtNum = ptempNode->m_MaxCrushRtNum;
		++ tempMaxCrushRtNum;

		if(tempMaxCrushRtNum >= MAX_CRUSH_RT_NUM)
			(tempMaxCrushRtNum = MAX_CRUSH_RT_NUM);

		int tempCurCrushRtNum = tempMaxCrushRtNum - 1;

		// ũ  ǥ...
		CPoint tempScrolledPoint = point + (GetScrollPosition());
		CPoint tempVirtualBasePoint = m_VirtualBasePoint;

		CRect tempRect;

		tempRect.left = ( (tempScrolledPoint.x - tempVirtualBasePoint.x) / tempMultifyNumber );
		tempRect.top  = ( (tempScrolledPoint.y - tempVirtualBasePoint.y) / tempMultifyNumber );

		tempRect.right  = tempRect.left   +1;
		tempRect.bottom = tempRect.bottom +1;

		(ptempNode->m_CrushRt[tempCurCrushRtNum]) = tempRect;

		ptempNode->m_MaxCrushRtNum = tempMaxCrushRtNum;
	}

	CScrollView::OnRButtonDown(nFlags, point);
}
