// BmpView.cpp : implementation of the CBmpView class
//

#include "stdafx.h"
#include "Map.h"

#include "MainFrm.h"

#include "MapDoc.h"
#include "BmpView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBmpView

IMPLEMENT_DYNCREATE(CBmpView, CScrollView)

BEGIN_MESSAGE_MAP(CBmpView, CScrollView)
	//{{AFX_MSG_MAP(CBmpView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONUP()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_BMP_VIEW_SHOW_TILE_OUT_LINE, OnBmpViewShowTileOutLine)
	ON_COMMAND(ID_BMP_VIEW_SET_TILE_OUT_LINE_COLOR, OnBmpViewSetTileOutLineColor)
	ON_COMMAND(ID_BMP_VIEW_SET_TILE_SELECT_LINE_COLOR, OnBmpViewSetTileSelectLineColor)
	ON_COMMAND_RANGE		  ( ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_1, ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_4, OnBmpViewSetPenSize)
	ON_UPDATE_COMMAND_UI_RANGE( ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_1, ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_4,	OnUpdateBmpViewSetPenSizeCheck)
	ON_COMMAND(ID_BMP_VIEW_SHOW_TILE_INDEX_NUMBER, OnBmpViewShowTileIndexNumber)
	ON_UPDATE_COMMAND_UI(ID_BMP_VIEW_SHOW_TILE_INDEX_NUMBER, OnUpdateBmpViewShowTileIndexNumber)
	ON_UPDATE_COMMAND_UI(ID_BMP_VIEW_SHOW_TILE_OUT_LINE, OnUpdateBmpViewShowTileOutLine)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBmpView construction/destruction

CBmpView::CBmpView()
{
	// TODO: add construction code here

	SetDefaultCBmpView();

}

CBmpView::~CBmpView()
{
}

BOOL CBmpView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CBmpView drawing

void CBmpView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 1;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

/////////////////////////////////////////////////////////////////////////////
// CBmpView printing

BOOL CBmpView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CBmpView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CBmpView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CBmpView diagnostics

#ifdef _DEBUG
void CBmpView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CBmpView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CMapDoc* CBmpView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMapDoc)));
	return (CMapDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBmpView message handlers


BOOL CBmpView::SetMaxScrollSize()
{
	CMapDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CSize tempMaxScrollSize( 1, 1);

	if( pDoc->m_BmpViewMemDC.GetMemDCOn() )
		tempMaxScrollSize = pDoc->m_BmpViewMemDC.GetMemDCSize();		//   Ȯ....

	if(tempMaxScrollSize.cx <= 0) tempMaxScrollSize.cx = 1;
	if(tempMaxScrollSize.cy <= 0) tempMaxScrollSize.cy = 1;

	tempMaxScrollSize.cx;
	tempMaxScrollSize.cy;

	
	SetScrollSizes(MM_TEXT, tempMaxScrollSize);	
	return TRUE;
}

CRect CBmpView::GetTileSelectRect()
{
	return m_TileSelectRect;
}



void CBmpView::SetDefaultCBmpView()
{
	m_TileSelectOn		= FALSE;			//	   ߴ üũ...

	m_TileIndexOn		= FALSE;			//	Ÿ ε ȣ ...
	
	m_DrawTileOutLineOn	= TRUE	 ;			//	   ..
		
	m_TileSelectRect.left		= 0;		//	 õ  ..
	m_TileSelectRect.top		= 0;
	m_TileSelectRect.right		= 0;
	m_TileSelectRect.bottom		= 0;

	m_TileSelectRectBasePoint.x = 0;
	m_TileSelectRectBasePoint.y = 0;

	//	 ׿  ...

	m_PenSize			= 2;				//	 ׸   ....
	
	m_ColTileOutLine	= RGB(0,0,0);		//	Ÿ ܰ ...

	m_ColBG				= RGB(192,192,192);	//	...
	
	m_ColTileSelLine	= RGB(255,255,255);	//	  ...

	//	  ....

	m_nPenSizeCheck = ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_2;

	m_nSetShowText	= ID_BMP_VIEW_SHOW_TILE_NO_NUMBER;
}




//////////////////////////////////////////////////////////////////////////////
/////	............... κ..............
//////////////////////////////////////////////////////////////////////////////

void CBmpView::OnDraw(CDC* pDC)
{
	CMapDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here


	
	if( pDoc->m_Bmp.BmpOn() )	
		if( pDoc->m_BmpViewMemDC.GetMemDCOn() )
		{
			DrawMemDCtoScreen(pDC);
			SetMaxScrollSize();
		}

}



BOOL CBmpView::ClearMemDC()
{
	//	   ִ Ȳ ó......

	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	CDC *ptempMemDC		= pDoc->m_BmpViewMemDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;


	//	׸  ..
	CRect tempTargetRect(0,0,0,0);
	CSize tempMaxMemDCSize = pDoc->m_BmpViewMemDC.GetMemDCSize();

	tempTargetRect.right	= tempMaxMemDCSize.cx;
	tempTargetRect.bottom	= tempMaxMemDCSize.cy;

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	
	
	tempPen.CreatePen(PS_SOLID, 1, m_ColBG);
	tempBrush.CreateSolidBrush ( m_ColBG );

	ptempOldPen		= (CPen *)		ptempMemDC->SelectObject (&tempPen);
	ptempOldBrush	= (CBrush *)	ptempMemDC->SelectObject(&tempBrush);

	ptempMemDC->Rectangle(&tempTargetRect);	

	ptempMemDC->SelectObject(ptempOldPen);
	ptempMemDC->SelectObject(ptempOldBrush);

	return TRUE;
}


void CBmpView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	DoLButtonDown(point);
	
	CScrollView::OnLButtonDown(nFlags, point);
}

void CBmpView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(nFlags & MK_LBUTTON)
	{
		DoLButtonMouseMove(point);
	}
	
	CScrollView::OnMouseMove(nFlags, point);
}


//////////////////////////////////////////////////////////////////////////////
/////	޸ DC ٰ ׸ ׸..........
//////////////////////////////////////////////////////////////////////////////

BOOL CBmpView::DrawBmpToMemDC()
{
	CMapDoc* pDoc = GetDocument();

	if(! pDoc -> m_Bmp.BmpOn() )	return FALSE;	

	CDC *ptempMemDC = pDoc->m_BmpViewMemDC.GetMemDC();

	if(! ptempMemDC)
		pDoc -> m_Bmp.BmpDraw(ptempMemDC);		// ׸ ׸........

	return TRUE;
}

CSize CBmpView::GetMaxBmpSize()
{
	CMapDoc* pDoc = GetDocument();

	int tempTileSize = pDoc->GetTileSize();

	CSize tempBmpSize;

	tempBmpSize.cx = pDoc->m_Bmp.GetWidth();
	tempBmpSize.cy = pDoc->m_Bmp.GetHeight();

	tempBmpSize.cx = tempBmpSize.cx / tempTileSize * tempTileSize;
	tempBmpSize.cy = tempBmpSize.cy / tempTileSize * tempTileSize;

	return tempBmpSize;
}
							

//////////////////////////////////////////////////////////////////////////////
/////	޸ DC  Ÿ ƿ ׸.........
//////////////////////////////////////////////////////////////////////////////

BOOL CBmpView::DrawTileOutLine()							
{
	CMapDoc* pDoc = GetDocument();

	CDC *ptempMemDC = pDoc->m_BmpViewMemDC.GetMemDC();
	
	if(! ptempMemDC )	return FALSE;

	CSize tempMemViewSize	= GetMaxBmpSize();
	CSize tempMaxDrawSize   = GetMaxBmpSize();

	int tempTileSize = pDoc->GetTileSize();

	// Ÿ 輱 ׸  ּҷ .......
	if(tempMemViewSize.cx < tempMaxDrawSize.cx)	tempMaxDrawSize.cx = tempMemViewSize.cx;
	if(tempMemViewSize.cy < tempMaxDrawSize.cy)	tempMaxDrawSize.cy = tempMemViewSize.cy;

	tempMaxDrawSize.cx = ( tempMaxDrawSize.cx / tempTileSize ) * tempTileSize;
	tempMaxDrawSize.cy = ( tempMaxDrawSize.cy / tempTileSize ) * tempTileSize;

	CRect tempDrawRect(0,0,tempMaxDrawSize.cx,tempMaxDrawSize.cy);

	//	귯 ...

	CPen tempPen, *ptempOldPen = NULL;

	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileOutLine);
	
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	for(int x = 0 ; x <= tempDrawRect.right; x += tempTileSize)
	{
		ptempMemDC->MoveTo(x,	tempDrawRect.top);
		ptempMemDC->LineTo(x,	tempDrawRect.bottom);
	}

	for(int y = 0 ;	y <= tempDrawRect.bottom; y+= tempTileSize )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	y);
		ptempMemDC->LineTo(tempDrawRect.right,	y);
	}

	ptempMemDC -> SelectObject(ptempOldPen);
	
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////////
/////	޸ DC  Ÿ   ׸......
//////////////////////////////////////////////////////////////////////////////

BOOL CBmpView::DrawTileSelectRectLine()	
{
	CMapDoc* pDoc = GetDocument();

	if(! pDoc->m_Bmp.BmpOn() )	return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )	return FALSE;

	CDC *ptempMemDC = pDoc->m_BmpViewMemDC.GetMemDC();
	
	if(! ptempMemDC )	return FALSE;

	CSize tempMemViewSize = pDoc ->m_BmpViewMemDC.GetMemDCSize();

	int tempTileSize = pDoc->GetTileSize();

	//	  ó............

	CPen tempPen, *ptempOldPen = NULL;
	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileSelLine);
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	//	⼭ ׸...............
	
	CRect	tempDrawRect =  m_TileSelectRect;

	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.top);
	}


	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.left,	tempDrawRect.bottom);
	}

	{
		ptempMemDC->MoveTo(tempDrawRect.right,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}
	
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.bottom);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}		


		ptempMemDC -> SelectObject(ptempOldPen);
		return TRUE;
	

	return TRUE;
}


//////////////////////////////////////////////////////////////////////////////
/////	޸ DC  ȭ ׸...
//////////////////////////////////////////////////////////////////////////////

BOOL CBmpView::DrawMemDCtoScreen(CDC *pDC)		
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)				return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)	return FALSE;

	CDC *ptempMemDC = pDoc->m_BmpViewMemDC.GetMemDC();

	CRect tempScreenSize;
	GetClientRect(&tempScreenSize);

	if(! ptempMemDC)	return FALSE;

	CSize tempMemViewSize = pDoc ->m_BmpViewMemDC.GetMemDCSize();

	pDoc->m_Bmp.BmpDraw(ptempMemDC);

	if(m_DrawTileOutLineOn)		//    ..
		DrawTileOutLine();		// ŸϿ ׸ ׸....

	if(m_TileSelectOn)		//    ߴ üũ...
		DrawTileSelectRectLine();

	if(m_TileIndexOn)
		ShowText();
	
	pDC->BitBlt(0, 0, 
				tempMemViewSize.cx, tempMemViewSize.cy,
				ptempMemDC, 
				0, 0, SRCCOPY);
 
	return TRUE;
}



BOOL CBmpView::DoLButtonDown(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)				return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)	return FALSE;

	int tempTileSize = pDoc->GetTileSize();

	CPoint tempScrolledPoint = point + (GetScrollPosition());

	CSize tempMemViewSize = GetMaxBmpSize();

	if(tempScrolledPoint.x >= tempMemViewSize.cx)		return	FALSE;
	if(tempScrolledPoint.y >= tempMemViewSize.cy)		return	FALSE;

	//	 ÿ  ó ..............

	m_TileSelectRect.left		= (tempScrolledPoint.x) / tempTileSize * tempTileSize;
	m_TileSelectRect.top		= (tempScrolledPoint.y) / tempTileSize * tempTileSize;
	m_TileSelectRect.right		= m_TileSelectRect.left	+ tempTileSize ;
	m_TileSelectRect.bottom		= m_TileSelectRect.top	+ tempTileSize ;
	
	m_TileSelectRectBasePoint.x	= m_TileSelectRect.left	+ (tempTileSize >> 1);
	m_TileSelectRectBasePoint.y	= m_TileSelectRect.top	+ (tempTileSize >> 1);

	Invalidate(FALSE);

	m_TileSelectOn = TRUE;

	// ʺ信     ó........!!
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	if(pMF->GetMapView() -> m_MouseMoveOn)
		pMF->GetMapView() -> m_MouseMoveOn = FALSE;
	
	m_TileSelectOn = TRUE;		//  ....

	return TRUE;
}


BOOL CBmpView::DoLButtonMouseMove(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)				return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)	return FALSE;

	CPoint tempPoint = point;
	CPoint tempScrolledPoint = tempPoint + ( GetScrollPosition() );

	CSize tempMemViewSize = GetMaxBmpSize();

	int tempTileSize		= pDoc->GetTileSize();
	int tempTileSizeSetNumber	= tempTileSize - 1;

	CRect tempRect = m_TileSelectRect;
	CPoint tempBasePoint = m_TileSelectRectBasePoint;

	// 콺    .........
	if(tempScrolledPoint.x > tempBasePoint.x)
	{
		tempRect.left	= (tempBasePoint.x)	/ tempTileSize * tempTileSize;
		tempRect.right	= (tempScrolledPoint.x + tempTileSize	) / tempTileSize * tempTileSize;
	}

	if(tempScrolledPoint.y > tempBasePoint.y)
	{
		tempRect.top	= (tempBasePoint.y)	/ tempTileSize * tempTileSize;
		tempRect.bottom	= (tempScrolledPoint.y	+ tempTileSize	) / tempTileSize * tempTileSize;
	}
	
	// 콺 »  ö ............

	if(tempScrolledPoint.x < tempBasePoint.x)
	{
		tempRect.left	= (tempScrolledPoint.x)/ tempTileSize * tempTileSize;
		tempRect.right	= (tempBasePoint.x + tempTileSize	) / tempTileSize * tempTileSize;
	}

	if(tempScrolledPoint.y < tempBasePoint.y)
	{
		tempRect.top	= (tempScrolledPoint.y)/ tempTileSize * tempTileSize;
		tempRect.bottom	= (tempBasePoint.y + tempTileSize	) / tempTileSize * tempTileSize;
	}

	//  ˻..............
	tempRect.NormalizeRect();
	
	if(tempRect.left	<= 0)
		tempRect.left = 0;

	if(tempRect.top		<= 0)
		tempRect.top = 0;
	
	if(tempRect.right	>= tempMemViewSize.cx)
		tempRect.right = tempMemViewSize.cx;

	if(tempRect.bottom	>= tempMemViewSize.cy)
		tempRect.bottom = tempMemViewSize.cy;
	
	m_TileSelectRect = tempRect;
	
	ClearMemDC();
	Invalidate(FALSE);

	return TRUE;
}


BOOL CBmpView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
    CBrush br(m_ColBG); 
    FillOutsideRect( pDC, &br );
    return FALSE;
	
	return CScrollView::OnEraseBkgnd(pDC);
}

BOOL CBmpView::ShowText()
{
	CMapDoc* pDoc = GetDocument();

	CDC *ptempMemDC = pDoc->m_BmpViewMemDC.GetMemDC();
	
	if(! ptempMemDC )	return FALSE;

	CSize tempMaxDrawSize   = GetMaxBmpSize();

	int tempTileSize = pDoc->GetTileSize();

	tempMaxDrawSize.cx = ( tempMaxDrawSize.cx / tempTileSize ) * tempTileSize;
	tempMaxDrawSize.cy = ( tempMaxDrawSize.cy / tempTileSize ) * tempTileSize;

	CRect tempDrawRect(0,0,tempMaxDrawSize.cx,tempMaxDrawSize.cy);

	CString tempMsg('x');

	int tempTileIndexNumber = 0;

	for(int y = 0 ; y < tempMaxDrawSize.cy ; y += tempTileSize)
	for(int x = 0 ; x < tempMaxDrawSize.cx ; x += tempTileSize)
	{

		//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
		tempMsg.Format("%d", tempTileIndexNumber);
		ptempMemDC->TextOut(x,y,tempMsg);
		
		++tempTileIndexNumber;		
	}
	
	
	
	return TRUE;
}

void CBmpView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	DoLButtonUp();

	CScrollView::OnLButtonUp(nFlags, point);
}

BOOL CBmpView::DoLButtonUp() 
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)				return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)	return FALSE;

//	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
//	pMF->GetMapView() ->m_TileSelectRect = m_TileSelectRect;

	return TRUE;
}

void CBmpView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
		// TODO: Add your message handler code here
	
	//	 üũ.........

	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;

	CDC *ptempMemDC		= pDoc->m_BmpViewMemDC.GetMemDC();
	if(! ptempMemDC)	return;

	//	޴ .........

	CMenu tempPopup;
	CMenu *tempPopupMenu;
	
	tempPopup.LoadMenu(IDR_POPUP_MENU_BMP_VIEW);

	tempPopupMenu = tempPopup.GetSubMenu(0);
	tempPopupMenu -> TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
}



void CBmpView::OnBmpViewShowTileOutLine() 
{
	// TODO: Add your command handler code here
	if(m_DrawTileOutLineOn)
		m_DrawTileOutLineOn = FALSE;
	else
		m_DrawTileOutLineOn = TRUE;

	ClearMemDC();


	Invalidate(FALSE);
}


void CBmpView::OnBmpViewSetPenSize(UINT nID)
{
	m_nPenSizeCheck = nID;
	
	if(nID == ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_1)
			m_PenSize = 1;
	else if(nID == ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_2)
			m_PenSize = 2;
	else if(nID == ID_BMP_VIEW_SET_TILE_LINE_PEN_SIZE_4)
			m_PenSize = 4;
	else
		m_PenSize = 2;

	ClearMemDC();

	Invalidate(FALSE);
}

void CBmpView::OnUpdateBmpViewSetPenSizeCheck(CCmdUI *pCmdUI)
{
	pCmdUI -> SetCheck(m_nPenSizeCheck == pCmdUI -> m_nID);
}



void CBmpView::OnBmpViewSetTileOutLineColor() 
{
	// TODO: Add your command handler code here
		CColorDialog tempDlg;

	if(tempDlg.DoModal() == IDOK)
	{
		m_ColTileOutLine = tempDlg.GetColor();
		Invalidate(FALSE);
	}
}

void CBmpView::OnBmpViewSetTileSelectLineColor() 
{
	// TODO: Add your command handler code here
	CColorDialog tempDlg;

	if(tempDlg.DoModal() == IDOK)
	{
		m_ColTileSelLine = tempDlg.GetColor();
		Invalidate(FALSE);
	}
}

void CBmpView::OnBmpViewShowTileIndexNumber() 
{
	// TODO: Add your command handler code here

	if(m_TileIndexOn)
		m_TileIndexOn = FALSE;
	
	else 
		m_TileIndexOn = TRUE;

	Invalidate(FALSE);
}

void CBmpView::OnUpdateBmpViewShowTileIndexNumber(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(m_TileIndexOn) 
		pCmdUI->SetText("Ÿ ε ȣ  ֱ..!!");
	
	else
		pCmdUI->SetText("Ÿ ε ȣ ֱ.....!!");
	
}

void CBmpView::OnUpdateBmpViewShowTileOutLine(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(m_DrawTileOutLineOn) 
		pCmdUI->SetText("Ÿ 輱  ֱ.......!!");
	
	else
		pCmdUI->SetText("Ÿ 輱 ֱ..........!!");

}
