// BmpView.h : interface of the CBmpView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_BMPVIEW_H__E753766C_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_)
#define AFX_BMPVIEW_H__E753766C_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MapDoc.h"

class CBmpView : public CScrollView
{
protected: // create from serialization only
	CBmpView();
	DECLARE_DYNCREATE(CBmpView)

public:
	BOOL		m_TileSelectOn;				//   ..

	BOOL		m_DrawTileOutLineOn;		//    ..

	BOOL		m_TileIndexOn;				//	Ÿ ε ȣ ...

	CRect		m_TileSelectRect;			// õǴ ...

	CPoint		m_TileSelectRectBasePoint;	//    ǥ....

	BYTE		m_PenSize;				//	 ׸   ....

	UINT		m_nPenSizeCheck;		//	Ÿ   .......

	UINT		m_nSetShowText;			//	 ȣ ........
	
	COLORREF	m_ColTileOutLine;		//	Ÿ ܰ ...

	COLORREF	m_ColBG;				//	...

	COLORREF	m_ColTileSelLine;		//	  ...


public:
	
	void SetDefaultCBmpView();
	
	BOOL ClearMemDC();						//	޸ DC  ĥ..

	BOOL ShowText();						//	ؽƮ (ε ȣ Ӽ ..)

	BOOL SetMaxScrollSize();				//	ִ ũ  ......

	BOOL DrawBmpToMemDC();					//	޸ 𾾿 ׸ ׸....
	
	BOOL DrawTileOutLine();					//	ŸϿܰ ׸....

	CRect GetTileSelectRect();				//	 õ  ϱ..
	
	BOOL DrawTileSelectRectLine();			//	   ׸..

	BOOL DrawMemDCtoScreen(CDC *pDC);		//	޸ DC  ȭ ׸...

	BOOL DoLButtonDown(CPoint point);		//	콺  ư ó..
	
	BOOL DoLButtonMouseMove(CPoint point);	//	콺  ư   ó..

	BOOL DoLButtonUp();

	CSize GetMaxBmpSize();


// Attributes
public:
	CMapDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBmpView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CBmpView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CBmpView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnBmpViewShowTileOutLine();
	afx_msg void OnBmpViewSetTileOutLineColor();
	afx_msg void OnBmpViewSetTileSelectLineColor();
	afx_msg	void OnBmpViewSetPenSize(UINT nID);
	afx_msg void OnUpdateBmpViewSetPenSizeCheck(CCmdUI *pCmdUI);
	afx_msg void OnBmpViewShowTileIndexNumber();
	afx_msg void OnUpdateBmpViewShowTileIndexNumber(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBmpViewShowTileOutLine(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#ifndef _DEBUG  // debug version in BmpView.cpp
inline CMapDoc* CBmpView::GetDocument()
   { return (CMapDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BMPVIEW_H__E753766C_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_)

//	afx_msg	void OnBmpViewSetShowText(UINT nID);
//	afx_msg void OnUpdateBmpViewSetTextCheck(CCmdUI *pCmdUI);
