// MapDoc.cpp : implementation of the CMapDoc class
//

#include "stdafx.h"
#include "Map.h"

#include "MainFrm.h"
#include "MapDoc.h"

#include "MapSizeInputDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAX_MINI_VIEW_HEIGHT	3000
#define MAX_MINI_VIEW_WIDTH		3000
#define MIN_MAP_SIZE			32

#define BMP_VIEW_BG_COLOR			RGB(192,192,192)
#define MAP_VIEW_BG_COLOR			RGB(192,192,192)
//#define MINI_VIEW_BG_COLOR			RGB(192,192,192)

/////////////////////////////////////////////////////////////////////////////
// CMapDoc

IMPLEMENT_DYNCREATE(CMapDoc, CDocument)

BEGIN_MESSAGE_MAP(CMapDoc, CDocument)
	//{{AFX_MSG_MAP(CMapDoc)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapDoc construction/destruction

CMapDoc::CMapDoc()
{
	
	InitializeMapDoc();

}

CMapDoc::~CMapDoc()
{
}

BOOL CMapDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMapDoc serialization

void CMapDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMapDoc diagnostics

#ifdef _DEBUG
void CMapDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMapDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMapDoc commands


void CMapDoc::InitializeMapDoc()
{
	m_TileSize	= MIN_MAP_SIZE;			// Ÿ ũ.....

	m_TileNumX	=	20;			//	  ȿ ִ X  Ÿ ..
	m_TileNumY	=	15;			//	  ȿ ִ Y  Ÿ ..

	m_PageNumX	=	1;			//	X   ..
	m_PageNumY	=	1;			//	Y   ..

	m_MapTileDefaultIndexNumber = -1;	//	 Ÿ ʱ  ε ȣ...
	
	m_MapTileDefaultAttribution = -1;	//	 Ÿ ʱ Ӽ ȣ....
}


/////////////////////////////////////////////////////////////////////////////
//	ο   ............................
/////////////////////////////////////////////////////////////////////////////

void CMapDoc::OnFileNew() 
{
	// TODO: Add your command handler code here
	static CFileDialog tempFileDlg( TRUE, "BMP", "*.BMP",
								OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
								"Ʈ (*.bmp)|*.BMP| (*.*)|*.*|" );

	if( tempFileDlg.DoModal() == IDOK ) 
	{
		CString tempFileName = tempFileDlg.GetPathName(); 
		
		//  ̸..
		m_CurFileName = tempFileDlg.GetFileName();

		CString tempFileType;
		tempFileType = tempFileName;

		tempFileType.MakeUpper();

		// Ʈ  εϱ....
		if(tempFileType.Find(".BMP") > -1 )
			LoadBmpFile(tempFileName);

		else
			AfxMessageBox("׸  (*.Bmp) ΰԽΰ ҷ ...-_/~~");

		UpdateAllViews(NULL);
	}
	
}


/////////////////////////////////////////////////////////////////////////////
//	ο   ó.............
/////////////////////////////////////////////////////////////////////////////

void CMapDoc::OnFileOpen() 
{
	// TODO: Add your command handler code here

	static CFileDialog tempFileDlg( TRUE, "BMP", "*.BMP",
								OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
								"Ʈ (*.bmp)|*.BMP| (*.map)|*.MAP| (*.*)|*.*|" );

	if( tempFileDlg.DoModal() == IDOK ) 
	{
		CString tempFileName = tempFileDlg.GetPathName(); 
		
		//  ̸..
		m_CurFileName = tempFileDlg.GetFileName();

		CString tempFileType;
		tempFileType = tempFileName;

		tempFileType.MakeUpper();

		// Ʈ  εϱ....
		if(tempFileType.Find(".BMP") > -1 )
			LoadBmpFile(tempFileName);

		if(tempFileType.Find(".MAP") > -1)
			LoadMapFile(tempFileName);
	}


	UpdateAllViews(NULL);
}

/////////////////////////////////////////////////////////////////////////////
//	  ó.................
/////////////////////////////////////////////////////////////////////////////

void CMapDoc::OnFileSave() 
{
	// TODO: Add your command handler code here

	//CMainFrame*	pMF=(CMainFrame*)AfxGetMainWnd();
	CFileDialog tempFileDlg(FALSE, "map", "*.MAP", OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
				    "  (*.map)|*.map|   (*.*)|*.*|");

	if( tempFileDlg.DoModal() == IDOK ) 
	{//OK
		CString tempFileName = tempFileDlg.GetPathName(); 

		if(! SaveMapFile(tempFileName))
		{
			AfxMessageBox(" ̺ ....");
			
			return;
		}

		m_CurFileName = tempFileDlg.GetFileName();
	}

}

/////////////////////////////////////////////////////////////////////////////
//	׸  θ..........
/////////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::LoadBmpFile(CString fileName)
{
	if(m_Bmp.BmpLoad(fileName))
	{
		InitializeMapDoc();

		if(! m_Bmp.BmpOn() )
			return FALSE;

		CMapSizeInputDlg tempDlg;

		//	  ޱ...........

		if( tempDlg.DoModal() == IDOK ) 
		{
			m_TileSize	= tempDlg.m_TileSize;	// Ÿ ũ.....

			m_TileNumX	= tempDlg.m_TileNumX;	//	  ȿ ִ X  Ÿ ..
			m_TileNumY	= tempDlg.m_TileNumY;	//	  ȿ ִ Y  Ÿ ..

			m_PageNumX	= tempDlg.m_PageNumX;	//	X   ..
			m_PageNumY	= tempDlg.m_PageNumY;	//	Y   ..
		}
		
		else 
			return FALSE;

		if(! CreateBmpViewMemDC() )	// ׸  ..................
			return FALSE;;

		if(! CreateMapViewMemDC() )	//   ..................
			return FALSE;;

		if(! CreateTileDataList())	// ׸信 ŸϿ  ũ Ʈ ..
			return FALSE;			

		if(! CreateMapDataList())	// Ÿ 信 ŸϿ  ũ Ʈ ..
			return FALSE;


	
		//	 ʱȭ...........

		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	
		pMF -> GetBmpView() -> SetDefaultCBmpView();
		pMF -> GetBmpView() -> SetMaxScrollSize();

		pMF -> GetMapView() -> SetDefaultCMapView();
		pMF -> GetMapView() -> SetScrollSize();



		
		//	ʺ ڰ Ƿ  ڿ ...
		//	̴  ........

		if(! CreateMiniViewMemDC() )
			return FALSE;

		//	̴ 信  ׸ ϴ ׸....

		pMF-> GetMiniView() ->DrawAllMapTiletoMemDC();

		return TRUE;
	}

	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////
//	  θ...............
/////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////
//	Ÿ 1 ũ ϱ..........
/////////////////////////////////////////////////////////////////////////////

int CMapDoc::GetTileSize()
{
	return m_TileSize;
}


/////////////////////////////////////////////////////////////////////////////
//	 ý ػ ϱ........
/////////////////////////////////////////////////////////////////////////////

CSize CMapDoc::GetSystemResolution()
{
	CSize tempSystemResolution(1,1);

	tempSystemResolution.cx	=	GetSystemMetrics(0);	//  ػ..
	tempSystemResolution.cy =	GetSystemMetrics(1);	//  ػ..
	
	return tempSystemResolution;
}


/////////////////////////////////////////////////////////////////////////////
//	 ִ ũ ϱ (  *  ( ȼ ) )........!!
/////////////////////////////////////////////////////////////////////////////

CSize CMapDoc::GetMaxMapSize()	
{
	CSize tempMaxMapSize(0,0);

	tempMaxMapSize.cx = m_TileSize * m_TileNumX * m_PageNumX;
	tempMaxMapSize.cy = m_TileSize * m_TileNumY * m_PageNumY;

	//	 ũ Ÿ ũ * Ÿ ĭ  *   ...

	return tempMaxMapSize;
}

/////////////////////////////////////////////////////////////////////////////
//	Ÿ ũ帮Ʈ εȣ ׸  ϱ...
/////////////////////////////////////////////////////////////////////////////

CRect CMapDoc::GetTileBmpRect(int tileIndexNumber)
{
	CTileDataList *ptempNode = NULL;
	ptempNode = m_TileDataList.GetLinkedListNode(tileIndexNumber);
	
	if(! ptempNode) return FALSE;

	else
		return ptempNode ->m_BmpViewTileRect;
}
	
	
/////////////////////////////////////////////////////////////////////////////
//	ŸϿ  ũ Ʈ ...(׸ 信  )
/////////////////////////////////////////////////////////////////////////////
	
BOOL CMapDoc::CreateTileDataList()
{	
	if( ! m_Bmp.BmpOn()	)					return FALSE;	// ׸  ..!!
	if( ! m_BmpViewMemDC.GetMemDCOn()	)	return FALSE;	// ޸ DC  

	CTileDataList * ptempNode = NULL;

	//	 ũ Ʈ ........

	m_TileDataList.DelLinkedListAll();

	int tempTileSize			= GetTileSize();
	
	int tempBasePointNum	= tempTileSize >> 1;	// Ÿ ߽.. ߿ ǥüũ..

	int tempBmpWidth		= m_Bmp.GetWidth();
	int tempBmpHeight		= m_Bmp.GetHeight();


	// Ÿ ߸  ..

	tempBmpWidth  = ( tempBmpWidth / tempTileSize ) * tempTileSize;	// Ÿ ũⰡ  ߸..
	tempBmpHeight = ( tempBmpHeight	/ tempTileSize ) * tempTileSize;// Ÿ ũⰡ  ߸..

	// Ÿ 信 ׸ ....
	CRect tempSourceTileBmpRect(0,0,0,0);

	// Ÿ ε ȣ..
	int tempTileIndexNumber = 0;	// Ÿ Ϸùȣ..
	
	for(int y = 0 ; y < tempBmpHeight	; y += tempTileSize )
		for(int x = 0 ; x < tempBmpWidth	; x += tempTileSize )
		{

			tempSourceTileBmpRect.left	 = x;
			tempSourceTileBmpRect.top    = y,
			tempSourceTileBmpRect.right	 = x + tempTileSize -1,
			tempSourceTileBmpRect.bottom = y + tempTileSize -1;

			m_TileDataList.AddLinkedList(tempSourceTileBmpRect, tempTileIndexNumber);

			++ tempTileIndexNumber;	// Ÿ Ϸùȣ ..
		}

	return TRUE;
}

BOOL CMapDoc::CreateMapDataList()	// ʿ  ũ Ʈ ..
{	
	if( ! m_Bmp.BmpOn()	)					return FALSE;	// ׸  ..!!
	if( ! m_MapViewMemDC.GetMemDCOn()	)	return FALSE;	// ޸ DC  
	
	//	 ũ ϱ.......!!

	//	 ũ Ʈ ........

	m_MapDataList.DelLinkedListAll();
	m_MapBufferDataList.DelLinkedListAll();

	CSize tempMaxMapSize = GetMaxMapSize();

	// ũ Ʈ  .........!1

	int tempTileSize = GetTileSize();

	for(int y = 0 ; y < tempMaxMapSize.cy	; y += tempTileSize )
	for(int x = 0 ; x < tempMaxMapSize.cx	; x += tempTileSize )
	{
		m_MapDataList.AddLinkedList(m_MapTileDefaultIndexNumber, m_MapTileDefaultAttribution);
	}

	((CMainFrame *) AfxGetMainWnd()) ->GetMapView()->SetScrollSize();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
//	׸  ޸ DC ....
/////////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::CreateBmpViewMemDC()
{
	//	  ޸ DC ִٸ ʺ ũ ڵ ...

	if(! m_Bmp.BmpOn() ) return FALSE;

	CSize tempViewSize( m_Bmp.GetWidth(), m_Bmp.GetHeight() );
	
	if(tempViewSize.cx  <= 0)
		return FALSE;

	if(tempViewSize.cy  <= 0)
		return FALSE;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	CDC *ptempBmpViewDC = pMF -> GetBmpView() -> GetDC();	// ȭ DC .........

	m_BmpViewMemDC.CreateMemDC(ptempBmpViewDC,
							   tempViewSize, 
							   BMP_VIEW_BG_COLOR);	// ޸ DC ...   ĥ...

	pMF -> GetBmpView() -> ReleaseDC(ptempBmpViewDC);	// DC ..........

	ptempBmpViewDC = NULL;								//  ʱȭ..........

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
//	ʺ ޸ DC ....	(  ڵ ...)
/////////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::CreateMapViewMemDC()
{
	//	  ޸ DC ִٸ ʺ ũ ڵ ...
	
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	if(! m_Bmp.BmpOn() )	return FALSE;

	CDC *ptempMapViewDC = pMF -> GetMapView() -> GetDC();	// ȭ DC .........


	// ޸ DC   ϱ...........
	CSize tempMemViewSize = GetSystemResolution();

	if(! tempMemViewSize.cx) return FALSE;
	if(! tempMemViewSize.cy) return FALSE;
	
	//	޸ DC    DC ...

	m_MapBufferDC.CreateMemDC(ptempMapViewDC,
							  tempMemViewSize, 
							  MAP_VIEW_BG_COLOR);	
	

	pMF ->  GetMapView() -> ReleaseDC(ptempMapViewDC);		// DC ..........


	CDC *ptempMapViewMemDC = m_MapBufferDC.GetMemDC();
	
	// ޸ DC ...   ĥ...

	m_MapViewMemDC.CreateMemDC(ptempMapViewMemDC,
							   tempMemViewSize, 
							   MAP_VIEW_BG_COLOR);


	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//	̴  ޸ DC ....	(  ڵ ...)
/////////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::CreateMiniViewMemDC()
{
	//	  ޸ DC ִٸ ʺ ũ ڵ ...

	if(! m_Bmp.BmpOn() ) return FALSE;

	CSize tempMemViewSize( 1000, 1000);
	
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	CDC *ptempMiniViewDC = pMF -> GetMiniView() -> GetDC();	// ȭ DC .........

	COLORREF tempColTileNull = pMF->GetMapView() ->m_ColTileNull;

	//	޸ DC    DC ...

	m_MiniBufferDC.CreateMemDC(ptempMiniViewDC,
 							   tempMemViewSize, 
							   tempColTileNull);
	

	pMF ->  GetMiniView() -> ReleaseDC(ptempMiniViewDC);		// DC ..........


	CDC *ptempMiniViewMemDC = m_MiniBufferDC.GetMemDC();
	
	// ޸ DC ...   ĥ...

	m_MiniViewMemDC.CreateMemDC(ptempMiniViewMemDC,
								tempMemViewSize, 
							    tempColTileNull);

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////
//	  ϱ............
/////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::SaveMapFile(CString fileName)
{
	if(! m_Bmp.BmpOn() )
	{
		AfxMessageBox(" ׸ ..  ε϶ī..");
		return FALSE;
	}

	//  ...
	CFile tempMapFile(fileName, CFile::modeCreate | CFile::modeWrite); 

	///////////////////////////////////////////////////////////////////
	//   ...........
	// Ʈ  ׸ +  Ÿ ũ +  Ÿ   +  Ÿ   + Ÿ   + ũ Ʈ ...
	///////////////////////////////////////////////////////////////////
	
	//    ֱ.................
	BITMAPFILEHEADER tempBmpFileHeader;

	tempBmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + m_Bmp.GetPalSize();
	tempBmpFileHeader.bfReserved1 = NULL;
	tempBmpFileHeader.bfReserved2 = NULL;
	tempBmpFileHeader.bfSize = m_Bmp.GetBmpSize(); //  ũ⸦ ־.
	tempBmpFileHeader.bfType = 0x4d42; // Ʈ ũ ǥ....
	
	//   ...
	tempMapFile.Write(&tempBmpFileHeader, sizeof(BITMAPFILEHEADER)); //  .....

	// ҽ ׸ ...
	tempMapFile.Write(m_Bmp.m_hBmp, (m_Bmp.GetBmpSize() - sizeof(BITMAPFILEHEADER)) );

		//  ũ帮Ʈ ϱ...................
	int tempMaxListNumber = m_MapDataList.GetLinkedListMaxNumber();

	if(! tempMaxListNumber)
	{	//  Ʈ   ݰ .... BMP file  Ȱ ..
		AfxMessageBox("  ....  Ÿ  ʴ´ ~~!!");
		tempMapFile.Close();
		return FALSE;
	}

	//	׸ +  Ÿ ũ +  Ÿ  (XY) +   (XY)
	//	 Ÿ  .. + ũ Ʈ ...

	int tempTileSize = m_TileSize;
	
	int tempTileNumX = m_TileNumX;
	int tempTileNumY = m_TileNumY;

	int tempPageNumX = m_PageNumX;
	int tempPageNumY = m_PageNumY;

	//	Ÿ  ..........
	tempMapFile.Write(&tempTileSize, sizeof(int) );
	
	//	  Ÿ ..........
	tempMapFile.Write(&tempTileNumX, sizeof(int) );
	
	//	  Ÿ ..........
	tempMapFile.Write(&tempTileNumY, sizeof(int) );

	//	  
	tempMapFile.Write(&tempPageNumX, sizeof(int) );

	//	   
	tempMapFile.Write(&tempPageNumY, sizeof(int) );

	//	Ÿ  
	int tempMaxTileNumber = m_MapDataList.GetLinkedListMaxNumber();
	
	tempMapFile.Write(&tempMaxTileNumber, sizeof(int) );

	CMapDataList *ptempNode = NULL;

	int tempTileIndexNumber = -1;
	int tempTileAttribution = -1;

	m_MapDataList.SetCurOperatorNode(0);

	for(int i = 0; i < tempMaxListNumber; i++)
	{
		// ũ Ʈ    Ϳ ...
		ptempNode = m_MapDataList.GetCurOperatorNode();

		if(!ptempNode)
		{
			AfxMessageBox("  ....  Ÿ  ʴ´ ~~!!");
			tempMapFile.Close();
			return FALSE;
		}

		tempTileIndexNumber = ptempNode -> m_MapTileIndexNumber;
		tempTileAttribution = ptempNode -> m_MapTileAttribution;


		//////////////////////////////////////////////////////
		// ũ Ʈ Ͽ ...

		tempMapFile.Write( &tempTileIndexNumber,	sizeof(int) );
		tempMapFile.Write( &tempTileAttribution,	sizeof(int) );

		++m_MapDataList;
	}

	tempMapFile.Close();

	AfxMessageBox("  Ǿ....^_/~~~\nBy JiSung Jung !!");

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////
//	  ҷ.........
/////////////////////////////////////////////////////////////////////////

BOOL CMapDoc::LoadMapFile(CString fileName)
{
	//  ׸ ε...( ġ  ϰ ذ...)

	m_Bmp.BmpLoad(fileName);

	if(! m_Bmp.BmpOn() )
		return FALSE;

	int tempSourceBmpSize = m_Bmp.GetBmpSize();

	//	  ʱȭ...................
	InitializeMapDoc();

	if(! CreateBmpViewMemDC() )	// ׸  ..................
		return FALSE;;

	if(! CreateMapViewMemDC() )	//   ..................
		return FALSE;;

	if(! CreateTileDataList())	// ׸信 ŸϿ  ũ Ʈ ..
		return FALSE;

	m_MapDataList.DelLinkedListAll();
	
	//	׸ +  Ÿ ũ +  Ÿ  (XY) +   (XY)
	//	 Ÿ  .. + ũ Ʈ ...

	int tempTileSize = 0;

	int tempTileNumX = 0;
	int tempTileNumY = 0;

	int tempPageNumX = 0;
	int tempPageNumY = 0;

	//   ....
	CFile tempMapFile(fileName, CFile::modeRead | CFile::shareDenyRead);


	//  ͸  Ʈ  ũ⸸ŭ ̵...
	tempMapFile.Seek(tempSourceBmpSize, CFile::begin);

	//	Ÿ ũ..
	tempMapFile.Read(&tempTileSize, sizeof(int) );

	m_TileSize = tempTileSize;

	//	  Ÿ ..........
	tempMapFile.Read(&tempTileNumX, sizeof(int) );

	m_TileNumX = tempTileNumX;
	
	//	  Ÿ ..........
	tempMapFile.Read(&tempTileNumY, sizeof(int) );

	m_TileNumY = tempTileNumY;

	//	  
	tempMapFile.Read(&tempPageNumX, sizeof(int) );

	m_PageNumX= tempPageNumX;

	//	   
	tempMapFile.Read(&tempPageNumY, sizeof(int) );

	m_PageNumY = tempPageNumY;

	//	Ÿ  
	int tempMaxTileNumber = 0;
	
	//	Ÿ   о...
	tempMapFile.Read(&tempMaxTileNumber, sizeof(int) );

	int tempIndexNumber = -1;
	int tempAttribution = -1;

	for(int i = 0; i < tempMaxTileNumber; i++)
	{
		tempMapFile.Read(&tempIndexNumber,	sizeof(int) );
		tempMapFile.Read(&tempAttribution,	sizeof(int) );
		

		m_MapDataList.AddLinkedList(tempIndexNumber, tempAttribution);
		
		//////////////////////////////////////////////////////
		// ũ Ʈ Ͽ ...
	}

			//	 ʱȭ...........

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	pMF -> GetBmpView() -> SetDefaultCBmpView();
	pMF -> GetBmpView() -> SetMaxScrollSize();

	pMF -> GetMapView() -> SetDefaultCMapView();
	pMF -> GetMapView() -> SetScrollSize();


	//	ʺ ڰ Ƿ  ڿ ...
	//	̴  ........

	if(! CreateMiniViewMemDC() )
		return FALSE;

	//	̴ 信  ׸ ϴ ׸....

	pMF-> GetMiniView() ->DrawAllMapTiletoMemDC();

	return TRUE;

	//  غ............ ...
	DWORD dwCurPosition = tempMapFile.GetPosition();
	if(dwCurPosition == tempMapFile.SeekToEnd() )
	{
		tempMapFile.Close();

		return TRUE;		
	}
	
	AfxMessageBox(" ε尡  ̻մϴ..");

	return FALSE;
}



void CMapDoc::ReleaseAllData()
{

	//	 ʹ Ҹڸ ؼ ڵ ......

	if(m_Bmp.m_hBmp)
		delete m_Bmp.m_hBmp;
}
