// MapDoc.h : interface of the CMapDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAPDOC_H__E753766A_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_)
#define AFX_MAPDOC_H__E753766A_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Bmp.h"
#include "MemDC.h"

#include "MapData.h"
#include "TileData.h"


#define BMP_VIEW_BG_COLOR	RGB(192,192,192)
#define DEFAULT_LINE_COLOR	RGB(0,0,0)
#define SELECTED_AREA_COLOR RGB(255,255,255)


class CMapDoc : public CDocument
{
protected: // create from serialization only
	CMapDoc();
	DECLARE_DYNCREATE(CMapDoc)


public:

	//	ũ Ʈ....................

	CMapData	m_MapDataList;		//	 信  ŸϿ   Ÿ ε ȣ Ӽ   ũ Ʈ...
	
	CMapData	m_MapBufferDataList;	//	 õ   ٸ 
										//	ϱ   ӽ ũ Ʈ..

	CTileData	m_TileDataList;		//	׸ 信 ׸ ǥ Ÿ ε ȣ,  Ӽ   ũ Ʈ.......

	//	޸ DC..............................
	
	CMemDC		m_BmpViewMemDC;		//	׸ 信 ޸ DC ü...............
	
	
	CMemDC		m_MiniViewMemDC;	//	̴ 信 ޸ DC ü...............

	CMemDC		m_MiniBufferDC;		//	̴  ޸ DC   DC 

	CMemDC		m_MapViewMemDC;		//		信 ޸ DC ü...............
	
	CMemDC		m_MapBufferDC;		//	  ޸ DC   DC

	

	//	 ................

	int			m_MapTileDefaultIndexNumber;	//	 Ÿ ʱ  ε ȣ...
	
	int			m_MapTileDefaultAttribution;	//	 Ÿ ʱ Ӽ ȣ....

	CBmp		m_Bmp;				//	׸   ...

	CString		m_CurFileName;		//	  ̸..........

	int			m_TileSize;			//	Ÿ ϳ ... (⺻ 32 * 32)

	int			m_TileNumX;			//	  ȿ ִ X  Ÿ ..
	int			m_TileNumY;			//	  ȿ ִ Y  Ÿ ..

	int			m_PageNumX;			//	X   ..
	int			m_PageNumY;			//	Y   ..


public:

	//	 Լ............

	void	InitializeMapDoc();

	int		GetTileSize();						// Ÿ  ..

	CSize	GetMaxMapSize();					//  ִ ũ .( *  (ȼ) )

	CSize	GetSystemResolution();				// ý  ػ ϱ........

	CRect	GetTileBmpRect(int tileIndexNumber);	//	Ÿ ε ȣ ׸  ϱ...!!

	BOOL	CreateMapDataList();	// ʿ  ũ Ʈ ..

	BOOL	CreateTileDataList();				// ŸϿ  ũ Ʈ ..

	BOOL	CreateBmpViewMemDC();				// Ʈ  ޸ ..

	BOOL	CreateMapViewMemDC();				//   ޸ ....
	
	BOOL	CreateMiniViewMemDC();				// ̴  並 ....

	BOOL	LoadBmpFile(CString fileName);		// Ʈ ε..........

	BOOL	LoadMapFile(CString fileName);		//   ε..........
	
	BOOL	SaveMapFile(CString fileName);		//   ̺..........

	void	ReleaseAllData();
	

// Attributes
public:


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMapDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CMapDoc)
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	afx_msg void OnFileNew();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAPDOC_H__E753766A_D5C4_11D4_A1DD_0000E87BE29C__INCLUDED_)
