// MapSizeInputDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Map.h"
#include "MapSizeInputDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapSizeInputDlg dialog


CMapSizeInputDlg::CMapSizeInputDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMapSizeInputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMapSizeInputDlg)
	m_PageNumX = 1;
	m_PageNumY = 1;
	m_TileNumX = 20;
	m_TileNumY = 15;
	m_TileSize = 32;
	//}}AFX_DATA_INIT
}


void CMapSizeInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapSizeInputDlg)
	DDX_Control(pDX, IDC_TileSizeSpin, m_TileSizeSpin);
	DDX_Control(pDX, IDC_TileNumSpinY, m_TileNumSpinY);
	DDX_Control(pDX, IDC_TileNumSpinX, m_TileNumSpinX);
	DDX_Control(pDX, IDC_PageNumSpinX, m_PageNumSpinX);
	DDX_Control(pDX, IDC_PageNumSpinY, m_PageNumSpinY);

	DDX_Text(pDX, IDC_PAGE_NUM_X, m_PageNumX);
	DDV_MinMaxUInt(pDX, m_PageNumX, 1, 10000);

	DDX_Text(pDX, IDC_PAGE_NUM_Y, m_PageNumY);
	DDV_MinMaxUInt(pDX, m_PageNumY, 1, 10000);

	DDX_Text(pDX, IDC_TILE_NUM_X, m_TileNumX);
	DDV_MinMaxUInt(pDX, m_TileNumX, 8, 10000);
	
	DDX_Text(pDX, IDC_TILE_NUM_Y, m_TileNumY);
	DDV_MinMaxUInt(pDX, m_TileNumY, 8, 10000);
	
	DDX_Text(pDX, IDC_TILE_SIZE, m_TileSize);
	DDV_MinMaxUInt(pDX, m_TileSize, 8, 512);
	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMapSizeInputDlg, CDialog)
	//{{AFX_MSG_MAP(CMapSizeInputDlg)
	ON_BN_CLICKED(IDC_PAGE_SIZE_1024_768, OnPageSize1024x768)
	ON_BN_CLICKED(IDC_PAGE_SIZE_640_480, OnPageSize640x480)
	ON_BN_CLICKED(IDC_PAGE_SIZE_800_600, OnPageSize800x600)
	ON_BN_CLICKED(IDC_TILE_SIZE_16, OnTileSize16)
	ON_BN_CLICKED(IDC_TILE_SIZE_32, OnTileSize32)
	ON_BN_CLICKED(IDC_TILE_SIZE_24, OnTileSize24)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapSizeInputDlg message handlers

BOOL CMapSizeInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	

	m_TileSizeSpin.SetRange(8,512);
	
	m_TileNumSpinY.SetRange(8,10000);
	m_TileNumSpinX.SetRange(8,10000);
	
	m_PageNumSpinX.SetRange(1,10000);
	m_PageNumSpinY.SetRange(1,10000);

	return TRUE;  // return TRUE unless you set the focus to a control
		          // EXCEPTION: OCX Property Pages should return FALSE
}

void CMapSizeInputDlg::OnPageSize640x480() 
{
	// TODO: Add your control notification handler code here

	m_TileNumX =  640 / m_TileSize;
	m_TileNumY =  480 / m_TileSize;

	UpdateData(FALSE);
	
}


void CMapSizeInputDlg::OnPageSize800x600() 
{
	// TODO: Add your control notification handler code here

	m_TileNumX = 800 / m_TileSize;
	m_TileNumY = 600 / m_TileSize;

	UpdateData(FALSE);
}


void CMapSizeInputDlg::OnPageSize1024x768() 
{
	// TODO: Add your control notification handler code here
	
	m_TileNumX = 1024 / m_TileSize;
	m_TileNumY =  768 / m_TileSize;

	UpdateData(FALSE);
}

void CMapSizeInputDlg::OnTileSize16() 
{
	// TODO: Add your control notification handler code here
	m_TileSize = 16;

	UpdateData(FALSE);
}


void CMapSizeInputDlg::OnTileSize32() 
{
	// TODO: Add your control notification handler code here
	m_TileSize = 32;

	UpdateData(FALSE);
}

void CMapSizeInputDlg::OnTileSize24() 
{
	// TODO: Add your control notification handler code here
	m_TileSize = 24;

	UpdateData(FALSE);
}
