// MapView.cpp : implementation file
//

#include "stdafx.h"
#include "Map.h"

#include "MainFrm.h"
#include "MapView.h"

#include "MapViewTileAttriInput.h"
#include "SetAllAttriNumDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapView

IMPLEMENT_DYNCREATE(CMapView, CScrollView)

CMapView::CMapView()
{
	SetDefaultCMapView();	//	ʱȭ.........
}

CMapView::~CMapView()
{
}


BEGIN_MESSAGE_MAP(CMapView, CScrollView)
	//{{AFX_MSG_MAP(CMapView)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_RBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_LBUTTONUP()
	ON_WM_ERASEBKGND()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_MAP_VIEW_TILE_SELECT_DEL_RECT, OnMapViewTileSelectDelRect)
	ON_COMMAND_RANGE		  ( ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_1, ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_4, OnMapViewSetPenSize)
	ON_UPDATE_COMMAND_UI_RANGE( ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_1, ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_4,	OnUpdateMapViewSetPenSizeCheck)
	ON_COMMAND_RANGE		  ( ID_MAP_VIEW_SHOW_TILE_INDEX_NUMBER, ID_MAP_VIEW_SHOW_TILE_NO_NUMBER, OnMapViewSetShowText )
	ON_UPDATE_COMMAND_UI_RANGE( ID_MAP_VIEW_SHOW_TILE_INDEX_NUMBER, ID_MAP_VIEW_SHOW_TILE_NO_NUMBER, OnUpdateMapViewSetTextCheck )
	ON_COMMAND(ID_MAP_VIEW_SHOW_TILE_OUT_LINE, OnMapViewShowTileOutLine)
	ON_UPDATE_COMMAND_UI(ID_MAP_VIEW_SHOW_TILE_OUT_LINE, OnUpdateMapViewShowTileOutLine)
	ON_COMMAND(ID_MAP_VIEW_SET_TILE_OUT_LINE_COLOR, OnMapViewSetTileOutLineColor)
	ON_COMMAND(ID_MAP_VIEW_SET_TILE_SELECT_LINE_COLOR, OnMapViewSetTileSelectLineColor)
	ON_COMMAND(ID_MAP_VIEW_SET_TILE_NULL_COLOR, OnMapViewSetTileNullColor)
	ON_COMMAND(ID_MAP_VIEW_TILE_SELECT_FILL_FROM_BMP_VIEW, OnMapViewTileSelectFillFromBmpView)
	ON_COMMAND(ID_MAP_VIEW_TILE_SELECT_FILL_FROM_MAP_VIEW, OnMapViewTileSelectFillFromMapView)
	ON_COMMAND(ID_MAP_VIEW_SET_RECT_ATTRIBUTION, OnMapViewSetRectAttribution)
	ON_COMMAND(ID_MAP_VIEW_SET_TILE_ATTRIBUTION, OnMapViewSetTileAttribution)
	ON_COMMAND(ID_MAP_VIEW_SET_ALL_ATTRIBUTION, OnMapViewSetAllAttribution)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapView drawing

void CMapView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 1;
	SetScrollSizes(MM_TEXT, sizeTotal);
}


/////////////////////////////////////////////////////////////////////////////
// CMapView diagnostics

#ifdef _DEBUG
void CMapView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CMapView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CMapDoc* CMapView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMapDoc)));
	return (CMapDoc*)m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMapView message handlers


/////////////////////////////////////////////////////////////////////////////////
//	OnDraw Լ.................
/////////////////////////////////////////////////////////////////////////////////

void CMapView::OnDraw(CDC* pDC)
{
	CMapDoc* pDoc = GetDocument();
	// TODO: add draw code here

	if( pDoc->m_MapViewMemDC.GetMemDCOn() )
		if( pDoc->m_MapDataList.GetLinkedListOn() )
		{
			DrawMemDCtoScreen(pDC);
		}

	CString tempMsg;
	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	tempMsg.Format(" X = %d ", tempScrolledPoint.x);
	pDC->TextOut(GetScrollPosition().x + 20,GetScrollPosition().y + 20,tempMsg);

	tempMsg.Format(" Y = %d ", tempScrolledPoint.y);
	pDC->TextOut(GetScrollPosition().x + 20, GetScrollPosition().y + 36,tempMsg);

}


void CMapView::SetDefaultCMapView()
{
	//	׸   ʿ  ó...
	
	m_TileIndexOn		= FALSE;		//	Ÿ ε ȣ ...

	m_TileNumberOn		= FALSE;		//	Ÿ ʻ󿡼 ȣ ..

	m_TileAttributionOn	= FALSE;			//	Ÿ Ӽ ...

	
	//	   ..
	
	m_PenSize			= 3;				//	 ׸   ....
	
	m_ColTileNull		= RGB(13,141,7);		//	 Ÿ  ( )....

	m_ColTileOutLine	= RGB(0,0,0);		//	Ÿ ܰ ...

	m_ColBG				= RGB(192,192,192);	//	...
	
	m_ColTileSelLine	= RGB(255,255,255);	//	  ...

	//	  ....

	m_nPenSizeCheck = ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_2;

	m_nSetShowText	= ID_MAP_VIEW_SHOW_TILE_NO_NUMBER;

	//	ʹ ó  ...

	m_DrawTileOutLineOn		= TRUE;		//  ׸ Ÿ ƿ ׸ üũ..!!
	m_TileSelectOn			= FALSE;	//    ߴ üũ...
	m_MouseMoveOn			= FALSE;	//  콺  üũ..!!
		
	m_DrawTileSelectLineOn	= FALSE;	//	  ϰ ִ ..
	
	m_MousePoint.x	= 0;				//	 콺  ǥ üũ...
	m_MousePoint.y	= 0;

	m_CurPointInMemDC.x = 0;			//	 信 ǥ   콺  ϱ...
	m_CurPointInMemDC.y = 0;			

	m_TileSelectRect.left	= 0;		//  õ  ..
	m_TileSelectRect.top	= 0;
	m_TileSelectRect.right	= 0;
	m_TileSelectRect.bottom	= 0;
	
	m_TileSelectRectBasePoint.x = 0;	//	    ǥ..
	m_TileSelectRectBasePoint.y = 0;

	m_OldGetScrollPosition.x = 0;		//	ũѿ 簻 ؾϴ üũ..
	m_OldGetScrollPosition.y = 0;

	m_OldLButtonDownRect = m_TileSelectRect;	//	콺 ʹư  巡 Ǿ üũϱ  ..
}


/////////////////////////////////////////////////////////////////////////////////
//	ȭ ũ  ó...........
/////////////////////////////////////////////////////////////////////////////////

void CMapView::SetScrollSize()
{
	CMapDoc* pDoc = GetDocument();
	
	CSize tempSize(1,1);
	
	if(pDoc->m_MapDataList.GetLinkedListOn())
	{
		tempSize = pDoc -> GetMaxMapSize();	
		
		tempSize.cx += m_PenSize;
		tempSize.cy += m_PenSize;
	}
	


	SetScrollSizes(MM_TEXT, tempSize);
}

/////////////////////////////////////////////////////////////////////////////////
//	 Ʈ Ÿϳѹ  ϱ............
/////////////////////////////////////////////////////////////////////////////////

int	CMapView::GetTileNumberWithPoint(CPoint sourcePoint)
{
	CMapDoc* pDoc = GetDocument();

	int tempTileSize = pDoc->GetTileSize();
	
	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();


	int tempNumberX = sourcePoint.x / tempTileSize;					// X ࿡ Ÿ ȣ..
	int tempNumberY = sourcePoint.y / tempTileSize;					// Y ࿡ Ÿ ȣ..
	
	int tempTileNumberPerLine = tempMaxMapSize.cx / tempTileSize;	//  δ Ÿ ..

	int tempCurTileNumber = tempNumberX + (tempTileNumberPerLine * tempNumberY);

	return tempCurTileNumber;
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//
//	輱̳  óԼ............
//
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//	輱 ׷ֱ..........
//////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawTileOutLine()
{
	CMapDoc* pDoc = GetDocument();

	CDC *ptempMemDC = pDoc->m_MapViewMemDC.GetMemDC();

	int tempTileSize			= pDoc->GetTileSize();

	CSize tempMaxDrawSize = pDoc->GetMaxMapSize();

	CRect tempDrawRect;
	GetClientRect(&tempDrawRect);

	CPoint tempGetScrollPosition = GetScrollPosition();

	//	 ȭ麸   ó..

	if(tempDrawRect.right >= tempMaxDrawSize.cx)
		tempDrawRect.right = tempMaxDrawSize.cx / tempTileSize * tempTileSize;
	
	else 
		tempDrawRect.right		+= tempTileSize;
	 
	if(tempDrawRect.bottom >= tempMaxDrawSize.cy)
		tempDrawRect.bottom	 = tempMaxDrawSize.cy / tempTileSize * tempTileSize;
	
	else
		tempDrawRect.bottom		+= tempTileSize;

	CPen tempPen, *ptempOldPen = NULL;

	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileOutLine);
	
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	for(int x = 0 ; x <= tempDrawRect.right; x += tempTileSize)
	{
		ptempMemDC->MoveTo(x,	tempDrawRect.top);
		ptempMemDC->LineTo(x,	tempDrawRect.bottom);
	}

	for(int y = 0 ;	y <= tempDrawRect.bottom; y+= tempTileSize )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	y);
		ptempMemDC->LineTo(tempDrawRect.right,	y);
	}

	ptempMemDC -> SelectObject(ptempOldPen);
	return TRUE;
	
}



/////////////////////////////////////////////////////////////////////////////////
//	  ڽ ׸........(OnDraw ..........)
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawTileSelectLineForOnDraw()
{

	if(! m_DrawTileSelectLineOn)
		return FALSE;


	CMapDoc* pDoc = GetDocument();

	//	׸ ׸ ڰ ...

	CDC *ptempMemDC = pDoc->m_MapViewMemDC.GetMemDC();

	//	  ó............

	CPen tempPen, *ptempOldPen = NULL;
	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileSelLine);
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	//	⼭ ׸...............
	
	CRect	tempDrawRect =  m_CurTileSelectRect;

	CPoint tempGetScrollPosition = GetScrollPosition();

	int tempTileSize			= pDoc->GetTileSize();

	tempGetScrollPosition.x = ( tempGetScrollPosition.x / tempTileSize ) * tempTileSize;
	tempGetScrollPosition.y = ( tempGetScrollPosition.y / tempTileSize ) * tempTileSize;

	tempDrawRect.left	-= tempGetScrollPosition.x;
	tempDrawRect.top	-= tempGetScrollPosition.y;
	tempDrawRect.right	-= tempGetScrollPosition.x;
	tempDrawRect.bottom -= tempGetScrollPosition.y;


	if(tempDrawRect.right > 0)
	{
		if(tempDrawRect.top < 0)
			tempDrawRect.top = 0;
		
		if(tempDrawRect.bottom < 0)
			tempDrawRect.bottom = 0;
	}
	
	if(tempDrawRect.bottom > 0)
	{
		if(tempDrawRect.left < 0 )
			tempDrawRect.left = 0;

		if(tempDrawRect.right < 0 )
			tempDrawRect.left = 0;
	}
	
	//	  ׸...

	if(tempDrawRect.top >= 0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.top);
	}


	if(tempDrawRect.left >=0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.left,	tempDrawRect.bottom);
	}

	if(tempDrawRect.right >=0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.right,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}
	
	if(tempDrawRect.bottom >= 0)
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.bottom);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}		

		ptempMemDC -> SelectObject(ptempOldPen);
		return TRUE;
	
}


/////////////////////////////////////////////////////////////////////////////////
//	  ڽ ׸........
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawTileSelectLine()
{
	CMapDoc* pDoc = GetDocument();

	CDC *ptempMemDC = pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;

	CDC *ptempBufferDC = pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return FALSE;

	CClientDC tempDC(this);


	int tempTileSize			= pDoc->GetTileSize();
	int tempTileHalfSize		= tempTileSize >> 1;


	//	 õ   ǥ ° ...(ʺ信 õ ..)
	
	//	콺  ǥ Է.........

	CPoint tempPoint = m_MousePoint;

	CPoint tempGetScrollPosition = GetScrollPosition();
	CPoint tempScrolledPoint = tempPoint + tempGetScrollPosition;

	CRect	tempDrawRect	=	m_TileSelectRect;

	tempDrawRect.left	=	( tempDrawRect.left		/ tempTileSize ) * tempTileSize;
	tempDrawRect.top	=	( tempDrawRect.top		/ tempTileSize ) * tempTileSize;
	tempDrawRect.right	=	( tempDrawRect.right	/ tempTileSize ) * tempTileSize;
	tempDrawRect.bottom	=	( tempDrawRect.bottom	/ tempTileSize ) * tempTileSize;

	tempDrawRect.left	-=	(tempGetScrollPosition.x / tempTileSize * tempTileSize);
	tempDrawRect.top	-=	(tempGetScrollPosition.y / tempTileSize * tempTileSize);
	tempDrawRect.right	-=	(tempGetScrollPosition.x / tempTileSize * tempTileSize);
	tempDrawRect.bottom	-=	(tempGetScrollPosition.y / tempTileSize * tempTileSize);


	//	Ʈ Ʈ   ũ ϱ..
	
	CRect tempScreenSize;
	GetClientRect(&tempScreenSize);

	tempScreenSize.right += tempTileSize;
	tempScreenSize.bottom+= tempTileSize;

	//	޸ DC  ׸ .................

	CSize tempMaxMemDCSize = pDoc->m_MapBufferDC.GetMemDCSize();

	ptempMemDC -> BitBlt(
						 0,						//	׷ ũ ǥ
						 0,
						 tempScreenSize.right,
						 tempScreenSize.bottom,
						 ptempBufferDC,			//	׷  ޸ DC...

						 0,	0,					// ҽ ׸ ǥ..
		
						 SRCCOPY);

	
	//	ÿ ڽ ׸..

	//	  ó............

	CPen tempPen, *ptempOldPen = NULL;
	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileSelLine);
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	if(tempDrawRect.top >= 0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.top);
	}


	if(tempDrawRect.left >=0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.left,	tempDrawRect.bottom);
	}

	if(tempDrawRect.right >=0 )
	{
		ptempMemDC->MoveTo(tempDrawRect.right,	tempDrawRect.top);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}
	
	if(tempDrawRect.bottom >= 0)
	{
		ptempMemDC->MoveTo(tempDrawRect.left,	tempDrawRect.bottom);
		ptempMemDC->LineTo(tempDrawRect.right,	tempDrawRect.bottom);
	}		

	ptempMemDC -> SelectObject(ptempOldPen);
	
	
//	ptempMemDC->Rectangle(&tempDrawRect);


	//	ȭ ..........
	

	tempDC.BitBlt(0,0,							//	׷ ũ ǥ..
				 tempScreenSize.right,
				 tempScreenSize.bottom,
				 ptempMemDC,					//	׷  ޸ DC...
				 
				 (tempGetScrollPosition.x) % tempTileSize,		//	ҽ ׸ ǥ..
				 (tempGetScrollPosition.y) % tempTileSize,


				 SRCCOPY);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
//	õ  ׸׷ֱ..
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawTileSelectBmp()
{
	CMapDoc* pDoc = GetDocument();

	CDC *ptempMemDC = pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;

	CDC *ptempBufferDC = pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return FALSE;

	CClientDC tempDC(this);

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	CPoint	tempGetScrollPosition = GetScrollPosition();
	CPoint	tempScrolledPoint = m_MousePoint + tempGetScrollPosition;
	CSize	tempMaxMapSize = pDoc->GetMaxMapSize();
	
	//	ʿ ڰ ......
	
	int tempTileSize			= pDoc->GetTileSize();
	int tempTileHalfSize		= tempTileSize >> 1;


	//	׸ ׸  ǥ ϱ......

	CPoint tempDrawPoint = m_CurPointInMemDC;

	tempDrawPoint.x = ( tempDrawPoint.x / tempTileSize ) * tempTileSize;
	tempDrawPoint.y = ( tempDrawPoint.y / tempTileSize ) * tempTileSize;

	CRect	tempSelectRect(0,0,0,0);
	CRect	tempTargetRect(0,0,0,0);

	//	Ʈ Ʈ   ũ ϱ..
	
	CRect tempScreenSize;
	GetClientRect(&tempScreenSize);
	
	tempScreenSize.right   += tempTileSize;
	tempScreenSize.bottom += tempTileSize;



	//	 ׸ 信   Ǿ ִٸ...

	if( pMF->GetBmpView() -> m_TileSelectOn)
	{
		tempSelectRect = pMF -> GetBmpView() -> GetTileSelectRect();
		
		//	׸ ׷  .. ( ......)

		tempTargetRect.left		= tempDrawPoint.x;
		tempTargetRect.top		= tempDrawPoint.y;
		tempTargetRect.right	= tempTargetRect.left + tempSelectRect.Width();
		tempTargetRect.bottom	= tempTargetRect.top + tempSelectRect.Height();

		if(tempScrolledPoint.x >= tempMaxMapSize.cx)
		{
			tempTargetRect.left		= (tempMaxMapSize.cx - tempTileSize);
			tempTargetRect.right	= tempTargetRect.left + tempSelectRect.Width();
		}


		if(tempScrolledPoint.y >= tempMaxMapSize.cy)
		{
			tempTargetRect.top		= (tempMaxMapSize.cy - tempTileSize);
			tempTargetRect.bottom	= tempTargetRect.top + tempSelectRect.Height();
		}

		
		//	޸ DC  ׸ .................

		ptempMemDC -> BitBlt(
							 0,						//	׷ ũ ǥ
							 0,
							tempScreenSize.right  ,
							tempScreenSize.bottom,
													//	׷ ũ Y ǥ
							 ptempBufferDC,			//	׷  ޸ DC...

							 0,	0,					// ҽ ׸ ǥ..
			
							 SRCCOPY);
		
	
		
		//	  ׸ ׸..

		if(m_DrawTileSelectLineOn) DrawTileSelectLineForOnDraw();
		
		//	׸ ޸ DC ׸..

		pDoc->m_Bmp.BmpDraw(ptempMemDC, tempSelectRect , tempTargetRect);

		tempDC.BitBlt(0,0,							//	׷ ũ ǥ..
					tempScreenSize.right  ,
					tempScreenSize.bottom,
					 ptempMemDC,					//	׷  ޸ DC...
					 
					 (tempGetScrollPosition.x) % tempTileSize,		//	ҽ ׸ ǥ..
					 (tempGetScrollPosition.y) % tempTileSize,

	
					 SRCCOPY);

			
		return TRUE;	
	
	}

	return FALSE;

}



/////////////////////////////////////////////////////////////////////////////////
//	޸ DC   ĥϸ鼭 ʱȭ..
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::ClearMemDC()
{
	//	   ִ Ȳ ó......

	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;

	CDC *ptempMemDC		= pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;

	CDC *ptempBufferDC	= pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return FALSE;


	//	׸  ..
	CRect tempTargetRect(0,0,0,0);
	CSize tempMaxMemDCSize = pDoc->m_MapBufferDC.GetMemDCSize();

	tempTargetRect.right	= tempMaxMemDCSize.cx;
	tempTargetRect.bottom	= tempMaxMemDCSize.cy;

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	
	
	tempPen.CreatePen(PS_SOLID, 1, m_ColBG);
	tempBrush.CreateSolidBrush ( m_ColBG );

	ptempOldPen		= (CPen *)		ptempMemDC->SelectObject (&tempPen);
	ptempOldBrush	= (CBrush *)	ptempMemDC->SelectObject(&tempBrush);

	ptempMemDC->Rectangle(&tempTargetRect);	


	ptempMemDC->SelectObject(ptempOldPen);
	ptempMemDC->SelectObject(ptempOldBrush);

	ptempOldPen		= (CPen *)		ptempBufferDC->SelectObject (&tempPen);
	ptempOldBrush	= (CBrush *)	ptempBufferDC->SelectObject(&tempBrush);

	ptempBufferDC->Rectangle(&tempTargetRect);	

	ptempBufferDC->SelectObject(ptempOldPen);
	ptempBufferDC->SelectObject(ptempOldBrush);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
//	 ޸ DC ׷..
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawMapTileToMemDC(CDC *pMemDC, CRect sourceRect, CRect targetRect)
{

	CMapDoc* pDoc = GetDocument();

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pMemDC )									return FALSE;
	//if(! m_TileSelectOn)							return FALSE;


	CDC *ptempMemDC = pMemDC;

	int tempWidth	= sourceRect.Width();
	int tempHeight  = sourceRect.Height();

	int tempTileSize			= pDoc->GetTileSize();

	CSize tempMaxMapSize		= pDoc -> GetMaxMapSize();
	
	CPoint tempBasePoint(0,0);	//	 õ  üũϱ  ..

	tempBasePoint.x = sourceRect.left + (tempTileSize > 1);
	tempBasePoint.y = sourceRect.top  + (tempTileSize > 1) ;

	///////////////////////////////////////////////////////////////////////////
	// ۷   ũ帮Ʈ ...
	///////////////////////////////////////////////////////////////////////////

	CMapDataList *ptempNode = NULL;

	int tempBaseTileNumber = GetTileNumberWithPoint(tempBasePoint);

	////////////////////////////////////////////////////////////////////////
	//   ĥϱ  ó..			
	////////////////////////////////////////////////////////////////////////

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileNull);
	ptempOldPen = (CPen *) ptempMemDC -> SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( m_ColTileNull );
	ptempOldBrush = (CBrush *) ptempMemDC -> SelectObject(&tempBrush);

	// ũ Ʈ Ÿ ȣ   ..
	
	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	int tempMapTileIndexNumber = 0;	//  ׷ Ÿ ӽ ε ȣ..
	int tempMapTileAttribution = 0;	//  ׷ Ÿ ӽ Ӽ...
	
	//	Ÿ ȣ Y ȣ  (ü ʿ X  Ÿ ..)
	
	int tempTileNubmerPerLine		= tempMaxMapSize.cx / tempTileSize;
	int tempBmpTileNumberPerLine	= ( ( pDoc->m_Bmp.GetWidth() / tempTileSize ) * tempTileSize )	/ tempTileSize;
	int tempBmpTileNumberPerLineSet	= tempBmpTileNumberPerLine - 1;

	// ũ Ʈ   2  ............
	
	int tempAddNumberForY	=	tempTileNubmerPerLine;
	tempAddNumberForY -= (tempMaxMapSize.cx / tempTileSize);
	--tempAddNumberForY;

	/////////////////////////////////////////////////////////////////////////
	//	8Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

	//	 ޸ DC	û...

	if(pDoc->m_Bmp.m_BitCount == 8)
	{
		//	ķƮ ...
		HPALETTE hPalette=NULL, hOldPalette=NULL;	
		RGBQUAD *pTempPalette;	
		pTempPalette = pDoc-> m_Bmp.m_pBmpPalette;	
		struct	{	WORD Version;	WORD NumberOfEntries;	PALETTEENTRY aEntries[256];	} logicalPalette = {0x300,256};	for(int i =0 ; i < pDoc->m_Bmp.m_BitCount ; i++)	{	logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;	logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;	logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;	logicalPalette.aEntries[i].peFlags = 0;	}	hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);	hOldPalette = SelectPalette(ptempMemDC->m_hDC,hPalette,FALSE);	RealizePalette(ptempMemDC->m_hDC);		

		for(int y = targetRect.top ; y < targetRect.bottom ; y += tempTileSize)
		{
			for(int x = targetRect.left ; x < targetRect.right ; x += tempTileSize)
			{
				ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();

				if(! ptempNode) return FALSE;

				tempMapTileAttribution = ptempNode->m_MapTileAttribution;
				tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
				
				if(tempMapTileIndexNumber < 0)	//	  ó.......
					ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
				
				else
					StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,
								   tempTileSize,  (tempMapTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

				++pDoc->m_MapDataList;

		
			}	//	 X   ó..
			for(int i = 0; i < tempAddNumberForY ; i++)		++pDoc->m_MapDataList;
		}	

		SelectPalette(ptempMemDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
	}		
	
	ptempMemDC -> SelectObject(ptempOldPen);
	ptempMemDC -> SelectObject(ptempOldBrush);
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//
//	 Ÿ ׸ ׷..........
//	 ߿ κ̶  ӵ ַ ó......
//	ظϸ մ .... (Ʈ Լ ׸ óδ  Ÿ ó Ұ..T_/~~)
//	( Ǹ Ҵ...... ̰ ģ Լ.............)
//
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DrawAllMapTileToMemDC()
{
	CMapDoc* pDoc = GetDocument();
	CDC * ptempMemDC		=	pDoc -> m_MapViewMemDC.GetMemDC();
	CPoint tempScrolledPoint =  GetScrollPosition();

	///////////////////////////////////////////////////////////////////////////
	//	׸ ׸  ϱ  ڰ ؿ   ......
	///////////////////////////////////////////////////////////////////////////
	CString tempMsg('x');
	
	int tempTileSize			= pDoc->GetTileSize();
	CSize tempMaxMapSize	= pDoc -> GetMaxMapSize();
	CSize tempMaxDrawSize(0,0);

	// Ÿϵ ׸  ..................
	CRect tempScreenRect;
	GetClientRect(&tempScreenRect);

	tempMaxDrawSize.cx = tempScreenRect.right  ;
	tempMaxDrawSize.cy = tempScreenRect.bottom ;

	if(tempMaxMapSize.cx < tempScreenRect.right)
		tempMaxDrawSize.cx = tempMaxMapSize.cx;
	else
		tempMaxDrawSize.cx +=tempTileSize;

	if(tempMaxMapSize.cy < tempScreenRect.bottom)
		tempMaxDrawSize.cy = tempMaxMapSize.cy;
	else
		tempMaxDrawSize.cy +=tempTileSize;


	////////////////////////////////////////////////////////////////////////
	//   ĥϱ  ó..			
	////////////////////////////////////////////////////////////////////////

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	tempPen.CreatePen(PS_SOLID, m_PenSize, m_ColTileNull);
	ptempOldPen = (CPen *) ptempMemDC -> SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( m_ColTileNull );
	ptempOldBrush = (CBrush *) ptempMemDC -> SelectObject(&tempBrush);


	///////////////////////////////////////////////////////////////////////////
	// ۷   ũ帮Ʈ ...
	///////////////////////////////////////////////////////////////////////////

	CMapDataList *ptempNode = NULL;

	// ũ Ʈ Ÿ ȣ   ..
	//	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	int tempMapTileIndexNumber = 0;	//  ׷ Ÿ ӽ ε ȣ..
	int tempMapTileAttribution = 0;	//  ׷ Ÿ ӽ Ӽ...
	
	///////////////////////////////////////////////////////////////////////////
	// ׷ Ÿ ũ Ʈ  ڰ    ..
	///////////////////////////////////////////////////////////////////////////

	//	Ÿ ȣ Y ȣ  (ü ʿ X  Ÿ ..)
	
	int tempTileNubmerPerLine		= tempMaxMapSize.cx / tempTileSize;
	int tempBmpTileNumberPerLine	= ( ( pDoc->m_Bmp.GetWidth() / tempTileSize ) * tempTileSize )	/ tempTileSize;
	
	//	 ޸ DC  ǥ(0,0)   Ÿ ȣ ..
	//	 Ÿ ȣ ǻ X ǥ 0  ȣ ..(ũ Ʈ  ǥ)

	int tempBaseTileNumber = GetTileNumberWithPoint(tempScrolledPoint);

	// ũ Ʈ   2  ............
	
	int tempAddNumberForY	=	tempTileNubmerPerLine;
	tempAddNumberForY -= (tempMaxDrawSize.cx / tempTileSize);
	--tempAddNumberForY;

	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	//  ۷     Ǿ Ȯ.. 

	////////////////////////////////////////////////////////////////////////
	//	  ó.............
	////////////////////////////////////////////////////////////////////////

	//	 ǥ ִ  üũ...

	int tempTileLinkedListNumber = tempBaseTileNumber;


	////////////////////////////////////////////////////////////////////////
	//	⼭    Ÿ ׸ ׸...
	//	׳ ӵ  ϱ  IF  տ ɰ ...
	//	ӵ  ȳ  νũ ̶ ,
	//	ѹ ߾ غڽ...
	////////////////////////////////////////////////////////////////////////

	/////////////////////////////////////////////////////////////////////////
	//	8Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

	//	 ޸ DC	û...

	ClearMemDC();

  	if(pDoc->m_Bmp.m_BitCount == 8)
	{
		HPALETTE hPalette=NULL, hOldPalette=NULL;	
		RGBQUAD *pTempPalette;	
		pTempPalette = pDoc-> m_Bmp.m_pBmpPalette;	
		struct	{	WORD Version;	WORD NumberOfEntries;	PALETTEENTRY aEntries[256];	} logicalPalette = {0x300,256};	for(int i =0 ; i < pDoc->m_Bmp.m_BitCount ; i++)	{	logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;	logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;	logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;	logicalPalette.aEntries[i].peFlags = 0;	}	hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);	hOldPalette = SelectPalette(ptempMemDC->m_hDC,hPalette,FALSE);	RealizePalette(ptempMemDC->m_hDC);		
		
		if(m_TileIndexOn)	//	Ÿ ε ȣ ָ鼭 ׸..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempMapTileIndexNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}	//	 X   ó..
				for(int i = 0; i < tempAddNumberForY ; i++)		++pDoc->m_MapDataList;
			}	//	 ؼ Y  ó.. ϴ ׸ ϳ ...
		}
	
		else if(m_TileAttributionOn)	//	Ÿ Ӽ ...
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempMapTileAttribution);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
					++pDoc->m_MapDataList;
			}
		}

		else if(m_TileNumberOn)			//	Ÿ ʻ󿡼 Ÿ ȣ ..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					//	Ÿ ʻ󿡼 ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileLinkedListNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
			}
		}

		else	//	׳ ׸ ׸.......... 
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
				//	++tempTileLinkedListNumber;
				}

			}	// 256	Į ó ...
		}
		SelectPalette(ptempMemDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
	}

	/////////////////////////////////////////////////////////////////////////
	//	24Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

  	if(pDoc->m_Bmp.m_BitCount == 24)
	{
		if(m_TileIndexOn)	//	Ÿ ε ȣ ָ鼭 ׸..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempMapTileIndexNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}	//	 X   ó..
				for(int i = 0; i < tempAddNumberForY ; i++)		++pDoc->m_MapDataList;
			}	//	 ؼ Y  ó.. ϴ ׸ ϳ ...
		}
	
		else if(m_TileAttributionOn)	//	Ÿ Ӽ ...
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempMapTileAttribution);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
					++pDoc->m_MapDataList;
			}
		}

		else if(m_TileNumberOn)			//	Ÿ ʻ󿡼 Ÿ ȣ ..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					//	Ÿ ʻ󿡼 ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileLinkedListNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
			}
		}
		else	//	׳ ׸ ׸.......... 
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempMapTileAttribution = ptempNode->m_MapTileAttribution;	tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
					
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );


					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
				}

			}	// 24Ʈ Į ó ...
		}
	}

	//	ó ...  ģ ̶ ..

	ptempMemDC -> SelectObject(ptempOldPen);
	ptempMemDC -> SelectObject(ptempOldBrush);
	
	return TRUE;
}
	
	
	
	
	
	/*
	// Ÿϵ ׸  ..................


	///////////////////////////////////////////////////////////////////////////
	// ۷   ũ帮Ʈ ...
	///////////////////////////////////////////////////////////////////////////

	CMapDataList *ptempNode = NULL;

	// ũ Ʈ Ÿ ȣ   ..
	//	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	
	// ũ Ʈ   2  ............
	


	//  ۷     Ǿ Ȯ.. 

	////////////////////////////////////////////////////////////////////////
	//	  ó.............
	////////////////////////////////////////////////////////////////////////

	//	 ǥ ִ  üũ...

	int tempTileLinkedListNumber = tempBaseTileNumber;
	CString tempMsg('x');

	////////////////////////////////////////////////////////////////////////
	//	⼭    Ÿ ׸ ׸...
	//	׳ ӵ  ϱ  IF  տ ɰ ...
	//	ӵ  ȳ  νũ ̶ ,
	//	ѹ ߾ غڽ...
	////////////////////////////////////////////////////////////////////////

	/////////////////////////////////////////////////////////////////////////
	//	8Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

  	if(pDoc->m_Bmp.m_BitCount == 8)
	{
		HPALETTE hPalette=NULL, hOldPalette=NULL;	
		RGBQUAD *pTempPalette;	
		pTempPalette = pDoc-> m_Bmp.m_pBmpPalette;	
		struct	{	WORD Version;	WORD NumberOfEntries;	PALETTEENTRY aEntries[256];	} logicalPalette = {0x300,256};	for(int i =0 ; i < pDoc->m_Bmp.m_BitCount ; i++)	{	logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;	logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;	logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;	logicalPalette.aEntries[i].peFlags = 0;	}	hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);	hOldPalette = SelectPalette(ptempMemDC->m_hDC,hPalette,FALSE);	RealizePalette(ptempMemDC->m_hDC);
		
		if(m_TileIndexOn)	//	Ÿ ε ȣ ָ鼭 ׸..
		{
	
		else if(m_TileAttributionOn)	//	Ÿ Ӽ ...
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileIndexNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
					++pDoc->m_MapDataList;
			}
		}

		else if(m_TileNumberOn)			//	Ÿ ʻ󿡼 Ÿ ȣ ..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;

					//	׸ ׸....
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ʻ󿡼 ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileLinkedListNumber);
					ptempMemDC->TextOut(x,y,tempMsg);

					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}

				tempBaseTileNumber += tempTileNubmerPerLine;
			}
		}

		else	//	׳ ׸ ׸.......... 
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;

					//	׸ ׸....
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
				//	++tempTileLinkedListNumber;
				}

			}	// 256	Į ó ...
		}
		SelectPalette(ptempMemDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
	}

	/////////////////////////////////////////////////////////////////////////
	//	24Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

  	if(pDoc->m_Bmp.m_BitCount == 24)
	{
		if(m_TileIndexOn)	//	Ÿ ε ȣ ָ鼭 ׸..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);
				
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;
					
					if(tempTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					
					else
						StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileIndexNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;

				}	//	 X   ó..

				tempBaseTileNumber += tempTileNubmerPerLine;
		
			}	//	 ؼ Y  ó.. ϴ ׸ ϳ ...
		}
	
		else if(m_TileAttributionOn)	//	Ÿ Ӽ ...
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ε ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileIndexNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
					++pDoc->m_MapDataList;
			}
		}

		else if(m_TileNumberOn)			//	Ÿ ʻ󿡼 Ÿ ȣ ..
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{	
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;

					//	׸ ׸....
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					//	Ÿ ʻ󿡼 ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
					tempMsg.Format("%d", tempTileLinkedListNumber);
					ptempMemDC->TextOut(x,y,tempMsg);
					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
	
				
			}
		}
		else	//	׳ ׸ ׸.......... 
		{
			for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
			{
				for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
				{
					ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();	if(! ptempNode) return FALSE;
					tempTileAttribution = ptempNode->m_MapTileAttribution;	tempTileIndexNumber = ptempNode->m_TileIndexNumber;

					//	׸ ׸....
					if(tempTileIndexNumber < 0)	ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);
					else	StretchDIBits( ptempMemDC->m_hDC, x,  y,  tempTileSize,  tempTileSize,  (tempTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   pDoc->m_Bmp.m_BmpHeight - (tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,  tempTileSize, tempTileSize,   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					++pDoc->m_MapDataList;
					++tempTileLinkedListNumber;
				}
				for(int i = 0; i < tempAddNumberForY ; i++)
				{
					++pDoc->m_MapDataList;
				//	++tempTileLinkedListNumber;
				}

			}	// 24Ʈ Į ó ...
		}
	}

	//	ó ...  ģ ̶ ..

	ptempMemDC -> SelectObject(ptempOldPen);
	ptempMemDC -> SelectObject(ptempOldBrush);
*/

////////////////////////////////////////////////////////////////////////////////////
/*	̰   ̾... T_/~~
//	׳ ׸ ׸ (  ) .......... 
{
	for(int y = 0; y < tempMaxDrawSize.cy ; y += tempTileSize)
	{

	//	 1 ( )............
	//	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);
	//	tempTileLinkedListNumber = tempBaseTileNumber;
		
		for(int x = 0; x < tempMaxDrawSize.cx ; x += tempTileSize)
		{
			//	 ׷ Ÿ  ϱ...
			ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();
			if(! ptempNode) return FALSE;

			//	  Ÿ Ÿ ޱ..
			
			// Ÿ Ӽ...  0  ׸ ȱ׸..
			tempTileAttribution = ptempNode->m_MapTileAttribution;
			
			// Ÿ ε ȣ....
			tempTileIndexNumber = ptempNode->m_TileIndexNumber;

			//////////////////////////////////////////////////////
			//  ׸ ׷ֱ....
			//////////////////////////////////////////////////////

			//	Ÿ ε ȣ 0   ׸ ...
			if(tempTileIndexNumber < 0)
				ptempMemDC -> Rectangle( x, y, x + tempTileSize, y + tempTileSize);

			else
			{

				// ׸ ׸  Է...
				tempDrawSourceRect.left		=	(tempTileIndexNumber % tempBmpTileNumberPerLine) * tempTileSize;
				tempDrawSourceRect.top		=	(tempTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize;
				tempDrawSourceRect.right	=	tempDrawSourceRect.left	+ tempTileSize - 1;
				tempDrawSourceRect.bottom	=	tempDrawSourceRect.top	+ tempTileSize - 1;

				// ׸ ׸  Է...
				tempDrawTargetRect.left		= x;
				tempDrawTargetRect.top		= y;
				tempDrawTargetRect.right	= x + tempTileSize;
				tempDrawTargetRect.bottom	= y + tempTileSize;
	
				pDoc->m_Bmp.BmpDrawForMapTool(ptempMemDC,tempDrawSourceRect, tempDrawTargetRect);
			}


			//	Ÿ  ȣ ... (⿡ if  ɱ Ⱦ  տ ó...)
			//	tempMsg.Format("%d", tempLinkedListNumber);
			//	ptempMemDC->TextOut(x,y,tempMsg);

			//	۷ 꿡    ̵....
			++pDoc->m_MapDataList;
			++tempTileLinkedListNumber;
		}
		
	//	 1...۷      ...
	//	tempBaseTileNumber += tempTileNubmerPerLine;
	//	 2...۷      ...

		for(int i = 0; i < tempAddNumberForY ; i++)
		{
			++pDoc->m_MapDataList;
		//	++tempTileLinkedListNumber;
		}

	}

*/

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//
//	 ׸ ׸ ( OnDraw óϱ......)
//
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////


BOOL CMapView::DrawMemDCtoScreen(CDC *pDC) 
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;

	CPoint tempGetScrollPosition = GetScrollPosition();

	//	Ÿ ũ ....
	int tempTileSize = pDoc->GetTileSize();
	
	// ޸ DC ....
	
	CDC *ptempMemDC		= pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;

	CDC *ptempBufferDC	= pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return FALSE;


	//	 콺 ġ....

	//	׸ ׸  ũ ϱ..
	
	CRect tempScreenSize;
	GetClientRect(&tempScreenSize);

	///////////////////////////////////////////////////////////////////////////
	//  ׸.........
	///////////////////////////////////////////////////////////////////////////
	
	//	1. ʺ ޸ DC ü  Ÿϵ ׷......!!

	DrawAllMapTileToMemDC();	//	޸ 信 Ÿ ׸ ׷...

	if(m_DrawTileOutLineOn) DrawTileOutLine();

	//	 ȭ  DC  ...

	CSize tempMaxMemDCSize = pDoc->m_MapBufferDC.GetMemDCSize();
	
	ptempBufferDC -> BitBlt(0,	0,					//	׷ ũ ǥ
				   		    tempMaxMemDCSize.cx ,	//	׷ ũ 
						    tempMaxMemDCSize.cy,	//	׷ ũ 

							ptempMemDC,				//	׷  ޸ DC...
				
							0, 0,					// ҽ ׸ Y ǥ..
	
							SRCCOPY);


	if(m_DrawTileSelectLineOn)
		DrawTileSelectLineForOnDraw();




	// Ÿ ʻ󿡼 콺  ġ ... (⿡ if  ɱ Ⱦ  տ ó...)
	//  콺 ġ ...............



	/////////////////////////////////////////////////////////////////////////////////
	// 5. ħ BitBilt..................................
	/////////////////////////////////////////////////////////////////////////////////


	pDC->BitBlt(tempGetScrollPosition.x,	//	׷ ũ X ǥ
				tempGetScrollPosition.y,	//	׷ ũ Y ǥ
				
				tempScreenSize.right + tempTileSize,		//	׷ ũ 
				tempScreenSize.bottom+ tempTileSize,		//	׷ ũ 
				
				ptempMemDC,					//	׷  ޸ DC...
				
				tempGetScrollPosition.x % tempTileSize,	// ҽ ׸ X ǥ..
				tempGetScrollPosition.y % tempTileSize,	// ҽ ׸ Y ǥ..
				
				SRCCOPY);



	//	ȭ 簻 üũ...

	m_OldGetScrollPosition	= tempGetScrollPosition;

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////////
//
//	Ÿ Ӽ ϱ...............
//
/////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
//	콺  ư   ó...............
/////////////////////////////////////////////////////////////////////////////////


BOOL CMapView::SetTileAttrNum(int tileAttriNum)	//	 Ʈ Ÿ..
{
	CMapDoc* pDoc = GetDocument();

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;


	int tempTileSize = pDoc->GetTileSize();

	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	if( tempScrolledPoint.x >= tempMaxMapSize.cx)	return FALSE;
	if( tempScrolledPoint.y >= tempMaxMapSize.cy)	return FALSE;

	// ʺ信 Ÿ ۹ȣ ˾Ƴ..

	int tempCurMapTileNumber = GetTileNumberWithPoint( tempScrolledPoint );

	CMapDataList *ptempMapTileDataNode = NULL;

	ptempMapTileDataNode = pDoc->m_MapDataList.GetLinkedListNode(tempCurMapTileNumber);

	if(! ptempMapTileDataNode)		return FALSE;
	
	ptempMapTileDataNode -> m_MapTileAttribution = tileAttriNum;

	Invalidate(FALSE);

	return TRUE;
}


BOOL CMapView::SetRectAttrNum(int tileAttriNum)	//	 õ ..
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;


	int tempTileSize = pDoc->GetTileSize();

	
	if( m_CurTileSelectRect.Width()  < tempTileSize )	return FALSE;
	if( m_CurTileSelectRect.Height() < tempTileSize )	return FALSE;

	
	if(! m_TileSelectOn )							return FALSE;

	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	//	ǥ ˾Ƴ   ...

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	tempMaxMapSize.cx = ( tempMaxMapSize.cx / tempTileSize ) * tempTileSize;
	tempMaxMapSize.cy = ( tempMaxMapSize.cy / tempTileSize ) * tempTileSize;
	
	//	 信 Ÿ ִ ѹ..
	
	int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
	int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;


	if( m_TileSelectOn )
	{
		//	õ ..............

		CRect tempTileSelectRect = m_CurTileSelectRect;

		CPoint tempBasePoint(tempTileSelectRect.left, tempTileSelectRect.top);

		//	  ǥ ...

		if( tempBasePoint.x > tempMaxMapSize.cx )
			tempBasePoint.x = ( tempMaxMapSize.cx - ( tempTileSize >> 1) );

		if( tempBasePoint.y > tempMaxMapSize.cy )
			tempBasePoint.y = ( tempMaxMapSize.cy - ( tempTileSize >> 1) );


		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		int tempMapBaseTileNumber = GetTileNumberWithPoint( tempBasePoint );

		//	 Ѱġ ........

		int tempMaxMapTileNumberX	= tempMaxMapSize.cx / tempTileSize;
		int tempMaxMapTileNumberY	= tempMaxMapSize.cy / tempTileSize;
		
		int tempMapTileStartX		= tempBasePoint.x / tempTileSize;
		int tempMapTileStartY		= tempBasePoint.y / tempTileSize;

		int tempCurMapTileNumberX	= tempMapTileStartX;
		int tempCurMapTileNumberY	= tempMapTileStartY;
		
		//	 ȸ...

		int tempEraseNumberX = tempTileSelectRect.Width()  / tempTileSize;
		int tempEraseNumberY = tempTileSelectRect.Height() / tempTileSize;

		CMapDataList *ptempMapTileDataNode = NULL;
		
		for(int y = 0 ; y < tempEraseNumberY ; y ++ )
		{
			//	 ׸ Ÿϰ ʺ Ÿ 带 ...

			pDoc->m_MapDataList.SetCurOperatorNode(tempMapBaseTileNumber);

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
		
			for(int x = 0 ; x < tempEraseNumberX; x++)
			{
				ptempMapTileDataNode = pDoc->m_MapDataList.GetCurOperatorNode();
		
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( ptempMapTileDataNode )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				{
					//	Ӽ ȣ Է...
					
					ptempMapTileDataNode -> m_MapTileAttribution = tileAttriNum;
								
					++pDoc -> m_TileDataList;
					++pDoc -> m_MapDataList;
					
					//	  ϳ ......
					
					++tempCurMapTileNumberX;
				}

			}		//	ϴ X  ...
			
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			{

				tempMapBaseTileNumber += tempMaxMapTileNumberPerLine;
				++ tempCurMapTileNumberY;
			}

			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!

		}


		//	۷ ڸ ʱȭ.............

		pDoc->m_MapDataList.SetCurOperatorMemberDefault();


		//	ȭ ..

		Invalidate(FALSE);
	
		return TRUE;
	}

	return FALSE;
}

BOOL CMapView::SetAllAttrNum(int tileIndexNum, int tileAttriNum)	//  ε ȣ..
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	CMapDataList *ptempMapTileDataNode = NULL;
	int tempMaxMapTileNumber = pDoc->m_MapDataList.GetLinkedListMaxNumber();

	pDoc->m_MapDataList.SetCurOperatorNode(0);

	if(! pDoc->m_MapDataList.GetCurOperatorNodeOn() )	return FALSE;

	for(int i = 0; i < tempMaxMapTileNumber ; i++)
	{
		ptempMapTileDataNode = pDoc->m_MapDataList.GetCurOperatorNode();

		if(! ptempMapTileDataNode)	return FALSE;

		if( (ptempMapTileDataNode ->m_MapTileIndexNumber) == tileIndexNum )
			(ptempMapTileDataNode ->m_MapTileAttribution) = tileAttriNum;

		++pDoc->m_MapDataList;
	}

	Invalidate(FALSE);

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////////
//
//	콺 ó Լ......
//
/////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
//	콺  ư   ó...............
/////////////////////////////////////////////////////////////////////////////////

void CMapView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	DoLButtonDown(point);
	
	CScrollView::OnLButtonDown(nFlags, point);
}

BOOL CMapView::DoLButtonDown(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)					return FALSE;
	if( ! pDoc->m_MapViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapBufferDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;


	int tempTileSize = pDoc->GetTileSize();

	CPoint	tempScrolledPoint = point + (GetScrollPosition());
	CSize	tempMaxMapSize = pDoc -> GetMaxMapSize();

	m_OldLButtonDownRect.left = ( ( tempScrolledPoint.x / tempTileSize ) * tempTileSize );
	m_OldLButtonDownRect.top  = ( ( tempScrolledPoint.y / tempTileSize ) * tempTileSize );
	m_OldLButtonDownRect.right =	m_OldLButtonDownRect.left + tempTileSize;
	m_OldLButtonDownRect.bottom =	m_OldLButtonDownRect.top + tempTileSize;

	
	//	   Ǿ ִٸ  ...

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	if(pMF->GetBmpView() -> m_TileSelectOn )
		SaveBmpViewTileSelectRect();

	if(tempScrolledPoint.x >= tempMaxMapSize.cx)		return	FALSE;
	if(tempScrolledPoint.y >= tempMaxMapSize.cy)		return	FALSE;


	///////////////////	⼭    ////////////////////////

	m_TileSelectRect.left		= (tempScrolledPoint.x / tempTileSize) * tempTileSize;
	m_TileSelectRect.top		= (tempScrolledPoint.y / tempTileSize) * tempTileSize;
	m_TileSelectRect.right		= m_TileSelectRect.left	+ tempTileSize ;
	m_TileSelectRect.bottom		= m_TileSelectRect.top	+ tempTileSize ;
	
	m_TileSelectRectBasePoint.x	= m_TileSelectRect.left	+ (tempTileSize >> 1);
	m_TileSelectRectBasePoint.y	= m_TileSelectRect.top	+ (tempTileSize >> 1);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
//	콺 Ŭ ó.........	(  𸣰ڽ...)
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DoLButtonDblClk(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)					return FALSE;
	if( ! pDoc->m_MapViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapBufferDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;

	int tempTileSize = pDoc->GetTileSize();

	CPoint tempScrolledPoint = point + (GetScrollPosition());

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	if(tempScrolledPoint.x >= tempMaxMapSize.cx)		return	FALSE;
	if(tempScrolledPoint.y >= tempMaxMapSize.cy)		return	FALSE;

	m_TileSelectOn = TRUE;

	///////////////////	⼭    ////////////////////////

	m_TileSelectRect.left		= (tempScrolledPoint.x / tempTileSize) * tempTileSize;
	m_TileSelectRect.top		= (tempScrolledPoint.y / tempTileSize) * tempTileSize;
	m_TileSelectRect.right	= m_TileSelectRect.left	+ tempTileSize ;
	m_TileSelectRect.bottom	= m_TileSelectRect.top	+ tempTileSize ;
	
	m_TileSelectRectBasePoint.x	= m_TileSelectRect.left	+ (tempTileSize >> 1);
	m_TileSelectRectBasePoint.y	= m_TileSelectRect.top	+ (tempTileSize >> 1);


	//	  ߽ ǥ...

	m_DrawTileSelectLineOn = TRUE;

	// ʺ信     ó........!!

	m_TileSelectOn = TRUE;

	//	׸      ó.......!!
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	if(pMF->GetBmpView() -> m_TileSelectOn)
	{
		pMF->GetBmpView() -> m_TileSelectOn	 = FALSE;
		pMF->GetBmpView() -> Invalidate(FALSE);
	}

	DrawTileSelectLine();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////////
//	콺   ó............
/////////////////////////////////////////////////////////////////////////////////

void CMapView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	DoMouseMove(point);

	// 콺  ....
	if(nFlags & MK_LBUTTON)	DoLButtonMouseMove(point);
	Invalidate(FALSE);
	
	CScrollView::OnMouseMove(nFlags, point);
}


BOOL CMapView::DoMouseMove(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)					return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapBufferDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;

	CPoint	tempGetScrollPosition = GetScrollPosition();
	CPoint	tempScrolledPoint = point + tempGetScrollPosition;

	m_MouseMoveOn = TRUE;

	//	콺  ǥ Է.........
	CPoint tempPoint = m_MousePoint = point;

	m_CurPointInMemDC = tempScrolledPoint - point;
	int tempTileSize = pDoc->GetTileSize();


	m_CurPointInMemDC.x %= tempTileSize;
	m_CurPointInMemDC.y %= tempTileSize;

	m_CurPointInMemDC += point;

	CRect	tempSourceRect(0,0,0,0);
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	//	 ÿ ׷ֱⰡ ȵǾ ִٸ....
	//	  Ǿ...
	if(pMF->GetBmpView() -> m_TileSelectOn)
	{
	//	콺  ׸ ϱ  ... ϴ ̷ س..

		//	 ׸ ...
		DrawTileSelectBmp();

		return TRUE;
	}
	//	콺  ǥ Է¹ޱ  ..

	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
// 콺  Ŭ 巡 ó..
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::DoLButtonMouseMove(CPoint point)
{
	CMapDoc* pDoc = GetDocument();

	if( ! pDoc->m_Bmp.BmpOn()	)					return FALSE;
	if( ! pDoc->m_BmpViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapViewMemDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapBufferDC.GetMemDCOn()	)		return FALSE;
	if( ! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;

	CPoint tempPoint = point;
	CPoint tempScrolledPoint = tempPoint + ( GetScrollPosition() );
	
	//	 1ĭ  ̵ ʾҴٸ ...
	if( m_OldLButtonDownRect.PtInRect( tempScrolledPoint) )
		return FALSE;


	m_DrawTileSelectLineOn	= TRUE;			//	ö ׸ ǥ..
	m_TileSelectOn		= TRUE;			//	  Ǿ ˸..


	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	if(pMF->GetBmpView() -> m_TileSelectOn)
		pMF->GetBmpView() -> m_TileSelectOn = FALSE;



	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	int tempTileSize		= pDoc->GetTileSize();

	CRect tempRect = m_TileSelectRect;
	CPoint tempBasePoint = m_TileSelectRectBasePoint;

	CRect tempTileRect(0,0,0,0);
	
	tempTileRect.left	= (tempScrolledPoint.x) / tempTileSize * tempTileSize;
	tempTileRect.top	= (tempScrolledPoint.y) / tempTileSize * tempTileSize;
	tempTileRect.right  = tempTileRect.left + tempTileSize;
	tempTileRect.bottom	= tempTileRect.top	+ tempTileSize;


	// 콺    .........
	if(tempScrolledPoint.x > tempBasePoint.x)
	{
		tempRect.left	= (tempBasePoint.x	/ tempTileSize ) * tempTileSize;
		tempRect.right	= ( (tempScrolledPoint.x + tempTileSize) / tempTileSize ) * tempTileSize;
	}

	if(tempScrolledPoint.y > tempBasePoint.y)
	{
		tempRect.top	= (tempBasePoint.y)	/ tempTileSize * tempTileSize;
		tempRect.bottom	= ( (tempScrolledPoint.y	+ tempTileSize	) / tempTileSize ) * tempTileSize;
	}
	
	// 콺 »  ö ............

	if(tempScrolledPoint.x < tempBasePoint.x)
	{
		tempRect.left	= (tempScrolledPoint.x)/ tempTileSize * tempTileSize;
		tempRect.right	= (tempBasePoint.x + tempTileSize	) / tempTileSize * tempTileSize;
	}

	if(tempScrolledPoint.y < tempBasePoint.y)
	{
		tempRect.top	= (tempScrolledPoint.y)/ tempTileSize * tempTileSize;
		tempRect.bottom	= (tempBasePoint.y + tempTileSize	) / tempTileSize * tempTileSize;
	}

	//  ˻..............
	tempRect.NormalizeRect();
	
	if(tempRect.left	<= 0)
		tempRect.left = 0;

	if(tempRect.top		<= 0)
		tempRect.top = 0;
	
	if(tempRect.right	>= tempMaxMapSize.cx)
		tempRect.right = tempMaxMapSize.cx;

	if(tempRect.bottom	>= tempMaxMapSize.cy)
		tempRect.bottom = tempMaxMapSize.cy;
	
	//	õ  ...

	m_TileSelectRect = tempRect;

	m_CurTileSelectRect = tempRect;

	//	  ׷..

	DrawTileSelectLine();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//
//	   ͸ ϴ Լ...
//
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
//	׸䳪 ʺ信 õ  ϰ ȭ ..
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::SaveBmpViewTileSelectRect()
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	int tempTileSize = pDoc->GetTileSize();

	//	ǥ ˾Ƴ   ...

	//	׸ ִ ũ ˾Ƴ..

	CSize tempMaxBmpSize;
	tempMaxBmpSize.cx = ( ( pDoc -> m_Bmp.GetWidth()  ) / tempTileSize * tempTileSize );
	tempMaxBmpSize.cy = ( ( pDoc -> m_Bmp.GetHeight() ) / tempTileSize * tempTileSize );

	int tempMaxBmpTileNumberPerLine		= tempMaxBmpSize.cx	/ tempTileSize;
	int tempMaxBmpTileNumberForHeight	= tempMaxBmpSize.cy / tempTileSize;
		

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	tempMaxMapSize.cx = ( tempMaxMapSize.cx / tempTileSize ) * tempTileSize;
	tempMaxMapSize.cy = ( tempMaxMapSize.cy / tempTileSize ) * tempTileSize;
	
	//	 信 Ÿ ִ ѹ..
	
	int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
	int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	if(pMF->GetBmpView() -> m_TileSelectOn)
	{

		//	  ǥ ...

		if( tempScrolledPoint.x > tempMaxMapSize.cx )
			tempScrolledPoint.x = ( tempMaxMapSize.cx - ( tempTileSize >> 1) );

		if( tempScrolledPoint.y > tempMaxMapSize.cy )
			tempScrolledPoint.y = ( tempMaxMapSize.cy - ( tempTileSize >> 1) );

		//	õ ..............

		CRect tempTileSelectRect = pMF->GetBmpView() -> m_TileSelectRect;

		//	׸ 信 Ÿ ִ ѹ..
		
		int tempMaxBmpTileNumberPerLine		= tempMaxBmpSize.cx	/ tempTileSize;
		int tempMaxBmpTileNumberForHeight	= tempMaxBmpSize.cy / tempTileSize;
		
		int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
		int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;
		
		//	 Ÿ  ȣ ˾Ƴ..........(׸  ۹ȣ...)

		int tempBmpTileStartX = tempTileSelectRect.left / tempTileSize;
		int tempBmpTileStartY = tempTileSelectRect.top  / tempTileSize;

		//	׸信 Ÿ  ȣ ˾Ƴ..

		int tempBmpBaseTileNumber = tempBmpTileStartX + (tempBmpTileStartY * tempMaxBmpTileNumberPerLine ) ;
	
		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		int tempMapBaseTileNumber = GetTileNumberWithPoint( tempScrolledPoint );
		int tempMiniBaseTileNumber = tempMapBaseTileNumber;

		//	 Ѱġ ........

		int tempMaxMapTileNumberX	= tempMaxMapSize.cx / tempTileSize;
		int tempMaxMapTileNumberY	= tempMaxMapSize.cy / tempTileSize;
		
		int tempMapTileStartX		= tempScrolledPoint.x / tempTileSize;
		int tempMapTileStartY		= tempScrolledPoint.y / tempTileSize;

		int tempCurMapTileNumberX	= tempMapTileStartX;
		int tempCurMapTileNumberY	= tempMapTileStartY;
		
		//	 ȸ...

		int tempCopyNumberX = tempTileSelectRect.Width()  / tempTileSize;
		int tempCopyNumberY = tempTileSelectRect.Height() / tempTileSize;

		CTileDataList *ptempTileDataNode = NULL;
		CMapDataList *ptempMapDataNode = NULL;
		
		for(int y = 0 ; y < tempCopyNumberY ; y ++ )
		{
			//	 ׸ Ÿϰ ʺ Ÿ 带 ...

			pDoc->m_TileDataList.SetCurOperatorNode(tempBmpBaseTileNumber);
			pDoc->m_MapDataList.SetCurOperatorNode(tempMapBaseTileNumber);

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
		
			for(int x = 0 ; x < tempCopyNumberX; x++)
			{
			
				ptempTileDataNode = pDoc->m_TileDataList.GetCurOperatorNode();
				ptempMapDataNode = pDoc->m_MapDataList.GetCurOperatorNode();
		
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( ptempTileDataNode )
				if( ptempMapDataNode  )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				{
					//	ȣ Է...

					ptempMapDataNode -> m_MapTileAttribution 	= ptempTileDataNode -> m_TileAttribution;
					ptempMapDataNode -> m_MapTileIndexNumber	= ptempTileDataNode -> m_TileIndexNumber;
								
					++pDoc -> m_TileDataList;
					++pDoc -> m_MapDataList;
					
					//	  ϳ ......
					
					++tempCurMapTileNumberX;
				}

			}		//	ϴ X  ...
			
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			{
				//  ....

				tempBmpBaseTileNumber += tempMaxBmpTileNumberPerLine;
				tempMapBaseTileNumber += tempMaxMapTileNumberPerLine;
				
				++ tempCurMapTileNumberY;
			}

			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!

		}

		//	̴  ȭ ...
		pMF -> GetMiniView() -> DrawMapTileFromMapView(tempMiniBaseTileNumber, tempCopyNumberX, tempCopyNumberY);

		//	ȭ ..
		Invalidate(FALSE);
	
		return TRUE;
	}

	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////////
//	ʺ信 õ  .............
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::EraseTileSelectRect()
{

	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;


	int tempTileSize = pDoc->GetTileSize();

	
	if( m_CurTileSelectRect.Width()  < tempTileSize )	return FALSE;
	if( m_CurTileSelectRect.Height() < tempTileSize )	return FALSE;

	
	if(! m_TileSelectOn )							return FALSE;

	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	//	ǥ ˾Ƴ   ...

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	tempMaxMapSize.cx = ( tempMaxMapSize.cx / tempTileSize ) * tempTileSize;
	tempMaxMapSize.cy = ( tempMaxMapSize.cy / tempTileSize ) * tempTileSize;
	
	//	 信 Ÿ ִ ѹ..
	
	int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
	int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	if( m_TileSelectOn )
	{
		//	õ ..............

		CRect tempTileSelectRect = m_CurTileSelectRect;

		CPoint tempBasePoint(tempTileSelectRect.left, tempTileSelectRect.top);

		//	  ǥ ...

		if( tempBasePoint.x > tempMaxMapSize.cx )
			tempBasePoint.x = ( tempMaxMapSize.cx - ( tempTileSize >> 1) );

		if( tempBasePoint.y > tempMaxMapSize.cy )
			tempBasePoint.y = ( tempMaxMapSize.cy - ( tempTileSize >> 1) );


		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		int tempMapBaseTileNumber = GetTileNumberWithPoint( tempBasePoint );
		int tempMiniBaseTileNumber = tempMapBaseTileNumber;

		//	 Ѱġ ........

		int tempMaxMapTileNumberX	= tempMaxMapSize.cx / tempTileSize;
		int tempMaxMapTileNumberY	= tempMaxMapSize.cy / tempTileSize;
		
		int tempMapTileStartX		= tempBasePoint.x / tempTileSize;
		int tempMapTileStartY		= tempBasePoint.y / tempTileSize;

		int tempCurMapTileNumberX	= tempMapTileStartX;
		int tempCurMapTileNumberY	= tempMapTileStartY;
		
		//	 ȸ...

		int tempEraseNumberX = tempTileSelectRect.Width()  / tempTileSize;
		int tempEraseNumberY = tempTileSelectRect.Height() / tempTileSize;

		CMapDataList *ptempMapTileDataNode = NULL;
		
		for(int y = 0 ; y < tempEraseNumberY ; y ++ )
		{
			//	 ׸ Ÿϰ ʺ Ÿ 带 ...

			pDoc->m_MapDataList.SetCurOperatorNode(tempMapBaseTileNumber);

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
		
			for(int x = 0 ; x < tempEraseNumberX; x++)
			{
				ptempMapTileDataNode = pDoc->m_MapDataList.GetCurOperatorNode();
		
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( ptempMapTileDataNode )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				{
					//	ȣ Է...

					ptempMapTileDataNode -> m_MapTileIndexNumber = pDoc->m_MapTileDefaultIndexNumber;
					ptempMapTileDataNode -> m_MapTileAttribution = pDoc->m_MapTileDefaultAttribution;
								
					++pDoc -> m_TileDataList;
					++pDoc -> m_MapDataList;
					
					//	  ϳ ......
					
					++tempCurMapTileNumberX;
				}

			}		//	ϴ X  ...
			
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			{

				tempMapBaseTileNumber += tempMaxMapTileNumberPerLine;
				++ tempCurMapTileNumberY;
			}

			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!

		}


		//	۷ ڸ ʱȭ.............

		pDoc->m_MapDataList.SetCurOperatorMemberDefault();



		
		//	̴  ȭ ...

		pMF -> GetMiniView() -> DrawMapTileFromMapView(tempMiniBaseTileNumber, tempEraseNumberX, tempEraseNumberY);
		
		//	ȭ ..

		Invalidate(FALSE);
	
		return TRUE;
	}

	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////////
//  ׸ 信 õ  ʺ信 õ  ä...
/////////////////////////////////////////////////////////////////////////////////

BOOL CMapView::FillTileSelectRectFromBmpView()
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	
	int tempTileSize = pDoc->GetTileSize();


	if( pMF -> GetBmpView() -> m_TileSelectRect.Width() < tempTileSize )
		return FALSE;

	if( pMF -> GetBmpView() -> m_TileSelectRect.Height() < tempTileSize )
		return FALSE;

	if( m_TileSelectRect.Width() < tempTileSize )
		return FALSE;

	if( m_TileSelectRect.Height() < tempTileSize )
		return FALSE;

//	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	//	ǥ ˾Ƴ   ...

	//	׸ ִ ũ ˾Ƴ..

	CSize tempMaxBmpSize;
	tempMaxBmpSize.cx = ( ( pDoc -> m_Bmp.GetWidth()  ) / tempTileSize ) * tempTileSize;
	tempMaxBmpSize.cy = ( ( pDoc -> m_Bmp.GetHeight() ) / tempTileSize ) * tempTileSize;

	int tempMaxBmpTileNumberPerLine		= tempMaxBmpSize.cx	/ tempTileSize;
	int tempMaxBmpTileNumberForHeight	= tempMaxBmpSize.cy / tempTileSize;

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	tempMaxMapSize.cx = ( tempMaxMapSize.cx / tempTileSize ) * tempTileSize;
	tempMaxMapSize.cy = ( tempMaxMapSize.cy / tempTileSize ) * tempTileSize;
	
	//	 信 Ÿ ִ ѹ..
	
	int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
	int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;


	if(m_TileSelectOn)
	{
		//	õ ..............

		CRect tempBmpTileSelectRect = pMF->GetBmpView() -> m_TileSelectRect;
		CRect tempMapTileSelectRect = m_CurTileSelectRect;

		//	׸ 信 Ÿ ִ ѹ..
		
		int tempMaxBmpTileNumberPerLine		= tempMaxBmpSize.cx	/ tempTileSize;
		int tempMaxBmpTileNumberForHeight	= tempMaxBmpSize.cy / tempTileSize;
		
		int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
		int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;
		
		//	 Ÿ  ȣ ˾Ƴ..........(׸  ۹ȣ...)

		int tempBmpTileStartX = tempBmpTileSelectRect.left	/ tempTileSize;
		int tempBmpTileStartY = tempBmpTileSelectRect.top	/ tempTileSize;

		//	׸信 Ÿ  ȣ ˾Ƴ..

		int tempBmpBaseTileNumber = tempBmpTileStartX + (tempBmpTileStartY * tempMaxBmpTileNumberPerLine ) ;
		int tempBmpDefaultBaseTileNumber = tempBmpBaseTileNumber;
	
		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		CPoint tempBasePoint( tempMapTileSelectRect.left, tempMapTileSelectRect.top );

		int tempMapBaseTileNumber = GetTileNumberWithPoint( tempBasePoint );
		int tempMiniBaseTileNumber = tempMapBaseTileNumber;

		//	 Ѱġ ........

		int tempMaxBmpTileNumberX	= ( tempBmpTileSelectRect.right  )	/ tempTileSize;
		int tempMaxBmpTileNumberY	= ( tempBmpTileSelectRect.bottom )	/ tempTileSize;

		int tempMaxMapTileNumberX	= tempMaxMapSize.cx / tempTileSize;
		int tempMaxMapTileNumberY	= tempMaxMapSize.cy / tempTileSize;

		//	 ȣ   ġ ..

		int tempCurBmpTileNumberX	= tempBmpTileStartX;
		int tempCurBmpTileNumberY	= tempBmpTileStartY;

		int tempMapTileStartX		= tempMapTileSelectRect.left / tempTileSize;
		int tempMapTileStartY		= tempMapTileSelectRect.top  / tempTileSize;
		int tempCurMapTileNumberX	= tempMapTileStartX;
		int tempCurMapTileNumberY	= tempMapTileStartY;

		
		//	 ȸ..... ⼭ ʺ ÿ  ..(äϱ..)

		int tempCopyNumberX = tempMapTileSelectRect.Width()  / tempTileSize;
		int tempCopyNumberY = tempMapTileSelectRect.Height() / tempTileSize;

		CTileDataList *ptempTileDataNode = NULL;
		CMapDataList *ptempMapDataNode = NULL;
		
		for(int y = 0 ; y < tempCopyNumberY ; y ++ )
		{
			//	 ׸ Ÿϰ ʺ Ÿ 带 ...

			pDoc->m_TileDataList.SetCurOperatorNode(tempBmpBaseTileNumber);
			pDoc->m_MapDataList.SetCurOperatorNode (tempMapBaseTileNumber);

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
		
			for(int x = 0 ; x < tempCopyNumberX; x++)
			{
			
				ptempTileDataNode = pDoc->m_TileDataList.GetCurOperatorNode();
				ptempMapDataNode = pDoc->m_MapDataList.GetCurOperatorNode();
		
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( ptempTileDataNode )
				if( ptempMapDataNode  )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				{
					//	ȣ Է...

					ptempMapDataNode -> m_MapTileAttribution 	= ptempTileDataNode -> m_TileAttribution;
					ptempMapDataNode -> m_MapTileIndexNumber	= ptempTileDataNode -> m_TileIndexNumber;
								
					++pDoc -> m_TileDataList;
					++pDoc -> m_MapDataList;
					
					//	  ϳ ......

					++tempCurBmpTileNumberX;
					++tempCurMapTileNumberX;
					
					//	 X  ȣ Ѱġ Ѿ... ٽ ʱȭ..
					if( tempCurBmpTileNumberX >= tempMaxBmpTileNumberX )
					{
						pDoc->m_TileDataList.SetCurOperatorNode(tempBmpBaseTileNumber);
						tempCurBmpTileNumberX = tempBmpTileStartX;
					}

				}

			}		//	ϴ X  ...
			
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			{
				//	 ....

				tempBmpBaseTileNumber += tempMaxBmpTileNumberPerLine;
				tempMapBaseTileNumber += tempMaxMapTileNumberPerLine;

				++ tempCurBmpTileNumberY;
				++ tempCurMapTileNumberY;

				//	X ġ ʱȭ...

				tempCurBmpTileNumberX = tempBmpTileStartX;
			}

			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!

			//	Y   ̸  ʱȭ.........

			if( tempCurBmpTileNumberY >= tempMaxBmpTileNumberY )
			{
				tempBmpBaseTileNumber = tempBmpDefaultBaseTileNumber;
				tempCurBmpTileNumberY = tempBmpTileStartY;
			}

		}



		//	۷ ڸ ʱȭ.............

		pDoc->m_TileDataList.SetCurOperatorNodeDefault();
		pDoc->m_MapDataList.SetCurOperatorMemberDefault();
		


		//	̴  ..

		pMF -> GetMiniView() -> DrawMapTileFromMapView(tempMiniBaseTileNumber, tempCopyNumberX, tempCopyNumberY);

		//	ȭ ..

		Invalidate(FALSE);
	
		return TRUE;
	}

	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////////
//  ʺ信 õ  콺  ǥ ä (ǻ ....)
/////////////////////////////////////////////////////////////////////////////////
	
BOOL CMapView::FillTileSelectRectFromMapView()
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......

	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	int tempTileSize = pDoc->GetTileSize();


	if( m_CurTileSelectRect.Width() < tempTileSize )
		return FALSE;

	if( m_CurTileSelectRect.Height() < tempTileSize )
		return FALSE;

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();


	//	콺  ǥ ..

	CPoint tempScrolledPoint	= m_MousePoint + GetScrollPosition(); 

	//	 ִ ũ ˾Ƴ..

	CSize tempMaxMapSize = pDoc -> GetMaxMapSize();

	tempMaxMapSize.cx =	( tempMaxMapSize.cx / tempTileSize ) * tempTileSize;
	tempMaxMapSize.cy =	( tempMaxMapSize.cy / tempTileSize ) * tempTileSize;
	
	//	 信 Ÿ ִ ѹ..
	
	int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
	int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;


	if(m_TileSelectOn)
	{
		//	õ ..............
		CRect tempMapTileSelRect = m_CurTileSelectRect;

		//	ʺ信 Ÿ ִ ѹ..
		
		int tempMaxMapTileNumberPerLine		= tempMaxMapSize.cx	/ tempTileSize;
		int tempMaxMapTileNumberForHeight	= tempMaxMapSize.cy / tempTileSize;
		
		//	 Ÿ  ȣ ˾Ƴ..........(ʺ ۹ȣ...)

		int tempSelRectStartX = tempMapTileSelRect.left	/ tempTileSize;
		int tempSelRectStartY = tempMapTileSelRect.top	/ tempTileSize;

		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		CPoint tempSelRectPoint( tempMapTileSelRect.left, tempMapTileSelRect.top );
		int tempMapSelRectTileNumber = GetTileNumberWithPoint( tempSelRectPoint );

		//	 Ѱġ ........

		int tempMaxMapTileNumberX	= tempMaxMapSize.cx / tempTileSize;
		int tempMaxMapTileNumberY	= tempMaxMapSize.cy / tempTileSize;

		//	 ȣ   ġ ..

		int tempMapTileStartX		= tempMapTileSelRect.left / tempTileSize;
		int tempMapTileStartY		= tempMapTileSelRect.top  / tempTileSize;

		int tempCurMapTileNumberX	= tempMapTileStartX;
		int tempCurMapTileNumberY	= tempMapTileStartY;

		
		//	 ȸ..... ⼭ ʺ ÿ  ..(äϱ..)

		int tempCopyNumberX = tempMapTileSelRect.Width()  / tempTileSize;
		int tempCopyNumberY = tempMapTileSelRect.Height() / tempTileSize;

		//	ŸϿ  ӽ  .....

		int tempMapTileIndexNumber = -1;
		int tempMapTileAttribution = -1;

		//	 ũ Ʈ ִ ͵ ......

		pDoc->m_MapBufferDataList.DelLinkedListAll();

		//	ӽ ũ Ʈ ...

		CMapDataList *ptempMapDataNode = NULL;
		CMapDataList *ptempBufDataNode = NULL;


		//	 õ  ӽ  ũ Ʈ ...

		for(int y = 0 ; y < tempCopyNumberY ; y ++ )
		{
			//	 ʺ   Ÿ 带 ...

			pDoc->m_MapDataList.SetCurOperatorNode(tempMapSelRectTileNumber);

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
		
			for(int x = 0 ; x < tempCopyNumberX; x++)
			{
				ptempMapDataNode = pDoc->m_MapDataList.GetCurOperatorNode();
		
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				if( ptempMapDataNode )
				{
					//	ȣ Է...

					tempMapTileIndexNumber	= ptempMapDataNode -> m_MapTileIndexNumber;
					tempMapTileAttribution	= ptempMapDataNode -> m_MapTileAttribution;
					
					//	ۿ ũ Ʈ .........
					
					pDoc->m_MapBufferDataList.AddLinkedList(tempMapTileIndexNumber, tempMapTileAttribution);

					//	 ʵ ũ Ʈ   ̵..
					
					++pDoc -> m_MapDataList;

					//	  ϳ ......

					++tempCurMapTileNumberX;
				}
			}		//	ϴ X  ...
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			{
				//	 ....
				tempMapSelRectTileNumber += tempMaxMapTileNumberPerLine;
				++ tempCurMapTileNumberY;
			}
			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!
		}


		
		///////////////////////////////////////////////////////////////////////////////		
		//	ӽ  ũ Ʈ ִ   콺 Ϳ ..
		///////////////////////////////////////////////////////////////////////////////		

		/////////////////////////////////////////////////////////
		// ʺ信  ŸϿ  ͵ ....


		int tempMaxBufTileNumberX	= tempMapTileSelRect.Width()  / tempTileSize;
		int tempMaxBufTileNumberY	= tempMapTileSelRect.Height() / tempTileSize;

		int tempMaxBufTileNumberPerLine		= tempMapTileSelRect.Width()	/ tempTileSize;
		int tempMaxBufTileNumberForHeight	= tempMapTileSelRect.Height()	/ tempTileSize;
		
		int tempBufTileStartX		= 0;
		int tempBufTileStartY		= 0;

		int tempCurBufTileNumberX	= tempBufTileStartX;
		int tempCurBufTileNumberY	= tempBufTileStartY;

		//	ŸϿ  ӽ  .....

		tempMapTileIndexNumber = -1;
		tempMapTileAttribution = -1;

		//	 ũ Ʈ    ̹Ƿ...

		int tempBufTileNumber = 0;

		//	  ũ Ʈ  ó.............
		//////////////////////////////////////////////////////////////////

		CPoint tempBasePoint = tempScrolledPoint;

		//	  ǥ ...

		if( tempBasePoint.x > tempMaxMapSize.cx )
			tempBasePoint.x = ( tempMaxMapSize.cx - ( tempTileSize >> 1) );

		if( tempBasePoint.y > tempMaxMapSize.cy )
			tempBasePoint.y = ( tempMaxMapSize.cy - ( tempTileSize >> 1) );

		// ʺ信 Ÿ ۹ȣ ˾Ƴ..

		int tempMapBaseTileNumber = GetTileNumberWithPoint( tempBasePoint );
		int tempMiniBaseTileNumber = tempMapBaseTileNumber;


		//	ʵ    .....

		tempMapTileStartX		= tempBasePoint.x / tempTileSize;
		tempMapTileStartY		= tempBasePoint.y / tempTileSize;

		tempCurMapTileNumberX	= tempMapTileStartX;
		tempCurMapTileNumberY	= tempMapTileStartY;

		//	 ۿ ִ   ͷ ű...
		
		ptempMapDataNode = NULL;
		ptempBufDataNode = NULL;

		for(y = 0 ; y < tempCopyNumberY ; y ++ )
		{
			//	 ʺ   Ÿ 带 ...

			pDoc->m_MapBufferDataList.SetCurOperatorNode ( tempBufTileNumber );
			pDoc->m_MapDataList.SetCurOperatorNode ( tempMapBaseTileNumber );

			//	 Ÿ X ȣ ..

			tempCurMapTileNumberX = tempMapTileStartX;
			tempCurBufTileNumberX = tempBufTileStartX;
			
			for(int x = 0 ; x < tempCopyNumberX; x++)
			{
				ptempBufDataNode = pDoc->m_MapBufferDataList.GetCurOperatorNode();
				ptempMapDataNode = pDoc->m_MapDataList.GetCurOperatorNode();

				
				if( tempCurBufTileNumberX < tempMaxBufTileNumberX )
				if( tempCurBufTileNumberY < tempMaxBufTileNumberY )
				if( tempCurBufTileNumberX < tempMaxBufTileNumberPerLine )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberX )
				if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
				if( tempCurMapTileNumberX < tempMaxMapTileNumberPerLine )
				if( ptempMapDataNode )
				if( ptempBufDataNode )
				{
					//	ۿ ִ  Է...

					tempMapTileIndexNumber	= ptempBufDataNode -> m_MapTileIndexNumber;
					tempMapTileAttribution	= ptempBufDataNode -> m_MapTileAttribution;
					
					//	ۿ    Ϳ Է...

					ptempMapDataNode->m_MapTileIndexNumber = tempMapTileIndexNumber;
					ptempMapDataNode->m_MapTileAttribution = tempMapTileAttribution;
					
					//	 ʵ ũ Ʈ   ̵..

					++pDoc -> m_MapBufferDataList;
					++pDoc -> m_MapDataList;

					//	  ϳ ......

					++tempCurBufTileNumberX;
					++tempCurMapTileNumberX;
				}
			}		//	ϴ X  ...
			
			if( tempCurMapTileNumberY < tempMaxMapTileNumberY )
			if( tempCurBufTileNumberY < tempMaxBufTileNumberY )
			{
				//	 ....
				tempMapBaseTileNumber += tempMaxMapTileNumberPerLine;
				++ tempCurMapTileNumberY;

				tempBufTileNumber += tempMaxBufTileNumberPerLine;
				++ tempCurBufTileNumberY;
			}
			//	 ٽ X  ƺ............ õ ų б ..  ѷް ..!!
		}
		

		//	۷ ڸ ʱȭ.............

		pDoc->m_MapDataList.SetCurOperatorMemberDefault();
		pDoc->m_MapBufferDataList.SetCurOperatorMemberDefault();


		//	 ۿ ִ   ...........
		pDoc->m_MapBufferDataList.DelLinkedListAll();
		
		
		//	̴  ..
		pMF -> GetMiniView() -> DrawMapTileFromMapView(tempMiniBaseTileNumber, tempCopyNumberX, tempCopyNumberY);
		
		//	ȭ ..
		Invalidate(FALSE);
	
		return TRUE;
	}

	return FALSE;
}
	

/////////////////////////////////////////////////////////////////////////////////	
/////////////////////////////////////////////////////////////////////////////////
//
//	 ޼ Լ ó..................
//
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

void CMapView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	CPoint tempGetScrollPosition = GetScrollPosition();

	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return ;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return ;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return ;
	
	int tempTileSize = pDoc->GetTileSize();

	//	 ũ      ׸  ׸..
	if( tempTileSize > abs(m_OldGetScrollPosition.x - tempGetScrollPosition.x) )
	{
		Invalidate(FALSE);
	}


	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CMapView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CPoint tempGetScrollPosition = GetScrollPosition();

	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return ;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return ;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return ;
	
	int tempTileSize = pDoc->GetTileSize();

	//	 ũ      ׸  ׸..
	if( tempTileSize > abs(m_OldGetScrollPosition.y - tempGetScrollPosition.y) )
	{
		Invalidate(FALSE);
	}

	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}


void CMapView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
}

void CMapView::OnSize(UINT nType, int cx, int cy) 
{
	CScrollView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	SetScrollSize();
}


void CMapView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//	  ..
	
	//	m_DrawTileSelectLineOn = FALSE;

	CScrollView::OnLButtonUp(nFlags, point);
}

BOOL CMapView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
    CBrush br( m_ColBG ); 
    FillOutsideRect( pDC, &br );
    return FALSE;

	return CScrollView::OnEraseBkgnd(pDC);
}

void CMapView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	
	//	 üũ.........

	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;

	CDC *ptempMemDC		= pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return;

	CDC *ptempBufferDC	= pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return;


	//	޴ .........

	CMenu tempPopup;
	CMenu *tempPopupMenu;
	
	tempPopup.LoadMenu(IDR_POPUP_MENU_MAP_VIEW);

	tempPopupMenu = tempPopup.GetSubMenu(0);
	tempPopupMenu -> TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
	
}

void CMapView::OnMapViewTileSelectDelRect() 
{
	// TODO: Add your command handler code here
	
	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;

	CDC *ptempMemDC		= pDoc->m_MapViewMemDC.GetMemDC();
	if(! ptempMemDC)	return;

	CDC *ptempBufferDC	= pDoc->m_MapBufferDC.GetMemDC();
	if(! ptempBufferDC)	return;

	EraseTileSelectRect();

}

void CMapView::OnMapViewSetPenSize(UINT nID)
{
	m_nPenSizeCheck = nID;
	
	if(nID == ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_1)
			m_PenSize = 1;
	else if(nID == ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_2)
			m_PenSize = 2;
	else if(nID == ID_MAP_VIEW_SET_TILE_LINE_PEN_SIZE_4)
			m_PenSize = 4;
	else
		m_PenSize = 2;

	Invalidate(FALSE);
}

void CMapView::OnUpdateMapViewSetPenSizeCheck(CCmdUI *pCmdUI)
{
	pCmdUI -> SetCheck(m_nPenSizeCheck == pCmdUI -> m_nID);
}

void CMapView::OnMapViewSetShowText(UINT nID)
{

	m_nSetShowText = nID;
	
	if(nID == ID_MAP_VIEW_SHOW_TILE_INDEX_NUMBER)
	{
		m_TileIndexOn		= TRUE;		//	Ÿ ε ȣ ...
		m_TileNumberOn		= FALSE;		//	Ÿ ʻ󿡼 ȣ ..
		m_TileAttributionOn	= FALSE;			//	Ÿ Ӽ ...
	}
	
	else if(nID == ID_MAP_VIEW_SHOW_TILE_ATTRIBUTION_NUMBER)
	{
		m_TileIndexOn		= FALSE;		//	Ÿ ε ȣ ...
		m_TileNumberOn		= FALSE;		//	Ÿ ʻ󿡼 ȣ ..
		m_TileAttributionOn	= TRUE;			//	Ÿ Ӽ ...
	}

	else if(nID == ID_MAP_VIEW_SHOW_TILE_SERIAL_NUMBER)
	{
		m_TileIndexOn		= FALSE;		//	Ÿ ε ȣ ...
		m_TileNumberOn		= TRUE;			//	Ÿ ʻ󿡼 ȣ ..
		m_TileAttributionOn	= FALSE;		//	Ÿ Ӽ ...
	}

	else if(nID == ID_MAP_VIEW_SHOW_TILE_NO_NUMBER)
	{
		m_TileIndexOn		= FALSE;		//	Ÿ ε ȣ ...
		m_TileNumberOn		= FALSE;		//	Ÿ ʻ󿡼 ȣ ..
		m_TileAttributionOn	= FALSE;		//	Ÿ Ӽ ...
	}

	else 
	{
		m_TileIndexOn		= FALSE;		//	Ÿ ε ȣ ...
		m_TileNumberOn		= FALSE;		//	Ÿ ʻ󿡼 ȣ ..
		m_TileAttributionOn	= FALSE;		//	Ÿ Ӽ ...
	}

	Invalidate(FALSE);
}



void CMapView::OnUpdateMapViewSetTextCheck(CCmdUI *pCmdUI)
{
	pCmdUI -> SetCheck(m_nSetShowText == pCmdUI -> m_nID);
}



void CMapView::OnMapViewShowTileOutLine() 
{
	// TODO: Add your command handler code here
	if(m_DrawTileOutLineOn)
		m_DrawTileOutLineOn = FALSE;
	else
		m_DrawTileOutLineOn = TRUE;

	Invalidate(FALSE);

}

void CMapView::OnUpdateMapViewShowTileOutLine(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	if(m_DrawTileOutLineOn) 
		pCmdUI->SetText("Ÿ 輱 ߱..........!!");
	
	else
		pCmdUI->SetText("Ÿ 輱 ֱ........!!");

}

void CMapView::OnMapViewSetTileOutLineColor() 
{
	// TODO: Add your command handler code here
	CColorDialog tempDlg;

	if(tempDlg.DoModal() == IDOK)
	{
		m_ColTileOutLine = tempDlg.GetColor();
		Invalidate(FALSE);
	}
}

void CMapView::OnMapViewSetTileSelectLineColor() 
{
	// TODO: Add your command handler code here
	CColorDialog tempDlg;

	if(tempDlg.DoModal() == IDOK)
	{
		m_ColTileSelLine = tempDlg.GetColor();
		Invalidate(FALSE);
	}

}

void CMapView::OnMapViewSetTileNullColor() 
{
	// TODO: Add your command handler code here
	CColorDialog tempDlg;

	if(tempDlg.DoModal() == IDOK)
	{
		m_ColTileNull = tempDlg.GetColor();
		
		CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
		pMF -> GetMiniView() -> DrawAllMapTiletoMemDC();

		Invalidate(FALSE);
	}

}

void CMapView::OnMapViewTileSelectFillFromBmpView() 
{
	// TODO: Add your command handler code here
	
	FillTileSelectRectFromBmpView();
}

void CMapView::OnMapViewTileSelectFillFromMapView() 
{
	// TODO: Add your command handler code here
	
	FillTileSelectRectFromMapView();
}

void CMapView::OnMapViewSetRectAttribution() 
{
	// TODO: Add your command handler code here
	CMapDoc* pDoc = GetDocument();	//	 ó..............

	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return;


		CMapViewTileAttriInput tempDlg;

		int tempAttriNum(-1);

		//	  ޱ...........

		if( tempDlg.DoModal() == IDOK ) 
		{
			tempAttriNum = tempDlg.m_TileAttriNum;
			
			SetRectAttrNum(tempAttriNum);
		}

}

void CMapView::OnMapViewSetTileAttribution() 
{
	// TODO: Add your command handler code here
	CMapDoc* pDoc = GetDocument();	//	 ó..............

	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return;


		CMapViewTileAttriInput tempDlg;

		int tempAttriNum(-1);

		//	  ޱ...........

		if( tempDlg.DoModal() == IDOK ) 
		{
			tempAttriNum = tempDlg.m_TileAttriNum;
			
			SetTileAttrNum(tempAttriNum);
		}

}

void CMapView::OnMapViewSetAllAttribution() 
{
	// TODO: Add your command handler code here
	CMapDoc* pDoc = GetDocument();	//	 ó..............

	if(! pDoc->m_Bmp.BmpOn() )						return;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return;


	CSetAllAttriNumDlg tempDlg;

	int tempSourIndexNum(0);
	int tempTargetAttriNum(-1);

	//	  ޱ...........

	if( tempDlg.DoModal() == IDOK ) 
	{
		tempSourIndexNum	= tempDlg.m_SourIndexNum;
		tempTargetAttriNum	= tempDlg.m_TargetAttriNum;

		SetAllAttrNum(tempSourIndexNum, tempTargetAttriNum);
	}
}
