// MemDC.cpp: implementation of the CMemDC class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MemDC.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMemDC::CMemDC()
{
	m_MemDCSize.cx = 0;			// ޸DC X ִ밪......
	
	m_MemDCSize.cy = 0;			// ޸DC Y ִ밪......

	m_pMemDC	= NULL;				// ޸DC  ּ..........
}

CMemDC::~CMemDC()
{
	DeleteMemDC();
}

///////////////////////////////////////////////////////////////////////
//    ʿ  ϱ........
///////////////////////////////////////////////////////////////////////

BOOL CMemDC::DeleteMemDC()
{				// ޸ DC  ..
	if(GetMemDCOn())
	{
		delete m_pMemDC;
		m_pMemDC = NULL;
		return TRUE;
	}

	return TRUE;
}


CDC * CMemDC::GetMemDC()								// ޸ DC ..
{
	return m_pMemDC;
}			

BOOL CMemDC::GetMemDCOn()
{
	if(m_pMemDC != NULL)	return TRUE;
	else					return FALSE;		// ޸ DC  Ǿ Ȯ..
}

CSize CMemDC::GetMemDCSize()								// ޸ DC ..
{
	return m_MemDCSize;
}			


///////////////////////////////////////////////////////////////////////
//    ʿ  ϱ........
///////////////////////////////////////////////////////////////////////

BOOL CMemDC::CreateMemDC(CDC *pSourceViewGetDC, CSize memDCSize, COLORREF bgColor)	// ޸ DC ...   ĥ...
{
	if (memDCSize.cx <= 0 ) return FALSE;		//	 Ȯ.....
	if (memDCSize.cy <= 0 ) return FALSE;		//	 Ȯ......
	
	DeleteMemDC();								// Ǿִ ޸ DC  ........

	CDC *ptempDC = pSourceViewGetDC;			// ȭ DC ....
	
	m_pMemDC	= new CDC;						// ޸ DC ....

	if(! m_pMemDC)	return FALSE;				// ޸ Ȯ.....

	m_MemDCSize = memDCSize;					// ׸ ũ Ȯ..

	m_pMemDC -> CreateCompatibleDC(ptempDC);	

	CBitmap bmpBuffer;
	
	bmpBuffer.CreateCompatibleBitmap( ptempDC, memDCSize.cx, memDCSize.cy );

	m_pMemDC -> SelectObject(&bmpBuffer);

	InitialDraw(bgColor);						//  ޸ DC  ׸..
		
	return TRUE;
}

BOOL CMemDC::InitialDraw(COLORREF bgColor)
{
	if(! GetMemDCOn())	return FALSE;

	CDC * ptempMemDC = GetMemDC();

	CSize tempMemDCSize	= GetMemDCSize();	// ޸ DC  ִ ũ..

	CPen tempPen, *ptempOldPen = NULL;
	
	CBrush tempBrush, *ptempOldBrush;	

	tempPen.CreatePen(PS_SOLID, 1, bgColor);
	
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( bgColor );

	ptempOldBrush = (CBrush *) ptempMemDC->SelectObject(&tempBrush);

	ptempMemDC->Rectangle(0, 0,	tempMemDCSize.cx, tempMemDCSize.cy);	

	ptempMemDC->SelectObject(ptempOldPen);

	ptempMemDC->SelectObject(ptempOldBrush);

	return TRUE;
}

BOOL CMemDC::DrawMemDCtoScreen(CDC *sourceViewDC) 
{
	if( ! GetMemDCOn() )	return FALSE;

	CDC * ptempMemDC = GetMemDC();

	CSize tempMemDCSize = GetMemDCSize();	// ޸ DC  ũ ý ...

	sourceViewDC -> BitBlt(0,				0,
		    	 		   tempMemDCSize.cx,	tempMemDCSize.cy,
						   ptempMemDC, 
						   0,				0, 
						   SRCCOPY);
 
	return TRUE;
}



BOOL BitBltMemDC(CRect sourceRect, CRect targetPoint)	// ޸ DC ƮƮ...
{
	
	
	return TRUE;
}


