// MiniView.cpp : implementation file
//

#include "stdafx.h"
#include "Map.h"
#include "MapDoc.h"

#include "MainFrm.h"
#include "MiniView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMiniView

IMPLEMENT_DYNCREATE(CMiniView, CScrollView)

CMiniView::CMiniView()
{
}

CMiniView::~CMiniView()
{
}


BEGIN_MESSAGE_MAP(CMiniView, CScrollView)
	//{{AFX_MSG_MAP(CMiniView)
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMiniView drawing

void CMiniView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 1;
	SetScrollSizes(MM_TEXT, sizeTotal);
}


/////////////////////////////////////////////////////////////////////////////
// CMiniView diagnostics

#ifdef _DEBUG
void CMiniView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CMiniView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CMapDoc* CMiniView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMapDoc)));
	return (CMapDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMiniView message handlers

void CMiniView::OnDraw(CDC* pDC)
{
	CMapDoc* pDoc = GetDocument();

	DrawMemDCtoScreen(pDC);

}

CSize CMiniView::GetMaxDrawSize()
{
	CMapDoc* pDoc = GetDocument();

	int tempPageNumX = pDoc->m_PageNumX;
	int tempPageNumY = pDoc->m_PageNumY;

	int tempTileNumX = pDoc->m_TileNumX;
	int tempTileNumY = pDoc->m_TileNumY;

	CSize tempMinTileSize = GetMinTileSize();

	CSize tempMaxDrawSize(0,0);

	tempMaxDrawSize.cx = tempMinTileSize.cx * tempPageNumX * tempTileNumX;
	tempMaxDrawSize.cy = tempMinTileSize.cy * tempPageNumY * tempTileNumY;

	return tempMaxDrawSize;
}


CSize CMiniView::GetMinTileSize()
{
	CMapDoc* pDoc = GetDocument();

	int tempPageNumX = pDoc->m_PageNumX;
	int tempPageNumY = pDoc->m_PageNumY;

	int tempTileNumX = pDoc->m_TileNumX;
	int tempTileNumY = pDoc->m_TileNumY;

	CSize tempMiniViewMemDCSize = pDoc->m_MiniViewMemDC.GetMemDCSize();

	CSize tempMinTileSize(0,0);

	tempMinTileSize.cx = tempMiniViewMemDCSize.cx / ( tempPageNumX * tempTileNumX );
	tempMinTileSize.cy = tempMiniViewMemDCSize.cy / ( tempPageNumY * tempTileNumY );

	return tempMinTileSize;
}



BOOL CMiniView::ClearMemDC()
{
	//	   ִ Ȳ ó......

	CMapDoc* pDoc = GetDocument();
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_TileDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_BmpViewMemDC.GetMemDCOn() )		return FALSE;

	CDC *ptempMemDC		= pDoc->m_MiniBufferDC.GetMemDC();
	if(! ptempMemDC)	return FALSE;


	//	׸  ..
	CRect tempTargetRect(0,0,0,0);
	CSize tempMaxMemDCSize = pDoc->m_MiniViewMemDC.GetMemDCSize();

	tempTargetRect.right	= tempMaxMemDCSize.cx;
	tempTargetRect.bottom	= tempMaxMemDCSize.cy;

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	COLORREF tempCol = pMF ->GetMapView() ->m_ColTileNull;


	tempPen.CreatePen(PS_SOLID, 1, tempCol );
	tempBrush.CreateSolidBrush ( tempCol );

	ptempOldPen		= (CPen *)		ptempMemDC->SelectObject (&tempPen);
	ptempOldBrush	= (CBrush *)	ptempMemDC->SelectObject(&tempBrush);

	ptempMemDC->Rectangle(&tempTargetRect);	

	ptempMemDC->SelectObject(ptempOldPen);
	ptempMemDC->SelectObject(ptempOldBrush);

	return TRUE;
}


BOOL CMiniView::DrawMemDCtoScreen(CDC *pDC) 
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_MiniViewMemDC.GetMemDCOn() )		return FALSE;

	//	Ÿ ũ ....
	int tempTileSize = pDoc->GetTileSize();

	//	׸ ũ........
	
	CSize tempMaxDrawSize = GetMaxDrawSize();

	CRect tempRect;

	GetClientRect(&tempRect);

	CDC * ptempMemDC = pDoc -> m_MiniViewMemDC.GetMemDC();
	CDC * ptempBufferDC = pDoc -> m_MiniBufferDC.GetMemDC();

	if(! ptempMemDC)		return FALSE;

	ptempMemDC -> BitBlt(0,	0,						//	׷ ũ ǥ
						 tempMaxDrawSize.cx,
						 tempMaxDrawSize.cy,

						 ptempBufferDC,			//   ޸ DC...
						 0, 0,					// ҽ ׸ Y ǥ..

						 SRCCOPY);

	
	DrawMapViewScreenLine();

	//	 ȭ鿡 ׸...................

	pDC-> StretchBlt(	0,	0,					//	׷ ũ ǥ
						tempRect.right,			//	׷ ũ 
						tempRect.bottom,		//	׷ ũ 

						ptempMemDC,					//	׷  ޸ DC...
						0,	0,						// ҽ ׸ Y ǥ..

						tempMaxDrawSize.cx,
						tempMaxDrawSize.cy,

						SRCCOPY);

	return TRUE;
}



BOOL CMiniView::DrawMapViewScreenLine()
{
	CMapDoc* pDoc = GetDocument();
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	CDC *ptempMemDC = pDoc->m_MiniViewMemDC.GetMemDC();

	CMapView *ptempMapView = pMF->GetMapView();
	
	int tempTileSize = pDoc->GetTileSize();

	CPoint tempMapViewPoint = ptempMapView->GetScrollPosition();
	CRect  tempMapViewRect;
	
	ptempMapView->GetClientRect(&tempMapViewRect);

	CRect tempTargetRect(0,0,0,0);

	tempTargetRect = tempMapViewRect;
	
	tempTargetRect.left = tempMapViewPoint.x;
	tempTargetRect.top  = tempMapViewPoint.y;

	tempTargetRect.right	= tempMapViewPoint.x + tempMapViewRect.right  + tempTileSize;
	tempTargetRect.bottom	= tempMapViewPoint.y + tempMapViewRect.bottom + tempTileSize;

	CSize tempMaxMapSize = pDoc->GetMaxMapSize();
	
	tempTargetRect.left		/= tempTileSize;
	tempTargetRect.top		/= tempTileSize;
	tempTargetRect.right	/= tempTileSize;
	tempTargetRect.bottom	/= tempTileSize;

	CSize tempMinTileSize = GetMinTileSize();

	tempTargetRect.left	  *= tempMinTileSize.cx;
	tempTargetRect.right  *= tempMinTileSize.cx;
	tempTargetRect.top    *= tempMinTileSize.cy;
	tempTargetRect.bottom *= tempMinTileSize.cy;


	CSize tempMaxDrawSize = GetMaxDrawSize();
	if(tempTargetRect.right > tempMaxDrawSize.cx)
		tempTargetRect.right = tempMaxDrawSize.cx;

	if(tempTargetRect.bottom > tempMaxDrawSize.cy)
		tempTargetRect.bottom = tempMaxDrawSize.cy;

	CPen tempPen, *ptempOldPen = NULL;

	CRect tempMiniVewRect;
	GetClientRect(&tempMiniVewRect);

	CSize tempCorrectPenSize(0,0);

	tempCorrectPenSize.cx = tempMaxDrawSize.cx / tempMiniVewRect.right;
	tempCorrectPenSize.cy = tempMaxDrawSize.cy / tempMiniVewRect.bottom;
	
	int tempPenSize = tempCorrectPenSize.cx;
	
	if(tempCorrectPenSize.cx < tempCorrectPenSize.cy)
		tempPenSize = tempCorrectPenSize.cy;

	tempPenSize *= 2;

	if(tempPenSize <=0) tempPenSize = 10;
	
	COLORREF tempPenColor = RGB(255,255,255);

	tempPen.CreatePen(PS_SOLID, tempPenSize, tempPenColor);
	ptempOldPen = (CPen *) ptempMemDC->SelectObject (&tempPen);
	ptempMemDC->SelectObject( GetStockObject (NULL_BRUSH) );

	ptempMemDC->Rectangle(&tempTargetRect);	
	ptempMemDC->SelectObject(ptempOldPen);
	return TRUE;
	
}


BOOL CMiniView::DrawMapTileFromMapView(int baseTileNumber, int copyTileNumberX, int copyTileNumberY)
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_MiniViewMemDC.GetMemDCOn() )		return FALSE;
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	CDC * ptempMemDC = pDoc -> m_MiniBufferDC.GetMemDC();

	int	  tempTileSize		= pDoc->GetTileSize();
	CSize tempMaxMemDCSize	= pDoc->m_MiniViewMemDC.GetMemDCSize();

	CSize tempMaxDrawSize	= GetMaxDrawSize();
	CSize tempMinTileSize	= GetMinTileSize();

	
	////////////////////////////////////////////////////////////////////////
	//   ĥϱ  ó..			
	////////////////////////////////////////////////////////////////////////

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	COLORREF tempColTileNull = pMF ->GetMapView() ->m_ColTileNull;

	tempPen.CreatePen(PS_SOLID, 1, tempColTileNull);
	ptempOldPen = (CPen *) ptempMemDC -> SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( tempColTileNull );
	ptempOldBrush = (CBrush *) ptempMemDC -> SelectObject(&tempBrush);

	CRect tempTargetRect(0,0,0,0);


	int tempMapTileIndexNumber = 0;	//  ׷ Ÿ ӽ ε ȣ..
	
	//	Ÿ ȣ Y ȣ  (ü ʿ X  Ÿ ..)

	CSize tempMaxMapSize = pDoc->GetMaxMapSize();
	
	int tempTileNumberPerLine		= tempMaxMapSize.cx / tempTileSize;

	int tempBmpTileNumberPerLine	= ( ( pDoc->m_Bmp.GetWidth() / tempTileSize ) * tempTileSize )	/ tempTileSize;
	
	int tempBmpTileNumberPerLineSet	= tempBmpTileNumberPerLine -1;	
	
	int tempBaseTileNumber = baseTileNumber;

	tempTargetRect.left = ( tempBaseTileNumber %  tempTileNumberPerLine) * tempMinTileSize.cx;
	tempTargetRect.top  = ( tempBaseTileNumber /  tempTileNumberPerLine ) * tempMinTileSize.cy;

	tempTargetRect.right	= tempTargetRect.left + ( copyTileNumberX * tempMinTileSize.cx);
	tempTargetRect.bottom	= tempTargetRect.top  + ( copyTileNumberY * tempMinTileSize.cy);
	
	
	// ũ Ʈ   2  ............
	
	int tempAddNumberForY	=	tempTileNumberPerLine;

	CMapDataList *ptempNode = NULL;
	
	// ũ Ʈ Ÿ ȣ   ..
	
	int tempCurTileNumber = baseTileNumber;
	int tempMaxTileNumber = pDoc->m_MapDataList.GetLinkedListMaxNumber();

	/////////////////////////////////////////////////////////////////////////
	//	8Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

	if(pDoc->m_Bmp.m_BitCount == 8)
	{
		//	ķƮ ...
		HPALETTE hPalette=NULL, hOldPalette=NULL;	
		RGBQUAD *pTempPalette;	
		pTempPalette = pDoc-> m_Bmp.m_pBmpPalette;	
		struct	{	WORD Version;	WORD NumberOfEntries;	PALETTEENTRY aEntries[256];	} logicalPalette = {0x300,256};	for(int i =0 ; i < pDoc->m_Bmp.m_BitCount ; i++)	{	logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;	logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;
		
		logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;	logicalPalette.aEntries[i].peFlags = 0;	}
		hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);	
		
		hOldPalette = SelectPalette(ptempMemDC->m_hDC,hPalette,FALSE);	
		RealizePalette(ptempMemDC->m_hDC);		

		for(int y = tempTargetRect.top ; y < tempTargetRect.bottom ; y += tempMinTileSize.cy)
		{

			if(tempCurTileNumber < tempMaxTileNumber)
				pDoc->m_MapDataList.SetCurOperatorNode(tempCurTileNumber);
			
			for(int x = tempTargetRect.left ; x < tempTargetRect.right ; x += tempMinTileSize.cx)
			{
				ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();

				if(ptempNode)
				{

					tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
				
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempMinTileSize.cx, y + tempMinTileSize.cy);
					
					else
						StretchDIBits( ptempMemDC->m_hDC,
									   x,  y,  
									   tempMinTileSize.cx, tempMinTileSize.cy,

									   (tempMapTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   
									   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,

									   tempTileSize, tempTileSize,
									   
									   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					++pDoc->m_MapDataList;
				}
				
			}	//	 X   ó..

			tempCurTileNumber += tempTileNumberPerLine;
		}	

		SelectPalette(ptempMemDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
	}		
	
	else if(pDoc->m_Bmp.m_BitCount == 24)
	{
		for(int y = tempTargetRect.top ; y < tempTargetRect.bottom ; y += tempMinTileSize.cy)
		{

			if(tempCurTileNumber < tempMaxTileNumber)
				pDoc->m_MapDataList.SetCurOperatorNode(tempCurTileNumber);
			
			for(int x = tempTargetRect.left ; x < tempTargetRect.right ; x += tempMinTileSize.cx)
			{
				ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();

				if(ptempNode)
				{

					tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
				
					if(tempMapTileIndexNumber < 0)	//	  ó.......
						ptempMemDC -> Rectangle( x, y, x + tempMinTileSize.cx, y + tempMinTileSize.cy);
					
					else
						StretchDIBits( ptempMemDC->m_hDC,
									   x,  y,  
									   tempMinTileSize.cx, tempMinTileSize.cy,

									   (tempMapTileIndexNumber & tempBmpTileNumberPerLineSet) * tempTileSize,   
									   pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,

									   tempTileSize, tempTileSize,
									   
									   pDoc->m_Bmp.m_pImageBit,  (BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,  DIB_RGB_COLORS,	SRCCOPY	  );

					++pDoc->m_MapDataList;
				}
				
			}	//	 X   ó..

			tempCurTileNumber += tempTileNumberPerLine;
		}	

	}		

	ptempMemDC -> SelectObject(ptempOldPen);
	ptempMemDC -> SelectObject(ptempOldBrush);


	Invalidate(FALSE);
	
	return TRUE;
}


	
BOOL CMiniView::DrawAllMapTiletoMemDC() 
{
	CMapDoc* pDoc = GetDocument();

	ClearMemDC();

	CDC * ptempMemDC = pDoc -> m_MiniBufferDC.GetMemDC();

	///////////////////////////////////////////////////////////////////////////
	//	׸ ׸  ϱ  ڰ ؿ   ......
	///////////////////////////////////////////////////////////////////////////
	
	int	  tempTileSize		= pDoc->GetTileSize();
	CSize tempMaxMemDCSize	= pDoc->m_MiniViewMemDC.GetMemDCSize();

	CSize tempMaxDrawSize	= GetMaxDrawSize();
	CSize tempMinTileSize	= GetMinTileSize();
	
	if(tempMinTileSize.cx <=0)	return FALSE;
	if(tempMinTileSize.cy <=0)	return FALSE;

	if(tempMaxDrawSize.cx <=0)	return FALSE;
	if(tempMaxDrawSize.cy <=0)	return FALSE;

	if(tempMaxDrawSize.cx > tempMaxMemDCSize.cx)	return FALSE;
	if(tempMaxDrawSize.cy > tempMaxMemDCSize.cy)	return FALSE;
	

	////////////////////////////////////////////////////////////////////////
	//   ĥϱ  ó..			
	////////////////////////////////////////////////////////////////////////

	CPen tempPen, *ptempOldPen = NULL;
	CBrush tempBrush, *ptempOldBrush;	

	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();
	COLORREF tempCol = pMF ->GetMapView() ->m_ColTileNull;


	tempPen.CreatePen(PS_SOLID, 1, tempCol);
	ptempOldPen = (CPen *) ptempMemDC -> SelectObject (&tempPen);

	tempBrush.CreateSolidBrush ( tempCol );
	ptempOldBrush = (CBrush *) ptempMemDC -> SelectObject(&tempBrush);


	///////////////////////////////////////////////////////////////////////////
	// ۷   ũ帮Ʈ ...
	///////////////////////////////////////////////////////////////////////////

	CMapDataList *ptempNode = NULL;

	// ũ Ʈ Ÿ ȣ   ..
	//	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	int tempMapTileIndexNumber = 0;	//  ׷ Ÿ ӽ ε ȣ..
	
	///////////////////////////////////////////////////////////////////////////
	// ׷ Ÿ ũ Ʈ  ڰ    ..
	///////////////////////////////////////////////////////////////////////////

	int tempBmpTileNumberPerLine	= ( ( pDoc->m_Bmp.GetWidth() / tempTileSize ) * tempTileSize )	/ tempTileSize;

	int tempBaseTileNumber = 0;

	pDoc->m_MapDataList.SetCurOperatorNode(tempBaseTileNumber);

	//  ۷     Ǿ Ȯ.. 

	/////////////////////////////////////////////////////////////////////////
	//	8Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

	ClearMemDC();

  	if(pDoc->m_Bmp.m_BitCount == 8)
	{
		HPALETTE hPalette=NULL, hOldPalette=NULL;	
		RGBQUAD *pTempPalette;	
		pTempPalette = pDoc-> m_Bmp.m_pBmpPalette;	
		struct	{	WORD Version;	WORD NumberOfEntries;	PALETTEENTRY aEntries[256];	} logicalPalette = {0x300,256};	for(int i =0 ; i < pDoc->m_Bmp.m_BitCount ; i++)	{	logicalPalette.aEntries[i].peRed   = pTempPalette[i].rgbRed;	logicalPalette.aEntries[i].peGreen = pTempPalette[i].rgbGreen;	logicalPalette.aEntries[i].peBlue  = pTempPalette[i].rgbBlue;	logicalPalette.aEntries[i].peFlags = 0;	}	hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);	hOldPalette = SelectPalette(ptempMemDC->m_hDC,hPalette,FALSE);	RealizePalette(ptempMemDC->m_hDC);		
		
		for(int y = 0; y < tempMaxDrawSize.cy ; y += tempMinTileSize.cy)
		{
			for(int x = 0; x < tempMaxDrawSize.cx ; x += tempMinTileSize.cx)
			{
				ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();
				if(ptempNode)
				{

				tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
				
				if(tempMapTileIndexNumber < 0)	//	  ó.......
					ptempMemDC -> Rectangle( x, y, x + tempMinTileSize.cx, y + tempMinTileSize.cy);
				
				else
					StretchDIBits(	ptempMemDC->m_hDC,
									x,  y,  
									tempMinTileSize.cx,  tempMinTileSize.cy,
									
									(tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,
									pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,

									tempTileSize,	tempTileSize,
									
									pDoc->m_Bmp.m_pImageBit,  
									(BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,
									DIB_RGB_COLORS,	SRCCOPY	  );

			
				++pDoc->m_MapDataList;
				}
			}	//	 X   ó..
			
		}	

		SelectPalette(ptempMemDC->m_hDC,hOldPalette,FALSE);
		DeleteObject(hPalette);
	}

	/////////////////////////////////////////////////////////////////////////
	//	24Ʈ Ÿ ׸.....	/////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////

  	if(pDoc->m_Bmp.m_BitCount == 24)
	{
		for(int y = 0; y < tempMaxDrawSize.cy ; y += tempMinTileSize.cy)
		{
			for(int x = 0; x < tempMaxDrawSize.cx ; x += tempMinTileSize.cx)
			{
				ptempNode = pDoc->m_MapDataList.GetCurOperatorNode();
				if(ptempNode){

				tempMapTileIndexNumber = ptempNode->m_MapTileIndexNumber;
				
				if(tempMapTileIndexNumber < 0)	//	  ó.......
					ptempMemDC -> Rectangle( x, y, x + tempMinTileSize.cx, y + tempMinTileSize.cy);
				
				else
					StretchDIBits(	ptempMemDC->m_hDC,
									x,  y,  
									tempMinTileSize.cx,  tempMinTileSize.cy,
									
									(tempMapTileIndexNumber %  tempBmpTileNumberPerLine) * tempTileSize,
									pDoc->m_Bmp.m_BmpHeight - (tempMapTileIndexNumber / tempBmpTileNumberPerLine) * tempTileSize - tempTileSize,

									tempTileSize,	tempTileSize,
									
									pDoc->m_Bmp.m_pImageBit,  
									(BITMAPINFO*) pDoc->m_Bmp.m_pBmpInfoHeader,
									DIB_RGB_COLORS,	SRCCOPY	  );

			
				++pDoc->m_MapDataList;
				}
			}	//	 X   ó..
		}
	}

	//	ó ...  ģ ̶ ..

	ptempMemDC -> SelectObject(ptempOldPen);
	ptempMemDC -> SelectObject(ptempOldBrush);

	Invalidate(FALSE);

	return TRUE;
}


void CMiniView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	Invalidate(FALSE);

	CScrollView::OnRButtonDown(nFlags, point);
}

void CMiniView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	DoLButtonDown(point);

	//	   ִ Ȳ ó......

	CScrollView::OnLButtonDown(nFlags, point);
}


BOOL CMiniView::DoLButtonDown(CPoint point) 
{
	CMapDoc* pDoc = GetDocument();

	//	   ִ Ȳ ó......
	if(! pDoc->m_Bmp.BmpOn() )						return FALSE;
	if(! pDoc->m_MapDataList.GetLinkedListOn() )	return FALSE;
	if(! pDoc->m_MapViewMemDC.GetMemDCOn() )		return FALSE;
	if(! pDoc->m_MiniViewMemDC.GetMemDCOn() )		return FALSE;
	
	CMainFrame *pMF = (CMainFrame *) AfxGetMainWnd();

	CRect tempScreenRect(0,0,0,0);

	GetClientRect(&tempScreenRect);

	int	  tempTileSize		= pDoc->GetTileSize();
	CSize tempMaxDrawSize	= GetMaxDrawSize();
	CSize tempMinTileSize	= GetMinTileSize();

	CPoint tempScrollPoint(0,0);

	//	ǥ ̵...

	tempScrollPoint.x = (point.x * tempMaxDrawSize.cx / tempScreenRect.right ) / tempMinTileSize.cx * tempTileSize;
	tempScrollPoint.y = (point.y * tempMaxDrawSize.cy / tempScreenRect.bottom) / tempMinTileSize.cy * tempTileSize;

	CRect tempMapViewScreenRect(0,0,0,0);

	pMF->GetMapView()->GetClientRect(&tempMapViewScreenRect);

	CSize tempMaxMapSize = pDoc->GetMaxMapSize();

	if(tempMapViewScreenRect.right > tempMaxMapSize.cx)
		tempScrollPoint.x = 0;

	if(tempMapViewScreenRect.bottom > tempMaxMapSize.cy)
		tempScrollPoint.y = 0;


	pMF->GetMapView()->ScrollToPosition(tempScrollPoint);

	Invalidate(FALSE);

	return TRUE;
}
