// asm.cpp

//******************************************
// copyright 1998	Mickey Kawick
// This file may be used anywhere for free, but this
// comment info must be left here.

// If you use this code in any shape or form or even
// as a reference for profit send me a dollar. 
// Not a dollar per copy, just a single US dollar. 

// If you are not in the US, send me
// a few different coins or the equivalent of a dollar.
// I love foreign currency, and I have a little collection.
// MKawick@sprintmail.com
//******************************************

typedef unsigned short U16;
typedef U16*  U16ptr;

//**************************************************
void __fastcall Memset16Bit ( U16ptr dst, U16 fill, int num )
{
    if (num <= 0) return;
    if (num&1) *dst++ = fill; // one too many for stosd
    if (num <2) return;

 _asm
 {
    mov    ax, fill   // store value
    mov   ecx, num    // how many copies
    shl   eax, 16     // shift it into high order
    mov   edi, dst    // to where
    add    ax, fill   // do two pixels at a time
    shr   ecx, 1      // divide by 2

    rep   stosd
 }
}
//**************************************************
void __fastcall Memcpy16Bit ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;


	int test1 = (int) dest;
	if (test1&2)// to handle a misalligned destination address
	{
		*dest++ = *source++;
		if (num < 2) return;
		num--;
		if (!(num&1))
		{
			_asm
			{
				mov   ecx, num    // how many copies
				mov   edi, dest   // to where
				shr   ecx, 1
				mov   esi, source    // set source
				rep   movsd
			}				
		}
		else
		{
			_asm
			{
				mov   ecx, num    // how many copies
				mov   edi, dest   // to where
				shr   ecx, 1
				mov   esi, source    // set source

				rep   movsd
			}
			*(dest+num-1) = *(source+num-1);
		}
		return;
	}

	if (num&1) *dest++ = *source++;	// 1 too many for movsd
    if (num < 2) return;

	_asm
	{
		mov   ecx, num    // how many copies
		mov   edi, dest   // to where
		shr   ecx, 1
		mov   esi, source    // set source

		rep   movsd
	}
}
//**************************************************
void __fastcall Memcpy16BitLightened ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;


 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
	shr   ecx, 1
    mov   esi, source   // set source
light:
    
    mov   eax, esi
	add   esi, 2
	
	and   eax, 0x3DEF   // mask high bits 100001000010000
	add   edi, 2	

	shl	  eax, 1		// increase light value	
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  light
 }
}
//**************************************************
void __fastcall Memcpy16BitDarkened ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
	shr   ecx, 1
    mov   esi, source   // set source
dark:
    
    mov   eax, esi
	add   esi, 2
	
	and   eax, 0x421    // mask off low bits 000010000100001
	add   edi, 2	

	shr	  eax, 1		// decrease light value	
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  dark
 }
}
//**************************************************
//**************************************************
void __fastcall Memcpy15Bit50Percent ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat:
    
	mov   edx, [edi]
	add   edi, 2

	mov   eax, [esi]
	add   esi, 2	

	and   eax, 0x7BDE	// mask off low bits 111101111011110 // 31710
	and   edx, 0x7BDE	// mask off low bits 111101111011110 // 31710

	shr   eax, 1		// 50 % value
	dec   ecx			// counter stores flag

	shr   edx, 1
	mov   [edi-2], ax

	add   [edi-2], dx

	cmp   ecx, 0
	jg    repeat
 }
}
//**************************************************
void __fastcall Memcpy15Bit25Percent ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat:
    
	mov   ebx, [edi]	// this will be 25% of source lightening the background more
	mov   edx, [edi]	// this will be 50%
	
	and   ebx, 0x739C	// mask off low bits 111001110011100 //  29596
	mov   eax, [esi]	// this will be 25%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0x739C	// mask off low bits 111001110011100 //  29596

	mov	  [edi], bx		// result 25%
	and   edx, 0x7BDE	// mask off low bits 111101111011110 // 31710

	shr   eax, 2		// 25 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 1		// 50%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 25%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 50% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat
 }
}
//**************************************************
void __fastcall Memcpy15Bit75Percent ( U16ptr dest, U16ptr source, int num )
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat:
    
	mov   ebx, [esi]	// this will be 25% of source lightening the foreground more
	mov   edx, [edi]	// this will be 25%
	
	and   ebx, 0x739C	// mask off low bits 111001110011100 //  29596
	mov   eax, [esi]	// this will be 50%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0x7BDE	// mask off low bits 111101111011110 //  31710

	mov	  [edi], bx		// result 25%
	and   edx, 0x739C	// mask off low bits 111001110011100 // 29596

	shr   eax, 1		// 50 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 2		// 25%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 50%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 25% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat
 }
}
//**************************************************
//**************************************************
