//***************************
//***************** CDIB class file
//****************************************

#include "Cdib.h"
#include "WinInit.h"


/////////////////////////////////////////////////////////////
//        
CDib:: CDib(const char* fileName)
{
	LoadBitmapFile(fileName);
}
/////////////////////////////////////////////////////////////
//          ı
CDib:: ~CDib()
{
	//GlobalFree(m_pBmInfo);
	//if(m_pBmInfo!=NULL)	delete m_pBmInfo;
	free(m_pBmInfo);
}
/////////////////////////////////////////////////////////////
// ε Ʈ 
void CDib:: LoadBitmapFile( const char* fileName)
{
	HANDLE hFile;
	DWORD dwRead;
	hFile=CreateFile(fileName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	
	if(hFile==INVALID_HANDLE_VALUE) {
			CloseHandle(hFile);
			MessageBox(NULL,"ȭϾ!","!",MB_OK);
	}

	BITMAPFILEHEADER bmFileHeader;
	ReadFile(hFile,(void*)&bmFileHeader,sizeof(bmFileHeader),&dwRead,NULL);

	if(bmFileHeader.bfType!=0x4d42)
	{
		MessageBox(NULL,"Not a bitmap file type!","!",MB_OK);
		m_pBmFileHeader=0;
		m_pBmInfo=0;
		m_pBmInfoHeader=0;
		m_pRGBTable =0;
		m_pDibBits = 0;
		m_numColors=0;
	}
	else
	{
		DWORD fileLength = GetFileSize(hFile,NULL);
		DWORD dibSize = fileLength - sizeof(bmFileHeader);

		//BYTE* pDib= (BYTE*) GlobalAlloc(GMEM_MOVEABLE,dibSize); 
		//BYTE* pDib = (BYTE*) new BYTE(sizeof(dibSize)*dibsize));
		BYTE* pDib = (BYTE*) malloc(dibSize);
		if(pDib==NULL) MessageBox(NULL,"malloc() faild!","!",MB_OK);


		//SetFilePointer(hFile,(long)(next*sizeof(Item)),NULL,FILE_BEGIN);
		ReadFile(hFile, (void*)&pDib, dibSize, &dwRead, NULL);
		CloseHandle(hFile);
		
//Ʈ BITMAPINFO BITMAPINFOHEADER  ͵ ʱȭ
		m_pBmInfo = (LPBITMAPINFO) pDib;
		m_pBmInfoHeader = (LPBITMAPINFOHEADER) pDib;

		m_pRGBTable = (RGBQUAD*) (pDib + m_pBmInfoHeader->biSize);

		int m_numColors=GetDibNumColors();
		// bitmap image size 
		m_pBmInfoHeader->biSizeImage = GetDibSizeImage();

		if(m_pBmInfoHeader->biClrUsed == 0 ) m_pBmInfoHeader->biClrUsed = m_numColors;

		// Ʈ Ϳ   
		DWORD clrTableSize = m_numColors * sizeof(RGBQUAD);
		m_pDibBits = pDib + m_pBmInfoHeader->biSize + clrTableSize;
	}
}
/////////////////////////////////////////////////////////////
//   Image size Return(DWORD)
DWORD CDib :: GetDibSizeImage()
{
	if(m_pBmInfoHeader->biSizeImage == 0)
	{
		DWORD byteWidth = (DWORD) GetDibWidth();
		DWORD height = (DWORD) GetDibHeight();
		DWORD imageSize = byteWidth * height;
		return imageSize;
	}
	else return m_pBmInfoHeader->biSizeImage;
}
/////////////////////////////////////////////////////////////
UINT CDib :: GetDibWidth()
{
	return (UINT)m_pBmInfoHeader->biWidth;
}
/////////////////////////////////////////////////////////////
UINT CDib :: GetDibHeight()
{
	return (UINT)m_pBmInfoHeader->biHeight;
}
/////////////////////////////////////////////////////////////
UINT CDib ::GetDibNumColors()
{
	if( (m_pBmInfoHeader->biClrUsed == 0) && 
		(m_pBmInfoHeader->biBitCount < 9) )
		return (1 << m_pBmInfoHeader->biBitCount);
	
	else return (int) m_pBmInfoHeader->biClrUsed;
}

//////////////////////////////////////////////////////////////

LPBITMAPINFOHEADER CDib ::GetDibInfoHeaderPtr()
{
	return m_pBmInfoHeader;
}
//////////////////////////////////////////////////////////////
LPBITMAPINFO CDib ::GetDibInfoPtr()
{
	return m_pBmInfo;
}
/////////////////////////////////////////////////////////////
LPRGBQUAD CDib ::GetDibRGBTablePtr()
{
	return m_pRGBTable;
}
/////////////////////////////////////////////////////////////
BYTE* CDib ::GetDibBitsPtr()
{
	return m_pDibBits;
}
////////////////////////////////////////////////////////////





		



