#ifndef __WININIT_H
#define __WININIT_H

#include <windows.h>
#include <ddraw.h>
#include "MyDefine.h"
#include "asm.h"

typedef class DIRECT_DRAW_MANAGER
{
public:
	enum COLOR_TYPE{_5x5x5_,_5x6x5_};
	enum {MAXOFFSURFACES=200};
	HWND WindowHandle;
	unsigned int MAX_OFFSURFACE;
private:
	//HWND WindowHandle;
	int WindowX, WindowY;
	int	Width,Height,ColorType;
	bool FullScreenFlag,NotInitializedFlag;
	DWORD TotalVideoMemory, FreeVideoMemory;
	SCREEN_STRUCT Screen;

	LPDIRECTDRAW DDObject;
	LPDIRECTDRAW7 DDObjectNew;
	
	LPDIRECTDRAWSURFACE7 Primary;
	LPDIRECTDRAWSURFACE7 BackBuffer;
	
	DDSURFACEDESC2 Description;
	DDSCAPS2 ddsCaps;

	//********** ޸𸮿  ׸  ũ ***
	
//	LPDIRECTDRAWSURFACE7 OffSurface[MAXOFFSURFACES];
//	DDSURFACEDESC2 OffSurfaceDescription;
//	unsigned int OffWidth[MAXOFFSURFACES] , OffHeight[MAXOFFSURFACES];
	LPDIRECTDRAWSURFACE7 OffSurface[10];
	DDSURFACEDESC2 OffSurfaceDescription;
	unsigned int OffWidth[10] , OffHeight[10];
	int NumOffSurfaces;
	
	//******** ũ
	LPDIRECTDRAWCLIPPER DDClipper;

	
	int CreateDirectDraw();
	
	
	

public:
	DIRECT_DRAW_MANAGER();
	~DIRECT_DRAW_MANAGER();

	void ErrorMessage(char* str);
	void CreateOffSurface(int which, int w, int h);
	
	//*********************
	int DrawFrame();  // ø ϴ κ
	LPDIRECTDRAWSURFACE7 GetPrimary() {return Primary;}   // ̸Ӹ ּҰ
	LPDIRECTDRAWSURFACE7 GetBackBuffer() {return this->BackBuffer;}   //  ּҰ
	
	HWND CreateMainWindow(int w,int h, char* ClassName,
				   void* MessageLoop,void* hInst, bool FullScreen=true);
	int GetColorType() { return ColorType;}  // 5*5*5 or 5*6*6 mode
	void PaintText (const int x, const int y, const char* string);
	int GetColorMode() {return (ColorType ==_5x5x5_) ?  555 : 565 ; }
	
	//***************ũ Լ
	
	LPDIRECTDRAWSURFACE7 GetOffSurfacePtr(int which) {return this->OffSurface[which]; } //???
	void* GetOffSurfaceDescPtr() { return &OffSurfaceDescription; }

	int CreateBlankOffSurface(int w,int h);

	void ReleaseOffSurface (const int which);
	SCREEN_STRUCT* GetOffSurface (const int which);
	void ClearBackBuffer(); //Ŭ 
	SCREEN_STRUCT* PreFrame();
	void InterruptFrame ();
	void CopyFileToSurface(const int num,const char* fileName);
	void CopyOffSurfaceToBack(const int which);
	void CopyFileToBackBuffer(const char* fileName);
	
	BOOL OffSurfaceLock(const int which);
	void OffSurfaceUnlock(const int which);
	SCREEN_STRUCT*  GetScreen () {return & Screen;}

} DDRAW_MASTER ,*LPDDRAW_MASTER;

#endif
