#include "WinInit.h"
#include "CDib.h"

HWND DIRECT_DRAW_MANAGER :: CreateMainWindow (int w,int h, char* ClassName,
				                           void* MessageLoop,void* hInst, bool FullScreen)
{
	WNDCLASS wc;
	wc.style=           CS_HREDRAW | CS_VREDRAW;
  	wc.lpfnWndProc =    (WNDPROC) MessageLoop;
	wc.cbClsExtra =     0;
 	wc.cbWndExtra =     0;
 	wc.hInstance =     (struct HINSTANCE__ *) hInst;
 	wc.hIcon =          LoadIcon ((struct HINSTANCE__ *)hInst, IDI_APPLICATION);
 	wc.hCursor =        LoadCursor(NULL, IDC_ARROW);
 	wc.hbrBackground =  NULL;
 	
	wc.lpszMenuName =   ClassName;//NULL;
 	wc.lpszClassName =  ClassName;

 	RegisterClass(&wc);

	if (FullScreen)// there are some slight differences between 
					//fullscreen and not
    {
		WindowX = 0, WindowY = 0;
		WindowHandle = CreateWindowEx(
			WS_EX_TOPMOST,
			ClassName,
			ClassName,
			WS_POPUP,
			WindowX,
			WindowY,
			640, ///GetSystemMetrics( SM_CXSCREEN ),// full screen dimensions
			480,//GetSystemMetrics( SM_CYSCREEN ),
			NULL,
			NULL,
			(struct HINSTANCE__ *)hInst,
			NULL);
	}
	else {
		WindowX=GetSystemMetrics(SM_CXSCREEN)/2-w/2;
		WindowY=GetSystemMetrics(SM_CYSCREEN)/2-h/2;
		WindowHandle = CreateWindowEx(
			0,
			ClassName,
			ClassName,
			WS_POPUP,
			WindowX,
			WindowY,
			w, ///GetSystemMetrics( SM_CXSCREEN ),// full screen dimensions
			h,//GetSystemMetrics( SM_CYSCREEN ),
			NULL,
			NULL,
			(struct HINSTANCE__ *)hInst,
			NULL);
	}
	
	if(WindowHandle==NULL) {ErrorMessage("Window Create Faild");return NULL;}
	
	Width=w; Height=h;

	ShowWindow (WindowHandle, 1);
 	UpdateWindow (WindowHandle);
 	SetFocus    (WindowHandle);
 //	ShowCursor (FALSE);
	FullScreenFlag=FullScreen;
	int err=CreateDirectDraw();
	if(err==0) return NULL;

	return WindowHandle;

}
//////////////////////////////////////////////////////////////////
void DIRECT_DRAW_MANAGER :: ErrorMessage(char* str)
{
	MessageBox(WindowHandle,str,"Error",MB_OK);
	DestroyWindow(WindowHandle);
}
//********************************  ******
DIRECT_DRAW_MANAGER ::DIRECT_DRAW_MANAGER()
{
	DDObject=NULL;
	DDObjectNew=NULL;
	Primary=NULL;
	BackBuffer=NULL;
	
	WindowHandle=NULL;
	WindowX=0, WindowY=0;
	Width=0,Height=0;
	TotalVideoMemory=0, FreeVideoMemory=0;
	NumOffSurfaces=0;
	FullScreenFlag=0;
	NotInitializedFlag = true;
	for(int i=0;i<MAXOFFSURFACES;i++) OffSurface[i]=NULL;
}
//**************************************************Ҹ
DIRECT_DRAW_MANAGER :: ~DIRECT_DRAW_MANAGER()
{
	if(DDObjectNew!=NULL)
	{
		DDObjectNew->Release();
		if(Primary!=NULL) Primary->Release();
		if(DDClipper!=NULL) DDClipper->Release();
		if(BackBuffer!=NULL) BackBuffer->Release();
	}
}
//**********************̷Ʈ ο ʱȭ Լ
int DIRECT_DRAW_MANAGER :: CreateDirectDraw()
{
	HRESULT ddret=DirectDrawCreate(NULL,&DDObject,NULL); // ???
	//HRESULT ddret= DirectDrawCreateEx (NULL, (VOID**) &DDObject, IID_IDirectDraw7, NULL) ;
	//HRESULT ddret= DirectDrawCreateEx (NULL, (VOID**) &DDObject, IID_IDirectDraw7, NULL) ;
	
	if(ddret!=DD_OK)
	{
		DestroyWindow(WindowHandle);
		return 0;
	}
	
	ddret=DDObject->SetCooperativeLevel(WindowHandle,
		(FullScreenFlag) ? (DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT) 
							: (DDSCL_NORMAL));
	
	if(ddret!=DD_OK)
	{
		ErrorMessage("SetCooperativeLevel() faild!");
		return 0;
	}
	ddret=DDObject->QueryInterface(IID_IDirectDraw7,(LPVOID *)&DDObjectNew);
	if(ddret!=DD_OK)
	{
		ErrorMessage("Initializing IID_IDirectDraw7");
		return 0;
	}

	if(FullScreenFlag)
	{
		ddret=DDObjectNew->SetDisplayMode( Width, Height, 16,0,0);
		
		if(ddret!=DD_OK)
		{
			ErrorMessage("SetDisplay() faild!");
			return 0;
		}
	}
//**********Primary surface ´
	ZeroMemory(&Description,sizeof(Description));
	ZeroMemory(&Description.ddpfPixelFormat,sizeof(DDPIXELFORMAT));

	Description.dwSize=sizeof(Description);
	Description.dwFlags= DDSD_CAPS;
	Description.ddsCaps.dwCaps= DDSCAPS_PRIMARYSURFACE;
	
	if(FullScreenFlag)
	{
		Description.ddsCaps.dwCaps =DDSCAPS_PRIMARYSURFACE |DDSCAPS_FLIP | DDSCAPS_COMPLEX;
		Description.dwFlags =DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	}

	//****back buffer 
	Description.dwBackBufferCount=1;

	ddret= DDObjectNew->CreateSurface( &Description, &Primary, NULL);
	if(ddret!=DD_OK)
	{
		ErrorMessage("CreateSurface() faild!");
		return 0;
	}
 //*************** Get BackBuffer surface


	if (FullScreenFlag)
	{
		ZeroMemory(&ddsCaps, sizeof(ddsCaps)); // ߰ ۰ Ⱥپ...߰
		ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;

		ddret = Primary->GetAttachedSurface(&ddsCaps, &BackBuffer);
		if (ddret != DD_OK)
		{ 
			if(ddret==DDERR_INVALIDOBJECT) ErrorMessage ("primary surface not attached(1)"); 
			if(ddret==DDERR_INVALIDPARAMS) ErrorMessage ("primary surface not attached(2)"); 
			if(ddret==DDERR_NOTFOUND) ErrorMessage ("primary surface not attached(3)"); 
			if(ddret==DDERR_SURFACELOST) ErrorMessage ("primary surface not attached(4)"); 

			//ErrorMessage ("primary surface not attached"); 
			return 0;
		}
	}
	else 
	{
		Description.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		Description.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		Description.dwWidth = Width;
		Description.dwHeight = Height;
		
		ddret = DDObjectNew->CreateSurface(&Description, &BackBuffer, NULL);
		if (ddret != DD_OK){ ErrorMessage ("back buffer not made"); return 0;}
	}

	//***********ȼ  ´
	Description.dwSize= sizeof(Description);
	Description.dwFlags= DDSD_PIXELFORMAT;
	ddret=Primary->GetSurfaceDesc( &Description);
	if(ddret!=DD_OK)
	{
		ErrorMessage("Pixel format not available!");
		return 0;
	}

	//*****÷ Ÿ ´
	int g= Description.ddpfPixelFormat.dwGBitMask>>5;
	if(g==0x1f) ColorType=_5x5x5_;
	else if(g==0x3f) ColorType=_5x6x5_;
	else {
		ErrorMessage("ColorType not set");
		return 0;
	}
	//*************** create clipper

	if (FullScreenFlag == false)
	{
		ddret = DDObjectNew->CreateClipper ( 0, &DDClipper, NULL);
		
		if (ddret != DD_OK){ ErrorMessage ("clipper not created"); return 0;}

		ddret = DDClipper->SetHWnd (0, WindowHandle);
		if (ddret != DD_OK)
		{ 
			ErrorMessage ("Surface not assigned to hwnd"); 
			return 0;
		}

		ddret = Primary->SetClipper (DDClipper);
		if (ddret != DD_OK)
		{ 
			ErrorMessage ("clipper not set on primary surface"); 
			return 0;
		}
	}

       

	ZeroMemory (&ddsCaps, sizeof (DDSCAPS2));



	ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;

	ddret = DDObjectNew->GetAvailableVidMem (&ddsCaps, &TotalVideoMemory, 
								&FreeVideoMemory);
	

	if(ddret != DD_OK) return 0;
	DDObject->Release();
	NotInitializedFlag=false;
	return 1;
}
//*****************************ø ϴ κ
int DIRECT_DRAW_MANAGER :: DrawFrame()
{
	if(FullScreenFlag)
	{
		int ret= BackBuffer->GetFlipStatus (DDGFS_ISFLIPDONE);
		if(ret== DDERR_WASSTILLDRAWING) return 1;

		ret= Primary->Flip(NULL,0L);
		if( ret==DDERR_SURFACELOST)
		{
			ret= DDObjectNew->RestoreAllSurfaces();
			if( ret!=DD_OK)
			{
				ErrorMessage("Surface lost!");
				return 1;
			}
		}
	}
	else   // Ǯũ ƴҶ ڵ ߿ 
	{
	
	}

Screen.Screen=NULL;
//DDObjectNew->WaitForVerticalBlank(DDWAITVB_BLOCKEND,NULL);
return 0;
}

//*****************Ŭ 
void DIRECT_DRAW_MANAGER:: ClearBackBuffer()
{
	PreFrame();
	Memset16Bit(Screen.Screen, 0, Screen.Width * Screen.Height);
}

//*******************ͷƮ 
void DIRECT_DRAW_MANAGER:: InterruptFrame ()
{    
	if (NotInitializedFlag == true) return;
    BackBuffer->Unlock (NULL);
    Screen.Screen = NULL;
}

////**************************ڿ 
void DIRECT_DRAW_MANAGER:: PaintText (const int x, const int y, const char* string)
{
	if (NotInitializedFlag == true) return;
    HDC hdc;
    BackBuffer->Unlock (NULL);
    
    BackBuffer-> GetDC(&hdc);
    SetBkMode (hdc, TRANSPARENT);
    SetTextColor (hdc, RGB(0, 0, 255));
    TextOut (hdc, x, y, string, strlen(string));
    BackBuffer->ReleaseDC (hdc);
   /* int ret;
    do{
        ret = BackBuffer->Lock (NULL, &Description, 
								DDLOCK_SURFACEMEMORYPTR, NULL);
    }while (ret!=DD_OK);*/

/* an older way to accomplish the same thing
	if (lpDDSBack->GetDC(&hdc) == DD_OK) // must be locked
{ 
    SetBkColor(hdc, RGB(0, 0, 255)); 
    SetTextColor(hdc, RGB(255, 255, 0)); 
    TextOut(hdc, 0, 0, szBackMsg, lstrlen(szBackMsg)); 
    lpDDSBack->ReleaseDC(hdc); 
} 
*/
}

//****************preFrame κ....
SCREEN_STRUCT*
 DIRECT_DRAW_MANAGER:: PreFrame ()
{
	if (NotInitializedFlag == true) return NULL;
 	ZeroMemory (&Description, sizeof (DDSURFACEDESC));
 	Description.dwSize = sizeof (Description);
 	int ret;
 	do{
   		ret = BackBuffer->Lock (NULL, &Description, 
								DDLOCK_SURFACEMEMORYPTR, NULL);
    }while(ret!=DD_OK);

	BackBuffer->Unlock (NULL);
	Screen.Width = Width;
	Screen.Height = Height;
	Screen.Screen = (U16ptr) Description.lpSurface;
	Screen.RealWidth = Description.lPitch/2;
	return &Screen;
}

//********************* ̽  
void DIRECT_DRAW_MANAGER:: CreateOffSurface (const int which, const int w, const int h)
{
	
	if (NotInitializedFlag == true) return;
	ZeroMemory (&OffSurfaceDescription, sizeof (DDSURFACEDESC));
    
    OffSurfaceDescription.dwSize = sizeof (DDSURFACEDESC);
    OffSurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    OffSurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    OffSurfaceDescription.dwHeight = h;
    OffSurfaceDescription.dwWidth = w;
    HRESULT result = DDObjectNew->CreateSurface (&OffSurfaceDescription, 
										&OffSurface[which], NULL);  
	if( result !=DD_OK) ErrorMessage("Create OffSurface Faild");
	OffWidth[which]=w; OffHeight[which]=h;
	
	
}
///////////////////////////////////////////////////////////////////////
BOOL DIRECT_DRAW_MANAGER :: OffSurfaceLock(const int which)
{
	ZeroMemory (&OffSurfaceDescription, sizeof (DDSURFACEDESC));
 	OffSurfaceDescription.dwSize = sizeof (OffSurfaceDescription);
 	int ret;
 	do{
   		ret = OffSurface[which]->Lock (NULL, &OffSurfaceDescription, 0, NULL);
    
	}while(ret!=DD_OK);
	if( ret == DD_OK) return TRUE;
	else return FALSE;
}
////////////////////////////////////////////////////////////
void DIRECT_DRAW_MANAGER :: OffSurfaceUnlock(const int which)
{
	OffSurface[which]->Unlock(NULL);
}

///****************ũ ̼ ° 
int  DIRECT_DRAW_MANAGER:: CreateBlankOffSurface (const int w, const int h)
{
	if (NotInitializedFlag == true) return -1;
	if (NumOffSurfaces >= MAXOFFSURFACES) return -1;
	int which = NumOffSurfaces;
	CreateOffSurface(which, w, h);
	OffWidth[which] = w; OffHeight[which] = h;

	U16ptr ptr = (U16ptr) GetOffSurface(which);
	if (ptr != NULL) Memset16Bit (ptr, 0, w*h);
	ReleaseOffSurface (which);

	NumOffSurfaces++;// increment our count
	return which;
}

//************* ̽
void DIRECT_DRAW_MANAGER:: ReleaseOffSurface (const int which)
{
	if (NotInitializedFlag == true) return;
	if (which >= NumOffSurfaces || which<0 || NumOffSurfaces<1) return;
	OffSurface[which]->Unlock(NULL);
}

//*****************GetOffSurface
SCREEN_STRUCT* 
	DIRECT_DRAW_MANAGER:: GetOffSurface (const int which)// must exist first
{  
	if (NotInitializedFlag == true) return NULL;
	if (which >= NumOffSurfaces || which<0 || NumOffSurfaces<1) return NULL;

	ZeroMemory(&OffSurfaceDescription, sizeof (DDSURFACEDESC));
	OffSurfaceDescription.dwSize = sizeof (DDSURFACEDESC);
	if (OffSurface[which]->IsLost()) OffSurface[which]->Restore();

	HRESULT rval = OffSurface[which]->Lock(NULL, &OffSurfaceDescription, 
											0, NULL);
	if(rval != DD_OK) return NULL;

	Screen.Width = OffWidth[which], Screen.Height = OffHeight[which], 
		Screen.Screen = (U16ptr) OffSurfaceDescription.lpSurface;
	Screen.RealWidth = OffSurfaceDescription.lPitch/2;
 	return &Screen; 
}
/////////////////////////////////////////////////////////////////
void DIRECT_DRAW_MANAGER ::CopyFileToSurface(const int num,const char* fileName)
{
	BOOL exitLoop=FALSE;
	UINT dibW=0,dibH=0;
	HRESULT result;
	char* pSurfaceBits;
	char* pDibBits;
	
	LPCDIB dibImage= new CDib(fileName);
	
	dibW=dibImage->GetDibWidth();  dibH=dibImage->GetDibHeight();

	if(OffSurface[num] == NULL) 
	{
		
		CreateOffSurface(num,dibW,dibH);
		
	}
	ZeroMemory(&OffSurfaceDescription, sizeof (DDSURFACEDESC));
	OffSurfaceDescription.dwSize = sizeof (OffSurfaceDescription);
	
	do
	{
	result=OffSurface[num]->Lock(NULL,&OffSurfaceDescription,DDLOCK_SURFACEMEMORYPTR,NULL);
	
	if(result == DDERR_SURFACELOST)
	{
		
		OffSurface[num]->Restore();
	}
	else if(result != DDERR_WASSTILLDRAWING) exitLoop=TRUE;
	
	} while(!exitLoop);
	
	if(result == DD_OK)
	{
		
		pSurfaceBits = (char*)OffSurfaceDescription.lpSurface;
		pDibBits = (char*) dibImage->GetDibBitsPtr();
// Ʈ   
		pDibBits += (dibH - 1) * dibW;
		//Ʈ  鿡 Ѵ
		for(UINT x=0; x<dibH;++x)
		{
			//Ʈ Ÿ  
			memcpy(pSurfaceBits,pDibBits,dibW);
			// ͸ 
			pSurfaceBits += OffSurfaceDescription.lPitch;
			pDibBits -= dibW;
		}
	OffSurface[num]->Unlock(NULL);
	}
	if(dibImage!=NULL) delete dibImage;
}
////////////////////////////////////////////////////////////////////////////
void DIRECT_DRAW_MANAGER :: CopyOffSurfaceToBack(const int which)
{
	HRESULT result1,result2;
	BOOL exitLoop=FALSE;
	char* OffSurfaceBits;
	char* BackSurfaceBits;
	
	ZeroMemory(&Description, sizeof (DDSURFACEDESC));
	Description.dwSize = sizeof (DDSURFACEDESC);
	
	do
	{
	result1 = BackBuffer->Lock(NULL,&Description,DDLOCK_SURFACEMEMORYPTR,NULL);
	result2 = OffSurface[which]->Lock(NULL,&OffSurfaceDescription,DDLOCK_SURFACEMEMORYPTR,NULL);

	if(result1 == DDERR_SURFACELOST)
	{
		BackBuffer->Restore();
	}
	else if(result2 == DDERR_SURFACELOST)
	{
		OffSurface[which]->Restore();
	}
	else if(result1 != DDERR_WASSTILLDRAWING || result2 != DDERR_WASSTILLDRAWING) exitLoop=TRUE;
	
	} while(!exitLoop);
	
	if(result1 == DD_OK && result2 == DD_OK)
	{
		
		OffSurfaceBits = (char*)OffSurfaceDescription.lpSurface;
		BackSurfaceBits = (char*)Description.lpSurface;
		

// Ʈ   
		OffSurfaceBits += (OffHeight[which] - 1) * OffWidth[which];
		//Ʈ  鿡 Ѵ
		for(UINT x=0; x<OffHeight[which];++x)
		{
			//Ʈ Ÿ  
			memcpy(BackSurfaceBits,OffSurfaceBits,OffWidth[which]);
			// ͸ 
			BackSurfaceBits += OffSurfaceDescription.lPitch;
			OffSurfaceBits -= OffWidth[which];
		}
	OffSurface[which]->Unlock(NULL);
	BackBuffer->Unlock(NULL);

	}
}
/////////////////////////////////////////////////////////////////////////////////////
void DIRECT_DRAW_MANAGER :: CopyFileToBackBuffer(const char* fileName)
{
	BOOL exitLoop=FALSE;
	UINT dibW=0,dibH=0;
	HRESULT result=0;
	unsigned short* pSurfaceBits=NULL;
	char* pDibBits=NULL;
	
	LPCDIB dibImage= (LPCDIB)new CDib(fileName);
	
	dibW=dibImage->GetDibWidth();  dibH=dibImage->GetDibHeight();

	
	ZeroMemory(&Description, sizeof (DDSURFACEDESC));
	Description.dwSize = sizeof (Description);
	exitLoop=FALSE;
	
	
	do
	{
	
		result = BackBuffer->Lock(NULL,&Description,DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR,NULL);
	
	if(result == DDERR_SURFACELOST)
	{
		
		BackBuffer->Restore();
	}
	else if(result != DDERR_WASSTILLDRAWING) exitLoop=TRUE;
	
	} while(!exitLoop);
	
	//SCREEN_STRUCTptr screen = PreFrame();
	
	if(result == DD_OK)
	{
		MessageBox(WindowHandle,"lock  ","ī",MB_OK);

	//	pSurfaceBits = (unsigned short*)Description.lpSurface;
	/*	pDibBits = (char*) dibImage->GetDibBitsPtr();
		pSurfaceBits[100]=65535;
// Ʈ   
		pDibBits += (dibH - 1) * dibW;
		//Ʈ  鿡 Ѵ
		for(UINT x=0; x<dibH;++x)
		{
			//Ʈ Ÿ  
			memcpy(pSurfaceBits,pDibBits,dibW);
			// ͸ 
			pSurfaceBits += Description.lPitch;
			pDibBits -= dibW;
		}*/
	BackBuffer->Unlock(NULL);
	}
	if(dibImage!=NULL) delete dibImage;
}