#include "RoadSearch.h"

struct NODE *OPEN;
struct NODE *CLOSED;
struct STACK *Stack;

int raw_key;
int key_table[7] = {0,0,0,0,0,0,0}; //̴µ .
int FINISHED=0;
int TileMap[TOTAL_TILES];

FILE *f1;

void DisplayPath(int ex, int ey, int sx, int sy)
{
	struct NODE *path, *Node;

	f1 = fopen("path.txt", "wb");

	path=(struct NODE *)FindPath((long)ex,(long)ey,(long)sx,(long)sy);

	fclose(f1);

	FILE *fp;
	char temp[20];
	fp = fopen("Road_Path.txt", "wt");
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "[%4d], [%4d]\n", path->x, path->y);
	fwrite(temp, sizeof(temp), 1, fp);

	while (path->Parent != NULL)
	{
		path=path->Parent;
		ZeroMemory(temp, sizeof(temp));
		wsprintf(temp, "[%4d], [%4d]\n", path->x, path->y);
		fwrite(temp, sizeof(temp), 1, fp);
    }
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "[%4d], [%4d]\n", path->x, path->y);
	fwrite(temp, sizeof(temp), 1, fp);
	fclose(fp);
    
	
	// Free Nodes up
	Node=OPEN->NextNode;
	while (Node != NULL)
	{
		free(Node);
		Node=Node->NextNode;
	}


	Node=CLOSED->NextNode;
	
	while (Node != NULL)
	{
		free(Node);
		Node=Node->NextNode;
	}
	fp = fopen("Road_Path_free2.txt", "wt");
	fwrite("asdf", 4, 1, fp);
	fclose(fp);
}


int TileNum(int x, int y)
{
    return (FreeTile(x, y, 1));
}


int FreeTile(int cx, int cy, int num)
{
	int x, y, a, b, aa, bb, index=0;
	a = b = aa = bb = 0;
	int flag = FALSE;
	int t, tt;
	t = 3200 * 2;
	tt = 2976 * 2;

	int ox, oy;

	for(x=0; x<t; x+=64)
	{
		if((x <= cx) && ((x+63) >= cx))
		{
			b = 0;

			for(y=0; y<tt; y+=34)
			{	
				if((y <= cy) && ((y+33) >= cy))
				{
					aa = cx / 32;
					a = aa * 32;
					aa = cx / 64;
					bb = cy / 17;
					b = bb * 17;

					if((a+1) % 2 == 0)
					{
						if((b+1) % 2 == 0)
							index = 1;
						else
							index = 3;
					}
					else
					{
						if((b+1) % 2 == 0)
							index = 2;
						else
							index = 3;
					}
					flag = TRUE;
					break;
				}
			}
			if(flag)
				break;
		}
	}
	

	int xm, xx, yy;
	switch(index)
	{
	case 1:
		{
			xm = (cx % 32)/2+1 ;
			yy = (cy % 17);

			if(yy >= 1 && yy <= xm)
			{
				ox = bb;
				oy = aa;
			}
			else
			{
				ox = bb+1;
				oy = aa;
			}
			break;
		}

	case 2:
		{
			xx = (cx % 32) / 2;
			xm = 16 - xx;
			yy = (cy % 17);
			
			if(yy >= 1 && yy <= xm)
			{
				ox = bb;
				oy = aa-1;
			}
			else
			{
				ox = bb+1;
				oy = aa;
			}
			break;
		}

	case 3:
		{
			xx = (cx % 32) / 2;
			xm = 16 - xx;
			yy = (cy % 17);
			
			if(yy >= 1 && yy <= xm)
			{
				ox = bb;
				oy = aa;
			}
			else
			{
				ox = bb+1;
				oy = aa;
			}
			break;
		}

	case 4:
		{
			xm = (cx % 32)/2+1 ;
			yy = (cy % 17);

			if(yy >= 1 && yy <= xm)
			{
				ox = bb;
				oy = aa;
			}
			else
			{
				ox = bb+1;
				oy = aa-1;
			}
			break;
		}
//	default:
//		MessageBox(gapp.hwnd, "1", "1", MB_OK);
	}

	if(num == 1)
		return (oy*COLS + ox);

	FILE *fp;
	char temp[16];
	fp = fopen("Road_Path_3.txt", "wt");
	fwrite("asdf", 4, 1, fp);
	fclose(fp);

	return (TileMap[oy*COLS + ox]);
}


void RoadSearch(long ex, long ey, long sx, long sy, int *obj)
{
	FILE *fp;
	char temp[40];
	fp = fopen("Road_Path_tilenum_before1.txt", "wt");
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "ǥ:[%4d, %4d] - [%4d, %4d]", sx, sy, ex, ey);
	fwrite(temp, sizeof(temp), 1, fp);
	fclose(fp);

	int count=1, x=32, y=16;

	CopyMemory(TileMap, obj, sizeof(obj));

	Stack=( struct STACK *)calloc(1,sizeof(struct STACK));  // setup the Stack.

	DisplayPath(ex, ey, sx, sy);  // sx, sy  
								  // dx, dy    
}




/**************************************************************************/
/***************************** A* Algorithm *******************************/
/**************************************************************************/

struct NODE *FindPath(long ex,long ey,long sx,long sy)
{
    struct NODE *Node, *BestNode;
    int TileNumDest;


	FILE *fp;
	char temp[16];
	fp = fopen("Road_Path_tilenum_before.txt", "wt");
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "Tile before");
	fwrite(temp, sizeof(temp), 1, fp);
	fclose(fp);

//	MessageBox(gapp.hwnd, "1", "1", MB_OK);

    TileNumDest = TileNum((int)ex,(int)ey);
    

	OPEN = (struct NODE *)calloc(1,sizeof( struct NODE ));
    CLOSED = (struct NODE *)calloc(1,sizeof( struct NODE ));
    

	Node = (struct NODE *)calloc(1,sizeof( struct NODE ));
    Node->g = 0;
    Node->h = sqrt((ex-sx)*(ex-sx)+(ey-sy)*(ey-sy));  // should really use sqrt().
    Node->f = Node->g + Node->h;
    Node->NodeNum = TileNum((int)sx,(int)sy);
    Node->x = sx;
    Node->y = sy;
	
	OPEN->NextNode = Node;        /* make Open List point to first node */


	fp = fopen("Road_Path_tilenum.txt", "wt");
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "Tile = %d", TileNumDest);
	fwrite(temp, sizeof(temp), 1, fp);
	fclose(fp);

	int i=0;
	
	for (;;)
	{
        BestNode=(struct NODE *)ReturnBestNode();

		FILE *fp;
		char temp[16];
		fp = fopen("Road_Path_2_1.txt", "wt");
		ZeroMemory(temp, sizeof(temp));
		wsprintf(temp, "%6d", i);
		fwrite(temp, sizeof(temp), 1, fp);
		fclose(fp);

        if (BestNode->NodeNum == TileNumDest)		/* if we've found the end, break and finish */
			break;
        
		GenerateSuccessors(BestNode, sx, sy);

		if(OPEN->NextNode == NULL)
		{
			ZeroMemory(temp, sizeof(temp));
			fp = fopen("Road_Path_2.txt", "wt");
			wsprintf(temp, "%6d", i);
			fwrite(temp, sizeof(temp), 1, fp);
			fclose(fp);
			break;
		}
		i++;
    }

	ZeroMemory(temp, sizeof(temp));
	fp = fopen("Road_Path_9.txt", "wt");
	wsprintf(temp, "%6d", i);
	fwrite(temp, sizeof(temp), 1, fp);
	fclose(fp);


    return (BestNode);
}


struct NODE *ReturnBestNode(void)
{
    struct NODE *tmp;
    
	if (OPEN->NextNode == NULL)
	{
		printf("ERROR: no more nodes on OPEN\n");

		exit(0);
	}

/* Pick Node with lowest f, in this case it's the first node in list
   because we sort the OPEN list wrt lowest f. Call it BESTNODE. */
    
	tmp = OPEN->NextNode;				// point to first node on OPEN
    OPEN->NextNode = tmp->NextNode;		// Make OPEN point to nextnode or NULL.
	

	/* Next take BESTNODE (or temp in this case) and put it on CLOSED */
    tmp->NextNode = CLOSED->NextNode;
    CLOSED->NextNode = tmp;

    return(tmp);
}


void GenerateSuccessors(struct NODE *BestNode,long sx,long sy)
{
    long x,y;

	//  ̵ Ÿ ̵  ִ  Ǵ (߽ ٱ 8)
    // Upper-Left
    if (FreeTile(x=(long)BestNode->x-TILESIZEX, y=(long)BestNode->y-TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Upper
    if (FreeTile(x=(long)BestNode->x, y=(long)BestNode->y-TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Upper-Right
    if (FreeTile(x=(long)BestNode->x+TILESIZEX, y=(long)BestNode->y-TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Right
    if (FreeTile(x=(long)BestNode->x+TILESIZEX, y=(long)BestNode->y, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Lower-Right
    if (FreeTile(x=(long)BestNode->x+TILESIZEX, y=(long)BestNode->y+TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Lower
    if (FreeTile(x=(long)BestNode->x, y=(long)BestNode->y+TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Lower-Left
    if (FreeTile(x=(long)BestNode->x-TILESIZEX, y=(long)BestNode->y+TILESIZEY, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);

    // Left
    if (FreeTile(x=(long)BestNode->x-TILESIZEX, y=(long)BestNode->y, 0) != 0)
        GenerateSucc(BestNode, x, y, sx, sy);
}


void GenerateSucc(struct NODE *BestNode,long x, long y, long sx, long sy)
{
    int g,TileNumS,c=0;
    struct NODE *Old,*Successor;

    g=BestNode->g+1;        // g(Successor)=g(BestNode)+cost of getting from BestNode to Successor
    TileNumS=TileNum((int)x, (int)y);  // identification purposes
    
	if ((Old=CheckOPEN(TileNumS)) != NULL) 
	{ // if equal to NULL then not in OPEN list, else it returns the Node in Old
        for(c=0; c<16; c++)  // 
            if(BestNode->Child[c] == NULL) // Add Old to the list of BestNode's Children (or Successors).
                break;
			
		BestNode->Child[c]=Old;
        
		if (g < Old->g)
		{  // if our new g value is < Old's then reset Old's parent to point to BestNode
            Old->Parent=BestNode;
            Old->g=g;
            Old->f=g+Old->h;
        }
    }
	else if ((Old=CheckCLOSED(TileNumS)) != NULL)
	{ // if equal to NULL then not in OPEN list, else it returns the Node in Old
        for(c=0; c<16; c++)
            if (BestNode->Child[c] == NULL) // Add Old to the list of BestNode's Children (or Successors).
                break;

		
		BestNode->Child[c]=Old;
        
		if (g < Old->g)
		{ // if our new g value is < Old's then reset Old's parent to point to BestNode
            Old->Parent=BestNode;
            Old->g=g;
            Old->f=g+Old->h;
            PropagateDown(Old);       /* Since we changed the g value of Old, we need
                                         to propagate this new value downwards, i.e.
                                         do a Depth-First traversal of the tree! */
        }
    }
	else
	{
        Successor=(struct NODE *)calloc(1,sizeof( struct NODE ));
        Successor->Parent=BestNode;
        Successor->g=g;
        Successor->h=sqrt((x-sx)*(x-sx)+(y-sy)*(y-sy));  // should do sqrt(), but since we don't really
        Successor->f=g+Successor->h;     // care about the distance but just which branch looks
        Successor->x=x;                  // better this should suffice. Anyayz it's faster.
        Successor->y=y;
        Successor->NodeNum=TileNumS;
        Insert(Successor);     /* Insert Successor on OPEN list wrt f */
        
		for(c=0; c<16; c++)
            if (BestNode->Child[c] == NULL) /* Add Old to the list of BestNode's Children (or Successors). */
                break;
			
		BestNode->Child[c]=Successor;
    }
}

struct NODE *CheckOPEN(int tilenum)
{
    struct NODE *tmp;
    
	tmp=OPEN->NextNode;
    
	while (tmp != NULL)
	{
        if (tmp->NodeNum == tilenum)
            return (tmp);
        else
            tmp=tmp->NextNode;
    }
    return (NULL);
}

struct NODE *CheckCLOSED(int tilenum)
{
    struct NODE *tmp;
    
	tmp=CLOSED->NextNode;
    
	while (tmp != NULL)
	{
        if (tmp->NodeNum == tilenum)
            return (tmp);
        else
            tmp=tmp->NextNode;
    }
    return (NULL);
}

void Insert(struct NODE *Successor)
{
    struct NODE *tmp1,*tmp2;
    long f;
    
	char temp[30];
	ZeroMemory(temp, sizeof(temp));
	wsprintf(temp, "[%d] [%d]\n", Successor->x, Successor->y);
	fwrite(temp, sizeof(temp), 1, f1);

	if (OPEN->NextNode == NULL)
	{
        OPEN->NextNode=Successor;
        return;
    }
    
	// insert into OPEN successor wrt f
    
	f=Successor->f;
    tmp1=OPEN;
    tmp2=OPEN->NextNode;
    
	while ((tmp2 != NULL) && (tmp2->f < f))
	{
        tmp1=tmp2;
        tmp2=tmp2->NextNode;
    }
	
	Successor->NextNode=tmp2;
	tmp1->NextNode=Successor;
}

void PropagateDown(struct NODE *Old)
{
    int c,g;
    struct NODE *Child, *Father;
    
	g=Old->g;            // alias.
    
	for(c=0; c<16; c++)
	{
        if ((Child=Old->Child[c])==NULL)   // create alias for faster access.            
			break;

        if (g+1 < Child->g)
		{
            Child->g=g+1;
            Child->f=Child->g+Child->h;
            Child->Parent=Old;           // reset parent to new path.
            Push(Child);                 // Now the Child's branch need to be
        }     // checked out. Remember the new cost must be propagated down.
    }
    
	while (Stack->NextStackPtr != NULL)
	{
        Father=Pop();
        
		for(c=0; c<16; c++)
		{
            if ((Child=Father->Child[c])==NULL)       /* we may stop the propagation 2 ways: either */
				break;

            if (Father->g+1 < Child->g)
			{       /* there are no children, or that the g value of */
                    /* the child is equal or better than the cost we're propagating */
                Child->g=Father->g+1;
                Child->f=Child->g+Child->h;
                Child->Parent=Father;
                Push(Child);            
			}
        }
    }
}

/**************************************************************************/
/*                            STACK FUNCTIONS                             */
/**************************************************************************/
void Push(struct NODE *Node)
{
    struct STACK *tmp;
    
	tmp=( struct STACK *)calloc(1,sizeof(struct STACK));
    tmp->NodePtr=Node;
    tmp->NextStackPtr=Stack->NextStackPtr;
    Stack->NextStackPtr=tmp;
}

struct NODE *Pop()
{
    struct NODE *tmp;
    struct STACK *tmpSTK;
    
	tmpSTK=Stack->NextStackPtr;
    tmp=tmpSTK->NodePtr;
    
	Stack->NextStackPtr=tmpSTK->NextStackPtr;
    free(tmpSTK);    
	return (tmp);
}
