#ifndef _ROADSEARCH_H
#define _ROADSEARCH_H

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <Malloc.h>
#include <stdlib.h>
#include <math.h>


#define COLS			101	
#define ROWS			351
#define TOTAL_TILES		ROWS * COLS + 1
#define TILESIZEX		32
#define TILESIZEY		16


struct NODE {
    long			f,h;
    int				g,tmpg;
    int				x,y;
    int				NodeNum;
    struct NODE		*Parent;
    struct NODE		*Child[16];
    struct NODE		*NextNode;
};




/**************************************************************************/
/*                                 STACK                                  */
/**************************************************************************/
struct STACK
{
    struct NODE *NodePtr;
    struct STACK *NextStackPtr;
};


void DisplayPath(int ex,int ey,int sx,int sy);
int  TileNum(int x, int y);
int  FreeTile(int x, int y, int num);
void BoundaryTiles(void);

void RoadSearch(long ex,long ey, long sx, long sy, int *obj);


struct	NODE	*FindPath(long ex,long ey, long sx,long sy);
struct	NODE	*ReturnBestNode(void);
void	GenerateSuccessors(struct NODE *BestNode,long sx,long sy);
void	GenerateSucc(struct NODE *BestNode,long x, long y, long sx, long sy);
struct	NODE	*CheckOPEN(int tilenum);
struct	NODE	*CheckCLOSED(int tilenum);
void	Insert(struct NODE *Successor);
void	PropagateDown(struct NODE *Old);

void Push(struct NODE *Node);
struct	NODE	*Pop(void);

#endif