#ifndef _WatchOutDDRAW_H
#define _WatchOutDDRAW_H

// Structure definition ///////////////

typedef struct _DDraw
{
	HWND					hwndApp;

	LPDIRECTDRAW			lpDD;			// Pointer to DirectDraw object
	
	LPDIRECTDRAWSURFACE		lpDDSPrimary;	// Pointer to primary surface
	LPDIRECTDRAWSURFACE		lpDDSBack;		// Pointer to back buffer

	LPDIRECTDRAWSURFACE		LoginBackground;
	LPDIRECTDRAWSURFACE		LoginBackground1;
	LPDIRECTDRAWSURFACE		LoginText;
	LPDIRECTDRAWSURFACE		LoginAccount;
	LPDIRECTDRAWSURFACE		LoginAccountBox;
	LPDIRECTDRAWSURFACE		LoginLoginOn;
	LPDIRECTDRAWSURFACE		LoginLoginOff;
	LPDIRECTDRAWSURFACE		LoginNewOn;
	LPDIRECTDRAWSURFACE		LoginNewOff;
	LPDIRECTDRAWSURFACE		LoginChangeOn;
	LPDIRECTDRAWSURFACE		LoginChangeOff;
	LPDIRECTDRAWSURFACE		LoginCancleOn;
	LPDIRECTDRAWSURFACE		LoginCancleOff;
	LPDIRECTDRAWSURFACE		LoginNewInput;
	LPDIRECTDRAWSURFACE		LoginNewInputBox;
	LPDIRECTDRAWSURFACE		LoginOkOn;
	LPDIRECTDRAWSURFACE		LoginOkOff;
	LPDIRECTDRAWSURFACE		LoginExitOn;
	LPDIRECTDRAWSURFACE		LoginExitOff;

	LPDIRECTDRAWSURFACE		lpDDSBackTrans;		// Pointer to back buffer
	
	LPDIRECTDRAWSURFACE		lpDDSTiles1;		// Back map
	LPDIRECTDRAWSURFACE		lpDDSTiles2;
	LPDIRECTDRAWSURFACE		lpDDSTiles3;
	LPDIRECTDRAWSURFACE		lpDDSTiles4;


	LPDIRECTDRAWSURFACE		lpDDS1002;
	LPDIRECTDRAWSURFACE		lpDDS1003;
	LPDIRECTDRAWSURFACE		lpDDS1004;
	LPDIRECTDRAWSURFACE		lpDDS1005;
	LPDIRECTDRAWSURFACE		lpDDS1006;
	LPDIRECTDRAWSURFACE		lpDDS1007;
	LPDIRECTDRAWSURFACE		lpDDS1008;
	LPDIRECTDRAWSURFACE		lpDDS1009;
	LPDIRECTDRAWSURFACE		lpDDS1010;
	LPDIRECTDRAWSURFACE		lpDDS1011;
	LPDIRECTDRAWSURFACE		lpDDS1012;
	LPDIRECTDRAWSURFACE		lpDDS1013;
	LPDIRECTDRAWSURFACE		lpDDS1014;
	
	LPDIRECTDRAWSURFACE		lpDDS2001;
	LPDIRECTDRAWSURFACE		lpDDS2002;
	LPDIRECTDRAWSURFACE		lpDDS2003;
	LPDIRECTDRAWSURFACE		lpDDS2004;
	LPDIRECTDRAWSURFACE		lpDDS2005;
	LPDIRECTDRAWSURFACE		lpDDS2006;
	LPDIRECTDRAWSURFACE		lpDDS2007;
	LPDIRECTDRAWSURFACE		lpDDS2008;
	LPDIRECTDRAWSURFACE		lpDDS2009;
	LPDIRECTDRAWSURFACE		lpDDS2010;
	LPDIRECTDRAWSURFACE		lpDDS2011;
	LPDIRECTDRAWSURFACE		lpDDS2012;
	LPDIRECTDRAWSURFACE		lpDDS2013;
	LPDIRECTDRAWSURFACE		lpDDS2014;
	LPDIRECTDRAWSURFACE		lpDDS2015;
	LPDIRECTDRAWSURFACE		lpDDS2016;
	LPDIRECTDRAWSURFACE		lpDDS2017;
	LPDIRECTDRAWSURFACE		lpDDS2018;
	LPDIRECTDRAWSURFACE		lpDDS2019;
	LPDIRECTDRAWSURFACE		lpDDS2020;
	LPDIRECTDRAWSURFACE		lpDDS2021;
	LPDIRECTDRAWSURFACE		lpDDS2022;
	LPDIRECTDRAWSURFACE		lpDDS2023;
	LPDIRECTDRAWSURFACE		lpDDS2024;
	LPDIRECTDRAWSURFACE		lpDDS2025;
	LPDIRECTDRAWSURFACE		lpDDS2026;
	LPDIRECTDRAWSURFACE		lpDDS2027;
	LPDIRECTDRAWSURFACE		lpDDS2028;
	LPDIRECTDRAWSURFACE		lpDDS2029;
	LPDIRECTDRAWSURFACE		lpDDS2030;
	LPDIRECTDRAWSURFACE		lpDDS2031;
	LPDIRECTDRAWSURFACE		lpDDS2032;
	
	LPDIRECTDRAWSURFACE		lpDDS3001;
	LPDIRECTDRAWSURFACE		lpDDS3002;
	LPDIRECTDRAWSURFACE		lpDDS3003;
	LPDIRECTDRAWSURFACE		lpDDS3004;
	LPDIRECTDRAWSURFACE		lpDDS3005;
	LPDIRECTDRAWSURFACE		lpDDS3006;
	LPDIRECTDRAWSURFACE		lpDDS3007;
	LPDIRECTDRAWSURFACE		lpDDS3008;
	LPDIRECTDRAWSURFACE		lpDDS3009;
	LPDIRECTDRAWSURFACE		lpDDS3010;
	LPDIRECTDRAWSURFACE		lpDDS3011;
	LPDIRECTDRAWSURFACE		lpDDS3012;
	LPDIRECTDRAWSURFACE		lpDDS3013;

	LPDIRECTDRAWSURFACE		lpDDS4001;
	LPDIRECTDRAWSURFACE		lpDDS4002;
	LPDIRECTDRAWSURFACE		lpDDS4003;
	LPDIRECTDRAWSURFACE		lpDDS4004;
	LPDIRECTDRAWSURFACE		lpDDS4005;
	LPDIRECTDRAWSURFACE		lpDDS4006;
	LPDIRECTDRAWSURFACE		lpDDS4007;
	LPDIRECTDRAWSURFACE		lpDDS4008;
	LPDIRECTDRAWSURFACE		lpDDS4009;
	LPDIRECTDRAWSURFACE		lpDDS4010;
	LPDIRECTDRAWSURFACE		lpDDS4011;
	LPDIRECTDRAWSURFACE		lpDDS4012;
	LPDIRECTDRAWSURFACE		lpDDS4013;
	LPDIRECTDRAWSURFACE		lpDDS4014;
	LPDIRECTDRAWSURFACE		lpDDS4015;
	LPDIRECTDRAWSURFACE		lpDDS4016;
	LPDIRECTDRAWSURFACE		lpDDS4017;

	LPDIRECTDRAWSURFACE		lpDDMapWindow;
	LPDIRECTDRAWSURFACE		lpDDMap;
	LPDIRECTDRAWSURFACE		lpDDDot;


	LPDIRECTDRAWSURFACE		lpBall;
	LPDIRECTDRAWSURFACE		lpStars;
	LPDIRECTDRAWSURFACE		lpMagic;



	// 
	LPDIRECTDRAWSURFACE		Explosion1;		// 1

	LPDIRECTDRAWSURFACE		Trans;			// 


	LPDIRECTDRAWSURFACE		Light1;
	LPDIRECTDRAWSURFACE		Light2;


	LPDIRECTDRAWSURFACE		Balloon;			// ǳ
	LPDIRECTDRAWSURFACE		BalloonBig;

	LPDIRECTDRAWSURFACE		LightStone;
	LPDIRECTDRAWSURFACE		LightStoneBeam;


	//  â
	LPDIRECTDRAWSURFACE		lpBoard;		// Pointer to offscreen board surface
	LPDIRECTDRAWSURFACE		lpBoard_over_cha;
	LPDIRECTDRAWSURFACE		lpBoard_down_cha;
	LPDIRECTDRAWSURFACE		lpBoard_over_map;
	LPDIRECTDRAWSURFACE		lpBoard_down_map;
	LPDIRECTDRAWSURFACE		lpBoard_over_heal;
	LPDIRECTDRAWSURFACE		lpBoard_down_heal;
	LPDIRECTDRAWSURFACE		lpBoard_over_op;
	LPDIRECTDRAWSURFACE		lpBoard_down_op;
	LPDIRECTDRAWSURFACE		lpBoard_over_mana;
	LPDIRECTDRAWSURFACE		lpBoard_down_mana;
	LPDIRECTDRAWSURFACE		lpBoard_over_item;
	LPDIRECTDRAWSURFACE		lpBoard_down_item;
	LPDIRECTDRAWSURFACE		lpBoard_over_magic;
	LPDIRECTDRAWSURFACE		lpBoard_down_magic;
	LPDIRECTDRAWSURFACE		lpBoard_empty_healbar;
	LPDIRECTDRAWSURFACE		lpBoard_full_healbar;
	LPDIRECTDRAWSURFACE		lpBoard_empty_manabar;
	LPDIRECTDRAWSURFACE		lpBoard_full_manabar;
	LPDIRECTDRAWSURFACE		lpBoard_chat;


	
	//  ĳ â
	LPDIRECTDRAWSURFACE		lpCharInfo;
	LPDIRECTDRAWSURFACE		lpCloseButton;
	LPDIRECTDRAWSURFACE		lpNumber;
	LPDIRECTDRAWSURFACE		lpNature;
	LPDIRECTDRAWSURFACE		lpCharItem_Man;
	LPDIRECTDRAWSURFACE		lpCharItem_Woman;
	LPDIRECTDRAWSURFACE		lpPlus;



	LPDIRECTDRAWSURFACE		lpCSSide;
	LPDIRECTDRAWSURFACE		lpCSChar1_off;
	LPDIRECTDRAWSURFACE		lpCSChar1_on;
	LPDIRECTDRAWSURFACE		lpCSChar2_off;
	LPDIRECTDRAWSURFACE		lpCSChar2_on;
	LPDIRECTDRAWSURFACE		lpCSChar3_off;
	LPDIRECTDRAWSURFACE		lpCSChar3_on;
	LPDIRECTDRAWSURFACE		lpCSFlat_off;
	LPDIRECTDRAWSURFACE		lpCSFlat_on;
	LPDIRECTDRAWSURFACE		lpCSArm1;
	LPDIRECTDRAWSURFACE		lpCSArm1_over;
	LPDIRECTDRAWSURFACE		lpCSArm2;
	LPDIRECTDRAWSURFACE		lpCSArm2_over;
	LPDIRECTDRAWSURFACE		lpCSArm3;
	LPDIRECTDRAWSURFACE		lpCSArm3_over;
	LPDIRECTDRAWSURFACE		lpCSSex1;
	LPDIRECTDRAWSURFACE		lpCSSex1_over;
	LPDIRECTDRAWSURFACE		lpCSSex2;
	LPDIRECTDRAWSURFACE		lpCSSex2_over;
	LPDIRECTDRAWSURFACE		lpCSInfo_text;
	LPDIRECTDRAWSURFACE		lpCSMenu1_off;
	LPDIRECTDRAWSURFACE		lpCSMenu1_on;
	LPDIRECTDRAWSURFACE		lpCSMenu2;
	LPDIRECTDRAWSURFACE		lpCSMenu2_off;
	LPDIRECTDRAWSURFACE		lpCSMenu2_on;
	LPDIRECTDRAWSURFACE		lpCSMenu3_off;
	LPDIRECTDRAWSURFACE		lpCSMenu3_on;



	// 
	LPDIRECTDRAWSURFACE		lpMagic0;
	LPDIRECTDRAWSURFACE		lpMagic1;
	LPDIRECTDRAWSURFACE		lpMagic2;
	LPDIRECTDRAWSURFACE		lpMagic3;
	LPDIRECTDRAWSURFACE		lpMagic4;
	LPDIRECTDRAWSURFACE		lpMagic5;
	LPDIRECTDRAWSURFACE		lpMagic6;


	LPDIRECTDRAWPALETTE		lpDDPal;
	LPDIRECTDRAWCLIPPER		lpClipper;		// Pointer to clipper
	DDBLTFX					ddbltfx;
	BOOL					fEnabled;		// DirectDraw enabled
	BOOL					fFullScreen;	// True when in FullScreen mode

	int						nCooperation;	// Cooperation level
	int						cx;				// Width of window
	int						cy;				// Height of window
	int						bbp;			// Bits per plane
	int						nBuffers;		// Numbers of buffers to create
} DDraw, *LPDDraw;

extern LPDDraw lpdraw;


// Functions declarations ///////////////////

BOOL DDrawInit();
BOOL DDEnable();
static BOOL DDCreateSurfaces();
LPDIRECTDRAWSURFACE DDCreateSurface(DWORD width, DWORD height, BOOL sysmem);
BOOL LoadImage();
BOOL LoginImage0();
BOOL LoginImage1();
void DDSetWidth( int w );
void DDSetHeight( int h );
void DDSetBpp( int bpp );
void DDDestroy();
void LoginDisable0();
void LoginDisable1();
void DDDisable();
BOOL DDSetCooperativeLevel(int level);
int DDGetCooperativeLevel();
LPDIRECTDRAW DDCreate(HWND hwndApp);
BOOL DDFlip();
HRESULT DDTextOut( LPDIRECTDRAWSURFACE lpDDSSurface, char* lpString, COLORREF BackColor, COLORREF TextColor, int posx, int posy);
void TextDisp(LPDIRECTDRAWSURFACE lpDDSSurface, char *string, BYTE color, int x, int y);
void BlitBoard (LPDIRECTDRAWSURFACE lpDDSScreen);
LPDIRECTDRAW DDGetLPDirectDraw();
HRESULT DDSRestore(void);
BOOL FillBufferRect(LPDIRECTDRAWSURFACE lpSurface, LPRECT lprect, COLORREF color);

#endif

