
#ifndef _WatchOutMAIN_H
#define _WatchOutMAIN_H


#define STRICT
#define WIN32_LEAN_AND_MEAN


#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <ddraw.h>
#include <mmsystem.h>
#include <process.h>
	
#include "ddutil.h"

#include "cmap.h"
#include "cmusic.h"
#include "csprite.h"
#include "cscreen.h"
#include "MouseInfo.h"

#include "WatchOutmap.h"
#include "WatchOutddraw.h"
#include "WatchOututil.h"	// not for release
#include "resource.h"

#include "Network.h"
#include "object.h"
#include "imeview.h"

#include "srhan.h"

#include <imm.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>


// Structure definitions //////////////////////////////
// Global Variables ///////////////////////////////////

typedef struct _GApp
{
	// Global datas //
	HWND		hwnd;
	RECT		wndRect;
	UINT		timerid;
	BOOL		bFlippingPaused;
	BOOL		bCanRunWindowed;
	BOOL		bChatMode;
	char		ChatText[101];
	int			ChatTextCount;
	
	BOOL		bLoginInput;
	int			LoingInputStep;

	BOOL		bScrollChat;
	int			ScrollPosi;
	char		ScrollChat[18][120];
	int			ScrollChatCount;
} GApp;

extern	GApp gapp;


typedef struct _Object
{
	unsigned short		Kind;			// ü 
										// 0 : Ϲ 
										// 1 : ǹ
										// 2 : ٸ ÷̾
										// 3 : 
										// 4 : ȣ
										// 5 : 
										// 6 : Ǵ
										// 7 : ȭ ν
										// 8 : ġ
	unsigned short		bWalk;			//   ִ 
	unsigned short		bSprite;		// Ʈ ó 
	PLAYER				Player;
	FIX					Fixed;
}Obj;

typedef struct _SELECTCHAR
{
	unsigned short		CurrentSelNum;

	BOOL				bSelChar;
	unsigned short		CurrentSelCharPosiNum;
	unsigned short		SelCharNum;
	int					CompleteSelChar[3];

	BOOL				bSelArm;
	unsigned short		CurrentSelArmPosiNum;
	unsigned short		SelArmNum;

	BOOL				bSelSex;
	unsigned short		CurrentSelSexPosiNum;
	unsigned short		SelSexNum;

	unsigned short		CurrentSelMenuPosiNum;
} SelChar;

extern SelChar	SChar;

// classes definitions /////////////////////////////////
extern	SrHan			Han;
extern	CMap			Map;
extern	CSocket*		Gsocket;
extern	CScreen			Screen;
extern	CSprite*		Tree;
extern	CMouseInfo		MouseInfo;
extern	CImeView		Ime;


// ÷̾  ۿ  ü
// =================   ڼ ========================
//     
extern	CSprite*		P4101;		//ڸ			Fix;
extern	CSprite*		P4111;		//ȱ				Move;
extern	CSprite*		P4121;		//ٱ				Run
extern	CSprite*		P4131;		//				Attack;
extern	CSprite*		P4141;		//(Ư)	Magic;
extern	CSprite*		P4151;		//´µ			
extern	CSprite*		P4161;		//ɾִڼ	= 
extern	CSprite*		P4171;		// ڼ	= 

//     
extern	CSprite*		P4102;		//ڸ			Fix;
extern	CSprite*		P4112;		//ȱ				Move;
extern	CSprite*		P4122;		//ٱ				Run
extern	CSprite*		P4132;		//				Attack;
extern	CSprite*		P4142;		//(Ư)	Magic;
extern	CSprite*		P4152;		//´µ			
extern	CSprite*		P4162;		//ɾִڼ	= 
extern	CSprite*		P4172;		// ڼ	= 


// ü    
extern	CSprite*		P4201;		//ڸ			Fix;
extern	CSprite*		P4211;		//ȱ				Move;
extern	CSprite*		P4221;		//ٱ				Run
extern	CSprite*		P4231;		//				Attack;
extern	CSprite*		P4241;		//(Ư)	Magic;
extern	CSprite*		P4251;		//´µ			
extern	CSprite*		P4261;		//ɾִڼ	= 
extern	CSprite*		P4271;		// ڼ	= 

// ü    
extern	CSprite*		P4202;		//ڸ			Fix;
extern	CSprite*		P4212;		//ȱ				Move;
extern	CSprite*		P4222;		//ٱ				Run
extern	CSprite*		P4232;		//				Attack;
extern	CSprite*		P4242;		//(Ư)	Magic;
extern	CSprite*		P4252;		//´µ			
extern	CSprite*		P4262;		//ɾִڼ	= 
extern	CSprite*		P4272;		// ڼ	= 

//     
extern	CSprite*		P4301;		//ڸ			Fix;
extern	CSprite*		P4311;		//ȱ				Move;
extern	CSprite*		P4321;		//ٱ				Run
extern	CSprite*		P4331;		//				Attack;
extern	CSprite*		P4341;		//(Ư)	Magic;
extern	CSprite*		P4351;		//´µ			
extern	CSprite*		P4361;		//ɾִڼ	= 
extern	CSprite*		P4371;		// ڼ	= 

//     
extern	CSprite*		P4302;		//ڸ			Fix;
extern	CSprite*		P4312;		//ȱ				Move;
extern	CSprite*		P4322;		//ٱ				Run
extern	CSprite*		P4332;		//				Attack;
extern	CSprite*		P4342;		//(Ư)	Magic;
extern	CSprite*		P4352;		//´µ			
extern	CSprite*		P4362;		//ɾִڼ	= 
extern	CSprite*		P4372;		// ڼ	= 



// ============= 1  ڼ ========================
//   1 
extern	CSprite*		P5101;		//ڸ			Fix;
extern	CSprite*		P5111;		//ȱ				Move;
extern	CSprite*		P5121;		//ٱ				Run
extern	CSprite*		P5131;		//				Attack;
extern	CSprite*		P5141;		//(Ư)	Magic;
extern	CSprite*		P5151;		//´µ			


//   1 
extern	CSprite*		P5102;		//ڸ			Fix;
extern	CSprite*		P5112;		//ȱ				Move;
extern	CSprite*		P5122;		//ٱ				Run
extern	CSprite*		P5132;		//				Attack;
extern	CSprite*		P5142;		//(Ư)	Magic;
extern	CSprite*		P5152;		//´µ			



// ü  1 
extern	CSprite*		P5201;		//ڸ			Fix;
extern	CSprite*		P5211;		//ȱ				Move;
extern	CSprite*		P5221;		//ٱ				Run
extern	CSprite*		P5231;		//				Attack;
extern	CSprite*		P5241;		//(Ư)	Magic;
extern	CSprite*		P5251;		//´µ			


// ü  1 
extern	CSprite*		P5202;		//ڸ			Fix;
extern	CSprite*		P5212;		//ȱ				Move;
extern	CSprite*		P5222;		//ٱ				Run
extern	CSprite*		P5232;		//				Attack;
extern	CSprite*		P5242;		//(Ư)	Magic;
extern	CSprite*		P5252;		//´µ			


//   1 
extern	CSprite*		P5301;		//ڸ			Fix;
extern	CSprite*		P5311;		//ȱ				Move;
extern	CSprite*		P5321;		//ٱ				Run
extern	CSprite*		P5331;		//				Attack;
extern	CSprite*		P5341;		//(Ư)	Magic;
extern	CSprite*		P5351;		//´µ			


//   1 
extern	CSprite*		P5302;		//ڸ			Fix;
extern	CSprite*		P5312;		//ȱ				Move;
extern	CSprite*		P5322;		//ٱ				Run
extern	CSprite*		P5332;		//				Attack;
extern	CSprite*		P5342;		//(Ư)	Magic;
extern	CSprite*		P5352;		//´µ			

// ==========================================================
// ========== ȿ Draw ===========================
// ==========================================================

extern	int mapWidth, mapHeight;

// Functions declarations //////////////////////////////
static	BOOL DoInit (HINSTANCE hInstance, int nCmdShow);
long	FAR PASCAL WindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
static	BOOL InitFail (HWND hwnd);
static	void LoginLoop0();
static  void MainLoop();
static	BOOL DrawInit();
static  void PlayerNextFrame(int user);
void	CheckKeyboard(int user);
BOOL	CreateObjects();
void	DestroyObjects();
//void   _beginthread();
//_beginthread (void (__cdecl *) (void *), unsigned, void *);

void	MovePlayerPathSetting(int user);
void	Login_MouseDown0(int x, int y, int *Step);
void	Login_MouseDown1(int x, int y, int *Step);
void	Login_MouseDown2(int x, int y, int *Step);
void	Login_MouseDown3(int x, int y, int *Step);
void	KeyMouse_OnMouseDown(int x, int y, int User);
void	KeyMouse_OnMouseDown_ItemWindow();
//int		KeyMouse_OnMouseMove(int x, int y);
void	LoadObjectFile();

VOID	Receive_Data(void* UserValue);
VOID	NextFrame_Data(void *UserValue);

void	Login_KeyDown(int step, WPARAM wParam, LPARAM lParam);		// α ܰ

extern int		StepCurrentStep;	// α:0, :1...

VOID	TestThread(LPVOID lParam);
void  	_endthread();


#endif