/*
 *
 *  Xrainbow DirectX TG Hangul Library V1.0
 *
 *  Program by LEE WON HEE (GGUMTL)
 *
 *  1997.5.13 ~
 */

#ifndef __XDDFONT_H
#define __XDDFONT_H

#ifndef __cplusplus
	#error "This library was made C++."
#endif 

typedef BYTE            COLOR;

enum FONT_PATTERN
{
	NORMAL_PATTERN = 0,
	INC16_PATTERN,
	DEC16_PATTERN,
	INC8_PATTERN,
	DEC8_PATTERN,
	DECINC_PATTERN,
	INCDEC_PATTERN,
};

enum FONT_FILE_TYPE
{
	HANGUL_FNT,
	ENGLISH_FNT,
};

typedef struct {
	BYTE sndchar;
	BYTE fstchar;
} hanchar;

typedef struct {
	WORD jongsung : 5;
	WORD jungsung : 5;
	WORD chosung  : 5;
	WORD det_han_or_eng : 1;
} hancode;

typedef union {
	 hanchar hchar;
	 hancode hcode;
} hangul;

// Initialize

BOOL InitXddFont(char *pHan,char *pEng);

// Load

BOOL LoadFont(char *pFile,WORD wType);

// Attribute

void SetFontPattern(int nPattern);

void SetUserFontPattern(char *Pattern);

void SetFontWidth(int nHangul,int nEnglish,int nSpace);

// Output

int PutFont(IDirectDrawSurface *pdds,int xPos,int yPos,COLOR color,char *pStr);

int PutFontf(IDirectDrawSurface *pdds,int xPos,int yPos,COLOR color,char *fmt,...);


#if defined(__WATCOMC__)

extern void _Image_Or (char *src, char *dest );
#pragma aux _Image_Or  =
            "MOV        EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            "ADD    EDI,4"\
            "ADD    ESI,4"\

            "MOV    EAX,[ESI]"\
            "OR     [EDI],EAX"\
            parm    [ESI] [EDI] modify [EAX];
#endif

#endif

