#undef   WIN32_LEAN_AND_MEAN
#define  WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

//#include "XddWin.h"
#include "XddFont.h"

static char HF8_1[8][20][32];
static char HF8_2[4][22][32];
static char HF8_3[4][28][32];
static char EF[256][16];

const char INDEXHF[3][32] = 
{
    { 0, 0, 1, 2, 3, 4, 5, 6,7, 8, 9,10,11,12,13,14,
      15,16,17,18,19,0, 0, 0,0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 1, 2, 3, 4, 5,0, 0, 6, 7, 8, 9,10,11,
      0, 0,12,13,14,15,16,17,0, 0,18,19,20,21, 0, 0 },
    { 0, 0, 1, 2, 3, 4, 5, 6,7, 8, 9,10,11,12,13,14,
      15,16, 0,17,18,19,20,21,22,23,24,25,26,27, 0, 0 }
};

const char REFSECOND10_8[2][20] = 
{
    { 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1 },
    { 2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3 }
};

const char REFFIRST8[2][22] = 
{
    { 0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0 },
    { 1,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5 }
};

const char REFLAST10_8[22] = {0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1 };

static int ENGLISH_WIDTH = 0;
static int HANGUL_WIDTH  = 0;
static int SPACE_WIDTH   = 0;

static char *pPattern;
static char pattNormal[16]   ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static char pattIncress16[16]={0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
static char pattDecress16[16]={15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
static char pattIncress8[16] ={0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1};
static char pattDecress8[16] ={7,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1};
static char pattIncDec[16]   ={0,1,1,1,1,1,1,1,0,-1,-1,-1,-1,-1,-1,-1};
static char pattDecInc[16]   ={7,-1,-1,-1,-1,-1,-1,0,1,1,1,1,1,1,1,1};

////////////////////////////////////////////////////////////////////////////

#if !defined(__WATCOMC__)

static void _Image_Or(char *scr,char *dest)
{
	_asm
	{
        push	esi
        push	edi

        mov     esi,scr
        mov     edi,dest
        mov     ecx,8
	}
_LOOP:
	_asm
	{
        mov     eax,[esi]
        or      [edi],eax
        add     edi,4
        add     esi,4

        dec     ecx
        test	ecx,ecx
        ja      _LOOP

        pop     edi
        pop     esi
	}
}

#endif

static void Put_Eng(char *v,int nWidth,COLOR color,char *pData)
{
	char  *p = pPattern;
	for(int i=0;i<16;i++)
	{
		color += *p++;
		if(*pData)
		{
			if(*pData & 0X80) *(v)   = color;
			if(*pData & 0X40) *(v+1) = color;
			if(*pData & 0X20) *(v+2) = color;
			if(*pData & 0X10) *(v+3) = color;
			if(*pData & 0X08) *(v+4) = color;
			if(*pData & 0X04) *(v+5) = color;
			if(*pData & 0X02) *(v+6) = color;
			if(*pData & 0X01) *(v+7) = color;
		}
		v += nWidth;
		pData++;
	}	
}

static void Put_Han(char *v,int nWidth,COLOR color,char *pData)
{
	char  *p = pPattern;

	for(int i=0;i<16;i++)
	{
		color += *p++;
		if(*pData)
		{
			if (*pData & 0X80) *(v)  =color;
			if (*pData & 0X40) *(v+1)=color;
			if (*pData & 0X20) *(v+2)=color;
			if (*pData & 0X10) *(v+3)=color;
			if (*pData & 0X08) *(v+4)=color;
			if (*pData & 0X04) *(v+5)=color;
			if (*pData & 0X02) *(v+6)=color;
			if (*pData & 0X01) *(v+7)=color;
		}
		pData++;
		if(*pData)
		{
			if (*pData & 0X80) *(v+8) =color;
			if (*pData & 0X40) *(v+9) =color;
			if (*pData & 0X20) *(v+10)=color;
			if (*pData & 0X10) *(v+11)=color;
			if (*pData & 0X08) *(v+12)=color;
			if (*pData & 0X04) *(v+13)=color;
			if (*pData & 0X02) *(v+14)=color;
			if (*pData & 0X01) *(v+15)=color;
		}
		v += nWidth;
		pData++;
	}
}

static void Put_Han_Char(char *v,int nWidth,COLOR color,BYTE fstByte,BYTE sndByte)
{
	char hbuffer[32];
	hangul h;
	int b1, b2, b3, first, mid, last;

	h.hchar.fstchar = fstByte;
	h.hchar.sndchar = sndByte;

	first = *(*(INDEXHF)+h.hcode.chosung);
	mid   = *(*(INDEXHF+1)+h.hcode.jungsung);
	last  = *(*(INDEXHF+2)+h.hcode.jongsung);

	if(!last)
	{
		b2 = *(*(REFSECOND10_8)+first);
		b1 = *(*(REFFIRST8)+mid);
	}
	else
	{
		b2 = *(*(REFSECOND10_8+1)+first);
		b1 = *(*(REFFIRST8+1)+mid);
	}

	memcpy(hbuffer, *(*(HF8_1+b1)+first),32);
	if(mid) _Image_Or( *(*(HF8_2+b2)+mid),hbuffer);
	if(last)
	{
		b3 = *(REFLAST10_8+mid);
		_Image_Or( *(*(HF8_3+b3)+last),hbuffer);
	}

	Put_Han(v,nWidth,color,hbuffer);
}

BOOL LoadFont(char *pFile,WORD wType)
{
	FILE *fp;
	fp = fopen(pFile,"rb");
	if(fp==NULL) return FALSE;

	if(wType == ENGLISH_FNT)
	{
		fread(EF, 4096, 1, fp);
	} else
	{
		fread((void *)HF8_1, 5120, 1, fp);
		fread((void *)HF8_2, 2816, 1, fp);
		fread((void *)HF8_3, 3584, 1, fp);
	}

	fclose(fp);
	return TRUE;
}

void SetFontWidth(int nHangul,int nEnglish,int nSpace)
{
	HANGUL_WIDTH  = nHangul;
	ENGLISH_WIDTH = nEnglish;
	SPACE_WIDTH   = nSpace;
}

void SetFontPattern(int nPattern)
{
	switch(nPattern)
	{
		case NORMAL_PATTERN: pPattern = &pattNormal[0];	   break;
		case INC16_PATTERN : pPattern = &pattIncress16[0]; break;
		case DEC16_PATTERN : pPattern = &pattDecress16[0]; break;
		case INC8_PATTERN  : pPattern = &pattIncress8[0];  break;
		case DEC8_PATTERN  : pPattern = &pattDecress8[0];  break;
		case DECINC_PATTERN: pPattern = &pattDecInc[0];    break;
		case INCDEC_PATTERN: pPattern = &pattIncDec[0];    break;
		default: pPattern = &pattNormal[0];
	}
}

void SetUserFontPattern(char *Pattern)
{
	pPattern = Pattern;
}

BOOL InitXddFont(char *pHan,char *pEng)
{
	BOOL ret = FALSE;

	SetFontPattern(NORMAL_PATTERN);

	if(pHan)
	{
		ret = LoadFont(pHan,HANGUL_FNT);
		if(!ret) return FALSE;
		SetFontWidth(16,ENGLISH_WIDTH,8);
	}

	if(pEng)
	{
		ret = LoadFont(pEng,ENGLISH_FNT);
		SetFontWidth(HANGUL_WIDTH,8,8);
	}

	return ret;
}

int PutFont(IDirectDrawSurface *pdds,int xPos,int yPos,COLOR color,char *pStr)
{
	DDSURFACEDESC ddsc;
	BYTE fstByte;
	char *ptr;

	ddsc.dwSize = sizeof(ddsc);
	if(pdds->Lock(NULL,&ddsc,DDLOCK_WAIT,NULL) !=DD_OK)
	{
		OutputDebugString("PutFont locking error...\n");
		return xPos;
	}

	ptr = (char *)ddsc.lpSurface + (yPos * ddsc.lPitch) + xPos ;
	
	while(*pStr) {

		fstByte = *pStr++;

		if(fstByte & 0x80)    // Hangul
		{						
			Put_Han_Char(ptr,ddsc.lPitch,color,fstByte,*pStr++);
			ptr  += HANGUL_WIDTH;
			xPos += HANGUL_WIDTH;
		} 
		else
		{
			if(fstByte != ' ') // English
			{
				Put_Eng(ptr,ddsc.lPitch,color,*(EF+fstByte));
				ptr += ENGLISH_WIDTH;
				xPos+= ENGLISH_WIDTH;
			} else 
			{
				ptr  += SPACE_WIDTH;
				xPos += SPACE_WIDTH;
			}
		}
	}

	pdds->Unlock(NULL);
	return xPos;
}

int PutFontf(IDirectDrawSurface *pdds,int xPos,int yPos,COLOR color,char *fmt,...)
{
	char buffer[256];

	va_list argptr;
	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	return PutFont(pdds,xPos,yPos,color,buffer);
}

