/*
 *
 *  Xrainbow DirectX Image File Library V1.0
 *
 *  Program by LEE WON HEE (GGUMTL)
 *
 *  ( BMP,PCX,GIF,SPR,TIL,IMG,PAL,FLC,FLI )
 */

#ifndef __XDDPIC_H
#define __XDDPIC_H

#ifndef __cplusplus
	#error "This library was made C++."
#endif 

typedef struct 
{
	char  Manufacturer;
	char  Version;
	char  Encode;
	char  BitPerPixel;
	short Xmin;
	short Ymin;
	short Xmax;
	short Ymax;
	short Hres;
	short Vres;
	char  RGB_Palette[48];
	char  Reserved;
	char  ColorPlanes;
	short BytePerLine;
	short PaletteType;
	char  Filler[58];
}PCXHEAD,*LPPCXHEAD;

enum PIC_TYPE
{
	BMP_FILE = 1,
	PCX_FILE,
	GIF_FILE,
	SPR_FILE,
	TIL_FILE,
	IMG_FILE,
	PAL_FILE
};

// Palette    ( BMP,PCX,GIF,SPR,TIL,IMG,PAL)

IDirectDrawPalette * DDLoadPalette(LPCSTR szBitmap,DWORD dwType);

// Image File ( BMP,PCX,GIF,SPR,TIL,IMG)

IDirectDrawSurface * DDLoadPic(LPCSTR szBitmap,DWORD dwType);

HRESULT              DDReLoadPic(IDirectDrawSurface *pdds, LPCSTR szBitmap,DWORD dwType);

// Animation File


// Colorkey & Copy Bitmap

HRESULT              DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int x, int y, int dx, int dy);

DWORD                DDColorMatch(IDirectDrawSurface *pdds, COLORREF rgb);

HRESULT              DDSetColorKey(IDirectDrawSurface *pdds, COLORREF rgb);


#endif

