
#include "WatchOutmain.h"


//////////////////////////////////////////////////////////////////////////////////
// CMusic Constructor
//////////////////////////////////////////////////////////////////////////////////
CMusic::CMusic(void *hWnd)
{
	m_hWnd  = gapp.hwnd;
	m_bPlay = FALSE;
}

//////////////////////////////////////////////////////////////////////////////////
// CMusic Play
//////////////////////////////////////////////////////////////////////////////////
BOOL CMusic::Play(const char *Filename)
{
	if(Filename == NULL) return FALSE;
	char buffer[256];

	sprintf(buffer, "open %s type sequencer alias MUSIC", Filename);

	if (mciSendString("close all", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	if (mciSendString(buffer, NULL, 0, NULL) != 0)
	{	
		return(FALSE);
	}

	if (mciSendString("play MUSIC from 0 notify", NULL, 0, gapp.hwnd) != 0)
	{
		return(FALSE);
	}	
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CMusic Stop
//////////////////////////////////////////////////////////////////////////////////
CMusic::Stop()
{
	if (mciSendString("close all", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}   
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CMusic Pause
//////////////////////////////////////////////////////////////////////////////////
BOOL CMusic::Pause(void)
{
	// Pause if we're not already paused
	if (mciSendString("stop MUSIC", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CMusic Stop
//////////////////////////////////////////////////////////////////////////////////
BOOL CMusic::Resume(void)
{	
	// Resume midi
	if (mciSendString("play MUSIC notify", NULL, 0, gapp.hwnd) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CMusic Restart
//////////////////////////////////////////////////////////////////////////////////
BOOL CMusic::Restart(void)
{
	DWORD	err = 0;

	// Replay midi
	err = mciSendString("play MUSIC from 0 notify", NULL, 0, gapp.hwnd);
	if (err != 0)
	{
		PrintMciErrorMsg(err, "Sequencer device did not open!");
		return(FALSE);
	}
	return TRUE;
}

// PrintMciErrorMsg -- Handles MCI error messages
void PrintMciErrorMsg(DWORD err, TCHAR * str)
{
	#define BUFFERSIZE 128
	char	buffer[BUFFERSIZE];
	
	printf("ERROR: %s\r\n", str);
	if (mciGetErrorString(err, &buffer[0], sizeof(buffer)))
	{
		printf("%s\r\n", &buffer[0]);
	}
	else
	{
		printf("0x%08X returned!\r\n", err);
	}
}
