
#include "WatchOutmain.h"


void CSprite::Init()
{
	m_ddSurface = NULL;
	m_spriteX = 0;
	m_spriteY = 0;
	m_frame = 0;
	m_bVisible = TRUE;
}


CSprite::CSprite(LPSTR filename, unsigned short width, unsigned short height)
{
	LPDIRECTDRAW lpdd = DDGetLPDirectDraw();

	// Initialize
	Init();

	// Create offscreen surface holding sprite bitmap
	m_ddSurface = DDLoadBitmap (lpdd, filename, 0, 0);

	if (m_ddSurface == NULL)
	{
		OutputDebugString( "CSprite (DDLoadBitmap) : Couldn't create CSprite object surface...\n" );
		return;
	}

	//=======================================================
	// Set color key for this surface
	//DDSetColorKey (m_ddSurface, RGB(255,255,255));
	DDSetColorKey (m_ddSurface, RGB(0, 0, 0));
	//=======================================================

	// initialize variables
	m_w = width;
	m_h = height;
}


CSprite::~CSprite()
{
	if( m_ddSurface != NULL )
		m_ddSurface->Release();
}


void CSprite::Render (LPDIRECTDRAWSURFACE lpDestSurf, unsigned short x, unsigned short y, unsigned short frame, int	MaxFrame, int TransFlag)
{
	DDBLTFX     ddbltfx;

	RECT srcRect;
	RECT destRect;
	
	unsigned short xOffset,yOffset;
	unsigned short xLen, yLen;
	unsigned short xOff, yOff;

	if (frame < MaxFrame)
	{
		xOffset = frame * m_w;
		yOffset=0;
	}
	else if (frame < MaxFrame*2) 
	{
		xOffset = (frame - MaxFrame) * m_w;
		yOffset = m_h;
	}
	else if (frame < MaxFrame*3)
	{
		xOffset = (frame - MaxFrame*2) * m_w;
		yOffset = m_h*2;
	}
	else if (frame < MaxFrame*4)
	{
		xOffset = (frame - MaxFrame*3) * m_w;
		yOffset = m_h*3;
	}
	else if (frame < MaxFrame*5)
	{
		xOffset = (frame - MaxFrame*4) * m_w;
		yOffset = m_h*4;
	}
	else if (frame < MaxFrame*6)
	{
		xOffset = (frame - MaxFrame*5) * m_w;
		yOffset = m_h*5;
	}
	else if (frame < MaxFrame*7)
	{
		xOffset = (frame - MaxFrame*6) * m_w;
		yOffset = m_h*6;
	}
	else if (frame < MaxFrame*8)
	{
		xOffset = (frame - MaxFrame*7) * m_w;
		yOffset = m_h*7;
	}

//	x-=m_w;
//	y-=m_h;
	
	if(x >= (m_w/2))		// 70 >= 50
	{
		destRect.left = x-(m_w/2);	// 70 - 50 = 20
		destRect.right = x+(m_w/2);	// 70 + 50 = 120

		srcRect.left = xOffset;		// 0
		srcRect.right = xOffset + m_w;	// 0 + 100 - 1 = 99
	}
	else
	{
		destRect.left = 0;			// 0
		destRect.right = (m_w/2)+x;	// 50 + -10

		srcRect.left = xOffset + (m_w/2) - x;		// 100 - 10 = 90
		srcRect.right = xOffset + m_w; // 0 + 100 - 1
	}

	if(y >= (m_h/2))
	{
		destRect.top = y-(m_h/2);
		destRect.bottom = y+(m_h/2);

		srcRect.top = yOffset;
		srcRect.bottom = yOffset + m_h;
	}
	else
	{
		destRect.top = 0;
		destRect.bottom =(m_h/2)+y;

		srcRect.top = yOffset + (m_h/2) - y;
		srcRect.bottom = yOffset + m_h;
	}

//	char ttttt[100];
//	sprintf(ttttt, "[%d, %d][%d, %d],   [%d, %d][%d, %d]", destRect.left, destRect.top, destRect.right, destRect.bottom,
//								srcRect.left, srcRect.top, srcRect.right, srcRect.bottom);
//	DDTextOut( lpdraw->lpDDSBack, ttttt, RGB(0,0,0), RGB(255, 0, 0), 20, 250 );

	memset(&ddbltfx, NULL, sizeof(ddbltfx));
	ddbltfx.dwSize = sizeof(ddbltfx);

	ddbltfx.dwDDFX = NULL;

	lpDestSurf->Blt(&destRect, m_ddSurface, &srcRect, DDBLT_WAIT | DDBLT_KEYSRC, &ddbltfx);
}