     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// cCostume_Order.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "costume.h"

///////////////////////////////////////////////////////////////////////////////
bool cCostume_Order :: Save( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) return Fail( this, "COSTUME_ERR_SAVE");
	file.Write( &m_Order, sizeof( COSTUME_ORDER));

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cCostume_Order :: Load( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) return Fail( this, "COSTUME_ERR_LOAD");
	file.Read( &m_Order, sizeof( COSTUME_ORDER));
	return true;
}
///////////////////////////////////////////////////////////////////////////////
void cCostume_Order :: SetCostumeOrder( int order, int iType)
{
	switch( order)
	{
	case 0: m_Order.u0st = iType; break;
	case 1: m_Order.u1st = iType; break;
	case 2: m_Order.u2st = iType; break;
	case 3: m_Order.u3st = iType; break;
	case 4: m_Order.u4st = iType; break;
	case 5: m_Order.u5st = iType; break;

	}
}
///////////////////////////////////////////////////////////////////////////////
int cCostume_Order :: GetCostumeOrder( int order)
{
	switch( order)
	{
	case 0: return m_Order.u0st;
	case 1: return m_Order.u1st;
	case 2: return m_Order.u2st;
	case 3: return m_Order.u3st;
	case 4: return m_Order.u4st;
	case 5: return m_Order.u5st;

	default: return -1;
	}
}
