     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// file.h
///////////////////////////////////////////////////////////////////////////////
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef _FILE_H_
#define _FILE_H_

#ifndef _STRUCT_H_
#include "struct.h"
#endif

///////////////////////////////////////////////////////////////////////////////
typedef int FILE_HANDLE;

///////////////////////////////////////////////////////////////////////////////
typedef class cFile
{
public:
    enum FILE_FLAGS { FF_NO_IO, FF_READ, FF_WRITE };
	enum FILE_ERR { FE_NONE, FE_NOT_READABLE, FE_NOT_WRITABLE, FE_PROBLEM };

public:
	cFile( string sFileName, FILE_FLAGS fFlag);
	virtual ~cFile();

	FILE_ERR  Status();					
	FILE_ERR  Write( void* data, int size );
	FILE_ERR  Read( void* data, int size );

	int       Seek( int where);
	int       Advance( int howmuch);
	int       SeekFromEnd( int where);


protected:
    FILE_FLAGS  m_fFlag;
	FILE_HANDLE m_hFile;

    
} cFile, * cFilePtr;

///////////////////////////////////////////////////////////////////////////////
//
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool Load( Type* pType, string sFilePath)
{
	cFile file( sFilePath, cFile :: FF_READ);

	if( file.Status() != 0) return false;
	if( !pType->Load( file)) return Fail( pType, "FILE_ERR_LOAD");

    return true;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool Save( Type* pType, string sFilePath)
{ 
	cFile file( sFilePath, cFile :: FF_WRITE);

	if( file.Status() != 0) return false;
	if( !pType->Save( file)) return Fail(  pType, "FILE_ERR_SAVE");
	
    return true;
}
///////////////////////////////////////////////////////////////////////////////
#endif //_FILE_H_
///////////////////////////////////////////////////////////////////////////////