     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Graphic.h
///////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif 

#ifndef _GRAPHIC_H_
#define _GRAPHIC_H_

#ifndef _STRUCT_H_
#include "struct.h"
#endif

#ifndef _FILE_H_
#include "file.h"
#endif

#ifndef _SCREEN_H_
#include "screen.h"
#endif

///////////////////////////////////////////////////////////////////
// GRAPIC_FLAG
///////////////////////////////////////////////////////////////////
#define GRP_CLRTYPE_5x5x5_        1
#define GRP_CLRTYPE_5x6x5_        GRP_CLRTYPE_5x5x5_ * 2

#define GRP_NORMAL                GRP_CLRTYPE_5x6x5_ * 2
#define GRP_TEXTURE               GRP_NORMAL * 2
#define GRP_SURFACE               GRP_TEXTURE * 2
#define GRP_VIRTUAL               GRP_SURFACE * 2
  
#define GRP_CLRKEY_HAS            GRP_VIRTUAL * 2        // ǥ, ؽ ҽ ̱׷ Ҷ 
#define GRP_CLRKEY_FIND           GRP_CLRKEY_HAS * 2     // ÷Ű ãƶ...
#define GRP_CLRKEY_WHITE          GRP_CLRKEY_FIND * 2
#define GRP_CLRKEY_BLACK          GRP_CLRKEY_WHITE * 2
#define GRP_COMPRESS              GRP_CLRKEY_BLACK * 2   //  ׷ȸ ȭ鿡 ׸ Ҷ....  
#define GRP_CENTERDRAW            GRP_COMPRESS * 2
#define GRP_VIRTUAL_COMPRESS      GRP_CENTERDRAW * 2

        //////////////////////////////

#define GRP_SPRITE   ( GRP_CLRKEY_HAS | GRP_CLRKEY_FIND | GRP_COMPRESS )
#define GRP_SUR_SPR  ( GRP_SURFACE | GRP_CLRKEY_HAS | GRP_CLRKEY_FIND )
#define GRP_TILE     ( GRP_NORMAL )

///////////////////////////////////////////////////////////////////////////////
// DRAWING Flag
///////////////////////////////////////////////////////////////////////////////
enum DRAW_FLAG { DF_NORMAL, DF_ALPHA_25, DF_ALPHA_50, DF_ALPHA_75,
                 DF_BLUE, DF_RED, DF_GREEN, DF_SHADOW, DF_SLOPED_SHADOW, DF_LIGHTEN, DF_DARKEN};

#define g_pGraphicFormat g_pScreen->GetGraphicFormat()
///////////////////////////////////////////////////////////////////////////////
// cGraphic
///////////////////////////////////////////////////////////////////////////////
typedef class cGraphic 
{
public:
	cGraphic();
    virtual ~cGraphic();

    ////////////////////////////////
    
    void            Clear();

    bool            LoadGraphic( string FilePath, DWORD dwFlag);
    bool            Load( cFile& file);
	bool            Save( cFile& file);

	bool            Draw( int x, int y, DWORD dwFlag = DF_NORMAL);
	bool            DrawAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag = DF_NORMAL);
	bool            DrawTileAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag = DF_NORMAL);
	bool            DrawNormalAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag = DF_NORMAL);
	bool            DrawSpriteAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag = DF_NORMAL);
	bool            DrawVirtualAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag = DF_NORMAL);
	
    ////////////////////////////////
	
    WORD*           GetImagePtr() { return m_Canvas.pwAddress;}
	WORD            GetColorKey( WORD* ptr);
	WORD            GetColorKey() { return m_wColorKey;}
	int             GetWidth() { return m_Canvas.size.iWidth;}
	int             GetHeight() { return m_Canvas.size.iHeight;}
	DWORD           GetFlag() { return m_dwFlag;}

    void            CompressGraphic( WORD* pSrc);
	void            AddGraphicFlag( DWORD dwFlag){ m_dwFlag |= dwFlag;}
	void            CutEdge( POINT ptRelativeCenter);
	cGraphic*       CreateVirtualGraphic( RECT rc);

#ifdef _TOOL_
	void            SetCenterPoint( POINT pt);
#endif
	
	cGraphic &operator = (cGraphic &cSrc);

	////////////////////////////////////////
private:
	// Ʈ  Լ
    WORD*           LLECompression16Bit( WORD* pImage, int width, int height, WORD* pNumPixels) const; 
	void            LLECompressSingleLine16Bit ( WORD* Compress, WORD* wIndex, int iwidth, int* iBytesInLine) const;
	int             Count0sInAnArray16Bit ( WORD* a, int num) const; 
	int             CountNon0sInAnArray16Bit ( WORD* a, int num) const;
	int             CountRuns16Bit ( WORD* pIndex, int num) const;

	bool            LoadBmp( string strBmpFilePath);
	bool            LoadTga( string strBmpFilePath);

	bool            Load8Bit( cFile& file , int numColor);
	bool            Load24Bit( cFile& file);
	bool            Load16Bit( cFile& file);
   
    void            ConvertTo16Bit( WORD* pImage, RGBValPtr pRgbData, int Num);
    void            ConvertIndexToRGB( RGBVal* rgb, BYTE* index, LPVOID pPal, int len);
	void            ConvertTo_5x6x5( WORD* ptr , int num);
	void            ConvertTo_5x5x5( WORD* ptr , int num);

	bool            BlitCompressed( CANVASPtr pDestSur, int x, int y);
	bool            Blit( CANVASPtr pDestSur, int x, int y);

	bool            BlitCompressedVirtualGraphic( CANVASPtr pDestCan, int x, int y);
	bool            BlitCompressedClipped( CANVASPtr pDestSur, int x, int y);
	bool            BlitClipped( CANVASPtr pDestSur, int x, int y);
	int             Clipping( CANVASPtr pDestSur, int x, int y);

	void            SetBlitFunction( DWORD dwFlag = 0);    

	////////////////////////////////////////
protected:
	WORD      m_wNumPixels;
	WORD*     m_pwScratchPad; // ̹ ӽ ޸   

    WORD      m_wColorKey;
    DWORD     m_dwFlag;
	CANVAS    m_Canvas;
	POINT     m_CenterPt;

	// ̹ Ÿ  Լ  //
	void ( _fastcall * m_pfBlitFunction ) ( WORD* pwDest, WORD* pwSrc, int num, int hight);
    bool ( cGraphic :: * m_pfDrawAtFunction ) ( CANVASPtr pCanvas, int x, int y, DWORD dwFlag);

} cGraphic, * cGraphicPtr, ** cGraphicList;
///////////////////////////////////////////////////////////////////////////////
#endif // _GRAPHIC_H_

