     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// graphic_direction.h
///////////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
///////////////////////////////////////////////////////////////////////////////
#ifndef _GRAPHIC_DIRECTIONAL_H_
#define _GRAPHIC_DIRECTIONAL_H_

#ifndef _GRAPHIC_SEQUENCE_H_
#include "graphic_Sequence.h"
#endif

#ifndef _ANIMATION_STATE_H_
#include "animation_state.h"
#endif

///////////////////////////////////////////////////////////////////////////////
// cGraphic_Directional
//     : 8 
//  ĳ : 16  
// ̾  : 16    
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
class cGraphic_Directional : public cGraphic_Source
{
public:
	cGraphic_Directional(); 
	virtual ~cGraphic_Directional();

	virtual void   Clear();

	//////////////////////////////////////////
	bool             Save( cFile& file);
	bool             Load( cFile& file);   
    bool             LoadGraphicFromPrevious( string sFilepath, int iDirNum);
    bool             LoadGraphicFromDirectory( string sFilesPath, DWORD dwFlag); 

	int              GetSequenceNum () const;
	void*            GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const;
	void*            GetGraphic( cAnimation_State*) const;

	bool             Draw( cAnimation_State* pAnimState, int x, int y);
	bool             CreateDirectional( int iFrameNum, int iDirNum); // cCostume Ҷ .

protected:
	int              CountFolder( string sFilePath);

	//////////////////////////////////////////
private:
    cGraphic_Sequence < Type >* m_pSequences; 
	BYTE                        m_iNum;    // Sequence 

};
///////////////////////////////////////////////////////////////////////////////
// cGraphic_Directional
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
cGraphic_Directional < Type > :: cGraphic_Directional()
{
	m_pSequences   = NULL;
	m_iNum         = 0;
}

///////////////////////////////////////////////////////////////////////////////
template < typename Type >
cGraphic_Directional < Type > :: ~cGraphic_Directional()
{
	Clear();
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
void cGraphic_Directional < Type > ::Clear()
{
    SAFE_DELETE_ARRAY( m_pSequences);
}
///////////////////////////////////////////////////////////////////////////////
// cCostume ־ Ӹŭ ϱ  ޼
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: CreateDirectional( int iFrameNum, int iDirNum)
{
	m_iNum       = iDirNum;

    m_pSequences = new cGraphic_Sequence < Type > [ iDirNum];
	if( !m_pSequences) return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_CREATEDIRECTIONAL");
	
	for( int i = 0 ; i < iDirNum ; i++) 
	{
	   if( !m_pSequences[ i].CreateSequence( iFrameNum))
		   return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_SAVE");
    }

	return true;
}

///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: Load( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_INVALID_FILE");
    
    file.Read( &m_iNum, sizeof( BYTE));
    m_pSequences = new cGraphic_Sequence < Type > [ m_iNum];
	if( !m_pSequences) return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_SAVE_INVALID_PTR");
	
	for( int i = 0 ; i < m_iNum ; i++) 
	{
	   if( !m_pSequences[ i].Load( file))
		   return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_SAVE");
    }

	return true;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: Save( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_INVALID_FILE");
	
	if( !m_pSequences) return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_SAVE_INVALID_PTR");

    file.Write( &m_iNum, sizeof( BYTE)); 

	for( int i = 0 ; i < m_iNum ; i++) 
	   if( !m_pSequences[ i].Save( file))
		   return Fail( this, "GRAPHIC_DIRECTIONAL_ERR_SAVE");

	return true;
}
///////////////////////////////////////////////////////////////////////////////
// *.bmp Ƽ *.dir .
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: LoadGraphicFromDirectory( string sFilesPath, DWORD dwFlag)
{  // sFilePath = ..../wait
    string sSubFolder;
	sFilesPath += "/";        // ..../wait/
    
	m_iNum = CountFolder( sFilesPath);
	if( m_iNum == 0) return false;

	SAFE_DELETE_ARRAY( m_pSequences);
    m_pSequences = new cGraphic_Sequence < Type > [ m_iNum];
    
    for( int i = 0 ; i < m_iNum; i++)
	{	
		char num[ 15];
		itoa( i, num, 10);
       
		sSubFolder  = sFilesPath;     // ..../wait/
        sSubFolder += string( num);   // ..../wait/0

		if( !m_pSequences[ i].LoadGraphicFromDirectory( sSubFolder, dwFlag)) 
			return Fail( this,"GRAPHIC_DIRECTIONAL_ERR_LOADGRAPHICFROMDIRECTORY");                    
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
// *.sqc Ƽ *.dir .
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: LoadGraphicFromPrevious( string sFolder, int iDirNum)
{   // sFilePath = ..../wait
    string sFilePath;
    sFolder += "/";   // ..../wait/

    if( m_pSequences) SAFE_DELETE_ARRAY( m_pSequences);
    m_pSequences = new cGraphic_Sequence < Type > [ iDirNum];
	m_iNum       = iDirNum;

    for( int i = 0 ; i < iDirNum; i++)
	{	
		char num[ 15];
		itoa( i, num, 10);

		sFilePath = sFolder;       // .../wait/
		sFilePath += string( num); // .../wait/0
		sFilePath += ".sqc";       // .../wait/0.sqc

		if( ! :: Load( &m_pSequences[ i], sFilePath)) 
			return Fail( this,"GRAPHIC_DIRECTIONAL_ERR_LOAD");                    
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
int cGraphic_Directional < Type > :: CountFolder( string sFolderName)
{   // sFolderName = ..../head/

	string sSubPath;
   	int    Count = 0;
    char   cwd[ 255];
	 _getcwd( cwd, 255);//  ۾ 丮 
	
    while( true)
	{
		char num[ 15];
		itoa( Count, num, 10);

		sSubPath  = sFolderName;  // ..../head/
		sSubPath += string( num); // ..../head/0
		
		if( _chdir( sSubPath.c_str()) == 0) Count++;
	    else break;
	}
	 
	_chdir( cwd);
    return Count;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
int  cGraphic_Directional < Type > :: GetSequenceNum() const
{
	assert( m_pSequences);
    return m_pSequences[ 0].GetSequenceNum();
}
////////////////////////////////////////////////////////////////////////////////
template < typename Type >
void* cGraphic_Directional < Type > :: GetGraphic( cAnimation_State* pAnimState) const
{
   	assert( m_pSequences);

	int iDir =  pAnimState->GetDirection();
	if( iDir >= m_iNum) return NULL;
	return m_pSequences[ iDir].GetGraphic( pAnimState->GetFrame());
}
////////////////////////////////////////////////////////////////////////////////
template < typename Type >
void* cGraphic_Directional < Type > :: GetGraphic( int iFrame, int iDir, int iAnim) const
{
   	assert( m_pSequences);

	if( iDir >= m_iNum) return NULL;
	return m_pSequences[ iDir].GetGraphic( iFrame);
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Directional < Type > :: Draw( cAnimation_State* pAnimState, int x, int y)
{
	assert( pAnimState);

	if( !pAnimState) return false;

	int iDir =  pAnimState->GetDirection();
	if( iDir >= m_iNum) return false;
	return m_pSequences[ iDir].Draw( pAnimState, x, y);
}
///////////////////////////////////////////////////////////////////////////////
#endif // __cGraphic_Directional_H__

