     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef _SURFACE_H_
#define _SURFACE_H_

#ifndef _GRAPHIC_H_
#include "Graphic.h"
#endif

///////////////////////////////////////////////////////////////////////////////
// cSurface
///////////////////////////////////////////////////////////////////////////////
typedef class cSurface 
{
public:
	cSurface();
	cSurface( int x, int y);
	virtual ~cSurface();
	void FindAndSetColorKey();

    ////////////////////////////////
  
    void   Clear();
    bool   LoadGraphic( string sFilePath, DWORD dwFlag);
    bool   Load( cFile& file);
	bool   Reload() { return CopyGraphicByAsm();}
	bool   Save( cFile& file);

	bool   Draw( int x, int y, DWORD dwFlag);
	bool   DrawAt( CANVASPtr pDestCan, int x, int y);
    bool   DrawInRect( RECT* pDestRect, RECT* pSrcRect);

	int    GetWidth() { return m_Canvas.size.iWidth;}
	int    GetHeight(){ return m_Canvas.size.iHeight;}

    bool   IsColorKey( int x, int y);
	bool   SetCanvas( int w, int y);
	CANVAS GetCanvas() const { return m_Canvas;}
	LPDIRECTDRAWSURFACE7 GetDDSurface() { return m_lpDDS;}

	//////////////////////////////////////////////
private:
	bool   DrawAtClipped( int x, int y, DWORD dwFlag);
    bool   CreateSurface( int w, int y);

    bool   CopyGraphicByAsm();
	bool   SetColorKey();

	int    Clipping( CANVASPtr pDestCan, int x, int y);

	//////////////////////////////////////////////

protected:
    LPDIRECTDRAWSURFACE7 m_lpDDS; 
    CANVAS               m_Canvas;
	cGraphicPtr          m_pGraphic;
	WORD                 m_ColorKey;
	DWORD                m_dwFlag;
	
}cSurface, *cSurfacePtr, ** cSurfaceList ;

#endif // __SURFACE_H__
