     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Tile.h
////////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
////////////////////////////////////////////////////////////////////////////
#ifndef _TERRAIN_H_
#define _TERRAIN_H_

#ifndef  _GRAPHIC_SEQUENCE_H_
#include "graphic_directional.h"
#endif

#ifndef  _WORLDCOORDINATE_H_
#include "worldcoor.h"
#endif

#ifndef  _SCREENCOORDINATE_H_
#include "screenobject.h"
#endif

#define  TERRAIN_WIDTH  96
#define  TERRAIN_HEIGHT 63

#define  TILE_WIDTH     32
#define  TILE_HEIGHT    21

#define  TILE_XNUM       3 //  ׷ξȿ  Ÿ ,
#define  TILE_YNUM       3

class cTile;
///////////////////////////////////////////////////////////////////////////////
enum TERRAIN_PATTERN { TP_SPRITE, TP_TILE_SPRITE, TP_TILE, TP_SET = 16};
// grass_soil: 0(sprite), 1(tile sprite), 2(grass), 3(soil)..., 16( set :   setŸ ),....
///////////////////////////////////////////////////////////////////////////////
// TERRAIN_FLAG
///////////////////////////////////////////////////////////////////////////////
typedef struct TERRAIN_FLAG
{
	DWORD uType    :  8; 
	DWORD uPattern :  8;  
	DWORD uId      :  8; 
	
	DWORD Anim     :  1; // Animation ɰΰ?   ϸ̼ ȴ.
	DWORD Pad      : 16;

	///////////////////////////////////////////////
	TERRAIN_FLAG()
	{
		uType = 0, uPattern = 0, uId = 0;
	}
	///////////////////////////////////////////////
	TERRAIN_FLAG( int iType, int iPattern, int iId) 
	{
		uType = iType, uPattern = iPattern, uId = iId;
	}
	
} TERRAIN_FLAG;
///////////////////////////////////////////////////////////////////////////////
// TERRAIN_PATTERN_TYPE
///////////////////////////////////////////////////////////////////////////////
enum TERRAIN_TYPE
{ 
    TT_GRASS_SOIL, TT_GRASS_FOREST, TT_GRASS_WATER, 
    TT_BEACH_WATER, TT_GRASS_DESERT, 
    TT_WALL, TT_NUM
};

////////////////////////////////////////////////////////////////////////////
// cTerrain_Type
////////////////////////////////////////////////////////////////////////////
typedef class cTerrain_Type
{
public:
	cTerrain_Type() { m_pTerrains = NULL, m_iPatternNum = 0;} 
	virtual ~cTerrain_Type() { Clear();}
	virtual  void   Clear();

	cGraphic_Source* CreateTerrainPattern( int iPattern);
	bool             LoadGraphicFromDirectory( string sPath);
	bool             Load( cFile& file);
	bool             Save( cFile& file);

	string           GetPatternName( int i);
	int              GetGraphicFlag( int i);
	cGraphic*        GetGraphic( TERRAIN_FLAG tFlag);
	
	int              CountFolder( string sPath);

	////////////////////////////////////////
protected:
    cGraphic_Source* m_pTerrains;
	int              m_iPatternNum;

} cTerrain_Type, * cTerrain_TypePtr;

typedef map < int, cTerrain_TypePtr > mapTerrainType;
////////////////////////////////////////////////////////////////////////////
// cTerrain_Mgr
////////////////////////////////////////////////////////////////////////////
typedef class cTerrain_Mgr
{
public:
	cTerrain_Mgr() {}
	virtual ~cTerrain_Mgr() { Clear();}
	void     Clear();

	bool           LoadTerrainsFromStage( int iTerrainType);
	void           InsertTerrainType( int iTType, cTerrain_TypePtr pType);
	void           EraseTerrainType( int iTType);
	cTerrain_Type* FindTerrainType( int iTType);

	int            GetDefaultTerrainType();
	string         GetTypeName( int iType);
	cGraphic*      GetGraphic( TERRAIN_FLAG tFlag);

    ////////////////////////////////////////
protected:
	mapTerrainType  m_mapTerrainType;
	

} cTerrain_Mgr, * cTerrain_MgrPtr;
////////////////////////////////////////////////////////////////////////////
// cTerrain
////////////////////////////////////////////////////////////////////////////
typedef class cTerrain
{
public:

	cTerrain();
	virtual ~cTerrain() {};
	void          Clear() {};

	///////////////////////////////////////
   	bool                   Save( cFile& file);
	bool                   Load( cFile& file);

	bool                   Draw( int x, int y);
    bool                   DrawAt( CANVASPtr pCanvas, int x, int y);

    vector < cGraphicPtr > CreateVirtualGraphics();
	void                   SetGraphic( cGraphic* pGraphic) { m_pGraphic = pGraphic;}
	void                   SetFlag( TERRAIN_FLAG Flag) { m_TerrainFlag = Flag;}
	cGraphicPtr            GetGraphic() const { return m_pGraphic;}
	TERRAIN_FLAG           GetFlag() const { return m_TerrainFlag;}
	

	//////////////////////////////////////
protected:
    cGraphicPtr            m_pGraphic; 
	TERRAIN_FLAG           m_TerrainFlag;

} cTerrain, * cTerrainPtr;
////////////////////////////////////////////////////////////////////////////
#endif // _TERRAIN_H_