     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef  _VARIANT_H_
#define  _VARIANT_H_

#ifndef  _STRUCT_H_
#include "struct.h"
#endif

#ifndef _FILE_H_
#include "file.h"
#endif

/////////////////////////////////////////////////////////////////////
enum VARIANT_TYPE { VT_void, VT_int, VT_char, VT_bool, VT_float, VT_string, VT_num};
/////////////////////////////////////////////////////////////////////
// cVariant
/////////////////////////////////////////////////////////////////////
typedef class cVariant
{
public:
	cVariant() : m_pValue( NULL) {}
	~cVariant() {};

	template< typename Type>
	cVariant( Type Val, int Token) : m_pValue( new Type( Val)), m_byTokenType( Token)
	{
		SetTypeId( Val);
	}

	template< typename Type>
    void         SetTypeId( Type Val)
	{
		if(      typeid( Type) == typeid( void))   m_VarType = VT_void;
        else if( typeid( Type) == typeid( int))    m_VarType = VT_int;
		else if( typeid( Type) == typeid( char))   m_VarType = VT_char;
		else if( typeid( Type) == typeid( bool))   m_VarType = VT_bool;
		else if( typeid( Type) == typeid( float))  m_VarType = VT_float;  
		else if( typeid( Type) == typeid( string)) m_VarType = VT_string;  
	}

	void         Clear() { SAFE_DELETE( m_pValue);}
	void*        CreateVariant();
    void*        GetValue() const { return m_pValue;}
	int          GetTokenType() const { return m_byTokenType;}
	int          GetSize();
	VARIANT_TYPE GetVariantType() const { return m_VarType;}

	bool         Save( cFile& file);
	bool         Load( cFile& file);

    /////////////////////////////////
private:
	void*        m_pValue;
	BYTE         m_byTokenType;
	VARIANT_TYPE m_VarType;

} cVariant, * cVariantPtr;
//////////////////////////////////////////////////////////////////////
// usage: int n = variant_cast< int >( my_variant);
//////////////////////////////////////////////////////////////////////
template< typename Type>
inline
Type const& variant_cast( const cVariant& v)
{
    return * (( Type* ) v.GetValue());
}
//////////////////////////////////////////////////////////////////////
#endif // _VAIRANT_H_