     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// animation.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "animation_mgr.h"

extern string g_sAnimFolder;
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Mgr :: Clear()
{
	cAnimationPtr pAnim;
	int size = m_mapAnimation.size();
    mapAnimation :: iterator iter = m_mapAnimation.begin();

	for( int i = 0; i < size; i++)
	{
	   pAnim = ( iter++)->second;
	   SAFE_DELETE( pAnim);
	} 
	
	m_mapAnimation.clear();
}
///////////////////////////////////////////////////////////////////////////////
cAnimationPtr cAnimation_Mgr :: CreateAnimation( int iObjName)
{
	switch( iObjName)
	{
	case ON_KAI:               return new cAnimation_Hero();
	case ON_GWEN:              return new cAnimation_Hero();
	case ON_DUFF:              return new cAnimation_Hero();
	case ON_LARS:              return new cAnimation_Hero();
	case ON_ALLEINS:           return new cAnimation_Hero();
	case ON_MAY:               return new cAnimation_Hero();
	case ON_VINCE:             return new cAnimation_Hero();
	case ON_SURO:              return new cAnimation_Hero();

	case ON_MACULFINE:         return new cAnimation_Monster();
	case ON_GROHL:             return new cAnimation_Monster();
	case ON_ALLEN:             return new cAnimation_Monster();
	case ON_DR_DAVID:          return new cAnimation_Monster();

	case ON_MASTICS:           return new cAnimation_Monster();
	case ON_PLEGE  :           return new cAnimation_Monster();
    case ON_SEMAMIT:           return new cAnimation_Monster();
	case ON_GOALIATH:          return new cAnimation_Monster();
	case ON_CHUNGDAN:          return new cAnimation_Monster();
	case ON_BEHEMONTH:         return new cAnimation_Monster();
	case ON_HEAVEN_WARRIOR:    return new cAnimation_Monster();
	case ON_RIDING_WARRIOR:    return new cAnimation_Monster();
    case ON_STONE_WARRIOR:     return new cAnimation_Monster();

	default:                   return new cAnimation_Normal();

	}
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Mgr :: LoadAnimationFromStage( int iObjName)
{
	cAnimationPtr pAnim = CreateAnimation( iObjName);

	string sFilePath   = g_sAnimFolder;
	sFilePath         += "/";
	sFilePath         += :: GetObjectName( iObjName);
	sFilePath         += ".ani";

	if( !Load( pAnim, sFilePath))
		return Fail( this, "ANIMATION_MGR_ERR_LOADANIMATIONS");

	InsertAnimation( iObjName, pAnim);
	return true;
}
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Mgr :: InsertAnimation( int iObjName, cAnimationPtr pAnim)
{
	assert( pAnim);

	if( !pAnim) return;
    m_mapAnimation[ iObjName] = pAnim;
}
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Mgr :: EraseAnimation( int iObjName) 
{
	m_mapAnimation.erase( iObjName);
}   
///////////////////////////////////////////////////////////////////////////////
cAnimationPtr cAnimation_Mgr ::  FindAnimation( int iObjName) 
{
	mapAnimation :: iterator iter = m_mapAnimation.find( iObjName);
    return ( *iter).second;
}
///////////////////////////////////////////////////////////////////////////////
string  GetObjectName( int iName)
{
	switch( iName)
	{
	case ON_KAI:               return string( "Kai");
	case ON_GWEN:              return string( "Gwen");
	case ON_DUFF:              return string( "Duff");
	case ON_LARS:              return string( "Lars");
	case ON_ALLEINS:           return string( "Alleins");
	case ON_MAY:               return string( "May");
	case ON_VINCE:             return string( "Vince");
	case ON_SURO:              return string( "Suro");

	case ON_MACULFINE:         return string( "Maculfine");
	case ON_GROHL:             return string( "Grohl");
	case ON_ALLEN:             return string( "Allen");
	case ON_DR_DAVID:          return string( "Dr David");

	case ON_MASTICS:           return string( "Mastics");
	case ON_PLEGE  :           return string( "Plege");
    case ON_SEMAMIT:           return string( "SeManit");
	case ON_GOALIATH:          return string( "Goaliath");
	case ON_CHUNGDAN:          return string( "Chungdan");
	case ON_BEHEMONTH:         return string( "Benemonth");
	case ON_HEAVEN_WARRIOR:    return string( "Heaven Warrior");
	case ON_RIDING_WARRIOR:    return string( "Riding Warrior");
    case ON_STONE_WARRIOR:     return string( "Stone Warrior");

	default : return string();
	}
		
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
