     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000


// animation_state.h
///////////////////////////////////////////////////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
///////////////////////////////////////////////////////////////////////////////
#ifndef _ANIMATION_STATE_H_
#define _ANIMATION_STATE_H_

#ifndef _STRUCT_H_
#include "struct.h"
#endif

#ifndef _FILE_H_
#include "file.h"
#endif

///////////////////////////////////////////////////////////////////////////////
enum ANIMATION_TYPE { AT_WAIT, AT_WALK, AT_WALK_START, AT_ATTACK, AT_SPELL, AT_NUM};
enum COSTUME_TYPE { CT_HEAD, CT_LHAND, CT_RHAND, CT_BODY, CT_LEG, CT_CLOAK, CT_NUM};

class cGraphic_Costume;
///////////////////////////////////////////////////////////////////////////////
// cAnimation_State :  ִϸ̼  Ѵ.
//   Ʈ  ü ڽ  ִϸ̼ ¸ ϰ 
// ׸ cAnimation Ŭ  ü ͸ ؼ ׸.
///////////////////////////////////////////////////////////////////////////////
typedef struct ANIMATION_STATE
{
	ANIMATION_STATE() 
	{ 
	    uFrame = uDirection = uAnimType = uDrawFlag = uDelay = 0;	
	}

	DWORD     uDrawFlag  :  6;// 
	DWORD     uFrame     :  6;
	DWORD     uDirection :  4;
	DWORD     uAnimType  :  4;
	DWORD     uDelay     :  4;

	DWORD     uPad       :  8;
	
} ANIMATION_STATE, * ANIMATION_STATEPtr; 
///////////////////////////////////////////////////////////////////////////////
// COSTUME_INFO
///////////////////////////////////////////////////////////////////////////////
typedef struct COSTUME_INFO
{
	DWORD  uWhose        :  6; //  ΰ 
	DWORD  uType         :  5; //    ΰ.  
	DWORD  uLevel        :  5; // ο  .
   
	DWORD  uPad          : 16;

	COSTUME_INFO()
	{
		uWhose = uType = uLevel = 0;
	}

} COSTUME_INFO, * COSTUME_INFOPtr;
///////////////////////////////////////////////////////////////////////////////
// COSTUME_STATE
///////////////////////////////////////////////////////////////////////////////
typedef struct COSTUME_STATE
{
	DWORD  uHead         :  4; //  ¸ Ҷ .
	DWORD  uBody         :  4;
	DWORD  uLeg          :  4;
	DWORD  uHand         :  4;

	DWORD  uPad          : 16;

	COSTUME_STATE()
	{
		uHead = uBody = uLeg = uHand = 0;
	}

	////////////////////////////////////////
	void SetLevel( int iType, int iLevel)
	{
		switch( iType)
		{
		case CT_HEAD:  uHead = iLevel; break;
		case CT_RHAND: uHand = iLevel; break;
		case CT_LHAND: uHand = iLevel; break;
		case CT_BODY : uBody = iLevel; break;
		case CT_CLOAK: uBody = iLevel; break;
		case CT_LEG:   uLeg  = iLevel; break; 
			
		default :      return;
		}
	}
	/////////////////////////////////////////
	int GetLevel( int iType)
	{
		switch( iType)
		{
		case CT_HEAD:  return uHead;
		case CT_RHAND: return uHand;
		case CT_LHAND: return uHand;
		case CT_BODY : return uBody;
		case CT_CLOAK: return uBody;
		case CT_LEG:   return uLeg;  
			
		default :      return 0;
		}
	}
	
} COSTUME_STATE, * COSTUME_STATEPtr;
///////////////////////////////////////////////////////////////////////////////
// cAnimation_State
///////////////////////////////////////////////////////////////////////////////
typedef class cAnimation_State
{
public:
    cAnimation_State() {}
	virtual ~cAnimation_State() {}

	virtual   bool  Save( cFile& file);
	virtual   bool  Load( cFile& file);

	virtual   void  SetCostume( int iType, cGraphic_Costume* pCostume) {} 
	virtual   cGraphic_Costume* GetCostume( int iType) { return NULL;}
	virtual   COSTUME_STATEPtr  GetCostumeState() { return NULL;}
	virtual   void  SetLevel( int iType, int iLevel) {}
	virtual   int   GetLevel( int iType) { return 0;}

	void      UpdateFrame() { m_AnimState.uFrame++;}
	void      ResetFrame() { m_AnimState.uFrame = 0;}
	void      UpdateDelay() { m_AnimState.uDelay++;}
	void      ResetDelay() { m_AnimState.uDelay = 0;}

	int       GetFrame() { return m_AnimState.uFrame;}
	int       GetDirection() { return m_AnimState.uDirection;}
	int       GetAnimType() { return m_AnimState.uAnimType;}
	int       GetDrawFlag() { return m_AnimState.uDrawFlag;}
	int       GetDelay() { return m_AnimState.uDelay;}

	void      SetFrame( int iFrame) { m_AnimState.uFrame = iFrame;}
	void      SetDirection( int iDir) { m_AnimState.uDirection = iDir;}
	void      SetAnimType( int iAnimType) { m_AnimState.uAnimType = iAnimType;}
	void      SetDrawFlag( int iDrawFlag) { m_AnimState.uDrawFlag = iDrawFlag;}
	
	ANIMATION_STATEPtr GetAnimState() { return &m_AnimState;}

public:
    ANIMATION_STATE m_AnimState;
	
} cAnimation_State, * cAnimation_StatePtr; 
///////////////////////////////////////////////////////////////////////////////
// cCostume_State
///////////////////////////////////////////////////////////////////////////////
typedef class cCostume_State : public cAnimation_State
{
public:
	cCostume_State();
	virtual ~cCostume_State() {}

	bool     Save( cFile& file);
	bool     Load( cFile& file);

	void     SetCostume( int iType, cGraphic_Costume* pCostume); 
	cGraphic_Costume* GetCostume( int iType);
    COSTUME_STATEPtr  GetCostumeState() { return &m_CostumeState;}

	void     SetLevel( int iType, int iLevel) { m_CostumeState.SetLevel( iType, iLevel);}
	int      GetLevel( int iType) { return m_CostumeState.GetLevel( iType);}

public:
	cGraphic_Costume*   m_pCostumes[ CT_NUM];
	COSTUME_STATE       m_CostumeState;

} cCostume_State, * ccGraphic_CostumePtr;
///////////////////////////////////////////////////////////////////////////////
#endif // _ANIMATION_STATE_H_