     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// file.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "file.h"
#include <fcntl.h>    // _O_RDONLY ....
#include <sys/stat.h> // _S_IWRITE ....

#if defined(_MSC_VER) // microsoft compiler
#define  O_RDONLY   _O_RDONLY
#define  O_WRONLY   _O_WRONLY
#define  O_CREAT    _O_CREAT
#define  S_IREAD    _S_IREAD
#define  S_IWRITE   _S_IWRITE
#define  open       _open
#define  close      _close
#define  write      _write
#define  read       _read
#define  lseek      _lseek
#define  tell       _tell
#define  findfirst	_findfirst
#define  findnext   _findnext
#define  findclose	_findclose
#define  finddata_t _finddata_t

#define  FA_NORMAL   _A_NORMAL
#define  FA_RDONLY   _A_RDONLY	
#define  FA_HIDDEN   _A_HIDDEN	
#define  FA_SYSTEM   _A_SYSTEM	
#define  FA_SUBDIR   _A_SUBDIR	
#define  FA_ARCH	 _A_ARCH	

#endif
///////////////////////////////////////////////////////////////////////////////
// cFile
///////////////////////////////////////////////////////////////////////////////
cFile :: cFile( string sFileName, FILE_FLAGS fFlag)
{
	if( fFlag == FF_NO_IO) return;
	if( fFlag == FF_READ)
	{
		m_hFile = open( sFileName.c_str(), O_RDONLY | O_BINARY, S_IWRITE | S_IREAD);
		if( m_hFile == - 1) m_fFlag = FF_NO_IO;
		else m_fFlag = FF_READ;
	}
	else if( fFlag == FF_WRITE) 
	{
		m_hFile = open( sFileName.c_str()
			
			, O_WRONLY | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
		if( m_hFile == -1) m_fFlag = FF_NO_IO;
		else m_fFlag = FF_WRITE;
	}
	else m_fFlag = FF_NO_IO;
}
///////////////////////////////////////////////////////////////////////////////
cFile :: ~cFile()
{
	if( m_fFlag != FF_NO_IO) close( m_hFile); 
}
///////////////////////////////////////////////////////////////////////////////
cFile :: FILE_ERR  
cFile :: Status()
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////		
cFile :: FILE_ERR  
cFile :: Write ( void* data, int size )
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	if( m_fFlag == FF_READ) return FE_NOT_READABLE;

	int val = write( m_hFile, data, size );

	if (val == -1) return FE_PROBLEM;
	return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////

cFile :: FILE_ERR  
cFile :: Read ( void* data, int size )
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	if( m_fFlag == FF_WRITE) return FE_NOT_WRITABLE;

	int val = read( m_hFile, data, size );

	if( val == -1) return FE_PROBLEM;
	return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: Seek( int where)
{
	if( m_fFlag == FF_NO_IO) return -1;
	if( lseek( m_hFile, where, SEEK_SET ) == -1) return -1;
	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: Advance( int howmuch)
{
	if( m_fFlag == FF_NO_IO) return -1; 
	if( lseek( m_hFile, howmuch, SEEK_CUR ) == -1) return -1;
	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: SeekFromEnd( int where)
{
	if( m_fFlag == FF_NO_IO) return -1;
	if( lseek( m_hFile, where, SEEK_END ) == -1) return -1;
	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
