     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

////////////////////////////////////////////////////////////////////////
//Main.cpp
////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include <windowsx.h>
#include "Main.h"

////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{   
	MSG msg;
	g_bActiveApp       = false;
	g_bPlaying         = false;

	if( !WinInit( hInstance, nShowCmd)) return FALSE;

    while( 1)
	{
	    if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if( GetMessage( &msg, NULL, 0, 0))
			{
		        TranslateMessage( &msg);
		        DispatchMessage( &msg);

			}else return msg.wParam ;

		}
		else if( g_bActiveApp)
		{
            if( g_bPlaying)  UpdateFrame();
		    else  Game_Init();

		}else WaitMessage(); 
             
	}
	return msg.wParam;
}
/////////////////////////////////////////////////////////////////////////
BOOL WinInit( HINSTANCE hInstance, int nShowCmd)
{	
	WNDCLASSEX wc;
	DWORD      dwFlag;
    
	wc.cbSize        = sizeof( wc);
	wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.hInstance     = g_hInst = hInstance;
	wc.cbWndExtra    = 0;
	wc.cbClsExtra    = 0;
	wc.hCursor       = LoadCursor( NULL, IDC_ARROW);
	wc.hIcon         = LoadIcon( NULL, IDI_APPLICATION);
	wc.lpszClassName = NAME;
	wc.lpfnWndProc   = WndProc;
	wc.hIconSm       = NULL;
	wc.lpszMenuName  = NULL;
	wc.hbrBackground = ( HBRUSH  ) GetStockObject( BLACK_BRUSH);
	
	RegisterClassEx( &wc);
	if( g_bFullScreen) dwFlag = WS_POPUP;
	else dwFlag = WS_OVERLAPPEDWINDOW;
	
	g_hMainWnd = CreateWindow(
		                 NAME, 
		                 TITLE,
						 dwFlag, 
                         CW_USEDEFAULT,
						 CW_USEDEFAULT,
						 CW_USEDEFAULT,
						 CW_USEDEFAULT,
						 NULL,
						 NULL,
						 hInstance,
						 NULL);
	
	if( !g_hMainWnd)	return FALSE;
	ShowWindow( g_hMainWnd, nShowCmd);
	UpdateWindow( g_hMainWnd);
	
	return TRUE;
}
//////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message)
	{
		HANDLE_MSG( hwnd, WM_DESTROY, Game_OnDestroy);
		HANDLE_MSG( hwnd, WM_ACTIVATEAPP, Game_OnActivateApp);
		HANDLE_MSG( hwnd, WM_CREATE, Game_OnCreate);
		HANDLE_MSG( hwnd, WM_KEYDOWN, Game_OnKey);
		HANDLE_MSG( hwnd, WM_MOUSEMOVE, Game_OnMouseMove);
		HANDLE_MSG( hwnd, WM_LBUTTONDOWN, Game_OnLButtonDown);

    default:
		return DefWindowProc(hwnd, message, wParam, lParam);
	}
}
///////////////////////////////////////////////////////////////////////////////
// Messages
///////////////////////////////////////////////////////////////////////////////
BOOL Game_OnCreate( HWND hwnd, LPCREATESTRUCT lpCS)
{	
	return TRUE;
}
///////////////////////////////////////////////////////////////////////////////
void Game_OnActivateApp(HWND hwnd, BOOL fActivate, DWORD dwThreadId)
{
	g_bActiveApp   = fActivate;
	if( fActivate && g_bFullScreen && g_pScreen)
		g_pScreen->RestoreAllSurface();
}
///////////////////////////////////////////////////////////////////////////////
void Game_OnDestroy( HWND hwnd)
{   
    Game_Delete();
	PostQuitMessage( 0);
}
///////////////////////////////////////////////////////////////////////////////
void Game_OnKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags)
{
	if( vk == VK_ESCAPE) SendMessage( hwnd, WM_DESTROY, 0, 0); 
}
///////////////////////////////////////////////////////////////////////////////
void Game_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
	if( !g_bPlaying) return;
}
///////////////////////////////////////////////////////////////////////////////
void Game_OnLButtonDown( HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags)
{
/*	COSTUME_INFO ci;
	ci.uWhose = ON_KAI;
	ci.uType   = CT_leg;
	ci.uLevel = 1;
    g_pHeroAnim->PutonCostume( &g_CostumeState, ci);
*/
	g_pGraphic3->Clear();
}
///////////////////////////////////////////////////////////////////////////////
// Game Functions
///////////////////////////////////////////////////////////////////////////////
void Game_Init()
{
    char cwd[ 255];
	_getcwd( cwd, 255); 
	string scurrPath( cwd);
	g_sAnimFolder   = string( "g:/׸/Animation");
	
	pScreen         = new cScreen( g_hMainWnd , 800, 600, 16, cScreen :: SM_WINDOW);
	g_pSeq          = new cGraphic_Sequence < cGraphic > ();
    g_pSeqSrc       = new cGraphic_Sequence < cGraphic > ();
	g_pTexSrc       = new cGraphic_Sequence < cTexture > ();
	g_pDirSrc       = new cGraphic_Directional < cCostume_Order > ();
	g_pCstSrc       = new cGraphic_Costume();
	g_pAnim         = new cAnimation_Normal();
	g_pTexAnim      = new cAnimation_Normal();
	g_pMonsterAnim  = new cAnimation_Monster();
//	g_pHeroAnim     = new cAnimation_Hero();
	g_pTexture      = new cTexture();
	g_pGraphic1     = new cGraphic();
	g_pGraphic2     = new cGraphic();
	pAnimMgr        = new cAnimation_Mgr();

	g_pGraphic1->LoadGraphic( "G:/׸/MapSource/.bmp", GRP_NORMAL);
	g_pGraphic2->LoadGraphic( "G:/̹/1/bmp/0.bmp", GRP_SPRITE);
//	g_pTexture->LoadGraphic( "G:/û/׸/Spark/Spark10.bmp", GRP_TEXTURE);

	////////////////////////  ϸ̼  ///////////////////////
//   g_pTexSrc->LoadGraphicFromDirectory( "H:/Work/׸/Bmp/Explosion/Spark", GRP_TEXTURE);
//   Save( g_pTexSrc, "H:/Work/׸/Bmp/Explosion/spark.sqc");
//   Load( g_pTexSrc, "H:/Work/׸/Bmp/Explosion/spark.sqc");
//	 g_pTexture   = ( cTexture* ) g_pTexSrc->GetGraphic( 10);
    
//   g_pTexAnim->LoadAnimSource( "H:/Work/׸/Bmp/Explosion/Spark.sqc", AS_SEQUENCE_TEXTURE);
//	 Save( g_pTexAnim, "H:/Work/׸/Bmp/Explosion/spark.ani");
	 Load( g_pTexAnim, "H:/Work/׸/Bmp/Explosion/spark.ani");
//	 g_pTexture   = ( cTexture* ) g_pAnim->GetGraphic( 10);
	
	/////////////////////// ȭ ϸ̼  ////////////////////
//  g_pDirSrc->LoadGraphicFromDirectory( "G:/׸/Duff/wait", GRP_SPRITE); // ̹  ù°  
//	g_pDirSrc->LoadGraphicFromPrevious( "G:/׸/Duff/wait", 16);               // ̹  ι° 
//  Save( g_pDirSrc, "G:/׸/Duff/wait.dir");
//	Load( g_pDirSrc, "G:/׸/Duff/wait.dir");
//	g_pGraphic   = ( cGraphicPtr ) g_pDirSrc->GetGraphic( 10, 0);
/*    
	g_pAnim->LoadAnimSource( "G:/׸/Duff/wait.dir", AS_DIRECTIONAL_GRAPHIC);
	g_pAnim->GetFrames( 0)->uDelay = 8;
	g_pAnim->GetFrames( 1)->uDelay = 8;
	g_pAnim->GetFrames( 2)->uDelay = 8;
	g_pAnim->GetFrames( 3)->uDelay = 8;
*/
//	Save( g_pAnim, "G:/׸/Duff/wait.ani");
//	Load( g_pAnim, "G:/׸/Duff/wait.ani");
//	g_pGraphic   = ( cGraphicPtr ) g_pAnim->GetGraphic( 10, 3);

    //////////////////////  ϸ̼  /////////////////////////
//	g_pDirSrc->LoadGraphicFromDirectory( "G:/׸/Duff/wait", GRP_SPRITE);
//  Save( g_pDirSrc, "G:/׸/Duff/wait.dir");
//  Load( g_pDirSrc, "G:/׸/Duff/wait.dir");
//  g_pGraphic = ( cGraphicPtr ) g_pDirSrc->GetGraphic( 10, 15, 0);

//	g_pAnim->LoadAnimSource( "G:/׸/Duff/walk.dir", AS_DIRECTIONAL_GRAPHIC);
//  Save( g_pAnim, "G:/׸/Duff/walk.ani");
//	Load( g_pAnim, "G:/׸/Duff/walk.ani");

//	g_pMonsterAnim->LoadAnimSource( "G:/׸/Duff", AS_CHARACTER);
//	Save( g_pMonsterAnim, "G:/׸/Duff.ani");
//  Load( g_pMonsterAnim, "G:/׸/Duff.ani");
	
	//////////////////////  ĳ ִϸ̼  ///////////////////////
// 	g_pCstSrc->LoadGraphicFromDirectory( "G:/׸/Kai/leg/leg0", GRP_SPRITE);
//  Save( g_pCstSrc, "G:/׸/Kai/leg0.cst");
//  Load( g_pCstSrc, "G:/׸/Kai/leg0.cst");
//	g_pGraphic   = ( cGraphicPtr ) g_pCstSrc->GetGraphic( 8, 15, AT_ATTACK);

//	g_pDirSrc = new cGraphic_Directional < cCostume_Order > (); // Դ  
//	g_pDirSrc->CreateDirectional( 20, 16);
//	Save( g_pDirSrc, "G:/׸/Kai/attack.dir");
//  Load( g_pCstSrc, "G:/׸/Kai/attack.dir");

//  g_pAnim->LoadAnimSource( "G:/׸/Kai/attack.dir", AS_DIRECTIONAL_COSTUME);
//  Save( g_pAnim, "G:/׸/Kai/attack.ani");
//	Load( g_pAnim, "G:/׸/Kai/attack.ani");

//	g_pHeroAnim->LoadAnimSource( "G:/׸/Kai", AS_CHARACTER);
//	Save( g_pHeroAnim, "G:/׸/Kai.ani");
//  Load( g_pHeroAnim, "G:/׸/Kai.ani");

	/////////////////////////////////////////////////////////////////////////
	
    g_pAnimMgr->LoadAnimationFromStage( ON_MASTICS);
	g_pMonsterAnim = g_pAnimMgr->FindAnimation( ON_MASTICS);

	g_pAnimMgr->LoadAnimationFromStage( ON_KAI);
	g_pHeroAnim = g_pAnimMgr->FindAnimation( ON_KAI);
	
	g_AnimState.SetAnimType( AT_WALK);
	g_AnimState.SetDirection( 0);
//	g_AnimState.SetDrawFlag( DF_SLOPED_SHADOW);

	COSTUME_INFO ci;
	ci.uWhose = ON_KAI;
    g_pHeroAnim->PutonStartingCostume( &g_CostumeState, ci);
	g_CostumeState.SetAnimType( AT_ATTACK);
//  g_CostumeState.SetDrawFlag( DF_BLUE);

	RECT rc;
	SetRect( &rc , 100, 100, 200, 200);
    g_pGraphic3 = g_pGraphic2->CreateVirtualGraphic( rc);

	g_bPlaying = TRUE;
}
///////////////////////////////////////////////////////////////////////////////
void Game_Delete()
{
	SAFE_DELETE( g_pSeq);
	SAFE_DELETE( pScreen);
	SAFE_DELETE( g_pAnim);
	SAFE_DELETE( g_pSrc);
	SAFE_DELETE( g_pDirSrc);
	SAFE_DELETE( g_pCstSrc);
	SAFE_DELETE( g_pGraphic3);
	SAFE_DELETE( g_pTexAnim);
    SAFE_DELETE( pAnimMgr);
}
//////////////////////////////////////////////////////////////////////////////
void UpdateFrame()
{ 
	g_pScreen->PrepareFrame();
    g_pHeroAnim->UpdateFrame( &g_CostumeState);
    g_pMonsterAnim->UpdateFrame( &g_AnimState);
	g_pTexAnim->UpdateFrame( &g_SparkState);
	
	g_pGraphic1->Draw( 0, 0);
	g_pGraphic2->Draw( 500, 300);

    g_pHeroAnim->Draw( &g_CostumeState, 300, 200);
	g_pMonsterAnim->Draw( &g_AnimState, 200, 300);
	g_pTexAnim->Draw( &g_SparkState, 200, 300);
//	g_pGraphic2->Draw( 0, 0, DF_ALPHA_50 )
	g_pGraphic3->Draw( 0, 0);

    g_pScreen->WriteFrameCount();
	g_pScreen->Flip( g_hMainWnd);
}

