     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// script.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "script.h"
#include "event.h"
#include "stage.h"

#define MAX_CHAR 1024
///////////////////////////////////////////////////////////////////////////////
cScript :: cScript()
{
	m_pchCurrPos       = NULL;
	m_bInnerCmd        = false;
	m_pchContent       = new char[ MAX_CHAR]; 
	
	memset( m_pchContent, 0, MAX_CHAR);
}
///////////////////////////////////////////////////////////////////////////////
cScript :: ~cScript()
{
    Clear();
}
///////////////////////////////////////////////////////////////////////////////
void cScript :: Clear()
{
	SAFE_DELETE( m_pchContent);
}
///////////////////////////////////////////////////////////////////////////////
TOKEN_TYPES cScript :: GetToken()
{
	assert( m_pchContent);
	assert( m_pchCurrPos);

	memset( m_pchContent, 0, MAX_CHAR);
	char* chpTemp = m_pchContent;

	while( IsSpace( *m_pchCurrPos)) ++m_pchCurrPos; //  ǳ ٱ.

	if( IsEOF( *m_pchCurrPos)) return TT_EOF;
	if( IsEOL( *m_pchCurrPos))
	{
		m_pchCurrPos++;
		m_pchCurrPos++;

		return TT_EOL;
	}
    
	if( IsEOC( *m_pchCurrPos))
	{
		m_pchCurrPos++;
		return TT_EOC;
	}
    
	if( IsStatement( *m_pchCurrPos)) // ּ ó 
	{
        FindEOL();
		return TT_EOC;
	}

	if( IsQuote( *m_pchCurrPos))
	{
		m_pchCurrPos++;
		while( *m_pchCurrPos != '"' && *m_pchCurrPos != 'r') 
			*chpTemp++ = *m_pchCurrPos++;

		m_pchCurrPos++;
		return TT_QUOTE;
	}
	
	if( IsOperator( *m_pchCurrPos)) // operator
	{
		*chpTemp++ = *m_pchCurrPos++;
		return TT_OPERATOR;
	}

	if( IsDigit( *m_pchCurrPos))
	{
		while( !IsSpace( *m_pchCurrPos) && !IsOperator( *m_pchCurrPos) && !IsEOL( *m_pchCurrPos)) 
			*chpTemp++ = *m_pchCurrPos++;

		return TT_NUMBER;
	}

	if( IsAlpha( *m_pchCurrPos))
	{
		while( !IsSpace( *m_pchCurrPos) && !IsOperator( *m_pchCurrPos) && !IsEOL( *m_pchCurrPos))
			*chpTemp++ = *m_pchCurrPos++;

        COMMAND_TYPES Type = GetCommandType();
		if( Type == CT_VALUABLE) return TT_VALUABLE;
        else return TT_COMMAND;
	}

    return TT_ERROR;
}
///////////////////////////////////////////////////////////////////////////////
TOKEN_TYPES cScript :: Parsing_Line( cCommand& cmd)
{
	while( true)
	{
		TOKEN_TYPES   tokenType = GetToken();
		COMMAND_TYPES cmdType;   

		switch( tokenType)
		{
		case TT_EOC:  return TT_EOC;
		case TT_EOL:  return TT_EOL;
		case TT_EOF:  return TT_EOF;
        //////////////////////////////////////////////////
		case TT_QUOTE:
			{
				string str( m_pchContent);
				cVariant sVar( str, TT_QUOTE);
				cmd.Push_back( sVar);
			    break;
			}
        //////////////////////////////////////////////////
		case TT_NUMBER: // ڴ ϴ int ؼ óѴ.
			{
				int Val = atoi( m_pchContent);
				cVariant iVar( Val, TT_NUMBER);
			    cmd.Push_back( iVar);
			    break;
			}
        //////////////////////////////////////////////////
		case TT_OPERATOR:
			{
			    int opType = GetOperatorType();
			   	cVariant iVar( opType, TT_OPERATOR);
			    cmd.Push_back( iVar);
			    break;
			}
		//////////////////////////////////////////////////
		case TT_VALUABLE:
			{
				string str( m_pchContent);
				cVariant sVar( str, TT_VALUABLE);
				cmd.Push_back( sVar);
				break;
			}
        //////////////////////////////////////////////////
		case TT_COMMAND:
			{
				cmdType = GetCommandType();
			    if( !m_bInnerCmd) //   ָɾ о  
				{
				   cmd.SetType( cmdType);
				   m_bInnerCmd = true;
				}   
				else //   ڷ ɾ    
				{
				   cCommand subcmd;
				   subcmd.SetType( cmdType);

				   Parsing_Line( subcmd);
				   cVariant cmdVar( subcmd, TT_COMMAND);
				   cmd.Push_back( cmdVar);
				}

				if( cmdType == CT_END) // END()
				{
					m_pchCurrPos++; // (
					m_pchCurrPos++; // )
					return TT_EOE;
				}

				break;
            }
        
		}
	}
}
///////////////////////////////////////////////////////////////////////////////
cEvent cScript :: Parsing( char* pchTextScript)
{
	assert( pchTextScript);
	cEvent Event;

	if( pchTextScript)
	{
		TOKEN_TYPES Type;
		m_pchCurrPos = pchTextScript;

		while( true)
		{
			m_bInnerCmd = false;
			cCommand  com;
			Type = Parsing_Line( com);
			if( !com.Empty()) Event.Push_back( com);
			
			if( Type == TT_EOE || Type == TT_EOF) break;	
		}
	}

	return Event;
}
///////////////////////////////////////////////////////////////////////////////
void cScript :: FindEOL()
{
	while( *m_pchCurrPos != '\n' && *m_pchCurrPos != '\0') ++m_pchCurrPos;
	if( *m_pchCurrPos) m_pchCurrPos++;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsAlpha( char c)
{
	if( c >= 65 && c < 91) return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsDigit( char c)
{
	if( c >= 48 && c < 58)return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsOperator( char c)
{
	if( strchr(")+-<>/*%=", c))
		return true;

	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsSpace( char c)
{
	if( c == ' ' || strchr("(,;", c)) return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsQuote( char c)
{
    if( c == '"') return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsEOL( char c)
{
	if( c == '\r') return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsEOC( char c)
{
	if( c == ')') return true;
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsEOF( char c)
{
	if( c == - 3)
	{	
		return true;
	}
	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cScript :: IsStatement( char c)
{	
    if( *m_pchCurrPos == '/') // ּ ó 
	{
		char* pc = m_pchCurrPos + 1;
		if( *pc == '/') 
	
	    return true;
	}

	return false;
}
///////////////////////////////////////////////////////////////////////////////
COMMAND_TYPES cScript :: GetCommandType()
{
	if( strcmp( m_pchContent, "BEGIN")    == 0)  return CT_BEGIN;
	if( strcmp( m_pchContent, "END")      == 0)  return CT_END;
	if( strcmp( m_pchContent, "VALUABLE") == 0)  return CT_VALUABLE_DEFINE;
	if( strcmp( m_pchContent, "TALK")     == 0)  return CT_TALK;
	if( strcmp( m_pchContent, "GOTO")     == 0)  return CT_GOTO;
	if( strcmp( m_pchContent, "ATTACK")   == 0)  return CT_ATTACK;
	if( strcmp( m_pchContent, "TEST")     == 0)  return CT_TEST;

	return CT_VALUABLE;
}
///////////////////////////////////////////////////////////////////////////////
OPERATOR_TYPES cScript :: GetOperatorType()
{
	if( *m_pchContent == '+') return OT_PLUS;
	if( *m_pchContent == '-') return OT_MINUS;
	if( *m_pchContent == '/') return OT_DIVIDE;
	if( *m_pchContent == '*') return OT_MULTI;
	if( *m_pchContent == '=') return OT_EQUAL;
	if( *m_pchContent == '<') return OT_LESS_THAN;
	if( *m_pchContent == '>') return OT_GREATER_THAN;

	return OT_ERROR;
}
////////////////////////////////////////////////////////////////////////////////
bool cScript :: LoadScript(  cStage* pStage, string sFileName)
{
	assert( pStage);

	HFILE hFile  = _lopen( sFileName.c_str(), OF_READ);
	if( hFile == - 1) return false;

	assert( !(hFile== - 1));
	int size = GetFileSize( ( HANDLE ) hFile, NULL);
	if( size == 0) return false;

	m_pchCurrPos = new char[ size];
	memset( m_pchCurrPos, 0, size);
	_lread( hFile, m_pchCurrPos, size);
     	
	_lclose( hFile);
    return true;
}
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////