     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Struct.h
///////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _STRUCT_H_
#define _STRUCT_H_

////////////////////////////////////////////////////////////////////
#ifdef  _DEBUG
  #include <crtdbg.h>
  #define assert(f)  _ASSERT((f))

#else 
  #define assert(f)  ((void)0)

#endif

///////////////////////////////////////////////////////////////////
// standard template library  õ warning  ش.
#pragma warning( disable : 4786)  
#pragma warning( disable : 4700) 
///////////////////////////////////////////////////////////////////

class cScreen;
class cStage;
class cVariant;
class cMap;

///////////////////////////////////////////////////////////////////
#include <windows.h>
#include <math.h>
#include <direct.h> // _getcwd( cwd, 255);
#include <io.h>     // _findfirst
#include <string>
#include <vector>
#include <map>

using namespace std;
typedef map< string, cVariant > mapValuable;
typedef map< string, DWORD >    mapFunction;

////////////////////////////////////////////////////////////////////////////////
#define   KEYDOWN( State, keyID)  ( State[ keyID] & 0x80)

///////////////////////////////////////////////////////////////////////////////
#define   SAFE_DELETE(p)        { if(p) { delete (p);     (p)=NULL; }}
#define   SAFE_DELETE_ARRAY(p)  { if(p) { delete [] (p);  (p)=NULL; }}
#define   SAFE_RELEASE(p)       { if(p) { (p)->Release(); (p)=NULL; }}

///////////////////////////////////////////////////////////////////////////////
template <typename type>					// SGN
type  SGN (type a) {return ((a<0) ? -1:(a>0) ? 1:0);}
template <typename type>					// SQR
type  SQR (type a) {return a*a;}      
template <typename type>					// CUBE
type  CUBE (type a) {return a*a*a;}
template <typename type>					// ROUND
type  ROUND (type a) {return (a>0 ? (type)((int)(a+0.5F)):-(type)((int)(0.5F-a)));}
template <typename type>					// DIST // convert to polar distance
type  DIST (type a, type b) {return (type)(sqrt(((a)*(a))+((b)*(b))));}         
template <typename type>					// ABS
type  ABS (type a) {return ((a)<0) ? -(a):(a);}
template <typename type>
type  DIF (type a, type b) { return ABS( (int) (a) - (int) (b));} 
///////////////////////////////////////////////////////////////////////////////
template <typename type>
float  ANGLE( type x, type y) { return ( float) atan( y/x);}

///////////////////////////////////////////////////////////////////////////////
template <typename type>					// MIN
type  MIN (type a, type b) {return ((a<b) ? a:b);}   
template <typename type>					
type  MIN (type* array, int num) 
{
	type val = array[0];
	for (int i=1; i<num; i++)
	if (val>array[i]) val = array[i];
	return val;
} 
template <typename type>					// MIN3
type  MIN3 (type a, type b, type c) {return (MIN(MIN(a,b),c));}  
///////////////////////////////////////////////////////////////////////////////      
template <typename type>					// MAX
type  MAX (type a, type b) {return ((a>b) ? a:b);}    
template <typename type>					// MAX largest in array
type  MAX (type* array, int num) 
{
	type val = array[0];
	for (int i=1; i<num; i++)
	if (val<array[i]) val = array[i];
	return val;
} 
template <typename type>					// MAX3
type  MAX3 (type a, type b, type c) {return (MAX(MAX(a,b),c));}  
///////////////////////////////////////////////////////////////////////////////
template <typename type>					// AVG
type  AVG (type a, type b) {return ((a+b)/2);} 
template <typename type>					// AVG of an array
type  AVG (type* array, int num) 
{
	type sum = array[0];
	for (int i=1; i<num; i++)
	sum += array[i];
	return sum/num;
} 

///////////////////////////////////////////////////////////////////////////////
template <typename type>					// SUM add two numbers
type  SUM (type a, type b) {return (a+b);} 
template <typename type>					// SUM add array of numbers
type  SUM (type* array, int num) 
{
	type sum = array[0];
	for (int i=1; i<num; i++)
	sum += array[i];
	return sum;
} 
template <typename type>					// SUM add two numbers
type  FACTORIAL	 (type a) 
{
	type total = 1;
	for (int i=2; i<=a; i++)
		total *= i;
	return total;
}
///////////////////////////////////////////////////////////////////////////////
template <typename type>					// SWAP // a xor b; b xor a; a xor b;
void  SWAP( type& a, type& b) 
{
	type temp = a;
	a = b;
	b = temp;
} 
///////////////////////////////////////////////////////////////////
template <typename type, typename type2>		// LIMIT limit the range of a number
type  LIMIT (type val, type2 l, type2 h) 
{
	if (val<l) return (type) l;
	if (val>h) return (type) h;

	return val;
}
//////////////////////////////////////////////////////////////////
#define  SWAPPT(a,b) (SWAP(a.y,b.y), SWAP(a.x,b.x))// SWAP swap points   
template <typename type>					// RECIP // a^-1
type  RECIP (type a) {return (1/a);}  
template <typename type>					// NOT  // exclusive or unary
type  NOT (type a) {return (~(a));} 
template <typename type>					// XOR exclusive or binary
type  XOR (type a, type b) {return (a^b);}  
template <typename type>					// BSL bit shift left
type  BSL (type a) {return (a<<1);} 
template <typename type>					// BSL2 bit shift left by b positions
type  BSL2 (type a, type b) {return (a<<b);}  
template <typename type>					// BSR  bit shift right
type  BSR (type a) {return (a>>1);} 
template <typename type>					// BSR2 bit shift right by b positions
type  BSR2 (type a, type b) {return (a>>b);}  
template <typename type>					// BIT turns a bit on
type  BIT (int x) {return (type)(1<<x);}  

///////////////////////////////////////////////////////////////////
template <typename type>					// LO_BYTE
type  LO_BYTE (type a) {return (a&=0xff);}  
template <typename type>					// HI_BYTE 
type  HI_BYTE (type a) {return (a&=0xff00);} 
template <typename type>					// LO_WORD
type  LO_WORD (type a) {return (a&=0xffff);}  
template <typename type>					// HI_WORD 
type  HI_WORD (type a) {return (a&=0xffff0000);} 
template <typename type>					// HI_LOSWAPshort
type  HI_LOSWAPshort (type a) {return (LO_BYTE(a)<<8) | (HI_BYTE(a)>>8);}  
template <typename type>					// HI_LOSWAPlong
type  HI_LOSWAPlong (type x) {return (LO_WORD(a)<<16) | (HIWORD(a)>>16);}  

///////////////////////////////////////////////////////////////////
template < typename Type >
bool Fail( Type* pType, LPCSTR ErrStr)
{
	assert( !ERROR);
///////////////////////////////
#ifndef _TOOL_
   extern HWND g_hMainWnd;
   MessageBox( g_hMainWnd, ErrStr, "ERROR", MB_OK);
#endif

///////////////////////////////
#ifdef _TOOL_
   AfxMessageBox( ErrStr);
#endif

///////////////////////////////
   if( pType) pType->Clear();
   
   return false;
}

///////////////////////////////////////////////////////////////////
enum COLOR_TYPE { _0x0x0_ ,_5x5x5_, _5x6x5_};
enum COLOR { RED, FUCHSIA, BLUE, CYAN, GREEN, YELLOW, WHITE, GRAY, BLACK };
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
typedef struct RGBVal
{    
	enum  { LOW = 0L, HIGH = 255};
	BYTE  b, g, r;
	/////////////////////////////////

	RGBVal () {r = g = b = 0;}
	RGBVal (BYTE er, BYTE eg, BYTE eb) {r=er, g=eg, b=eb;}
	RGBVal (RGBVal& pal) {r=pal.r, g=pal.g, b=pal.b;}
	RGBVal (RGBVal* pal) {r=pal->r, g=pal->g, b=pal->b;}

	void SetVal (BYTE er, BYTE eg, BYTE eb){r = er, g = eg, b = eb;}

    ////////////////////////////////
	RGBVal operator = (long val) 
	{
		r = (BYTE)(val>>16);
		g = (BYTE)(val>>8);
		b = (BYTE)(val&0xff);
      return RGBVal (this);
	}
    ////////////////////////////////
	void	SwapColor () {SWAP (b,r);}
    ////////////////////////////////
	WORD Convert15() { return (WORD) (((r&248)<<7) + ((g&248)<<2) + (b>>3)); }
	WORD Convert16() { return (WORD) (((r&248)<<8) + ((g&252)<<3) + (b>>3)); }
	///////////////////////////////
	RGBVal From15Bit (WORD bit)
	{
		b=(BYTE)((bit<<3)&248);   if (b) b|=7;
		g=(BYTE)((bit>>2)&248);	  if (g) g|=7;
		r=(BYTE)((bit>>7)&248);   if (r) r|=7;
		return RGBVal (this);
	}
	///////////////////////////////
	RGBVal From16Bit (WORD bit)
	{
		b=(BYTE)((bit<<3)&248);	  if (b) b|=7;
		g=(BYTE)((bit>>2)&252);	  if (g) g|=3;
		r=(BYTE)((bit>>8)&248);   if (r) r|=7;
		return RGBVal (this);
	}
    ///////////////////////////////
	RGBVal operator = (RGBVal& pal)
	{
		r=pal.r, g=pal.g, b=pal.b;
		return RGBVal (this);
	}
	///////////////////////////////
	bool operator == (long val)
	{
		if (r==(BYTE)(val>>16) && g==(BYTE)(val>>8) && b==(BYTE)(val)) return true;
		return false;
	}
	//////////////////////////////
	bool operator == (RGBVal& pal)
	{
		if (r==pal.r && g==pal.g && b==pal.b) return true;
		return false;
	}
	/////////////////////////////
	bool operator > (RGBVal& pal)
	{
		long dist = (r-pal.r) + (g-pal.g) + (b-pal.b);
		if (dist>0) return true;
		return false;
	}
	/////////////////////////////
	bool operator < (RGBVal& pal)
	{
		long dist = (r-pal.r) + (g-pal.g) + (b-pal.b);
		if (dist<0) return true;
		return false;
	}
	//////////////////////////////
	RGBVal operator += (RGBVal& pal)
	{
		long er = pal.r, ir = r;
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
	
		r= (BYTE) LIMIT( er+ir, 0, 255), g=(BYTE) LIMIT(eg+ig, 0, 255), b=(BYTE) LIMIT(eb+ib, 0, 255);
		return RGBVal (this);
	}
	//////////////////////////////
	RGBVal operator -= (RGBVal& pal)
	{
		long er = pal.r, ir = r;
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		
		r= (BYTE) LIMIT(ir-er, 0, 255), g=(BYTE) LIMIT(ig-eg, 0, 255), b=(BYTE) LIMIT(ib-eb, 0, 255);
		return RGBVal (this);
	}
	//////////////////////////////
	RGBVal operator += (int amount)
	{
		long ir = r, ig = g, ib = b;
		
		r= (BYTE) LIMIT(ir+amount, 0, 255), g=(BYTE) LIMIT(ig+amount, 0, 255), b=(BYTE) LIMIT(ib+amount, 0, 255);
		return RGBVal (this);
	}
	//////////////////////////////
	RGBVal operator -= (int amount)
	{
		long ir = r, ig = g, ib = b;
		// limit is a macro defined above
		r= (BYTE) LIMIT(ir-amount, 0, 255), g=(BYTE) LIMIT(ig-amount, 0, 255), b=(BYTE) LIMIT(ib-amount, 0, 255);
		return RGBVal (this);
	}
	//////////////////////////////
	RGBVal operator + (RGBVal& pal)// used for col = c1 + c2;
	{
		long er = pal.r, ir = r;
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		BYTE tr= (BYTE) LIMIT(er+ir, 0, 255), tg=(BYTE) LIMIT(eg+ig, 0, 255), tb=(BYTE) LIMIT(eb+ib, 0, 255);
		return RGBVal (tr, tg, tb);
	}
	//////////////////////////////
	RGBVal operator - (RGBVal& pal)// used for col = c1 - c2;
	{
		long er = pal.r, ir = r;
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		BYTE tr= (BYTE) LIMIT(ir-er, 0, 255), tg=(BYTE) LIMIT(ig-eg, 0, 255), tb=(BYTE) LIMIT(ib-eb, 0, 255);
		return RGBVal (tr, tg, tb);
	}
	/////////////////////////////
	RGBVal operator ++ ()
	{
		long ir = r, ig = g, ib = b;
		
		r= (BYTE) LIMIT(ir+1, 0, 255), g=(BYTE) LIMIT(ig+1, 0, 255), b=(BYTE) LIMIT(ib+1, 0, 255);
		return RGBVal (this);
	}
	/////////////////////////////
	RGBVal operator -- ()// used for col = c1 - c2;
	{
		long ir = r, ig = g, ib = b;
	
		r= (BYTE) LIMIT(ir-1, 0, 255), g=(BYTE) LIMIT(ig-1, 0, 255), b=(BYTE) LIMIT(ib-1, 0, 255);
		return RGBVal (this);
	}
	/////////////////////////////
    void   SetVal (COLOR c)
    {
        switch (c)
        {
            case RED:
                r = 255, g = 0, b = 0;
            break;

            case FUCHSIA:
                r = 255, g = 0, b = 255;
            break;

            case BLUE:
                r = 0, g = 0, b = 255;
            break;

            case CYAN:
                r = 0, g = 255, b = 255;
            break;

            case GREEN:
                r = 0, g = 255, b = 0;
            break;

            case YELLOW:
                r = 255, g = 255, b = 0;
            break;

			case WHITE:
				r = 255, g = 255, b = 255;
			break;

			case GRAY:
				r = 127, g = 127, b = 127;
			break;

			default:// BLACK
				r = 0, g = 0, b = 0;// black
        }
    }

}RGBVal, * RGBValPtr;

///////////////////////////////////////////////////////////////////
// ޸𸮸 ̱   .
///////////////////////////////////////////////////////////////////
typedef struct CANVAS_SIZE
{
	DWORD   iWidth     : 16;
	DWORD   iHeight    : 16;
	DWORD   iRealWidth ; // ޸𸮻  , DDSURFACEDESC2 lPitch
					     //  Ѵ.

} CANVAS_SIZE;

///////////////////////////////////////////////////////////////////
typedef struct CANVAS
{
    WORD*       pwAddress;   // ǥ ޸  
	CANVAS_SIZE size;

} CANVAS, * CANVASPtr;
///////////////////////////////////////////////////////////////////
typedef struct TARGA_HEADER
{
	BYTE IDLength;
	BYTE ColorMapType;
	BYTE ImageType;
	WORD CMapStart;
//	WORD CMapLength;
	BYTE CMapDepth;
	WORD XOffset;
	WORD YOffset;
	WORD Width;
	WORD Height;
	BYTE PixelDepth;
	BYTE ImageDescriptor;

} TARGA_HEADER;
			  
///////////////////////////////////////////////////////////////////////////////////////////////
typedef struct GRAPHIC_FORMAT
{
	DWORD       dwRBitMask;
	DWORD       dwGBitMask;
    DWORD       dwBBitMask;
    COLOR_TYPE  ColorType;
    
	GRAPHIC_FORMAT() { dwRBitMask = dwGBitMask = dwBBitMask = 0, ColorType = _0x0x0_;}

} GRAPHIC_FORMAT, * GRAPHIC_FORMATPtr;
///////////////////////////////////////////////////////////////////////////////////////////////
typedef struct MANAGERS
{ 
//	MANAGERS() { pScreen = NULL, pDefineMgr = NULL, pStage = NULL;
//	                    pMap = NULL, pEntryMgr = NULL;}

	cScreen*          pScreen;
//	cMap*             pMap;
//	cDefine_Mgr*      pDefineMgr;
//	cEntry_Mgr*       pEntryMgr;
//	cStage*           pStage;
	
} MANAGERS, * MANAGERSPtr;

#endif // _STRUCT_H_