     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Tile.h
////////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
////////////////////////////////////////////////////////////////////////////
#ifndef _TILE_H_
#define _TILE_H_

#ifndef  _STRUCT_H_
#include "struct.h"
#endif

#ifndef  _GRAPHIC_H_
#include "graphic.h"
#endif

class   cEntry;

////////////////////////////////////////////////////////////////////////////
typedef struct TILE_FLAG
{
	DWORD uFlyable          : 1; // 1
	DWORD uPassable         : 1; // 2
	DWORD uPassed           : 1; 
	DWORD uDifficultToPass  : 1; // 3
	DWORD uCauseDamage      : 1; // 4
	DWORD uProvidesEnergy   : 1; // 5
	DWORD uProvidesMana     : 1; // 6
	DWORD uColorCycleStage  : 3; // 9
	DWORD uFog              : 3; // 12
	DWORD uTriggerPointID   : 4; // 16
	DWORD uTransportPointID : 4; // 20
    DWORD uDrawLevel        : 4; // 24


	DWORD Pad              : 8;

} TILE_FLAG, * TILE_FLAGPtr;
////////////////////////////////////////////////////////////////////////////
// CTile
////////////////////////////////////////////////////////////////////////////
typedef class cTile
{
public:
	cTile();
	virtual ~cTile() {};
	void            Clear() {};

	///////////////////////////////////////
	bool            Save( cFile& file);
	bool            Load( cFile& file);

	bool            Draw( int x, int y);
	bool            DrawAt( CANVASPtr pCanvas, int x, int y);

	void            SetGraphic( cGraphicPtr pGraphic) { m_pGraphic = pGraphic;}
	TILE_FLAG       GetTileFlag() { return m_TileFlag;}

	//////////////////////////////////////
protected:
	TILE_FLAG       m_TileFlag;
	cEntry*         m_pObject;
	cGraphicPtr     m_pGraphic; // virtual graphic

} cTile, * cTilePtr;

/////////////////////////////////////////////////////////////////////////////
#endif //_TILE_H_