//============================================================================
//   迭 C++ ø Ŭ
//============================================================================
//
//  1999 8 6 - 2001 2 19
//  ̻, YeNsd@hitel.net
//============================================================================

#ifndef __DYNARRAY_H__
#define __DYNARRAY_H__

#include "Commdef.h"

template <class T, class A = const T &, class F = const T &>
class SArray
{
public:
	SArray()
	{
		m_nSize = 0;
		m_nCapacity = CalcCapacity(0);
		m_ppt = new T *[m_nCapacity];
	}

	SArray(const SArray<T, A, F> &arr)
	{
		int i;
		T **ppt = new T *[arr.m_nCapacity];
		TRY
		{
			for (i = 0;i < arr.m_nSize;i++)
				ppt[i] = new T(*arr.m_ppt[i]);
		}
		CATCH_ALL(e)
		{
			for (i--;i >= 0;i--)
				delete ppt[i];
			delete [] ppt;
			THROW_LAST();
		}
		END_CATCH_ALL

		m_nSize = arr.m_nSize;
		m_nCapacity = arr.m_nCapacity;
		m_ppt = ppt;
	}

	virtual ~SArray()
	{
		for (int i = 0;i < m_nSize;i++)
			delete m_ppt[i];
		delete [] m_ppt;
	}

// Attributes
public:
	int GetSize() const
	{
		return m_nSize;
	}

	BOOL IsEmpty() const
	{
		return m_nSize == 0;
	}

	const T &GetAt(int nIndex) const
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return *m_ppt[nIndex];
	}

	void SetAt(int nIndex, A a)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		*m_ppt[nIndex] = a;
	}

	T &operator [](int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return *m_ppt[nIndex];
	}

	const T &operator [](int nIndex) const
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return *m_ppt[nIndex];
	}

// Operations
public:
	int Add(A a)
	{
		SHeap<T> pt = new T(a);
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, m_ppt, sizeof(T *) * m_nSize);
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
		m_ppt[m_nSize++] = pt.Detach();
		return m_nSize;
	}

	void Insert(int nIndex, A a)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		SHeap<T> pt = new T(a);
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, m_ppt, sizeof(T *) * nIndex);
			memcpy(pptNew + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memmove(m_ppt + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
		m_ppt[nIndex] = pt.Detach();
	}

	T &Add()
	{
		SHeap<T> pt = new T;
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, m_ppt, sizeof(T *) * m_nSize);
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
		return *(m_ppt[m_nSize++] = pt.Detach());
	}

	T &Insert(int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		SHeap<T> pt = new T;
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, m_ppt, sizeof(T *) * nIndex);
			memcpy(pptNew + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memmove(m_ppt + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
		return *(m_ppt[nIndex] = pt.Detach());
	}

	void Add(const SArray<T, A, F> &arr)
	{
		int i, nNewCapacity = CalcCapacity(m_nSize + arr.m_nSize);
		T **ppt = new T *[nNewCapacity];
		memcpy(ppt, m_ppt, sizeof(T *) * m_nSize);
		TRY
		{
			for (i = 0;i < arr.m_nSize;i++)
				ppt[m_nSize + i] = new T(*arr.m_ppt[i]);
		}
		CATCH_ALL(e)
		{
			for (i--;i >= 0;i--)
				delete ppt[m_nSize + i];
			delete [] ppt;
			THROW_LAST();
		}
		END_CATCH_ALL

		m_nSize += arr.m_nSize;
		m_nCapacity = nNewCapacity;
		delete [] m_ppt;
		m_ppt = ppt;
	}

	void Insert(int nIndex, const SArray<T, A, F> &arr)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		int i, nNewCapacity = CalcCapacity(m_nSize + arr.m_nSize);
		T **ppt = new T *[nNewCapacity];
		memcpy(ppt, m_ppt, sizeof(T *) * nIndex);
		memcpy(ppt + nIndex + arr.m_nSize, m_ppt + nIndex, sizeof(T *) * (m_nSize - nIndex));
		TRY
		{
			for (i = 0;i < arr.m_nSize;i++)
				ppt[nIndex + i] = new T(*arr.m_ppt[i]);
		}
		CATCH_ALL(e)
		{
			for (i--;i >= 0;i--)
				delete ppt[nIndex + i];
			delete [] ppt;
			THROW_LAST();
		}
		END_CATCH_ALL

		m_nSize += arr.m_nSize;
		m_nCapacity = nNewCapacity;
		delete [] m_ppt;
		m_ppt = ppt;
	}

	void Remove(int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		T *pt = m_ppt[nIndex];
		int nNewCapacity = CalcCapacity(m_nSize - 1);
		if (nNewCapacity != m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, m_ppt, sizeof(T *) * nIndex);
			memcpy(pptNew + nIndex, m_ppt + nIndex + 1, sizeof(T *) * (m_nSize - nIndex - 1));
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memcpy(m_ppt + nIndex, m_ppt + nIndex + 1, sizeof(T *) * (m_nSize - nIndex - 1));
		m_nSize--;
		delete pt;
	}

	void RemoveAll()
	{
		T **pptNew;
		int nNewCapacity = CalcCapacity(0);
		if (nNewCapacity != m_nCapacity)
			pptNew = new T *[nNewCapacity];

		for (int i = 0;i < m_nSize;i++)
			delete m_ppt[i];
		m_nSize = 0;
		if (nNewCapacity != m_nCapacity)
		{
			delete [] m_ppt;
			m_ppt = pptNew;
			m_nCapacity = nNewCapacity;
		}
	}

	void Move(int nCurIndex, int nNewIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		ASSERT(inrange(nNewIndex, 0, m_nSize));
		T *pt = m_ppt[nCurIndex];
		if (nCurIndex < nNewIndex)
			memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (nNewIndex - nCurIndex));
		else
			memmove(m_ppt + nNewIndex + 1, m_ppt + nNewIndex, sizeof(T *) * (nCurIndex - nNewIndex));
		m_ppt[nNewIndex] = pt;
	}

	void MoveToHead(int nCurIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		T *pt = m_ppt[nCurIndex];
		memmove(m_ppt + 1, m_ppt, sizeof(T *) * nCurIndex);
		m_ppt[0] = pt;
	}

	void MoveToTail(int nCurIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		T *pt = m_ppt[nCurIndex];
		memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (m_nSize - nCurIndex - 1));
		m_ppt[m_nSize - 1] = pt;
	}

	void Move(int nCurIndex, SArray<T, A, F> &arr, int nNewIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		ASSERT(inrange(nNewIndex, 0, arr.m_nSize + 1));

		if (&arr != this)
		{
			SArrHeap<T *> ppt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				ppt = new T *[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T **pptNew = new T *[nNewCapacity];
				memcpy(pptNew, arr.m_ppt, sizeof(T *) * nNewIndex);
				memcpy(pptNew + nNewIndex + 1, arr.m_ppt + nNewIndex, sizeof(T *) * (arr.m_nSize++ - nNewIndex));
				delete [] arr.m_ppt;
				arr.m_ppt = pptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			else
				memmove(arr.m_ppt + nNewIndex + 1, arr.m_ppt + nNewIndex, sizeof(T *) * (arr.m_nSize++ - nNewIndex));
			arr.m_ppt[nNewIndex] = m_ppt[nCurIndex];

			if (ppt != NULL)
			{
				memcpy(ppt, m_ppt, sizeof(T *) * nCurIndex);
				memcpy(ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
				delete [] m_ppt;
				m_ppt = ppt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
		}
		else
		{
			T *pt = m_ppt[nCurIndex];
			if (nCurIndex < nNewIndex)
				memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--nNewIndex - nCurIndex));
			else
				memmove(m_ppt + nNewIndex + 1, m_ppt + nNewIndex, sizeof(T *) * (nCurIndex - nNewIndex));
			m_ppt[nNewIndex] = pt;
		}
	}

	void MoveToHead(int nCurIndex, SArray<T, A, F> &arr)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		if (&arr != this)
		{
			SArrHeap<T *> ppt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				ppt = new T *[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T **pptNew = new T *[nNewCapacity];
				memcpy(pptNew + 1, arr.m_ppt, sizeof(T *) * arr.m_nSize++);
				delete [] arr.m_ppt;
				arr.m_ppt = pptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			else
				memmove(arr.m_ppt + 1, arr.m_ppt, sizeof(T *) * arr.m_nSize++);
			arr.m_ppt[0] = m_ppt[nCurIndex];

			if (ppt != NULL)
			{
				memcpy(ppt, m_ppt, sizeof(T *) * nCurIndex);
				memcpy(ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
				delete [] m_ppt;
				m_ppt = ppt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
		}
		else
		{
			T *pt = m_ppt[nCurIndex];
			memmove(m_ppt + 1, m_ppt, sizeof(T *) * nCurIndex);
			m_ppt[0] = pt;
		}
	}

	void MoveToTail(int nCurIndex, SArray<T, A, F> &arr)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		if (&arr != this)
		{
			SArrHeap<T *> ppt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				ppt = new T *[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T **pptNew = new T *[nNewCapacity];
				memcpy(pptNew, arr.m_ppt, sizeof(T *) * arr.m_nSize);
				delete [] arr.m_ppt;
				arr.m_ppt = pptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			arr.m_ppt[arr.m_nSize++] = m_ppt[nCurIndex];

			if (ppt != NULL)
			{
				memcpy(ppt, m_ppt, sizeof(T *) * nCurIndex);
				memcpy(ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
				delete [] m_ppt;
				m_ppt = ppt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (--m_nSize - nCurIndex));
		}
		else
		{
			T *pt = m_ppt[nCurIndex];
			memcpy(m_ppt + nCurIndex, m_ppt + nCurIndex + 1, sizeof(T *) * (m_nSize - nCurIndex - 1));
			m_ppt[m_nSize - 1] = pt;
		}
	}

	void MoveAll(SArray<T, A, F> &arr, int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		if (&arr == this)
			return;

		SArrHeap<T *> ppt;
		if (CalcCapacity(0) != m_nCapacity)
			ppt = new T *[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, arr.m_ppt, sizeof(T *) * nIndex);
			memcpy(pptNew + nIndex + m_nSize, arr.m_ppt + nIndex, sizeof(T *) * (arr.m_nSize - nIndex));
			delete [] arr.m_ppt;
			arr.m_ppt = pptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		else
			memmove(arr.m_ppt + nIndex + m_nSize, arr.m_ppt + nIndex, sizeof(T *) * (arr.m_nSize - nIndex));
		for (int i = 0;i < m_nSize;i++)
			arr.m_ppt[nIndex + i] = m_ppt[i];
		arr.m_nSize += m_nSize;

		if (ppt != NULL)
		{
			delete [] m_ppt;
			m_ppt = ppt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	void MoveToHeadAll(SArray<T, A, F> &arr)
	{
		if (&arr == this)
			return;

		SArrHeap<T *> ppt;
		if (CalcCapacity(0) != m_nCapacity)
			ppt = new T *[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew + m_nSize, arr.m_ppt, sizeof(T *) * arr.m_nSize);
			delete [] arr.m_ppt;
			arr.m_ppt = pptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		else
			memmove(arr.m_ppt + m_nSize, arr.m_ppt, sizeof(T *) * arr.m_nSize);
		for (int i = 0;i < m_nSize;i++)
			arr.m_ppt[i] = m_ppt[i];
		arr.m_nSize += m_nSize;

		if (ppt != NULL)
		{
			delete [] m_ppt;
			m_ppt = ppt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	void MoveToTailAll(SArray<T, A, F> &arr)
	{
		if (&arr == this)
			return;

		SArrHeap<T *> ppt;
		if (CalcCapacity(0) != m_nCapacity)
			ppt = new T *[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T **pptNew = new T *[nNewCapacity];
			memcpy(pptNew, arr.m_ppt, sizeof(T *) * arr.m_nSize);
			delete [] arr.m_ppt;
			arr.m_ppt = pptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		for (int i = 0;i < m_nSize;i++)
			arr.m_ppt[arr.m_nSize + i] = m_ppt[i];
		arr.m_nSize += m_nSize;

		if (ppt != NULL)
		{
			delete [] m_ppt;
			m_ppt = ppt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	int Find(F f, int nIndex = -1) const
	{
		ASSERT(inrange(nIndex, -1, m_nSize));
		for (nIndex++;nIndex < m_nSize;nIndex++)
			if (*m_ppt[nIndex] == f)
				return nIndex;
		return -1;
	}

	int Find(const T *pt, int nIndex = -1) const
	{
		ASSERT(IsValidReadOnlyAddress(pt));
		ASSERT(inrange(nIndex, -1, m_nSize));
		for (nIndex++;nIndex < m_nSize;nIndex++)
			if (m_ppt[nIndex] == pt)
				return nIndex;
		return -1;
	}

	void Reverse()
	{
		int nHelf = m_nSize / 2, nLast = m_nSize - 1;
		for (int i = 0;i < nHelf;i++)
		{
			T *pt = m_ppt[i];
			m_ppt[i] = m_ppt[nLast - i];
			m_ppt[nLast - i] = pt;
		}
	}

	void Swap(int nIndex1, int nIndex2)
	{
		ASSERT(inrange(nIndex1, 0, m_nSize));
		ASSERT(inrange(nIndex2, 0, m_nSize));
		swap(m_ppt[nIndex1], m_ppt[nIndex2]);
	}

	void Swap(int nIndex1, SArray<T, A, F> &arr, int nIndex2)
	{
		ASSERT(inrange(nIndex1, 0, m_nSize));
		ASSERT(inrange(nIndex2, 0, arr.m_nSize));
		swap(m_ppt[nIndex1], arr.m_ppt[nIndex2]);
	}

	void Swap(SArray<T, A, F> &arr)
	{
		swap(m_nSize, arr.m_nSize);
		swap(m_nCapacity, arr.m_nCapacity);
		swap(m_ppt, arr.m_ppt);
	}

	void InsertSort(BOOL bAscending = TRUE)
	{
		if (bAscending)
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T *pt = m_ppt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && *m_ppt[i2] > *pt;i2--)
					m_ppt[i2 + 1] = m_ppt[i2];
				m_ppt[i2 + 1] = pt;
			}
		else
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T *pt = m_ppt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && *m_ppt[i2] < *pt;i2--)
					m_ppt[i2 + 1] = m_ppt[i2];
				m_ppt[i2 + 1] = pt;
			}
	}

	void MergeSort(BOOL bAscending = TRUE)
	{
		T **pptBuffer = new T *[m_nCapacity];
		if (bAscending)
			for (int nSize = 1;nSize < m_nSize;nSize *= 2)
			{
				for (int i = 0, nLeft = 0, nRight = nSize;nRight < m_nSize;)
				{
					int nEnd = nRight + nSize;
					if (nEnd > m_nSize)
						nEnd = m_nSize;
					for (int iLeft = nLeft, iRight = nRight;;i++)
						if (iLeft == nRight)
						{
							if (iRight == nEnd)
								break;
							pptBuffer[i] = m_ppt[iRight++];
						}
						else
							if (iRight == nEnd || *m_ppt[iLeft] <= *m_ppt[iRight])
								pptBuffer[i] = m_ppt[iLeft++];
							else
								pptBuffer[i] = m_ppt[iRight++];
					nLeft = nEnd;
					nRight = nEnd + nSize;
				}
				memcpy(pptBuffer + i, m_ppt + i, sizeof(T *) * (m_nSize - i));
				swap(m_ppt, pptBuffer);
			}
		else
			for (int nSize = 1;nSize < m_nSize;nSize *= 2)
			{
				for (int i = 0, nLeft = 0, nRight = nSize;nRight < m_nSize;)
				{
					int nEnd = nRight + nSize;
					if (nEnd > m_nSize)
						nEnd = m_nSize;
					for (int iLeft = nLeft, iRight = nRight;;i++)
						if (iLeft == nRight)
						{
							if (iRight == nEnd)
								break;
							pptBuffer[i] = m_ppt[iRight++];
						}
						else
							if (iRight == nEnd || *m_ppt[iLeft] >= *m_ppt[iRight])
								pptBuffer[i] = m_ppt[iLeft++];
							else
								pptBuffer[i] = m_ppt[iRight++];
					nLeft = nEnd;
					nRight = nEnd + nSize;
				}
				memcpy(pptBuffer + i, m_ppt + i, sizeof(T *) * (m_nSize - i));
				swap(m_ppt, pptBuffer);
			}
		delete [] pptBuffer;
	}

	void ShellSort(BOOL bAscending = TRUE)
	{
		for (int nInc = 1;nInc < m_nSize;nInc = 3 * nInc + 1)
			NULL;
		if (bAscending)
		{
			for (nInc /= 3;nInc > 1;nInc /= 3)
				for (int nBegin = 0;nBegin < nInc;nBegin++)
					for (int i1 = nBegin + nInc;i1 < m_nSize;i1 += nInc)
					{
						T *pt = m_ppt[i1];
						for (int i2 = i1 - nInc;i2 >= 0 && *m_ppt[i2] > *pt;i2 -= nInc)
							m_ppt[i2 + nInc] = m_ppt[i2];
						m_ppt[i2 + nInc] = pt;
					}
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T *pt = m_ppt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && *m_ppt[i2] > *pt;i2--)
					m_ppt[i2 + 1] = m_ppt[i2];
				m_ppt[i2 + 1] = pt;
			}
		}
		else
		{
			for (nInc /= 3;nInc > 1;nInc /= 3)
				for (int nBegin = 0;nBegin < nInc;nBegin++)
					for (int i1 = nBegin + nInc;i1 < m_nSize;i1 += nInc)
					{
						T *pt = m_ppt[i1];
						for (int i2 = i1 - nInc;i2 >= 0 && *m_ppt[i2] < *pt;i2 -= nInc)
							m_ppt[i2 + nInc] = m_ppt[i2];
						m_ppt[i2 + nInc] = pt;
					}
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T *pt = m_ppt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && *m_ppt[i2] < *pt;i2--)
					m_ppt[i2 + 1] = m_ppt[i2];
				m_ppt[i2 + 1] = pt;
			}
		}
	}

	void HeapSort(BOOL bAscending = TRUE)
	{
		int nSize = m_nSize;
		T **ppt = m_ppt - 1;
		if (bAscending)
		{
			for (int i = nSize / 2;i > 0;i--)
			{
				int iParent = i;
				T *pt = ppt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && *ppt[iChild] < *ppt[iChild + 1])
						iChild++;
					if (*pt >= *ppt[iChild])
						break;
					ppt[iParent] = ppt[iChild];
					iParent = iChild;
				}
				ppt[iParent] = pt;
			}
			while (nSize > 1)
			{
				T *pt = ppt[1];
				ppt[1] = ppt[nSize];
				ppt[nSize--] = pt;

				int iParent = 1;
				pt = ppt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && *ppt[iChild] < *ppt[iChild + 1])
						iChild++;
					if (*pt >= *ppt[iChild])
						break;
					ppt[iParent] = ppt[iChild];
					iParent = iChild;
				}
				ppt[iParent] = pt;
			}
		}
		else
		{
			for (int i = nSize / 2;i > 0;i--)
			{
				int iParent = i;
				T *pt = ppt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && *ppt[iChild] > *ppt[iChild + 1])
						iChild++;
					if (*pt <= *ppt[iChild])
						break;
					ppt[iParent] = ppt[iChild];
					iParent = iChild;
				}
				ppt[iParent] = pt;
			}
			while (nSize > 1)
			{
				T *pt = ppt[1];
				ppt[1] = ppt[nSize];
				ppt[nSize--] = pt;

				int iParent = 1;
				pt = ppt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && *ppt[iChild] > *ppt[iChild + 1])
						iChild++;
					if (*pt <= *ppt[iChild])
						break;
					ppt[iParent] = ppt[iChild];
					iParent = iChild;
				}
				ppt[iParent] = pt;
			}
		}
	}

	void QuickSort(BOOL bAscending = TRUE)
	{
		if (m_nSize > 1)
			if (bAscending)
				QuickSortAscending(m_ppt, m_nSize);
			else
				QuickSortDescending(m_ppt, m_nSize);
	}

	void Sort(BOOL bAscending = TRUE)
	{
		QuickSort(bAscending);
	}

	bool operator ==(const SArray<T, A, F> &arr) const
	{
		if (m_nSize != arr.m_nSize)
			return false;
		for (int i = 0;i < m_nSize;i++)
			if (*m_ppt[i] != *arr.m_ppt[i])
				return false;
		return true;
	}

	bool operator !=(const SArray<T, A, F> &arr) const
	{
		if (m_nSize != arr.m_nSize)
			return true;
		for (int i = 0;i < m_nSize;i++)
			if (*m_ppt[i] != *arr.m_ppt[i])
				return true;
		return false;
	}

	SArray<T, A, F> &operator =(const SArray<T, A, F> &arr)
	{
		if (&arr == this)
			return *this;

		int i;
		T **ppt = new T *[arr.m_nCapacity];
		TRY
		{
			for (i = 0;i < arr.m_nSize;i++)
				ppt[i] = new T(arr[i]);
		}
		CATCH_ALL(e)
		{
			for (i--;i >= 0;i--)
				delete ppt[i];
			delete ppt;
			THROW_LAST();
		}
		END_CATCH_ALL

		for (i = 0;i < m_nSize;i++)
			delete m_ppt[i];
		delete [] m_ppt;

		m_nSize = arr.m_nSize;
		m_nCapacity = arr.m_nCapacity;
		m_ppt = ppt;
		return *this;
	}

	SArray<T, A, F> &operator +=(const SArray<T, A, F> &arr)
	{
		Add(arr);
		return *this;
	}

#ifdef _STREAM

	void ReadFromStream(SInputStream &in)
	{
		int i, nSize, nCapacity;
		in >> nSize;
		nCapacity = CalcCapacity(nSize);
		T **ppt = new T *[nCapacity];
		TRY
		{
			for (i = 0;i < nSize;i++)
			{
				ppt[i] = new T;
				in >> *ppt[i];
			}
		}
		CATCH_ALL(e)
		{
			for (i--;i >= 0;i--)
				delete ppt[i];
			delete ppt;
			THROW_LAST();
		}
		END_CATCH_ALL

		for (i = 0;i < m_nSize;i++)
			delete m_ppt[i];
		delete [] m_ppt;

		m_nSize = nSize;
		m_nCapacity = nCapacity;
		m_ppt = ppt;
	}

	void WriteToStream(SOutputStream &out) const
	{
		out << m_nSize;
		for (int i = 0;i < m_nSize;i++)
			out << *m_ppt[i];
	}

#endif // _STREAM

#ifdef _MFC_VER
	friend CArchive &operator >>(CArchive &ar, SArray<T, A, F> &arr);
	friend CArchive &operator <<(CArchive &ar, const SArray<T, A, F> &arr);
#endif // _MFC_VER

// Implementation
protected:
	int m_nSize, m_nCapacity;
	T **m_ppt;

	static int CalcCapacity(int nSize)
	{
		return nSize <= 64 ? 64 : ALIGN(64, nSize);
	}

private:
	static void QuickSortAscending(T **ppt, int nSize)
	{
		int iLeft = -1, iRight = nSize - 1;
		T *ptPivot = ppt[nSize / 2];
		ppt[nSize / 2] = ppt[iRight];
		ppt[iRight] = ptPivot;
		while (TRUE)
		{
			while (++iLeft < nSize && *ppt[iLeft] < *ptPivot)
				NULL;
			while (--iRight >= 0 && *ppt[iRight] > *ptPivot)
				NULL;
			if (iLeft >= iRight)
				break;
			swap(ppt[iLeft], ppt[iRight]);
		}
		swap(ppt[iLeft], ppt[nSize - 1]);

		if (iLeft > 1)
			QuickSortAscending(ppt, iLeft);
		if ((iRight = nSize - iLeft - 1) > 1)
			QuickSortAscending(ppt + iLeft + 1, iRight);
	}

	static void QuickSortDescending(T **ppt, int nSize)
	{
		int iLeft = -1, iRight = nSize - 1;
		T *ptPivot = ppt[nSize / 2];
		ppt[nSize / 2] = ppt[iRight];
		ppt[iRight] = ptPivot;
		while (TRUE)
		{
			while (++iLeft < nSize && *ppt[iLeft] > *ptPivot)
				NULL;
			while (--iRight >= 0 && *ppt[iRight] < *ptPivot)
				NULL;
			if (iLeft >= iRight)
				break;
			swap(ppt[iLeft], ppt[iRight]);
		}
		swap(ppt[iLeft], ppt[nSize - 1]);

		if (iLeft > 1)
			QuickSortDescending(ppt, iLeft);
		if ((iRight = nSize - iLeft - 1) > 1)
			QuickSortDescending(ppt + iLeft + 1, iRight);
	}
};

template <class T, class A = const T &, class F = const T &>
class SRefArray : public SArray<T, A, F>
{
// Operations
public:
	int AddRef(T *pt)
	{
		TRY
		{
			int nNewCapacity = CalcCapacity(m_nSize + 1);
			if (nNewCapacity != m_nCapacity)
			{
				T **pptNew = new T *[nNewCapacity];
				memcpy(pptNew, m_ppt, sizeof(T *) * m_nSize);
				delete [] m_ppt;
				m_ppt = pptNew;
				m_nCapacity = nNewCapacity;
			}
		}
		CATCH_ALL(e)
		{
			delete pt;
			THROW_LAST();
		}
		END_CATCH_ALL
		m_ppt[m_nSize++] = pt;
		return m_nSize;
	}

	void InsertRef(int nIndex, T *pt)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		TRY
		{
			int nNewCapacity = CalcCapacity(m_nSize + 1);
			if (nNewCapacity != m_nCapacity)
			{
				T **pptNew = new T *[nNewCapacity];
				memcpy(pptNew, m_ppt, sizeof(T *) * nIndex);
				memcpy(pptNew + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
				delete [] m_ppt;
				m_ppt = pptNew;
				m_nCapacity = nNewCapacity;
			}
			else
				memmove(m_ppt + nIndex + 1, m_ppt + nIndex, sizeof(T *) * (m_nSize++ - nIndex));
		}
		CATCH_ALL(e)
		{
			delete pt;
			THROW_LAST();
		}
		END_CATCH_ALL
		m_ppt[nIndex] = pt;
	}
};

template <class T, class A = T, class F = T>
class SDrtArray
{
public:
	SDrtArray()
	{
		m_nSize = 0;
		m_nCapacity = CalcCapacity(0);
		m_pt = new T[m_nCapacity];
	}

	SDrtArray(const SDrtArray<T, A, F> &arr)
	{
		T *ptNew = new T[arr.m_nCapacity];
		memcpy(ptNew, arr.m_pt, sizeof(T) * arr.m_nSize);

		m_nSize = arr.m_nSize;
		m_nCapacity = arr.m_nCapacity;
		m_pt = ptNew;
	}

	virtual ~SDrtArray()
	{
		delete [] m_pt;
	}

// Attributes
public:
	int GetSize() const
	{
		return m_nSize;
	}

	BOOL IsEmpty() const
	{
		return m_nSize == 0;
	}

	T GetAt(int nIndex) const
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return m_pt[nIndex];
	}

	void SetAt(int nIndex, A a)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		m_pt[nIndex] = a;
	}

	T &operator [](int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return m_pt[nIndex];
	}

	const T &operator [](int nIndex) const
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		return m_pt[nIndex];
	}

// Operations
public:
	int Add(A a)
	{
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, m_pt, sizeof(T) * m_nSize);
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = nNewCapacity;
		}
		m_pt[m_nSize++] = a;
		return m_nSize;
	}

	void Insert(int nIndex, A a)
	{
		ASSERT(inrange(nIndex, 0, m_nSize + 1));
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, m_pt, sizeof(T) * nIndex);
			memcpy(ptNew + nIndex + 1, m_pt + nIndex, sizeof(T) * (m_nSize++ - nIndex));
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memmove(m_pt + nIndex + 1, m_pt + nIndex, sizeof(T) * (m_nSize++ - nIndex));
		m_pt[nIndex] = a;
	}

	T &Add()
	{
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, m_pt, sizeof(T) * m_nSize);
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = nNewCapacity;
		}
		return m_pt[m_nSize++];
	}

	T &Insert(int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize + 1));
		int nNewCapacity = CalcCapacity(m_nSize + 1);
		if (nNewCapacity != m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, m_pt, sizeof(T) * nIndex);
			memcpy(ptNew + nIndex + 1, m_pt + nIndex, sizeof(T) * (m_nSize++ - nIndex));
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memmove(m_pt + nIndex + 1, m_pt + nIndex, sizeof(T) * (m_nSize++ - nIndex));
		return m_pt[nIndex];
	}

	void Add(const SDrtArray<T, A, F> &arr)
	{
		int nNewCapacity = CalcCapacity(m_nSize + arr.m_nSize);
		T *ptNew = new T[nNewCapacity];
		memcpy(ptNew, m_pt, sizeof(T) * m_nSize);
		memcpy(ptNew + m_nSize, arr.m_pt, sizeof(T) * arr.m_nSize);

		m_nSize += arr.m_nSize;
		m_nCapacity = nNewCapacity;
		delete [] m_pt;
		m_pt = ptNew;
	}

	void Insert(int nIndex, const SDrtArray<T, A, F> &arr)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		int nNewCapacity = CalcCapacity(m_nSize + arr.m_nSize);
		T *ptNew = new T[nNewCapacity];
		memcpy(ptNew, m_pt, sizeof(T) * nIndex);
		memcpy(ptNew + nIndex, arr.m_pt, sizeof(T) * arr.m_nSize);
		memcpy(ptNew + nIndex + arr.m_nSize, m_pt + nIndex, sizeof(T) * (m_nSize - nIndex));

		m_nSize += arr.m_nSize;
		m_nCapacity = nNewCapacity;
		delete [] m_pt;
		m_pt = ptNew;
	}

	void Remove(int nIndex)
	{
		ASSERT(inrange(nIndex, 0, m_nSize));
		int nNewCapacity = CalcCapacity(m_nSize - 1);
		if (nNewCapacity != m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, m_pt, sizeof(T) * nIndex);
			memcpy(ptNew + nIndex, m_pt + nIndex + 1, sizeof(T) * (m_nSize - nIndex - 1));
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = nNewCapacity;
		}
		else
			memcpy(m_pt + nIndex, m_pt + nIndex + 1, sizeof(T) * (m_nSize - nIndex - 1));
		m_nSize--;
	}

	void RemoveAll()
	{
		if (CalcCapacity(0) != m_nCapacity)
		{
			T *ptNew = new T[CalcCapacity(0)];
			delete [] m_pt;
			m_pt = ptNew;
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	void Move(int nCurIndex, int nNewIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		ASSERT(inrange(nNewIndex, 0, m_nSize));
		T t = m_pt[nCurIndex];
		if (nCurIndex < nNewIndex)
			memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (nNewIndex - nCurIndex));
		else
			memmove(m_pt + nNewIndex + 1, m_pt + nNewIndex, sizeof(T) * (nCurIndex - nNewIndex));
		m_pt[nNewIndex] = t;
	}

	void MoveToFirst(int nCurIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		T t = m_pt[nCurIndex];
		memmove(m_pt + 1, m_pt, sizeof(T) * nCurIndex);
		m_pt[0] = t;
	}

	void MoveToLast(int nCurIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		T t = m_pt[nCurIndex];
		memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (m_nSize - nCurIndex - 1));
		m_pt[m_nSize - 1] = t;
	}

	void Move(int nCurIndex, SDrtArray<T, A, F> &arr, int nNewIndex)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		ASSERT(inrange(nNewIndex, 0, arr.m_nSize + 1));

		if (&arr != this)
		{
			SArrHeap<T> pt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				pt = new T[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T *ptNew = new T[nNewCapacity];
				memcpy(ptNew, arr.m_pt, sizeof(T) * nNewIndex);
				memcpy(ptNew + nNewIndex + 1, arr.m_pt + nNewIndex, sizeof(T) * (arr.m_nSize++ - nNewIndex));
				delete [] arr.m_pt;
				arr.m_pt = ptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			else
				memmove(arr.m_pt + nNewIndex + 1, arr.m_pt + nNewIndex, sizeof(T) * (arr.m_nSize++ - nNewIndex));
			arr.m_pt[nNewIndex] = m_pt[nCurIndex];

			if (pt != NULL)
			{
				memcpy(pt, m_pt, sizeof(T) * nCurIndex);
				memcpy(pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
				delete [] m_pt;
				m_pt = pt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
		}
		else
		{
			T t = m_pt[nCurIndex];
			if (nCurIndex < nNewIndex)
				memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--nNewIndex - nCurIndex));
			else
				memmove(m_pt + nNewIndex + 1, m_pt + nNewIndex, sizeof(T) * (nCurIndex - nNewIndex));
			m_pt[nNewIndex] = t;
		}
	}

	void MoveToFirst(int nCurIndex, SDrtArray<T, A, F> &arr)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		if (&arr != this)
		{
			SArrHeap<T> pt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				pt = new T[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T *ptNew = new T[nNewCapacity];
				memcpy(ptNew + 1, arr.m_pt, sizeof(T) * arr.m_nSize++);
				delete [] arr.m_pt;
				arr.m_pt = ptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			else
				memmove(arr.m_pt + 1, arr.m_pt, sizeof(T) * arr.m_nSize++);
			arr.m_pt[0] = m_pt[nCurIndex];

			if (pt != NULL)
			{
				memcpy(pt, m_pt, sizeof(T) * nCurIndex);
				memcpy(pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
				delete [] m_pt;
				m_pt = pt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
		}
		else
		{
			T t = m_pt[nCurIndex];
			memmove(m_pt + 1, m_pt, sizeof(T) * nCurIndex);
			m_pt[0] = t;
		}
	}

	void MoveToLast(int nCurIndex, SDrtArray<T, A, F> &arr)
	{
		ASSERT(inrange(nCurIndex, 0, m_nSize));
		if (&arr != this)
		{
			SArrHeap<T> pt;
			int nCurCapacity = CalcCapacity(m_nSize - 1);
			if (nCurCapacity != m_nCapacity)
				pt = new T[nCurCapacity];

			int nNewCapacity = CalcCapacity(arr.m_nSize + 1);
			if (nNewCapacity != arr.m_nCapacity)
			{
				T *ptNew = new T[nNewCapacity];
				memcpy(ptNew, arr.m_pt, sizeof(T) * arr.m_nSize);
				delete [] arr.m_pt;
				arr.m_pt = ptNew;
				arr.m_nCapacity = nNewCapacity;
			}
			arr.m_pt[arr.m_nSize++] = m_pt[nCurIndex];

			if (pt != NULL)
			{
				memcpy(pt, m_pt, sizeof(T) * nCurIndex);
				memcpy(pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
				delete [] m_pt;
				m_pt = pt.Detach();
				m_nCapacity = nCurCapacity;
			}
			else
				memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (--m_nSize - nCurIndex));
		}
		else
		{
			ASSERT(inrange(nCurIndex, 0, m_nSize));
			T t = m_pt[nCurIndex];
			memcpy(m_pt + nCurIndex, m_pt + nCurIndex + 1, sizeof(T) * (m_nSize - nCurIndex - 1));
			m_pt[m_nSize - 1] = t;
		}
	}

	void MoveAll(SDrtArray<T, A, F> &arr, int nIndex)
	{
		ASSERT(inrange(nIndex, 0, arr.m_nSize + 1));
		if (&arr == this)
			return;

		SArrHeap<T> pt;
		if (CalcCapacity(0) != m_nCapacity)
			pt = new T[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, arr.m_pt, sizeof(T) * nIndex);
			memcpy(ptNew + nIndex + m_nSize, arr.m_pt + nIndex, sizeof(T) * (arr.m_nSize - nIndex));
			delete [] arr.m_pt;
			arr.m_pt = ptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		else
			memmove(arr.m_pt + nIndex + m_nSize, arr.m_pt + nIndex, sizeof(T) * (arr.m_nSize - nIndex));
		for (int i = 0;i < m_nSize;i++)
			arr.m_pt[nIndex + i] = m_pt[i];
		arr.m_nSize += m_nSize;

		if (pt != NULL)
		{
			delete [] m_pt;
			m_pt = pt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	void MoveToFirstAll(SDrtArray<T, A, F> &arr)
	{
		if (&arr == this)
			return;

		SArrHeap<T> pt;
		if (CalcCapacity(0) != m_nCapacity)
			pt = new T[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew + m_nSize, arr.m_pt, sizeof(T) * arr.m_nSize);
			delete [] arr.m_pt;
			arr.m_pt = ptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		else
			memmove(arr.m_pt + m_nSize, arr.m_pt, sizeof(T) * arr.m_nSize);
		for (int i = 0;i < m_nSize;i++)
			arr.m_pt[i] = m_pt[i];
		arr.m_nSize += m_nSize;

		if (pt != NULL)
		{
			delete [] m_pt;
			m_pt = pt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	void MoveToLastAll(SDrtArray<T, A, F> &arr)
	{
		if (&arr == this)
			return;

		SArrHeap<T> pt;
		if (CalcCapacity(0) != m_nCapacity)
			pt = new T[CalcCapacity(0)];

		int nNewCapacity = CalcCapacity(arr.m_nSize + m_nSize);
		if (nNewCapacity != arr.m_nCapacity)
		{
			T *ptNew = new T[nNewCapacity];
			memcpy(ptNew, arr.m_pt, sizeof(T) * arr.m_nSize);
			delete [] arr.m_pt;
			arr.m_pt = ptNew;
			arr.m_nCapacity = nNewCapacity;
		}
		for (int i = 0;i < m_nSize;i++)
			arr.m_pt[arr.m_nSize + i] = m_pt[i];
		arr.m_nSize += m_nSize;

		if (pt != NULL)
		{
			delete [] m_pt;
			m_pt = pt.Detach();
			m_nCapacity = CalcCapacity(0);
		}
		m_nSize = 0;
	}

	int Find(F f, int nIndex = -1) const
	{
		ASSERT(inrange(nIndex, -1, m_nSize));
		for (nIndex++;nIndex < m_nSize;nIndex++)
			if (m_pt[nIndex] == f)
				return nIndex;
		return -1;
	}

	void Reverse()
	{
		int nHalf = m_nSize / 2, nLast = m_nSize - 1;
		for (int i = 0;i < nHalf;i++)
		{
			T t = m_pt[i];
			m_pt[i] = m_pt[nLast - i];
			m_pt[nLast - i] = t;
		}
	}

	void Swap(int nIndex1, int nIndex2)
	{
		ASSERT(inrange(nIndex1, 0, m_nSize));
		ASSERT(inrange(nIndex2, 0, m_nSize));
		swap(m_pt[nIndex1], m_pt[nIndex2]);
	}

	void Swap(int nIndex1, SDrtArray<T, A, F> &arr, int nIndex2)
	{
		ASSERT(inrange(nIndex1, 0, m_nSize));
		ASSERT(inrange(nIndex2, 0, arr.m_nSize));
		swap(m_pt[nIndex1], arr.m_pt[nIndex2]);
	}

	void Swap(SDrtArray<T, A, F> &arr)
	{
		swap(m_nSize, arr.m_nSize);
		swap(m_nCapacity, arr.m_nCapacity);
		swap(m_pt, arr.m_pt);
	}

	void InsertSort(BOOL bAscending = TRUE)
	{
		if (bAscending)
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T t = m_pt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && m_pt[i2] > t;i2--)
					m_pt[i2 + 1] = m_pt[i2];
				m_pt[i2 + 1] = t;
			}
		else
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T t = m_pt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && m_pt[i2] < t;i2--)
					m_pt[i2 + 1] = m_pt[i2];
				m_pt[i2 + 1] = t;
			}
	}

	void MergeSort(BOOL bAscending = TRUE)
	{
		T *ptBuffer = new T[m_nCapacity];
		if (bAscending)
			for (int nSize = 1;nSize < m_nSize;nSize *= 2)
			{
				for (int i = 0, nLeft = 0, nRight = nSize;nRight < m_nSize;)
				{
					int nEnd = nRight + nSize;
					if (nEnd > m_nSize)
						nEnd = m_nSize;
					for (int iLeft = nLeft, iRight = nRight;;i++)
						if (iLeft == nRight)
						{
							if (iRight == nEnd)
								break;
							ptBuffer[i] = m_pt[iRight++];
						}
						else
							if (iRight == nEnd || m_pt[iLeft] <= m_pt[iRight])
								ptBuffer[i] = m_pt[iLeft++];
							else
								ptBuffer[i] = m_pt[iRight++];
					nLeft = nEnd;
					nRight = nEnd + nSize;
				}
				memcpy(ptBuffer + i, m_pt + i, sizeof(T) * (m_nSize - i));
				swap(m_pt, ptBuffer);
			}
		else
			for (int nSize = 1;nSize < m_nSize;nSize *= 2)
			{
				for (int i = 0, nLeft = 0, nRight = nSize;nRight < m_nSize;)
				{
					int nEnd = nRight + nSize;
					if (nEnd > m_nSize)
						nEnd = m_nSize;
					for (int iLeft = nLeft, iRight = nRight;;i++)
						if (iLeft == nRight)
						{
							if (iRight == nEnd)
								break;
							ptBuffer[i] = m_pt[iRight++];
						}
						else
							if (iRight == nEnd || m_pt[iLeft] >= m_pt[iRight])
								ptBuffer[i] = m_pt[iLeft++];
							else
								ptBuffer[i] = m_pt[iRight++];
					nLeft = nEnd;
					nRight = nEnd + nSize;
				}
				memcpy(ptBuffer + i, m_pt + i, sizeof(T) * (m_nSize - i));
				swap(m_pt, ptBuffer);
			}
		delete [] ptBuffer;
	}

	void ShellSort(BOOL bAscending = TRUE)
	{
		for (int nInc = 1;nInc < m_nSize;nInc = 3 * nInc + 1)
			NULL;
		if (bAscending)
		{
			for (nInc /= 3;nInc > 1;nInc /= 3)
				for (int nBegin = 0;nBegin < nInc;nBegin++)
					for (int i1 = nBegin + nInc;i1 < m_nSize;i1 += nInc)
					{
						T t = m_pt[i1];
						for (int i2 = i1 - nInc;i2 >= 0 && m_pt[i2] > t;i2 -= nInc)
							m_pt[i2 + nInc] = m_pt[i2];
						m_pt[i2 + nInc] = t;
					}
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T t = m_pt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && m_pt[i2] > t;i2--)
					m_pt[i2 + 1] = m_pt[i2];
				m_pt[i2 + 1] = t;
			}
		}
		else
		{
			for (nInc /= 3;nInc > 1;nInc /= 3)
				for (int nBegin = 0;nBegin < nInc;nBegin++)
					for (int i1 = nBegin + nInc;i1 < m_nSize;i1 += nInc)
					{
						T t = m_pt[i1];
						for (int i2 = i1 - nInc;i2 >= 0 && m_pt[i2] < t;i2 -= nInc)
							m_pt[i2 + nInc] = m_pt[i2];
						m_pt[i2 + nInc] = t;
					}
			for (int i1 = 1;i1 < m_nSize;i1++)
			{
				T t = m_pt[i1];
				for (int i2 = i1 - 1;i2 >= 0 && m_pt[i2] < t;i2--)
					m_pt[i2 + 1] = m_pt[i2];
				m_pt[i2 + 1] = t;
			}
		}
	}

	void HeapSort(BOOL bAscending = TRUE)
	{
		int nSize = m_nSize;
		T *pt = m_pt - 1;
		if (bAscending)
		{
			for (int i = nSize / 2;i > 0;i--)
			{
				int iParent = i;
				T t = pt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && pt[iChild] < pt[iChild + 1])
						iChild++;
					if (t >= pt[iChild])
						break;
					pt[iParent] = pt[iChild];
					iParent = iChild;
				}
				pt[iParent] = t;
			}
			while (nSize > 1)
			{
				T t = pt[1];
				pt[1] = pt[nSize];
				pt[nSize--] = t;

				int iParent = 1;
				t = pt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && pt[iChild] < pt[iChild + 1])
						iChild++;
					if (t >= pt[iChild])
						break;
					pt[iParent] = pt[iChild];
					iParent = iChild;
				}
				pt[iParent] = t;
			}
		}
		else
		{
			for (int i = nSize / 2;i > 0;i--)
			{
				int iParent = i;
				T t = pt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && pt[iChild] > pt[iChild + 1])
						iChild++;
					if (t <= pt[iChild])
						break;
					pt[iParent] = pt[iChild];
					iParent = iChild;
				}
				pt[iParent] = t;
			}
			while (nSize > 1)
			{
				T t = pt[1];
				pt[1] = pt[nSize];
				pt[nSize--] = t;

				int iParent = 1;
				t = pt[iParent];
				while (iParent <= nSize / 2)
				{
					int iChild = iParent * 2;
					if (iChild < nSize && pt[iChild] > pt[iChild + 1])
						iChild++;
					if (t <= pt[iChild])
						break;
					pt[iParent] = pt[iChild];
					iParent = iChild;
				}
				pt[iParent] = t;
			}
		}
	}

	void QuickSort(BOOL bAscending = TRUE)
	{
		if (m_nSize > 1)
			if (bAscending)
				QuickSortAscending(m_pt, m_nSize);
			else
				QuickSortDescending(m_pt, m_nSize);
	}

	void Sort(BOOL bAscending = TRUE)
	{
		QuickSort(bAscending);
	}

	bool operator ==(const SDrtArray<T, A, F> &arr) const
	{
		if (m_nSize != arr.m_nSize)
			return false;
		for (int i = 0;i < m_nSize;i++)
			if (m_pt[i] != arr.m_pt[i])
				return false;
		return true;
	}

	bool operator !=(const SDrtArray<T, A, F> &arr) const
	{
		if (m_nSize != arr.m_nSize)
			return true;
		for (int i = 0;i < m_nSize;i++)
			if (m_pt[i] != arr.m_pt[i])
				return true;
		return false;
	}

	SDrtArray<T, A, F> &operator =(const SDrtArray<T, A, F> &arr)
	{
		if (&arr == this)
			return *this;

		SArrHeap<T> pt = new T[arr.m_nCapacity];
		memcpy(pt, arr.m_pt, sizeof(T) * arr.m_nSize);

		delete [] m_pt;
		m_nSize = arr.m_nSize;
		m_nCapacity = arr.m_nCapacity;
		m_pt = pt.Detach();
		return *this;
	}

	SDrtArray<T, A, F> &operator +=(const SDrtArray<T, A, F> &arr)
	{
		Add(arr);
		return *this;
	}

#ifdef _STREAM

	void ReadFromStream(SInputStream &in)
	{
		int nSize, nCapacity;
		in >> nSize;
		nCapacity = CalcCapacity(nSize);
		SArrHeap<T> pt = new T[nCapacity];
		for (int i = 0;i < nSize;i++)
			in >> pt[i];

		delete [] m_pt;
		m_nSize = nSize;
		m_nCapacity = nCapacity;
		m_pt = pt.Detach();
	}

	void WriteToStream(SOutputStream &out) const
	{
		out << m_nSize;
		for (int i = 0;i < m_nSize;i++)
			out << m_pt[i];
	}

#endif // _STREAM

// Implementation
private:
	int m_nSize, m_nCapacity;
	T *m_pt;

	static int CalcCapacity(int nSize)
	{
		return nSize <= 64 ? 64 : ALIGN(64, nSize);
	}

	void QuickSortAscending(T *pt, int nSize)
	{
		int iLeft = -1, iRight = nSize - 1;
		T tPivot = pt[nSize / 2];
		pt[nSize / 2] = pt[iRight];
		pt[iRight] = tPivot;
		while (TRUE)
		{
			while (++iLeft < nSize && pt[iLeft] < tPivot)
				NULL;
			while (--iRight >= 0 && pt[iRight] > tPivot)
				NULL;
			if (iLeft >= iRight)
				break;
			swap(pt[iLeft], pt[iRight]);
		}
		swap(pt[iLeft], pt[nSize - 1]);

		if (iLeft > 1)
			QuickSortAscending(pt, iLeft);
		if ((iRight = nSize - iLeft - 1) > 1)
			QuickSortAscending(pt + iLeft + 1, iRight);
	}

	void QuickSortDescending(T *pt, int nSize)
	{
		int iLeft = -1, iRight = nSize - 1;
		T tPivot = pt[nSize / 2];
		pt[nSize / 2] = pt[iRight];
		pt[iRight] = tPivot;
		while (TRUE)
		{
			while (++iLeft < nSize && pt[iLeft] > tPivot)
				NULL;
			while (--iRight >= 0 && pt[iRight] < tPivot)
				NULL;
			if (iLeft >= iRight)
				break;
			swap(pt[iLeft], pt[iRight]);
		}
		swap(pt[iLeft], pt[nSize - 1]);

		if (iLeft > 1)
			QuickSortDescending(pt, iLeft);
		if ((iRight = nSize - iLeft - 1) > 1)
			QuickSortDescending(pt + iLeft + 1, iRight);
	}
};

#endif // __DYNARRAY_H__
