//============================================================================
//    C++ Ŭ
//============================================================================
//
//===========================================================

#ifndef __FILEIO_H__
#define __FILEIO_H__

#include "Stream.h"

#define FM_READ            0x0001
#define FM_WRITE           0x0002
#define FM_READWRITE       0x0003
#define FM_SHARE_READ      0x0010
#define FM_SHARE_WRITE     0x0020
#define FM_SHARE_READWRITE 0x0030
#define FM_CREATE          0x0100

#define FS_BEGIN   0
#define FS_CURRENT 1
#define FS_END     2

#define FE_NONE         0
#define FE_CREATE       1
#define FE_CREATEEXIST  2
#define FE_OPENREAD     3
#define FE_OPENWRITE    4
#define FE_FILENOTFOUND 5
#define FE_READ         6
#define FE_WRITE        7
#define FE_SEEK         8
#define FE_DISKFULL     9
#define FE_ENDOFFILE    10
#define FE_BADFORMAT    11

class SFileStream : public SBinaryStream
{
public:
	void Create(LPCTSTR lpszFileName, UINT nMode);
	virtual void Open(LPCTSTR lpszFileName, UINT nMode) = 0;

	virtual DWORD Seek(long lOffset, UINT nFrom) = 0;
	virtual DWORD GetPosition() const = 0;
	virtual DWORD GetLength() const = 0;
	virtual void SetLength(DWORD dwLength) = 0;

	void SeekToBegin();
	DWORD SeekToEnd();

	void SetVersionInfo(int nVersionInfo);
};

class STextFileStream : public STextStream
{
protected:
	virtual UINT Read(LPVOID lpBuf, UINT nSize) = 0;
	virtual void Write(LPCVOID lpBuf, UINT nSize) = 0;

public:
	void Create(LPCTSTR lpszFileName, UINT nMode);
	virtual void Open(LPCTSTR lpszFileName, UINT nMode) = 0;

	virtual BOOL ReadString(LPSTR lpsz, int nMax, BOOL *pbEndLine = NULL);
	virtual BOOL ReadString(LPWSTR lpsz, int nMax, BOOL *pbEndLine = NULL);
	virtual BOOL ReadChar(char *pch);
	virtual BOOL ReadChar(WCHAR *pch);

	virtual void WriteString(LPCSTR lpsz);
	virtual void WriteString(LPCWSTR lpsz);
	virtual void WriteChar(char ch);
	virtual void WriteChar(WCHAR ch);

	virtual DWORD Seek(long lOffset, UINT nFrom) = 0;
	virtual DWORD GetPosition() const = 0;
	virtual DWORD GetLength() const = 0;
	virtual void SetLength(DWORD dwLength) = 0;

	void SeekToBegin();
	DWORD SeekToEnd();
};

class SFile : public SFileStream
{
public:
	SFile();
	SFile(LPCTSTR lpszFileName, UINT nMode);
	virtual ~SFile();

private:
	HANDLE m_hFile;
	TCHAR m_szFileName[MAX_PATH];

	void SetFileName(LPCTSTR lpszFileName);

public:
	virtual void Open(LPCTSTR lpszFileName, UINT nMode);
	virtual void Close();
	virtual void Flush();

	virtual UINT Read(LPVOID lpBuf, UINT nSize, BOOL bThrowEndOfFileException = TRUE);
	virtual void Write(LPCVOID lpBuf, UINT nSize);

	virtual DWORD Seek(long lOffset, UINT nFrom);
	virtual DWORD GetPosition() const;
	virtual DWORD GetLength() const;
	virtual void SetLength(DWORD dwLength);

	void ThrowException(UINT nCause) const;
	virtual void ThrowBadFormatException() const;

	LPCTSTR GetFileName() const;
	operator HANDLE();
};

class STextFile : public STextFileStream
{
public:
	STextFile();
	STextFile(LPCTSTR lpszFileName, UINT nMode);

private:
	SFile m_file;

protected:
	virtual UINT Read(LPVOID lpBuf, UINT nSize);
	virtual void Write(LPCVOID lpBuf, UINT nSize);

public:
	virtual void Open(LPCTSTR lpszFileName, UINT nMode);
	virtual void Close();
	virtual void Flush();

	virtual BOOL ReadString(LPSTR lpsz, int nMax, BOOL *pbEndLine = NULL);
	virtual BOOL ReadString(LPWSTR lpsz, int nMax, BOOL *pbEndLine = NULL);
	virtual BOOL ReadChar(char *pch);
	virtual BOOL ReadChar(WCHAR *pch);

	virtual void WriteString(LPCSTR lpsz);
	virtual void WriteString(LPCWSTR lpsz);
	virtual void WriteChar(char ch);
	virtual void WriteChar(WCHAR ch);

	virtual DWORD Seek(long lOffset, UINT nFrom);
	virtual DWORD GetPosition() const;
	virtual DWORD GetLength() const;
	virtual void SetLength(DWORD dwLength);

	void ThrowException(UINT nCause) const;

	LPCTSTR GetFileName() const;
};

class SFileException : public CException
{
public:
	SFileException(UINT nCause, LPCTSTR lpszFileName);
	virtual BOOL GetErrorMessage(LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext = NULL);

protected:
	UINT m_nCause;
	TCHAR m_szFileName[MAX_PATH];
};

inline void SFileStream::Create(LPCTSTR lpszFileName, UINT nMode)
{
	Open(lpszFileName, nMode | FM_CREATE);
}

inline void SFileStream::SeekToBegin()
{
	Seek(0, FS_BEGIN);
}

inline DWORD SFileStream::SeekToEnd()
{
	return Seek(0, FS_END);
}

inline void SFileStream::SetVersionInfo(int nVersionInfo)
{
	m_nVersionInfo = nVersionInfo;
}

inline void STextFileStream::Create(LPCTSTR lpszFileName, UINT nMode)
{
	Open(lpszFileName, nMode | FM_CREATE);
}

inline void STextFileStream::SeekToBegin()
{
	Seek(0, FS_BEGIN);
}

inline DWORD STextFileStream::SeekToEnd()
{
	return Seek(0, FS_END);
}

inline SFile::SFile()
{
	m_hFile = INVALID_HANDLE_VALUE;
	SetFileName(_T(""));
}

inline SFile::SFile(LPCTSTR lpszFileName, UINT nMode)
{
	ASSERT(IsValidString(lpszFileName));
	m_hFile = INVALID_HANDLE_VALUE;
	SetFileName(_T(""));
	Open(lpszFileName, nMode);
}

inline void SFile::SetFileName(LPCTSTR lpszFileName)
{
	ASSERT(IsValidString(lpszFileName));
	lstrcpyn(m_szFileName, lpszFileName, countof(m_szFileName));
}

inline LPCTSTR SFile::GetFileName() const
{
	return m_szFileName;
}

inline SFile::operator HANDLE()
{
	return m_hFile;
}

inline STextFile::STextFile()
{
}

inline STextFile::STextFile(LPCTSTR lpszFileName, UINT nMode)
{
	ASSERT(IsValidString(lpszFileName));
	Open(lpszFileName, nMode);
}

inline LPCTSTR STextFile::GetFileName() const
{
	return m_file.GetFileName();
}

void ThrowFileException(UINT nCause, LPCTSTR lpszFileName);

#endif // __FILEIO_H__
