// ScrollWnd.cpp : implementation file
//

#include "stdafx.h"
#include "ScrollWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScrollWnd

CScrollWnd::CScrollWnd()
{
}

CScrollWnd::~CScrollWnd()
{
}


BEGIN_MESSAGE_MAP(CScrollWnd, CWnd)
	//{{AFX_MSG_MAP(CScrollWnd)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CScrollWnd message handlers

int CScrollWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	return 0;
}

void CScrollWnd::OnPaint() 
{
	CPaintDC dc(this);
	OnPrepareDC(&dc);
	OnDraw(&dc);
}

void CScrollWnd::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);

	SCROLLINFO si;
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = m_sizeTotal.cy;
	si.nPage = cy;
	SetScrollInfo(SB_VERT, &si);

	si.nMin = 0;
	si.nMax = m_sizeTotal.cx;
	si.nPage = cx;
	SetScrollInfo(SB_HORZ, &si);
}

void CScrollWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SCROLLINFO si;
	GetScrollInfo(SB_VERT, &si);

	int n;
	switch (nSBCode)
	{
	case SB_TOP:
		n = si.nMin - si.nPos;
		break;
	case SB_BOTTOM:
		n = si.nMax - si.nPos;
		break;
	case SB_LINEUP:
		n = -1;
		break;
	case SB_LINEDOWN:
		n = 1;
		break;
	case SB_PAGEUP:
		n = -(int) si.nPage;
		break;
	case SB_PAGEDOWN:
		n = si.nPage;
		break;
	case SB_THUMBTRACK:
		n = nPos - si.nPos;
		break;
	default:
		return;
	}

	int nMin = si.nMin - si.nPos, nMax = si.nMax - si.nPos - si.nPage + 1;
	if (n < nMin)
		n = nMin;
	if (n > nMax)
		n = nMax;
	if (n != 0)
	{
		SetScrollPos(SB_VERT, si.nPos + n);
		ScrollWindow(0, -n);
	}
	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CScrollWnd::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SCROLLINFO si;
	GetScrollInfo(SB_HORZ, &si);

	int n;
	switch (nSBCode)
	{
	case SB_TOP:
		n = si.nMin - si.nPos;
		break;
	case SB_BOTTOM:
		n = si.nMax - si.nPos;
		break;
	case SB_LINEUP:
		n = -1;
		break;
	case SB_LINEDOWN:
		n = 1;
		break;
	case SB_PAGEUP:
		n = -(int) si.nPage;
		break;
	case SB_PAGEDOWN:
		n = si.nPage;
		break;
	case SB_THUMBTRACK:
		n = nPos - si.nPos;
		break;
	default:
		return;
	}

	int nMin = si.nMin - si.nPos, nMax = si.nMax - si.nPos - si.nPage + 1;
	if (n < nMin)
		n = nMin;
	if (n > nMax)
		n = nMax;
	if (n != 0)
	{
		SetScrollPos(SB_HORZ, si.nPos + n);
		ScrollWindow(-n, 0);
	}
	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

CSize CScrollWnd::GetTotalSize() const
{
	return m_sizeTotal;
}

void CScrollWnd::SetScrollSizes(int nMapMode, SIZE sizeTotal)
{
	ASSERT(nMapMode == MM_TEXT);
	m_sizeTotal = sizeTotal;

	CRect rect;
	GetClientRect(&rect);

	SCROLLINFO si;
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = m_sizeTotal.cy;
	si.nPage = rect.Width();
	SetScrollInfo(SB_VERT, &si);

	si.nMin = 0;
	si.nMax = m_sizeTotal.cx;
	si.nPage = rect.Height();
	SetScrollInfo(SB_HORZ, &si);
}

void CScrollWnd::OnPrepareDC(CDC *pDC)
{
	pDC->SetViewportOrg(-GetScrollPos(SB_HORZ), -GetScrollPos(SB_VERT));
}
