#include "stdafx.h"
#include "Stream.h"

SStream::~SStream()
{
}

void SInputStream::ReadString(int nSize, LPSTR lpsz)
{
	ASSERT(nSize >= 0);
	ASSERT(IsValidAddress(lpsz, nSize + 1));
	Read(lpsz, sizeof(*lpsz) * nSize);
	lpsz[nSize] = NULL;
}

void SInputStream::ReadString(int nSize, LPWSTR lpsz)
{
	ASSERT(nSize >= 0);
	ASSERT(IsValidAddress(lpsz, nSize + 1));
	Read(lpsz, sizeof(*lpsz) * nSize);
	lpsz[nSize] = NULL;
}

#ifdef _STRLIB

BOOL SInputStream::ReadString(SString &str)
{
	return TRUE;
}

void SInputStream::ReadString(int nSize, SString &str)
{
	ReadString(nSize, str.AllocBuffer(nSize + 1));
	str.FreeExtra();
}

#endif // _STRLIB

void SOutputStream::WriteString(LPCSTR lpsz)
{
	ASSERT(IsValidString(lpsz));
	int nLength = strlen(lpsz);
	*this << nLength;
	Write(lpsz, sizeof(*lpsz) * nLength);
}

void SOutputStream::WriteString(LPCWSTR lpsz)
{
	ASSERT(IsValidString(lpsz));
	int nLength = wcslen(lpsz);
	*this << nLength;
	Write(lpsz, sizeof(*lpsz) * nLength);
}

void SOutputStream::WriteString(int nSize, LPCSTR lpsz)
{
	ASSERT(nSize >= 0);
	ASSERT(IsValidString(lpsz));

	int nLength = strlen(lpsz);
	Write(lpsz, sizeof(*lpsz) * min(nLength, nSize));

	char ach[256] = { 0, };
	for (nSize -= nLength;nSize > 0;nSize -= countof(ach))
		Write(ach, sizeof(*lpsz) * min(countof(ach), nSize));
}

void SOutputStream::WriteString(int nSize, LPCWSTR lpsz)
{
	ASSERT(nSize >= 0);
	ASSERT(IsValidString(lpsz));

	int nLength = wcslen(lpsz);
	Write(lpsz, sizeof(*lpsz) * min(nLength, nSize));

	WCHAR ach[256] = { 0, };
	for (nSize -= nLength;nSize > 0;nSize -= countof(ach))
		Write(ach, sizeof(*lpsz) * min(countof(ach), nSize));
}
